/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.graph.impl.Node;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.InputStreamSource;
import de.grogra.pf.io.InputStreamSourceImpl;
import de.grogra.pf.io.StreamAdapter;
import de.grogra.pf.registry.ImportsClassLoader;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Library;
import de.grogra.pf.registry.LibraryClassLoader;
import de.grogra.pf.registry.Plugin;
import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.PluginPrerequisite;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.XMLRegistryReader;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.util.I18NBundle;
import de.grogra.util.IOWrapException;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.WrapException;
import de.grogra.util.XByteArrayOutputStream;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.util.ObjectList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.xml.sax.SAXException;

public final class PluginDescriptor
extends Item {
    public static final int FRESH = 0;
    public static final int DISABLED = 1;
    public static final int ERROR = 2;
    public static final int MISSING_PREREQUISITE = 3;
    public static final int INACTIVE = 4;
    public static final int ACTIVE = 5;
    private int state = 0;
    private LibraryClassLoader loader;
    private FileSystem fileSystem;
    private Object[] libraryFiles = new Object[0];
    private Object directory;
    private InputStreamSource input;
    private Plugin plugin = null;
    private I18NBundle i18n = null;
    private String version;
    private String cls;
    public static final Node.NType $TYPE = new Node.NType(new PluginDescriptor());
    public static final Node.NType.Field version$FIELD = new _Field("version", 0x200002, ClassAdapter.wrap(String.class), null, 0);
    public static final Node.NType.Field cls$FIELD;
    private boolean instantiating = false;
    private boolean instantiated = false;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new PluginDescriptor();
    }

    PluginDescriptor() {
        super(null);
    }

    String getPluginClass() {
        return this.cls;
    }

    public static PluginDescriptor createCoreDescriptor(File file) {
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setName("de.grogra");
        pluginDescriptor.setI18NBundle(Main.getI18NBundle());
        pluginDescriptor.version = String.valueOf(pluginDescriptor.getFromResource("pluginVersion"));
        ObjectList<File> objectList = new ObjectList<File>();
        if (file != null) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory() || !fileArray[i].getName().toLowerCase().endsWith(".jar")) continue;
                Main.getLogger().config("jar extension " + fileArray[i]);
                objectList.add(fileArray[i]);
            }
        }
        pluginDescriptor.fileSystem = LocalFileSystem.FILE_ADAPTER;
        pluginDescriptor.libraryFiles = objectList.toArray(new File[objectList.size()]);
        pluginDescriptor.loader = new LibraryClassLoader(pluginDescriptor.libraryFiles, file, pluginDescriptor);
        return pluginDescriptor;
    }

    public String getPluginVersion() {
        return this.version;
    }

    public String getPluginName() {
        return String.valueOf(this.getFromResource("pluginName"));
    }

    public String getPluginProvider() {
        return String.valueOf(this.getFromResource("provider"));
    }

    public Object get(Object object, Object object2) {
        if ("pluginId".equals(object)) {
            return this.getName();
        }
        if ("pluginName".equals(object)) {
            return this.getPluginName();
        }
        if ("provider".equals(object)) {
            return this.getPluginProvider();
        }
        return super.get(object, object2);
    }

    protected boolean readAttribute(String string, String string2, String string3) throws SAXException {
        if ("".equals(string)) {
            if ("id".equals(string2)) {
                this.setName(string3);
                return true;
            }
            if ("class".equals(string2)) {
                this.cls = string3;
                return true;
            }
        }
        return super.readAttribute(string, string2, string3);
    }

    public static PluginDescriptor read(String string, InputStream inputStream, FileSystem fileSystem, Object object) throws IOException {
        XByteArrayOutputStream xByteArrayOutputStream = new XByteArrayOutputStream(16384);
        xByteArrayOutputStream.read(inputStream);
        ByteArrayInputStream byteArrayInputStream = xByteArrayOutputStream.createInputStream();
        InputStreamSourceImpl inputStreamSourceImpl = new InputStreamSourceImpl(byteArrayInputStream, string, MimeType.TEXT_XML, null, null);
        StreamAdapter streamAdapter = new StreamAdapter(inputStreamSourceImpl, IOFlavor.XML_FLAVOR);
        XMLRegistryReader xMLRegistryReader = new XMLRegistryReader(null, null, null);
        try {
            streamAdapter.parse(xMLRegistryReader, null, null, null, null);
        }
        catch (SAXException sAXException) {
            throw new IOWrapException(sAXException, "Reading of plugin " + string + " failed.");
        }
        byteArrayInputStream.reset();
        PluginDescriptor pluginDescriptor = (PluginDescriptor)xMLRegistryReader.getRoot();
        pluginDescriptor.fileSystem = fileSystem;
        pluginDescriptor.directory = object;
        pluginDescriptor.input = inputStreamSourceImpl;
        return pluginDescriptor;
    }

    public boolean loadPlugin(Registry registry, ClassLoader classLoader) {
        Map map;
        LibraryClassLoader[] libraryClassLoaderArray;
        this.state = 4;
        this.setRegistry(registry);
        ObjectList<PluginClassLoader> objectList = new ObjectList<PluginClassLoader>(10);
        for (libraryClassLoaderArray = (LibraryClassLoader[])this.getBranch(); libraryClassLoaderArray != null; libraryClassLoaderArray = (Item)libraryClassLoaderArray.getSuccessor()) {
            if (!(libraryClassLoaderArray instanceof PluginPrerequisite)) continue;
            objectList.add(registry.getPluginDescriptor(((PluginPrerequisite)libraryClassLoaderArray).getName()).getPluginClassLoader());
        }
        libraryClassLoaderArray = new LibraryClassLoader[objectList.size()];
        objectList.toArray(libraryClassLoaderArray);
        PluginClassLoader pluginClassLoader = new ImportsClassLoader(classLoader, libraryClassLoaderArray, this);
        for (map = (Item)this.getBranch(); map != null; map = (Item)((Node)map).getSuccessor()) {
            if (!(map instanceof Library)) continue;
            pluginClassLoader = ((Library)map).createLoader(this.directory, pluginClassLoader);
        }
        this.loader = new LibraryClassLoader(new Object[]{this.directory}, pluginClassLoader, new String[0]);
        this.i18n.initClassLoader(this.loader);
        map = new StreamAdapter(this.input, IOFlavor.XML_FLAVOR);
        XMLRegistryReader xMLRegistryReader = new XMLRegistryReader(registry, this, new PersistenceBindings(this.loader, registry));
        try {
            this.instantiatePlugin();
            if (this.plugin.initialize()) {
                map.parse(xMLRegistryReader, null, null, null, null);
                return true;
            }
            this.state = 1;
            Main.getLogger().config("Plugin " + this + " disabled itself.");
            return false;
        }
        catch (Exception exception) {
            Main.getLogger().log(Level.CONFIG, "Error loading plugin " + this.getPluginName(), exception);
            System.err.println("Error loading plugin " + this.getPluginName());
            exception.printStackTrace();
            this.state = 2;
            return false;
        }
    }

    public Object getPluginDirectory() {
        return this.directory;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public synchronized void setPluginState(int n) {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.state = n;
    }

    public synchronized int getPluginState() {
        return this.state;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void instantiatePlugin() throws Exception {
        if (this.instantiated || this.plugin != null) {
            return;
        }
        this.instantiated = true;
        this.instantiating = true;
        try {
            this.plugin = this.cls == null ? new Plugin() : (Plugin)Class.forName(this.cls, true, this.loader).newInstance();
            this.plugin.descriptor = this;
        }
        finally {
            this.instantiating = false;
        }
    }

    synchronized void activatePlugin() {
        if (this.state != 4) {
            return;
        }
        if (this.instantiating) {
            return;
        }
        this.state = 5;
        Main.getLogger().log(Level.CONFIG, "Activating plugin " + this.getName());
        try {
            this.instantiatePlugin();
        }
        catch (Exception exception) {
            Main.error(exception);
        }
        this.plugin.startup();
    }

    public String toString() {
        return "Plugin[" + this.getName() + ", " + this.getPluginName() + ", provider=" + this.getPluginProvider() + ", version=" + this.version + "]";
    }

    public I18NBundle getI18NBundle() {
        return this.i18n;
    }

    public void setI18NBundle(I18NBundle i18NBundle) {
        this.i18n = i18NBundle;
    }

    public Object[] getLibraryFiles() {
        return this.libraryFiles;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public PluginClassLoader getPluginClassLoader() {
        return this.loader;
    }

    public URL getURLForResource(String string) {
        try {
            return new URL("plugin", null, -1, this.getName() + '/' + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrapException(malformedURLException);
        }
    }

    public static PluginDescriptor getInstance(String string) {
        return Main.getRegistry().getPluginDescriptor(string);
    }

    public static PluginDescriptor getInstance(Class clazz) {
        return PluginDescriptor.getInstance(clazz.getClassLoader());
    }

    public static PluginDescriptor getInstance(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader instanceof PluginClassLoader) {
                return ((PluginClassLoader)classLoader).descriptor;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    public File getConfigurationDirectory() {
        File file = Main.getConfigurationDirectory();
        if (file == null) {
            return null;
        }
        return (file = new File(file, this.getName())).isDirectory() || file.mkdir() ? file : null;
    }

    static {
        $TYPE.addManagedField(version$FIELD);
        cls$FIELD = new _Field("cls", 0x200002, ClassAdapter.wrap(String.class), null, 1);
        $TYPE.addManagedField(cls$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((PluginDescriptor)object).version = (String)object2;
                    return;
                }
                case 1: {
                    ((PluginDescriptor)object).cls = (String)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((PluginDescriptor)object).version;
                }
                case 1: {
                    return ((PluginDescriptor)object).cls;
                }
            }
            return super.getObject(object);
        }
    }
}

