/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.pf.registry.LibraryClassLoader;
import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.util.CompoundEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportsClassLoader
extends PluginClassLoader {
    private final LibraryClassLoader[] imports;

    ImportsClassLoader(ClassLoader classLoader, LibraryClassLoader[] libraryClassLoaderArray, PluginDescriptor pluginDescriptor) {
        super(new URL[0], classLoader, pluginDescriptor);
        this.imports = libraryClassLoaderArray;
    }

    @Override
    protected Class findClassNull(String string) {
        return this.loadClassParentsSelf(string);
    }

    @Override
    Class loadClassParentsSelf(String string) {
        for (int i = this.imports.length - 1; i >= 0; --i) {
            Class clazz = this.imports[i].loadClassParentsSelf(string);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (uRL != null) {
            return uRL;
        }
        for (int i = this.imports.length - 1; i >= 0; --i) {
            uRL = this.imports[i].getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        CompoundEnumeration<URL> compoundEnumeration = new CompoundEnumeration<URL>(true);
        compoundEnumeration.add(super.findResources(string));
        for (int i = this.imports.length - 1; i >= 0; --i) {
            compoundEnumeration.add(this.imports[i].findResources(string));
        }
        return compoundEnumeration;
    }

    protected boolean shouldLookForClass(String string) {
        return false;
    }

    public String toString() {
        return "Import " + Arrays.toString(this.imports);
    }
}

