/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.graph.impl.Node;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.GraphLoader;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.ProjectLoader;
import de.grogra.pf.io.RegistryLoader;
import de.grogra.pf.io.ResourceLoader;
import de.grogra.pf.io.StreamAdapter;
import de.grogra.pf.registry.Registry;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;

public final class IOFlavor {
    public static final int INPUT_STREAM = 1;
    public static final int OUTPUT_STREAM = 2;
    public static final int READER = 4;
    public static final int WRITER = 8;
    public static final int SAX = 16;
    public static final int FILE_READER = 32;
    public static final int FILE_WRITER = 64;
    public static final int DOM = 128;
    public static final int OBJECT = 256;
    public static final int VFILE_READER = 512;
    public static final int VFILE_WRITER = 1024;
    private static final String[] FEATURE_NAMES = new String[]{"is", "os", "reader", "writer", "sax", "freader", "fwriter", "dom", "object", "vfreader", "vfwriter"};
    public static final int TRANSFER_IO_STREAM = 3;
    public static final int TRANSFER_STREAM = 159;
    public static final int TRANSFER_TYPES = 2047;
    public static final int FILE_OUT = 74;
    public static final IOFlavor INVALID = new IOFlavor(MimeType.INVALID, 0, null);
    public static final IOFlavor FS_FLAVOR = new IOFlavor(FileSystem.MIME_TYPE, 256, FileSystem.class);
    public static final IOFlavor XML_FLAVOR = new IOFlavor(MimeType.TEXT_XML, 16, null);
    public static final IOFlavor SCI_FLAVOR = new IOFlavor(MimeType.TEXT_SCI, 4, null);
    public static final IOFlavor PROJECT_LOADER = IOFlavor.valueOf(ProjectLoader.class);
    public static final IOFlavor RESOURCE_LOADER = IOFlavor.valueOf(ResourceLoader.class);
    public static final IOFlavor REGISTRY_LOADER = IOFlavor.valueOf(RegistryLoader.class);
    public static final IOFlavor GRAPH_LOADER = IOFlavor.valueOf(GraphLoader.class);
    public static final IOFlavor REGISTRY = IOFlavor.valueOf(Registry.class);
    public static final IOFlavor NODE = IOFlavor.valueOf(Node.class);
    private final MimeType mimeType;
    private final int features;
    private final Class objectClass;

    public IOFlavor(MimeType mimeType) {
        this(mimeType, 256, mimeType.getRepresentationClass());
    }

    public IOFlavor(MimeType mimeType, int n, Class clazz) {
        mimeType.getClass();
        this.mimeType = mimeType;
        this.features = n;
        this.objectClass = clazz;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public boolean isInputStreamSupported() {
        return (this.features & 1) != 0;
    }

    public boolean isOutputStreamSupported() {
        return (this.features & 2) != 0;
    }

    public boolean isReaderSupported() {
        return (this.features & 4) != 0;
    }

    public boolean isWriterSupported() {
        return (this.features & 8) != 0;
    }

    public boolean isSAXSupported() {
        return (this.features & 0x10) != 0;
    }

    public boolean isDOMSupported() {
        return (this.features & 0x80) != 0;
    }

    public boolean isFileReaderSupported() {
        return (this.features & 0x20) != 0;
    }

    public boolean isFileWriterSupported() {
        return (this.features & 0x40) != 0;
    }

    public boolean isObjectSupported() {
        return (this.features & 0x100) != 0;
    }

    public boolean isVirtualFileReaderSupported() {
        return (this.features & 0x200) != 0;
    }

    public boolean isVirtualFileWriterSupported() {
        return (this.features & 0x400) != 0;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public boolean isAssignableFrom(IOFlavor iOFlavor) {
        return ((this.features & iOFlavor.features & 0x7FF) != 0 || (this.features & 0x4DF) != 0 && (iOFlavor.features & 0x9F) != 0 || (this.features & 0x9F) != 0 && (iOFlavor.features & 0xBF) != 0) && this.mimeType.isAssignableFrom(iOFlavor.mimeType) && ((this.features & 0x100) == 0 || this.objectClass == null || this.objectClass.isAssignableFrom(iOFlavor.objectClass));
    }

    FilterSource createAdapter(FilterSource filterSource) {
        IOFlavor iOFlavor = filterSource.getFlavor();
        if ((this.features & iOFlavor.features & 0x7FF) != 0) {
            return filterSource;
        }
        if ((this.features & 0x4DF) != 0 && (iOFlavor.features & 0x9F) != 0) {
            return new StreamAdapter(filterSource, this);
        }
        if ((this.features & 0x9F) != 0 && (iOFlavor.features & 0xBF) != 0) {
            return new StreamAdapter(filterSource, this);
        }
        throw new IllegalArgumentException("Can't adapt " + filterSource + " to " + this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.mimeType.toString());
        stringBuffer.append("; io=");
        int n = 1;
        boolean bl = true;
        for (int i = 0; i < FEATURE_NAMES.length; ++i) {
            if ((this.features & n) != 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(FEATURE_NAMES[i]);
            }
            n <<= 1;
        }
        return Utils.quote(stringBuffer);
    }

    public static IOFlavor valueOf(String string) {
        return IOFlavor.valueOf(MimeType.valueOf(Utils.unquote(string)));
    }

    public static IOFlavor valueOf(Class clazz) {
        return new IOFlavor(MimeType.valueOf(clazz), 256, clazz);
    }

    public static IOFlavor valueOf(MimeType mimeType) {
        StringMap stringMap = mimeType.getParameters();
        String string = (String)stringMap.get("io");
        stringMap.remove("io");
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < FEATURE_NAMES.length; ++i) {
            int n3 = string.indexOf(FEATURE_NAMES[i]);
            if (!(n3 < 0 || n3 != 0 && Character.isLetter(string.charAt(n3 - 1)) || (n3 += FEATURE_NAMES[i].length()) != string.length() && Character.isLetter(string.charAt(n3)))) {
                n |= n2;
            }
            n2 <<= 1;
        }
        return new IOFlavor(new MimeType(mimeType.getMediaType(), stringMap, mimeType.getRepresentationClass()), n, mimeType.getRepresentationClass());
    }

    public boolean isWritableTo(IOFlavor iOFlavor) {
        return IO.isWritableTo(this, iOFlavor);
    }

    public boolean isWritableTo(MimeType mimeType) {
        return this.isWritableTo(new IOFlavor(mimeType, 10, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) return true;
        if (!(object instanceof IOFlavor)) return false;
        IOFlavor iOFlavor = (IOFlavor)object;
        if (iOFlavor.features != this.features) return false;
        if (!Utils.equal(iOFlavor.objectClass, this.objectClass)) return false;
        if (!iOFlavor.mimeType.equals(this.mimeType)) return false;
        return true;
    }

    public int hashCode() {
        return this.features ^ this.mimeType.hashCode();
    }
}

