/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.MimeTypeItem;
import de.grogra.pf.io.NullSource;
import de.grogra.pf.io.StreamAdapter;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.util.I18NBundle;
import de.grogra.util.MimeType;
import de.grogra.util.Utils;
import de.grogra.vfs.FSFile;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.util.ObjectList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.jar.Attributes;

public final class IO {
    public static final String PROJECT_FS = "pfs";
    public static final char SYSTEM_ID_SEPARATOR = ':';
    public static final I18NBundle I18N = I18NBundle.getInstance(IO.class);
    private static IO instance;
    private final Registry registry;
    private final Hashtable writableFileTypes = new Hashtable(20);
    private final Hashtable readableFileTypes = new Hashtable(20);
    private final Hashtable writableFlavors = new Hashtable(20);

    private IO(Registry registry) {
        this.registry = registry;
    }

    static synchronized IO getInstance() {
        if (instance == null) {
            instance = new IO(Main.getRegistry());
        }
        return instance;
    }

    static Registry getRegistry() {
        return IO.getInstance().registry;
    }

    public static FilterSource createPipeline(FilterSource filterSource, IOFlavor iOFlavor) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class OptPipeline
        implements ItemVisitor {
            FilterSource opt = null;
            private static final int MAX_LEN = 15;
            private int len = 0;
            private int optLen = 15;
            private final FilterItem[] items = new FilterItem[15];
            final /* synthetic */ IOFlavor val$targetFlavor;

            OptPipeline(IOFlavor iOFlavor) {
                this.val$targetFlavor = iOFlavor;
            }

            void createPipeline(FilterSource filterSource) {
                if (this.len >= this.optLen || filterSource == null) {
                    return;
                }
                if (this.val$targetFlavor.isAssignableFrom(filterSource.getFlavor())) {
                    FilterSource filterSource2 = this.val$targetFlavor.createAdapter(filterSource);
                    if (filterSource2 != filterSource) {
                        ++this.len;
                    }
                    if (this.len < this.optLen) {
                        this.opt = filterSource2;
                        this.optLen = this.len;
                    }
                    if (filterSource2 != filterSource) {
                        --this.len;
                    }
                } else if (this.len + 1 < this.optLen) {
                    MimeType mimeType = filterSource.getFlavor().getMimeType();
                    Item.forAll(MimeTypeItem.get((RegistryContext)IO.getRegistry(), mimeType), null, null, this, filterSource, true);
                    if (!mimeType.equals(MimeType.OCTET_STREAM)) {
                        Item.forAll(MimeTypeItem.get((RegistryContext)IO.getRegistry(), MimeType.OCTET_STREAM), null, null, this, filterSource, true);
                    }
                }
            }

            @Override
            public void visit(Item item, Object object) {
                if (this.len + 1 >= this.optLen || !(item instanceof FilterItem)) {
                    return;
                }
                FilterItem filterItem = (FilterItem)item;
                FilterSource filterSource = (FilterSource)object;
                if (filterItem.getInputFlavor().isAssignableFrom(filterSource.getFlavor())) {
                    for (int i = this.len; i >= 0; --i) {
                        if (this.items[i] != filterItem) continue;
                        return;
                    }
                    FilterSource filterSource2 = filterItem.getInputFlavor().createAdapter(filterSource);
                    if (filterSource2 != filterSource) {
                        ++this.len;
                    }
                    ++this.len;
                    if (this.len < this.optLen) {
                        this.items[this.len] = filterItem;
                        this.createPipeline(filterItem.createFilter(filterSource2));
                        this.items[this.len] = null;
                    }
                    --this.len;
                    if (filterSource2 != filterSource) {
                        --this.len;
                    }
                }
            }
        }
        OptPipeline optPipeline = new OptPipeline(iOFlavor);
        optPipeline.createPipeline(filterSource);
        return optPipeline.opt;
    }

    public static FilterSource getRoot(FilterSource filterSource) {
        while (filterSource.getFilter() != null) {
            filterSource = filterSource.getFilter().getSource();
        }
        return filterSource;
    }

    public static String toSystemId(File file) {
        file = file.getAbsoluteFile();
        File file2 = Utils.relativize(new File(System.getProperty("user.home")), file);
        return file2.isAbsolute() ? file.getPath() : '~' + File.separator + file2.getPath();
    }

    public static FSFile toFile(RegistryContext registryContext, String string) {
        block4: {
            FSFile fSFile = IO.toFile(registryContext.getRegistry().getFileSystem(), string);
            if (fSFile != null) {
                return fSFile;
            }
            fSFile = IO.toFile(Registry.PLUGIN_FILE_SYSTEMS, string);
            if (fSFile != null) {
                return fSFile;
            }
            int n = string.indexOf(58);
            if (n > 1) {
                while (--n >= 0) {
                    char c = string.charAt(n);
                    if (c >= 'a' && c <= 'z') continue;
                    break block4;
                }
                return null;
            }
        }
        return new FSFile(LocalFileSystem.FILE_ADAPTER, IO.toLocalFile(string));
    }

    private static FSFile toFile(FileSystem fileSystem, String string) {
        if (fileSystem == null || !string.startsWith(fileSystem.getFSName() + ':')) {
            return null;
        }
        Object object = fileSystem.getFile(string.substring(fileSystem.getFSName().length() + 1));
        if (object == null) {
            return null;
        }
        return new FSFile(fileSystem, object);
    }

    public static File toLocalFile(String string) {
        switch (string.length()) {
            case 0: {
                return null;
            }
            case 1: {
                if (string.charAt(0) != '~') break;
                string = System.getProperty("user.home");
                break;
            }
            default: {
                if (string.charAt(0) != '~' || string.charAt(1) != File.separatorChar) break;
                return new File(System.getProperty("user.home"), string.substring(2));
            }
        }
        return new File(string);
    }

    public static String toPath(String string) {
        int n = string.indexOf(58);
        if (n > 0 && (string.lastIndexOf(47, n) >= 0 || string.lastIndexOf(File.separatorChar, n) >= 0)) {
            n = -1;
        }
        if (n > 0) {
            return string.substring(n + 1);
        }
        try {
            return new URL(string).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public static String toName(String string) {
        string = IO.toPath(string);
        return string.substring(Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar)) + 1);
    }

    public static String toSimpleName(String string) {
        int n = (string = IO.toName(string)).lastIndexOf(46);
        return n <= 0 ? string : string.substring(0, n);
    }

    public static URL toURL(RegistryContext registryContext, String string) throws MalformedURLException {
        FSFile fSFile = IO.toFile(registryContext, string);
        return fSFile == null ? new URL(string) : fSFile.fileSystem.toURL(fSFile.file);
    }

    public static String toSystemId(FileSystem fileSystem, URL uRL) {
        Object object = fileSystem.toFile(uRL);
        return object != null ? IO.toSystemId(fileSystem, object) : ("file".equals(uRL.getProtocol()) ? IO.toSystemId(Utils.urlToFile(uRL)) : uRL.toString());
    }

    public static String toSystemId(FileSystem fileSystem, Object object) {
        return fileSystem.getFSName() + ':' + fileSystem.getPath(object);
    }

    public static MimeType getMimeType(String string) {
        FileTypeItem fileTypeItem = FileTypeItem.get(IO.getRegistry(), string);
        return fileTypeItem != null ? fileTypeItem.getMimeType() : MimeType.OCTET_STREAM;
    }

    public static FileTypeItem.Filter[] getReadableFileTypes(IOFlavor[] iOFlavorArray) {
        ObjectList<IOFlavor> objectList = new ObjectList<IOFlavor>(iOFlavorArray);
        FileTypeItem.Filter[] filterArray = (FileTypeItem.Filter[])IO.getInstance().readableFileTypes.get(objectList);
        if (filterArray != null) {
            return filterArray;
        }
        Item[] itemArray = Item.findAll(IO.getRegistry(), "/io/filetypes", ItemCriterion.INSTANCE_OF, FileTypeItem.class, true);
        ObjectList<FileTypeItem.Filter> objectList2 = new ObjectList<FileTypeItem.Filter>();
        block0: for (int i = 0; i < itemArray.length; ++i) {
            NullSource nullSource = new NullSource(new IOFlavor(((FileTypeItem)itemArray[i]).getMimeType(), 549, null), IO.getRegistry(), null);
            for (int j = 0; j < iOFlavorArray.length; ++j) {
                if (IO.createPipeline(nullSource, iOFlavorArray[j]) == null) continue;
                objectList2.add(((FileTypeItem)itemArray[i]).getFilter());
                continue block0;
            }
        }
        filterArray = new FileTypeItem.Filter[objectList2.size()];
        objectList2.toArray(filterArray);
        IO.getInstance().readableFileTypes.put(objectList, filterArray);
        return filterArray;
    }

    public static FileTypeItem.Filter[] getWritableFileTypes(IOFlavor iOFlavor) {
        FileTypeItem.Filter[] filterArray = (FileTypeItem.Filter[])IO.getInstance().writableFileTypes.get(iOFlavor);
        if (filterArray != null) {
            return filterArray;
        }
        NullSource nullSource = new NullSource(iOFlavor, IO.getRegistry(), null);
        Item[] itemArray = Item.findAll(IO.getRegistry(), "/io/filetypes", ItemCriterion.INSTANCE_OF, FileTypeItem.class, true);
        ObjectList<FileTypeItem.Filter> objectList = new ObjectList<FileTypeItem.Filter>();
        for (int i = 0; i < itemArray.length; ++i) {
            if (IO.createPipeline(nullSource, new IOFlavor(((FileTypeItem)itemArray[i]).getMimeType(), 74, null)) == null) continue;
            objectList.add(((FileTypeItem)itemArray[i]).getFilter());
        }
        filterArray = new FileTypeItem.Filter[objectList.size()];
        objectList.toArray(filterArray);
        IO.getInstance().writableFileTypes.put(iOFlavor, filterArray);
        return filterArray;
    }

    static boolean isWritableTo(IOFlavor iOFlavor, IOFlavor iOFlavor2) {
        ObjectList<IOFlavor> objectList = new ObjectList<IOFlavor>(2);
        objectList.add(iOFlavor);
        objectList.add(iOFlavor2);
        Boolean bl = (Boolean)IO.getInstance().writableFlavors.get(objectList);
        if (bl == null) {
            bl = IO.createPipeline(new NullSource(iOFlavor, IO.getRegistry(), null), iOFlavor2) != null;
            IO.getInstance().writableFlavors.put(objectList, bl);
        }
        return bl;
    }

    public static String getDescription(MimeType mimeType) {
        return mimeType.getMediaType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(FilterSource filterSource, FileSystem fileSystem, String string, MimeType mimeType) throws IOException {
        OutputStream outputStream = null;
        try {
            Object object = fileSystem.create(fileSystem.getRoot(), string, false);
            outputStream = fileSystem.getOutputStream(object, false);
            new StreamAdapter(filterSource, new IOFlavor(mimeType, 2, null)).write(outputStream);
            outputStream.flush();
            fileSystem.getAttributes(object, true).put(Attributes.Name.CONTENT_TYPE, mimeType.toString());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

