/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.DOMSourceImpl;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.GraphXMLSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.PluginCollector;
import de.grogra.pf.io.StreamAdapter;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.Registry;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.vfs.MemoryFileSystem;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GSWriter
extends FilterBase
implements FileWriterSource {
    public static final IOFlavor FLAVOR = new IOFlavor(new MimeType("application/x-grogra-project", null), 64, null);

    public GSWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public static void write(Registry registry, FileSystem fileSystem, String string) throws IOException {
        HashSet hashSet = new HashSet();
        PluginCollector pluginCollector = new PluginCollector(hashSet);
        IO.writeXML(new GraphXMLSource(registry.getProjectGraph(), registry, pluginCollector), fileSystem, "graph.xml", GraphXMLSource.MIME_TYPE);
        StringMap stringMap = new StringMap().putObject("registry", registry);
        stringMap.put("filesystem", (Object)fileSystem);
        stringMap.put("projectfile", (Object)string);
        Executable.runExecutables(registry.getRootRegistry(), "/hooks/saving", registry, stringMap);
        IOFlavor iOFlavor = new IOFlavor(Registry.MIME_TYPE, 128, null);
        StreamAdapter streamAdapter = new StreamAdapter(registry.createXMLSource(hashSet), iOFlavor);
        Document document = streamAdapter.getDocument();
        Element element = document.getDocumentElement();
        element.setAttribute("graph", "graph.xml");
        Node node = element.getFirstChild();
        for (PluginDescriptor pluginDescriptor : hashSet) {
            Element element2 = document.createElementNS("http://grogra.de/registry", "import");
            element2.setAttribute("plugin", pluginDescriptor.getName());
            element2.setAttribute("version", pluginDescriptor.getPluginVersion());
            element.insertBefore(element2, node);
        }
        IO.writeXML(new DOMSourceImpl(document, streamAdapter.getSystemId(), iOFlavor, registry, null), fileSystem, string, Registry.MIME_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws IOException {
        File file2 = file.getParentFile();
        Registry registry = (Registry)((ObjectSource)this.source).getObject();
        FileSystem fileSystem = registry.getFileSystem();
        Collection collection = registry.getFiles();
        if (fileSystem instanceof MemoryFileSystem) {
            ((MemoryFileSystem)fileSystem).removeNonlistedFiles(collection);
        }
        fileSystem.removeNonlistedAttributes(collection);
        if (!(fileSystem instanceof LocalFileSystem) || !fileSystem.equals(file2, fileSystem.getRoot())) {
            fileSystem = new LocalFileSystem("pfs", file2);
            registry.substituteFileSystem(fileSystem);
        }
        GSWriter.write(registry, fileSystem, file.getName());
        File file3 = new File(file2, "META-INF");
        if (!file3.isDirectory() && !file3.mkdir()) {
            throw new IOException();
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(file3, "MANIFEST.MF")));
        try {
            fileSystem.getManifest().write(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }
}

