/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.persistence;

import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceManager;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAQueue;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldChain;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;
import de.grogra.xl.util.BooleanList;
import de.grogra.xl.util.ByteList;
import de.grogra.xl.util.CharList;
import de.grogra.xl.util.DoubleList;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongList;
import de.grogra.xl.util.ShortList;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public final class IndirectField
extends PersistenceField
implements Cloneable {
    private final Type typeWhen0;
    private final int begin;
    private ManageableType.Field[] chain = new ManageableType.Field[4];
    private int length = 0;
    private int indexCount = 0;
    private ManageableType.Field lastField;
    private boolean managed = true;
    private String totalName = null;
    private IndirectField[] subfields = null;
    private IndirectField superfield;
    private IntList ints = null;
    private Type cast = null;

    public IndirectField dup() {
        try {
            IndirectField indirectField = (IndirectField)this.clone();
            indirectField.chain = (ManageableType.Field[])this.chain.clone();
            indirectField.totalName = null;
            indirectField.subfields = null;
            indirectField.ints = null;
            return indirectField;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    private IndirectField(Type type, int n) {
        super("IndirectField", "IndirectField", 0, Type.INVALID);
        this.typeWhen0 = type;
        this.begin = n;
    }

    public IndirectField(Type type) {
        this(type, 0);
    }

    public IndirectField() {
        this(null, 0);
    }

    public IndirectField(PersistenceField persistenceField) {
        this(null, 0);
        this.set(persistenceField);
    }

    public PersistenceField getShallowSubchain(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.indexCount;
        for (int i = 0; i < n; ++i) {
            if (!this.chain[i].isArrayComponent) continue;
            --n2;
        }
        return this.pooledSubfield(n, n2);
    }

    private IndirectField pooledSubfield(int n, int n2) {
        IndirectField indirectField;
        IndirectField[] indirectFieldArray = this.subfields;
        if (this.subfields == null || indirectFieldArray.length <= n) {
            this.subfields = indirectFieldArray = new IndirectField[n + 1];
        }
        if ((indirectField = indirectFieldArray[n]) == null) {
            indirectFieldArray[n] = indirectField = new IndirectField(null, n);
        }
        indirectField.chain = this.chain;
        indirectField.fco = this.fco;
        indirectField.lastField = this.lastField;
        indirectField.length = this.length - n;
        indirectField.managed = this.managed;
        indirectField.typeId = this.typeId;
        indirectField.indexCount = n2;
        return indirectField;
    }

    PersistenceField getShallowSuperchain() {
        if (this.length < 2) {
            return null;
        }
        IndirectField indirectField = this.superfield;
        if (indirectField == null) {
            indirectField = this.superfield = new IndirectField(null, this.begin);
        }
        indirectField.chain = this.chain;
        indirectField.indexCount = this.lastField.isArrayComponent ? this.indexCount - 1 : this.indexCount;
        indirectField.lastField = this.chain[this.begin + this.length - 2];
        indirectField.typeId = indirectField.lastField.typeId;
        indirectField.length = this.length - 1;
        indirectField.totalName = this.totalName;
        for (int i = this.length - 2; i >= 0; --i) {
            if (this.chain[this.begin + i].managed) continue;
            indirectField.managed = false;
            indirectField.fco = false;
            return indirectField;
        }
        indirectField.managed = true;
        indirectField.fco = indirectField.lastField.fco;
        return indirectField;
    }

    public static PersistenceField concat(PersistenceField persistenceField, PersistenceField persistenceField2) {
        if (persistenceField2 == null) {
            return persistenceField;
        }
        if (persistenceField == null) {
            return persistenceField2;
        }
        IndirectField indirectField = new IndirectField(persistenceField);
        indirectField.add(persistenceField2);
        return indirectField;
    }

    public final Type getType() {
        return this.cast != null ? this.cast : (this.length == 0 ? this.typeWhen0 : this.lastField.getType());
    }

    public final Quantity getQuantity() {
        return this.lastField != null ? this.lastField.getQuantity() : null;
    }

    public final Number getMinValue() {
        return this.lastField != null ? (Number)this.lastField.getMinValue() : (Number)null;
    }

    public final Number getMaxValue() {
        return this.lastField != null ? (Number)this.lastField.getMaxValue() : (Number)null;
    }

    public String getName() {
        if (this.totalName == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.chain[this.begin + i].getSimpleName());
            }
            this.totalName = stringBuffer.toString();
        }
        return this.totalName;
    }

    public String getSimpleName() {
        return this.lastField != null ? this.lastField.getSimpleName() : null;
    }

    public int length() {
        return this.length;
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public ManageableType.Field getSubfield(int n) {
        return this.chain[this.begin + n];
    }

    public ManageableType.Field getLastField() {
        return this.lastField;
    }

    public boolean check() {
        for (int i = this.begin + 1; i < this.begin + this.length; ++i) {
            if (this.chain[i].isArrayComponent || Reflection.isCastableFrom(this.chain[i - 1].getType(), this.chain[i].getDeclaringType())) continue;
            return false;
        }
        return true;
    }

    public boolean overlaps(int[] nArray, FieldChain fieldChain, int[] nArray2) {
        if (fieldChain instanceof ManageableType.Field) {
            return this.length > 0 && fieldChain == this.chain[this.begin];
        }
        if (fieldChain instanceof IndirectField) {
            IndirectField indirectField = (IndirectField)fieldChain;
            int n = indirectField.length;
            n = this.length < n ? this.length : n;
            int n2 = -1;
            while (--n >= 0) {
                if (this.chain[this.begin + n] != indirectField.chain[indirectField.begin + n]) {
                    return false;
                }
                if (!this.chain[this.begin + n].isArrayComponent || nArray[++n2] == nArray2[n2]) continue;
                return false;
            }
            return true;
        }
        int n = fieldChain.length();
        n = this.length < n ? this.length : n;
        int n3 = -1;
        Type<?> type = null;
        while (--n >= 0) {
            if (type != null) {
                if (nArray[++n3] != nArray2[n3]) {
                    return false;
                }
                type = type.getComponentType();
                continue;
            }
            Field field = fieldChain.getField(n);
            if (this.chain[this.begin + n] != field && (field instanceof ManageableType.Field || !Reflection.membersEqual(this.chain[this.begin + n], field, false))) {
                return false;
            }
            type = field.getType().getComponentType();
        }
        return true;
    }

    public void clear() {
        this.length = 0;
        this.indexCount = 0;
        this.managed = true;
        this.lastField = null;
        this.totalName = null;
        this.fco = false;
        this.cast = null;
    }

    public void set(PersistenceField persistenceField) {
        assert (this.begin == 0);
        this.cast = null;
        if (persistenceField instanceof IndirectField) {
            IndirectField indirectField = (IndirectField)persistenceField;
            if (indirectField.length > this.chain.length) {
                this.chain = new ManageableType.Field[indirectField.length];
            }
            for (int i = indirectField.length - 1; i >= 0; --i) {
                this.chain[i] = indirectField.chain[indirectField.begin + i];
            }
            this.typeId = indirectField.typeId;
            this.fco = indirectField.fco;
            this.lastField = indirectField.lastField;
            this.managed = indirectField.managed;
            this.length = indirectField.length;
            this.indexCount = indirectField.indexCount;
        } else if (persistenceField != null) {
            this.chain[0] = this.lastField = (ManageableType.Field)persistenceField;
            this.typeId = this.lastField.getType().getTypeId();
            this.fco = this.lastField.fco;
            this.managed = this.lastField.managed;
            this.length = 1;
            this.indexCount = 0;
        } else {
            this.clear();
        }
    }

    public IndirectField add(Field field) {
        PersistenceField persistenceField = PersistenceField.get(field);
        if (persistenceField == null) {
            throw new IllegalArgumentException(field.toString());
        }
        this.add(persistenceField);
        return this;
    }

    public IndirectField add(FieldChain fieldChain) {
        for (int i = 0; i < fieldChain.length(); ++i) {
            this.add(fieldChain.getField(i));
        }
        return this;
    }

    public IndirectField add(PersistenceField persistenceField) {
        assert (this.begin == 0);
        if (persistenceField instanceof IndirectField) {
            IndirectField indirectField = (IndirectField)persistenceField;
            int n = this.length + indirectField.length;
            if (n > this.chain.length) {
                this.chain = new ManageableType.Field[n += 4];
                System.arraycopy(this.chain, 0, this.chain, 0, this.length);
            }
            for (n = indirectField.length - 1; n >= 0; --n) {
                this.chain[this.length + n] = indirectField.chain[indirectField.begin + n];
            }
            this.typeId = indirectField.typeId;
            this.lastField = indirectField.lastField;
            this.cast = indirectField.cast;
            if (this.managed && indirectField.managed) {
                this.fco = indirectField.fco;
            } else {
                this.managed = false;
                this.fco = false;
            }
            this.length += indirectField.length;
            this.indexCount += indirectField.indexCount;
        } else if (persistenceField != null) {
            return this.add((ManageableType.Field)persistenceField);
        }
        return this;
    }

    public IndirectField add(ManageableType.Field field) {
        assert (this.begin == 0);
        this.cast = null;
        int n = this.length + 1;
        if (n > this.chain.length) {
            this.chain = new ManageableType.Field[n += 4];
            System.arraycopy(this.chain, 0, this.chain, 0, this.length);
        }
        this.chain[this.length] = field;
        this.typeId = field.typeId;
        this.lastField = field;
        if (this.managed && field.managed) {
            this.fco = field.fco;
        } else {
            this.managed = false;
            this.fco = false;
        }
        ++this.length;
        if (field.isArrayComponent) {
            ++this.indexCount;
        }
        return this;
    }

    public void pop() {
        assert (this.begin == 0);
        this.cast = null;
        if (this.chain[--this.length].isArrayComponent) {
            --this.indexCount;
        }
        this.chain[this.length] = null;
        if (this.length > 0) {
            this.lastField = this.chain[this.length - 1];
            this.typeId = this.lastField.typeId;
            if (this.managed) {
                this.fco = this.lastField.fco;
            }
        } else {
            this.lastField = null;
            this.fco = false;
        }
    }

    public IndirectField cast(Type type) {
        this.cast = type;
        return this;
    }

    int[] read(PersistenceCapable persistenceCapable, XAQueue.Reader reader) {
        assert (this.begin == 0);
        this.clear();
        if (this.ints != null) {
            this.ints.clear();
        }
        int n = reader.readInt();
        int n2 = n >>> 24;
        ManageableType.Field field = persistenceCapable.getManageableType().getManagedField(n & 0xFFFFFF);
        this.add(field);
        Object object = persistenceCapable;
        for (n = 1; n < n2; ++n) {
            Object object2 = object = field.isArrayComponent ? field.arrayField.getArrayComponent(object, this.ints.peek(1)) : field.getObject(object);
            if (field.isArray) {
                if (this.ints == null) {
                    this.ints = new IntList();
                }
                this.ints.push(reader.readInt());
                field = field.arrayComponent;
            } else if (object instanceof Manageable) {
                field = ((Manageable)object).getManageableType().getManagedField(reader.readInt());
            } else {
                Type type = field.getType();
                if (type instanceof ManageableType || object != null && (type = reader.getBindings().resolveType(object.getClass())) != null) {
                    field = ((ManageableType)type).getManagedField(reader.readInt());
                } else {
                    throw new FatalPersistenceException(field + " " + object);
                }
            }
            if (field == null || !field.isArrayComponent && !field.getDeclaringType().isInstance(object)) {
                throw new FatalPersistenceException(field + " " + object);
            }
            this.add(field);
        }
        return this.ints != null && this.ints.size > 0 ? this.ints.elements : null;
    }

    void write(int[] nArray, XAQueue xAQueue) {
        xAQueue.writeInt(this.chain[this.begin].fieldId | this.length << 24);
        int n = -1;
        for (int i = 1; i < this.length; ++i) {
            ManageableType.Field field = this.chain[this.begin + i];
            if (field.isArrayComponent) {
                xAQueue.writeInt(nArray[++n]);
                continue;
            }
            xAQueue.writeInt(field.fieldId);
        }
    }

    void writeObject(Object object, PersistenceOutput persistenceOutput) throws IOException {
        this.lastField.writeObject(object, persistenceOutput);
    }

    private void remove(int n, int[] nArray, int n2, Object object) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.remove(n + 1, nArray, n2, object2);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            switch (field.arrayComponent.typeId) {
                case 2: {
                    ((BooleanList)object3).removeAt(n);
                    break;
                }
                case 3: {
                    ((ByteList)object3).removeAt(n);
                    break;
                }
                case 4: {
                    ((ShortList)object3).removeAt(n);
                    break;
                }
                case 5: {
                    ((CharList)object3).removeAt(n);
                    break;
                }
                case 6: {
                    ((IntList)object3).removeAt(n);
                    break;
                }
                case 7: {
                    ((LongList)object3).removeAt(n);
                    break;
                }
                case 8: {
                    ((FloatList)object3).removeAt(n);
                    break;
                }
                case 9: {
                    ((DoubleList)object3).removeAt(n);
                    break;
                }
                case 0: {
                    ((List)object3).remove(n);
                }
            }
        } else {
            int n3 = Array.getLength(object3) - 1;
            Object object4 = field.getType().createArray(n3);
            if (n > 0) {
                System.arraycopy(object3, 0, object4, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n + 1, object4, n, n3 - n);
            }
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], object4);
            } else {
                field.setObject(object, object4);
            }
        }
    }

    private static void cycle(int[] nArray, int n) {
        if (n > 1) {
            int n2 = nArray[0];
            for (int i = 1; i < n; ++i) {
                nArray[i - 1] = nArray[i];
            }
            nArray[n - 1] = n2;
        }
    }

    public void setBoolean(Object object, int[] nArray, boolean bl, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetBoolean((PersistenceCapable)object, indirectField, nArray, indirectField.getBoolean(object, nArray), bl);
        }
        indirectField.setBoolean(0, nArray, 0, object, bl);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertBoolean(Object object, int[] nArray, boolean bl, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertBoolean((PersistenceCapable)object, indirectField, nArray, bl);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertBoolean(0, nArray, 0, object, bl);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeBoolean(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveBoolean((PersistenceCapable)object, indirectField, nArray, indirectField.getBoolean(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    boolean readAndSetBoolean(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        boolean bl = reader.readBoolean();
        this.setBoolean(0, nArray, 0, persistenceCapable, bl);
        return bl;
    }

    void readAndInsertBoolean(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        boolean bl = reader.readBoolean();
        ((IndirectField)this.getShallowSuperchain()).insertBoolean(0, nArray, 0, persistenceCapable, bl);
    }

    public boolean getBoolean(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getBoolean(object);
    }

    public boolean getBoolean(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((boolean[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getBoolean(object);
    }

    public final void setBoolean(Object object, boolean bl) {
        this.setBoolean(0, null, 0, object, bl);
    }

    private void setBoolean(int n, int[] nArray, int n2, Object object, boolean bl) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setBoolean(n + 1, nArray, n2, object2, bl);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((boolean[])field.arrayField.getArray((Object)object))[nArray[n2]] = bl;
        } else {
            field.setBoolean(object, bl);
        }
    }

    private void insertBoolean(int n, int[] nArray, int n2, Object object, boolean bl) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertBoolean(n + 1, nArray, n2, object2, bl);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((BooleanList)object3).add(n, bl);
        } else {
            boolean[] blArray = (boolean[])object3;
            int n3 = blArray.length;
            blArray = new boolean[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, blArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, blArray, n + 1, n3 - n);
            }
            blArray[n] = bl;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], blArray);
            } else {
                field.setObject(object, blArray);
            }
        }
    }

    public void setByte(Object object, int[] nArray, byte by, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetByte((PersistenceCapable)object, indirectField, nArray, indirectField.getByte(object, nArray), by);
        }
        indirectField.setByte(0, nArray, 0, object, by);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertByte(Object object, int[] nArray, byte by, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertByte((PersistenceCapable)object, indirectField, nArray, by);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertByte(0, nArray, 0, object, by);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeByte(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveByte((PersistenceCapable)object, indirectField, nArray, indirectField.getByte(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    byte readAndSetByte(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        byte by = reader.readByte();
        this.setByte(0, nArray, 0, persistenceCapable, by);
        return by;
    }

    void readAndInsertByte(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        byte by = reader.readByte();
        ((IndirectField)this.getShallowSuperchain()).insertByte(0, nArray, 0, persistenceCapable, by);
    }

    public byte getByte(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getByte(object);
    }

    public byte getByte(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((byte[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getByte(object);
    }

    public final void setByte(Object object, byte by) {
        this.setByte(0, null, 0, object, by);
    }

    private void setByte(int n, int[] nArray, int n2, Object object, byte by) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setByte(n + 1, nArray, n2, object2, by);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((byte[])field.arrayField.getArray((Object)object))[nArray[n2]] = by;
        } else {
            field.setByte(object, by);
        }
    }

    private void insertByte(int n, int[] nArray, int n2, Object object, byte by) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertByte(n + 1, nArray, n2, object2, by);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((ByteList)object3).add(n, by);
        } else {
            byte[] byArray = (byte[])object3;
            int n3 = byArray.length;
            byArray = new byte[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, byArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, byArray, n + 1, n3 - n);
            }
            byArray[n] = by;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], byArray);
            } else {
                field.setObject(object, byArray);
            }
        }
    }

    public void setShort(Object object, int[] nArray, short s, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetShort((PersistenceCapable)object, indirectField, nArray, indirectField.getShort(object, nArray), s);
        }
        indirectField.setShort(0, nArray, 0, object, s);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertShort(Object object, int[] nArray, short s, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertShort((PersistenceCapable)object, indirectField, nArray, s);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertShort(0, nArray, 0, object, s);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeShort(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveShort((PersistenceCapable)object, indirectField, nArray, indirectField.getShort(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    short readAndSetShort(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        short s = reader.readShort();
        this.setShort(0, nArray, 0, persistenceCapable, s);
        return s;
    }

    void readAndInsertShort(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        short s = reader.readShort();
        ((IndirectField)this.getShallowSuperchain()).insertShort(0, nArray, 0, persistenceCapable, s);
    }

    public short getShort(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getShort(object);
    }

    public short getShort(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((short[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getShort(object);
    }

    public final void setShort(Object object, short s) {
        this.setShort(0, null, 0, object, s);
    }

    private void setShort(int n, int[] nArray, int n2, Object object, short s) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setShort(n + 1, nArray, n2, object2, s);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((short[])field.arrayField.getArray((Object)object))[nArray[n2]] = s;
        } else {
            field.setShort(object, s);
        }
    }

    private void insertShort(int n, int[] nArray, int n2, Object object, short s) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertShort(n + 1, nArray, n2, object2, s);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((ShortList)object3).add(n, s);
        } else {
            short[] sArray = (short[])object3;
            int n3 = sArray.length;
            sArray = new short[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, sArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, sArray, n + 1, n3 - n);
            }
            sArray[n] = s;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], sArray);
            } else {
                field.setObject(object, sArray);
            }
        }
    }

    public void setChar(Object object, int[] nArray, char c, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetChar((PersistenceCapable)object, indirectField, nArray, indirectField.getChar(object, nArray), c);
        }
        indirectField.setChar(0, nArray, 0, object, c);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertChar(Object object, int[] nArray, char c, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertChar((PersistenceCapable)object, indirectField, nArray, c);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertChar(0, nArray, 0, object, c);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeChar(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveChar((PersistenceCapable)object, indirectField, nArray, indirectField.getChar(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    char readAndSetChar(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        char c = reader.readChar();
        this.setChar(0, nArray, 0, persistenceCapable, c);
        return c;
    }

    void readAndInsertChar(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        char c = reader.readChar();
        ((IndirectField)this.getShallowSuperchain()).insertChar(0, nArray, 0, persistenceCapable, c);
    }

    public char getChar(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getChar(object);
    }

    public char getChar(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((char[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getChar(object);
    }

    public final void setChar(Object object, char c) {
        this.setChar(0, null, 0, object, c);
    }

    private void setChar(int n, int[] nArray, int n2, Object object, char c) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setChar(n + 1, nArray, n2, object2, c);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((char[])field.arrayField.getArray((Object)object))[nArray[n2]] = c;
        } else {
            field.setChar(object, c);
        }
    }

    private void insertChar(int n, int[] nArray, int n2, Object object, char c) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertChar(n + 1, nArray, n2, object2, c);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((CharList)object3).add(n, c);
        } else {
            char[] cArray = (char[])object3;
            int n3 = cArray.length;
            cArray = new char[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, cArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, cArray, n + 1, n3 - n);
            }
            cArray[n] = c;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], cArray);
            } else {
                field.setObject(object, cArray);
            }
        }
    }

    public void setInt(Object object, int[] nArray, int n, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n2 = 0;
        int n3 = this.indexCount;
        int n4 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n4++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n2 = i + 1;
            n3 -= n4;
            while (n4 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n4;
            }
        }
        IndirectField indirectField2 = indirectField = n2 > 0 ? this.pooledSubfield(n2, n3) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetInt((PersistenceCapable)object, indirectField, nArray, indirectField.getInt(object, nArray), n);
        }
        indirectField.setInt(0, nArray, 0, object, n);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n2; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n3;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n3), nArray, transaction);
        }
        if (n3 < this.indexCount) {
            while (--n3 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertInt(Object object, int[] nArray, int n, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n2 = 0;
        int n3 = this.indexCount;
        int n4 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n4++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n2 = i + 1;
            n3 -= n4;
            while (n4 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n4;
            }
        }
        IndirectField indirectField2 = indirectField = n2 > 0 ? this.pooledSubfield(n2, n3) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertInt((PersistenceCapable)object, indirectField, nArray, n);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertInt(0, nArray, 0, object, n);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n2; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n3;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n3).getShallowSuperchain(), nArray, transaction);
        }
        if (n3 < this.indexCount) {
            while (--n3 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeInt(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveInt((PersistenceCapable)object, indirectField, nArray, indirectField.getInt(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    int readAndSetInt(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        int n = reader.readInt();
        this.setInt(0, nArray, 0, persistenceCapable, n);
        return n;
    }

    void readAndInsertInt(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        int n = reader.readInt();
        ((IndirectField)this.getShallowSuperchain()).insertInt(0, nArray, 0, persistenceCapable, n);
    }

    public int getInt(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getInt(object);
    }

    public int getInt(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((int[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getInt(object);
    }

    public final void setInt(Object object, int n) {
        this.setInt(0, null, 0, object, n);
    }

    private void setInt(int n, int[] nArray, int n2, Object object, int n3) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setInt(n + 1, nArray, n2, object2, n3);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((int[])field.arrayField.getArray((Object)object))[nArray[n2]] = n3;
        } else {
            field.setInt(object, n3);
        }
    }

    private void insertInt(int n, int[] nArray, int n2, Object object, int n3) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertInt(n + 1, nArray, n2, object2, n3);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((IntList)object3).add(n, n3);
        } else {
            int[] nArray2 = (int[])object3;
            int n4 = nArray2.length;
            nArray2 = new int[n4 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, nArray2, 0, n);
            }
            if (n < n4) {
                System.arraycopy(object3, n, nArray2, n + 1, n4 - n);
            }
            nArray2[n] = n3;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], nArray2);
            } else {
                field.setObject(object, nArray2);
            }
        }
    }

    public void setLong(Object object, int[] nArray, long l, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetLong((PersistenceCapable)object, indirectField, nArray, indirectField.getLong(object, nArray), l);
        }
        indirectField.setLong(0, nArray, 0, object, l);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertLong(Object object, int[] nArray, long l, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertLong((PersistenceCapable)object, indirectField, nArray, l);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertLong(0, nArray, 0, object, l);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeLong(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveLong((PersistenceCapable)object, indirectField, nArray, indirectField.getLong(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    long readAndSetLong(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        long l = reader.readLong();
        this.setLong(0, nArray, 0, persistenceCapable, l);
        return l;
    }

    void readAndInsertLong(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        long l = reader.readLong();
        ((IndirectField)this.getShallowSuperchain()).insertLong(0, nArray, 0, persistenceCapable, l);
    }

    public long getLong(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getLong(object);
    }

    public long getLong(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((long[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getLong(object);
    }

    public final void setLong(Object object, long l) {
        this.setLong(0, null, 0, object, l);
    }

    private void setLong(int n, int[] nArray, int n2, Object object, long l) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setLong(n + 1, nArray, n2, object2, l);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((long[])field.arrayField.getArray((Object)object))[nArray[n2]] = l;
        } else {
            field.setLong(object, l);
        }
    }

    private void insertLong(int n, int[] nArray, int n2, Object object, long l) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertLong(n + 1, nArray, n2, object2, l);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((LongList)object3).add(n, l);
        } else {
            long[] lArray = (long[])object3;
            int n3 = lArray.length;
            lArray = new long[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, lArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, lArray, n + 1, n3 - n);
            }
            lArray[n] = l;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], lArray);
            } else {
                field.setObject(object, lArray);
            }
        }
    }

    public void setFloat(Object object, int[] nArray, float f, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetFloat((PersistenceCapable)object, indirectField, nArray, indirectField.getFloat(object, nArray), f);
        }
        indirectField.setFloat(0, nArray, 0, object, f);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertFloat(Object object, int[] nArray, float f, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertFloat((PersistenceCapable)object, indirectField, nArray, f);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertFloat(0, nArray, 0, object, f);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeFloat(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveFloat((PersistenceCapable)object, indirectField, nArray, indirectField.getFloat(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    float readAndSetFloat(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        float f = reader.readFloat();
        this.setFloat(0, nArray, 0, persistenceCapable, f);
        return f;
    }

    void readAndInsertFloat(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        float f = reader.readFloat();
        ((IndirectField)this.getShallowSuperchain()).insertFloat(0, nArray, 0, persistenceCapable, f);
    }

    public float getFloat(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getFloat(object);
    }

    public float getFloat(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((float[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getFloat(object);
    }

    public final void setFloat(Object object, float f) {
        this.setFloat(0, null, 0, object, f);
    }

    private void setFloat(int n, int[] nArray, int n2, Object object, float f) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setFloat(n + 1, nArray, n2, object2, f);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((float[])field.arrayField.getArray((Object)object))[nArray[n2]] = f;
        } else {
            field.setFloat(object, f);
        }
    }

    private void insertFloat(int n, int[] nArray, int n2, Object object, float f) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertFloat(n + 1, nArray, n2, object2, f);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((FloatList)object3).add(n, f);
        } else {
            float[] fArray = (float[])object3;
            int n3 = fArray.length;
            fArray = new float[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, fArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, fArray, n + 1, n3 - n);
            }
            fArray[n] = f;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], fArray);
            } else {
                field.setObject(object, fArray);
            }
        }
    }

    public void setDouble(Object object, int[] nArray, double d, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetDouble((PersistenceCapable)object, indirectField, nArray, indirectField.getDouble(object, nArray), d);
        }
        indirectField.setDouble(0, nArray, 0, object, d);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertDouble(Object object, int[] nArray, double d, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertDouble((PersistenceCapable)object, indirectField, nArray, d);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertDouble(0, nArray, 0, object, d);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeDouble(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveDouble((PersistenceCapable)object, indirectField, nArray, indirectField.getDouble(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    double readAndSetDouble(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        double d = reader.readDouble();
        this.setDouble(0, nArray, 0, persistenceCapable, d);
        return d;
    }

    void readAndInsertDouble(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        double d = reader.readDouble();
        ((IndirectField)this.getShallowSuperchain()).insertDouble(0, nArray, 0, persistenceCapable, d);
    }

    public double getDouble(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getDouble(object);
    }

    public double getDouble(Object object, int[] nArray) {
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? ((double[])this.lastField.arrayField.getArray(object))[nArray[n + 1]] : this.lastField.getDouble(object);
    }

    public final void setDouble(Object object, double d) {
        this.setDouble(0, null, 0, object, d);
    }

    private void setDouble(int n, int[] nArray, int n2, Object object, double d) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.setDouble(n + 1, nArray, n2, object2, d);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.isArrayComponent) {
            ((double[])field.arrayField.getArray((Object)object))[nArray[n2]] = d;
        } else {
            field.setDouble(object, d);
        }
    }

    private void insertDouble(int n, int[] nArray, int n2, Object object, double d) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object2 = field.getObject(object);
                    this.insertDouble(n + 1, nArray, n2, object2, d);
                    field.setObject(object, object2);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((DoubleList)object3).add(n, d);
        } else {
            double[] dArray = (double[])object3;
            int n3 = dArray.length;
            dArray = new double[n3 + 1];
            if (n > 0) {
                System.arraycopy(object3, 0, dArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object3, n, dArray, n + 1, n3 - n);
            }
            dArray[n] = d;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], dArray);
            } else {
                field.setObject(object, dArray);
            }
        }
    }

    public void setObject(Object object, int[] nArray, Object object2, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        if (persistenceManager != null & this.fco) {
            persistenceManager.makePersistent(object2, transaction);
        }
        Object object3 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object3 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object3, nArray[n3++]) : this.chain[i].getObject(object3);
            if (!(object3 instanceof PersistenceCapable) || ((PersistenceCapable)object3).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object3;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logSetObject((PersistenceCapable)object, indirectField, nArray, indirectField.getObject(object, nArray), object2);
        }
        indirectField.setObject(0, nArray, 0, object, object2);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField, nArray, transaction);
        }
        object3 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object3 = this.chain[i].arrayField.getArrayComponent(object3, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object3 = this.chain[i].getObject(object3);
            }
            if (!(object3 instanceof Manageable)) continue;
            ((Manageable)object3).fieldModified(this.pooledSubfield(i + 1, n2), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void insertObject(Object object, int[] nArray, Object object2, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        if (persistenceManager != null & this.fco) {
            persistenceManager.makePersistent(object2, transaction);
        }
        Object object3 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object3 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object3, nArray[n3++]) : this.chain[i].getObject(object3);
            if (!(object3 instanceof PersistenceCapable) || ((PersistenceCapable)object3).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object3;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logInsertObject((PersistenceCapable)object, indirectField, nArray, object2);
        }
        ((IndirectField)indirectField.getShallowSuperchain()).insertObject(0, nArray, 0, object, object2);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object3 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object3 = this.chain[i].arrayField.getArrayComponent(object3, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object3 = this.chain[i].getObject(object3);
            }
            if (!(object3 instanceof Manageable)) continue;
            ((Manageable)object3).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    public void removeObject(Object object, int[] nArray, Transaction transaction) {
        IndirectField indirectField;
        assert (this.begin == 0);
        PersistenceManager persistenceManager = object instanceof PersistenceCapable ? ((PersistenceCapable)object).getPersistenceManager() : null;
        Object object2 = object;
        int n = 0;
        int n2 = this.indexCount;
        int n3 = 0;
        for (int i = 0; i < this.length - 1; ++i) {
            object2 = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object2, nArray[n3++]) : this.chain[i].getObject(object2);
            if (!(object2 instanceof PersistenceCapable) || ((PersistenceCapable)object2).getPersistenceManager() == null) continue;
            object = (PersistenceCapable)object2;
            persistenceManager = ((PersistenceCapable)object).getPersistenceManager();
            n = i + 1;
            n2 -= n3;
            while (n3 > 0) {
                IndirectField.cycle(nArray, this.indexCount);
                --n3;
            }
        }
        IndirectField indirectField2 = indirectField = n > 0 ? this.pooledSubfield(n, n2) : this;
        if (transaction != null && persistenceManager != null) {
            transaction.makeActive().logRemoveObject((PersistenceCapable)object, indirectField, nArray, indirectField.getObject(object, nArray));
        }
        ((IndirectField)this.getShallowSuperchain()).remove(0, nArray, 0, object);
        if (object instanceof Manageable) {
            ((Manageable)object).fieldModified(indirectField.getShallowSuperchain(), nArray, transaction);
        }
        object2 = object;
        for (int i = n; i < this.length - 1; ++i) {
            if (this.chain[i].isArrayComponent) {
                object2 = this.chain[i].arrayField.getArrayComponent(object2, nArray[0]);
                --n2;
                IndirectField.cycle(nArray, this.indexCount);
            } else {
                object2 = this.chain[i].getObject(object2);
            }
            if (!(object2 instanceof Manageable)) continue;
            ((Manageable)object2).fieldModified(this.pooledSubfield(i + 1, n2).getShallowSuperchain(), nArray, transaction);
        }
        if (n2 < this.indexCount) {
            while (--n2 >= 0) {
                IndirectField.cycle(nArray, this.indexCount);
            }
        }
    }

    Object readAndSetObject(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        Object object = persistenceCapable;
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[i].getObject(object);
        }
        try {
            object = this.lastField.readObject(object, this.lastField.isArrayComponent ? nArray[n + 1] : -1, reader);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        this.setObject(0, nArray, 0, persistenceCapable, object);
        return object;
    }

    void readAndInsertObject(PersistenceCapable persistenceCapable, int[] nArray, XAQueue.Reader reader) {
        assert (this.begin == 0);
        Object object = persistenceCapable;
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[i].isArrayComponent ? this.chain[i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[i].getObject(object);
        }
        try {
            object = this.lastField.readObject(object, this.lastField.isArrayComponent ? nArray[n + 1] : -1, reader);
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        ((IndirectField)this.getShallowSuperchain()).insertObject(0, nArray, 0, persistenceCapable, object);
    }

    public Object getObject(Object object) {
        if (this.indexCount > 0) {
            throw new IllegalStateException(this + " contains array components");
        }
        if (this.length == 0) {
            return object;
        }
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.getObject(object);
    }

    public Object getObject(Object object, int[] nArray) {
        if (this.length == 0) {
            return object;
        }
        int n = -1;
        for (int i = 0; i < this.length - 1; ++i) {
            object = this.chain[this.begin + i].isArrayComponent ? this.chain[this.begin + i].arrayField.getArrayComponent(object, nArray[++n]) : this.chain[this.begin + i].getObject(object);
        }
        return this.lastField.isArrayComponent ? this.lastField.arrayField.getArrayComponent(object, nArray[n + 1]) : this.lastField.getObject(object);
    }

    public final void setObject(Object object, Object object2) {
        this.setObject(0, null, 0, object, object2);
    }

    private void setObject(int n, int[] nArray, int n2, Object object, Object object2) {
        Object object3;
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object4 = field.getObject(object);
                    this.setObject(n + 1, nArray, n2, object4, object2);
                    field.setObject(object, object4);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        if (field.usesList && (object3 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2]) : field.getObject(object)) == (object2 = field.setList(object3, object2)) && !field.isGetReturningCopy()) {
            return;
        }
        if (field.isArrayComponent) {
            n = nArray[n2];
            if (field.manageableType != null) {
                field.arrayField.setArrayComponent(object, n, field.manageableType.setObject(field.arrayField.getArrayComponent(object, n), object2));
            } else {
                field.arrayField.setArrayComponent(object, n, object2);
            }
        } else {
            field.setObject(object, object2);
        }
    }

    private void insertObject(int n, int[] nArray, int n2, Object object, Object object2) {
        ManageableType.Field field;
        while (n < this.length - 1) {
            field = this.chain[this.begin + n];
            if (field.isArrayComponent) {
                object = field.arrayField.getArrayComponent(object, nArray[n2++]);
            } else {
                if (field.isGetReturningCopy()) {
                    Object object3 = field.getObject(object);
                    this.insertObject(n + 1, nArray, n2, object3, object2);
                    field.setObject(object, object3);
                    return;
                }
                object = field.getObject(object);
            }
            ++n;
        }
        field = this.lastField;
        assert (field.isArray);
        Object object4 = field.isArrayComponent ? field.arrayField.getArrayComponent(object, nArray[n2++]) : field.getObject(object);
        n = nArray[n2];
        if (field.usesList) {
            ((List)object4).add(n, object2);
        } else {
            Object[] objectArray = (Object[])object4;
            int n3 = objectArray.length;
            objectArray = (Object[])field.getType().createArray(n3 + 1);
            if (n > 0) {
                System.arraycopy(object4, 0, objectArray, 0, n);
            }
            if (n < n3) {
                System.arraycopy(object4, n, objectArray, n + 1, n3 - n);
            }
            objectArray[n] = object2;
            if (field.isArrayComponent) {
                field.arrayField.setArrayComponent(object, nArray[n2 - 1], objectArray);
            } else {
                field.setObject(object, objectArray);
            }
        }
    }

    public final void setObject(PersistenceCapable persistenceCapable, int[] nArray, Object object) {
        this.setObject(0, nArray, 0, persistenceCapable, object);
    }

    public String toString() {
        Object[] objectArray = new Object[this.length];
        System.arraycopy(this.chain, this.begin, objectArray, 0, this.length);
        return "IndirectField" + Arrays.toString(objectArray);
    }
}

