/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.icon;

import de.grogra.icon.Icon;
import de.grogra.icon.IconImpl;
import de.grogra.icon.IconSource;
import de.grogra.icon.IconSourceBase;
import de.grogra.icon.IconTheme;
import de.grogra.icon.URLIconTheme;
import de.grogra.util.I18NBundle;
import de.grogra.util.ResourceConverterBase;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ScaledIconTheme
extends ResourceConverterBase
implements IconTheme {
    protected IconTheme[] themes;
    protected Dimension[] sizes;

    public ScaledIconTheme(String string, IconTheme[] iconThemeArray, Dimension[] dimensionArray) {
        super(string, new StringMap());
        this.themes = iconThemeArray;
        this.sizes = dimensionArray;
    }

    public ScaledIconTheme(String string, IconTheme[] iconThemeArray) {
        this(string, iconThemeArray, ScaledIconTheme.getSizes(iconThemeArray));
    }

    private static Dimension[] getSizes(IconTheme[] iconThemeArray) {
        Dimension[] dimensionArray = new Dimension[iconThemeArray.length];
        for (int i = 0; i < dimensionArray.length; ++i) {
            dimensionArray[i] = iconThemeArray[i].getSize();
        }
        return dimensionArray;
    }

    protected Object convertImpl(String string, I18NBundle i18NBundle) {
        for (int i = 0; i < this.themes.length; ++i) {
            if (this.themes[i].getSource(string) == null) continue;
            return new Source(string);
        }
        return null;
    }

    public IconSource getSource(String string) {
        return (IconSource)this.convert(null, string, null);
    }

    public Dimension getSize() {
        return null;
    }

    public static ScaledIconTheme readFromDirectory(String string, URL uRL, String string2) {
        if (uRL == null) {
            return ScaledIconTheme.create(string, new URL[0], new Dimension[0], string2);
        }
        return ScaledIconTheme.readFromDirectory(string, Utils.urlToFile(uRL), string2);
    }

    public static ScaledIconTheme readFromDirectory(String string, File file, String string2) {
        URL[] uRLArray = null;
        Dimension[] dimensionArray = null;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (int j = 0; j < fileArray.length; ++j) {
                int n2 = fileArray[j].getName().indexOf(120);
                if (n2 < 0) continue;
                try {
                    Dimension dimension = Utils.parseDimension(fileArray[j].getName());
                    try {
                        URL uRL = fileArray[j].toURI().toURL();
                        if (i == 1) {
                            uRLArray[n] = uRL;
                            dimensionArray[n] = dimension;
                        }
                        ++n;
                    }
                    catch (MalformedURLException malformedURLException) {}
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (i != 0) continue;
            uRLArray = new URL[n];
            dimensionArray = new Dimension[n];
        }
        return ScaledIconTheme.create(string, uRLArray, dimensionArray, string2);
    }

    public static ScaledIconTheme create(String string, URL[] uRLArray, Dimension[] dimensionArray, String string2) {
        IconTheme[] iconThemeArray = new URLIconTheme[uRLArray.length];
        for (int i = 0; i < iconThemeArray.length; ++i) {
            iconThemeArray[i] = new URLIconTheme(string, uRLArray[i], string2, dimensionArray[i]);
        }
        return new ScaledIconTheme(string, iconThemeArray, dimensionArray);
    }

    private class Source
    extends IconSourceBase {
        private final String key;

        Source(String string) {
            this.key = string;
        }

        protected Icon getIconImpl(Dimension dimension, int n) {
            Dimension dimension2;
            int n2 = 0;
            float f = Float.MAX_VALUE;
            for (int i = 0; i < ScaledIconTheme.this.sizes.length; ++i) {
                float f2;
                dimension2 = ScaledIconTheme.this.sizes[i];
                if (!(Math.abs((float)(dimension2.height * dimension.width) / (float)(dimension2.width * dimension.height) - 1.0f) < 0.2f) || !((f2 = Math.abs((float)dimension.width / (float)dimension2.width - 1.0f)) < f)) continue;
                f = f2;
                n2 = i;
            }
            if (ScaledIconTheme.this.sizes[n2].equals(dimension)) {
                IconSource iconSource = ScaledIconTheme.this.themes[n2].getSource(this.key);
                dimension2 = iconSource != null ? iconSource.getIcon(dimension, n) : null;
                return dimension2 != null ? new IconImpl((IconSource)this, (Icon)((Object)dimension2)) : null;
            }
            return this.getIcon(ScaledIconTheme.this.sizes[n2], n);
        }
    }
}

