/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.icon;

import de.grogra.icon.Icon;
import de.grogra.icon.IconSource;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.ImageIcon;

public class IconImpl
implements Icon {
    private final IconSource source;
    private final URL url;
    private final Image image;
    private final Rectangle bounds;
    private final boolean boundsCoverAll;
    private Icon icon;
    private int tolerance = 0;

    public IconImpl(IconSource iconSource, URL uRL, Image image, Rectangle rectangle) {
        this.source = iconSource;
        this.url = uRL;
        this.image = image;
        this.bounds = rectangle;
        this.boundsCoverAll = rectangle.x == 0 && rectangle.y == 0 && rectangle.width == image.getWidth(null) && rectangle.height == image.getHeight(null);
    }

    public IconImpl(IconSource iconSource, Icon icon) {
        this(iconSource, icon.getImageSource(), icon.getImage(), icon.getIconBounds());
        this.icon = icon;
    }

    public IconImpl(IconSource iconSource, URL uRL) {
        this.source = iconSource;
        this.url = uRL;
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (imageIcon.getImageLoadStatus() == 8) {
            this.image = imageIcon.getImage();
            this.bounds = new Rectangle(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        } else {
            this.image = null;
            this.bounds = null;
        }
        this.boundsCoverAll = true;
    }

    public void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        if (this.icon != null) {
            this.icon.paintIcon(component, graphics2D, n, n2, n3, n4, n5);
            return;
        }
        if (this.image == null) {
            return;
        }
        int n6 = n3 - this.bounds.width;
        int n7 = n4 - this.bounds.height;
        if (Math.abs(n6) <= this.tolerance && Math.abs(n7) <= this.tolerance) {
            n += n6 >> 1;
            n2 += n7 >> 1;
            n3 = this.bounds.width;
            n4 = this.bounds.height;
        }
        if (this.boundsCoverAll) {
            if (n3 == this.bounds.width && n4 == this.bounds.height) {
                graphics2D.drawImage(this.image, n, n2, null);
            } else {
                graphics2D.drawImage(this.image, n, n2, n3, n4, null);
            }
        } else {
            graphics2D.drawImage(this.image, n, n2, n + n3, n2 + n4, this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, null);
        }
    }

    public IconSource getIconSource() {
        return this.source;
    }

    public void prepareIcon() {
    }

    public boolean isMutable() {
        return this.url == null;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImage(int n, int n2) {
        return null;
    }

    public URL getImageSource() {
        return this.url;
    }

    public Rectangle getIconBounds() {
        return this.bounds;
    }

    public void setTolerance(int n) {
        this.tolerance = n;
    }
}

