/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph.impl;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.GraphOutput;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceOutputListener;
import de.grogra.persistence.XMLPersistenceWriter;
import de.grogra.util.IOWrapException;
import de.grogra.util.SAXElement;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLGraphWriter
extends XMLPersistenceWriter
implements GraphOutput {
    private final AttributesImpl atts = new SAXElement();
    private final StringBuffer buf = new StringBuffer();
    private GraphManager manager;
    private int visitedMark;
    private ObjectList nodesToWrite;
    private boolean onlyReferences;
    private String rootName;

    private void add(String string, String string2) {
        this.atts.addAttribute("", string, string, "CDATA", string2);
    }

    public XMLGraphWriter(ContentHandler contentHandler, PersistenceOutputListener persistenceOutputListener) {
        this(contentHandler, persistenceOutputListener, false);
    }

    public XMLGraphWriter(ContentHandler contentHandler, PersistenceOutputListener persistenceOutputListener, boolean bl) {
        super(contentHandler, persistenceOutputListener);
        this.onlyReferences = bl;
    }

    public void beginExtent(GraphManager graphManager, int n) throws IOException {
        this.beginExtent(graphManager);
        this.atts.setAttributes(NS_ATTRIBUTE);
        try {
            this.getContentHandler().startPrefixMapping("gx", "http://grogra.de/xmlpersistence");
        }
        catch (SAXException sAXException) {
            throw new IOWrapException(sAXException);
        }
        this.startElement("graph", this.atts);
        this.manager = graphManager;
        this.visitedMark = graphManager.allocateBitMark(false);
        this.nodesToWrite = new ObjectList();
    }

    public void endExtent() throws IOException {
        while (!this.nodesToWrite.isEmpty()) {
            Node node = (Node)this.nodesToWrite.pop();
            if (node.getBitMark(this.visitedMark)) continue;
            this.beginNode(node, null);
            this.endNode(node);
        }
        this.nodesToWrite = null;
        this.manager.disposeBitMark(this.visitedMark, true);
        this.manager = null;
        this.endElement("graph");
        try {
            this.getContentHandler().endPrefixMapping("gx");
        }
        catch (SAXException sAXException) {
            throw new IOWrapException(sAXException);
        }
        super.endExtent();
    }

    public void beginRoot(String string) throws IOException {
        this.rootName = string;
    }

    public void endRoot(String string) throws IOException {
    }

    public void beginNode(Node node, Edge edge) throws IOException {
        boolean bl;
        this.atts.clear();
        if (this.rootName != null) {
            this.add("root", this.rootName);
            this.rootName = null;
        }
        boolean bl2 = bl = !node.setBitMark(this.visitedMark, true) && !this.onlyReferences;
        if (bl) {
            this.add("id", Long.toString(node.getId()));
            this.add("type", node.getNType().getBinaryName());
            if (this.listener != null) {
                this.listener.objectWritten(node);
            }
        } else {
            this.add("ref", Long.toString(node.getId()));
        }
        if (edge != null) {
            this.buf.setLength(0);
            edge.getEdgeKeys(this.buf, true, false);
            this.add("edges", this.buf.toString());
        }
        this.startElement("node", this.atts);
        if (bl) {
            this.writeFields(node);
        }
    }

    public void endNode(Node node) throws IOException {
        this.endElement("node");
    }

    public void writePersistentObjectReference(PersistenceCapable persistenceCapable) throws IOException {
        super.writePersistentObjectReference(persistenceCapable);
        if (!((Node)persistenceCapable).getBitMark(this.visitedMark)) {
            this.nodesToWrite.add(persistenceCapable);
        }
    }
}

