/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.FloatAttributeAccessor;
import de.grogra.graph.GraphState;
import de.grogra.reflect.Type;
import de.grogra.util.NoSuchKeyException;
import de.grogra.util.Quantity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatAttribute
extends Attribute<Float> {
    public FloatAttribute(Type type, Quantity quantity) {
        super(type, quantity);
    }

    public FloatAttribute(Quantity quantity) {
        this(Type.FLOAT, quantity);
    }

    @Override
    public final Float get(Object object, boolean bl, GraphState graphState) {
        return Float.valueOf(graphState.getFloat(object, bl, this));
    }

    @Override
    public final Float set(Object object, boolean bl, Object object2, GraphState graphState) {
        float f = this.setFloat(object, bl, Float.valueOf(((Number)object2).floatValue()).floatValue(), graphState);
        return Float.valueOf(f);
    }

    protected float getDerived(Object object, boolean bl, GraphState graphState) {
        throw new AssertionError((Object)("getDerived not implemented in " + this.getClass()));
    }

    public float setFloat(Object object, boolean bl, float f, GraphState graphState) {
        if (this.isDerived()) {
            return this.setDerived(object, bl, f, graphState);
        }
        AttributeAccessor attributeAccessor = graphState.getGraph().getAccessor(object, bl, this);
        if (attributeAccessor != null) {
            return ((FloatAttributeAccessor)attributeAccessor).setFloat(object, f, graphState);
        }
        throw new NoSuchKeyException(object, this);
    }

    protected float setDerived(Object object, boolean bl, float f, GraphState graphState) {
        throw new UnsupportedOperationException();
    }

    public float getMinValue() {
        return -3.4028235E38f;
    }

    public float getMaxValue() {
        return Float.MAX_VALUE;
    }
}

