/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.util.Int2ObjectMap;

public class AttributeDependencies {
    private final Int2ObjectMap graph;
    private Int2ObjectMap dependent;

    public AttributeDependencies() {
        this.graph = new Int2ObjectMap();
    }

    public AttributeDependencies(AttributeDependencies attributeDependencies) {
        this.graph = attributeDependencies.graph.dup();
        for (int i = this.graph.size() - 1; i >= 0; --i) {
            this.graph.setValueAt(i, ((Int2ObjectMap)this.graph.getValueAt(i)).dup());
        }
    }

    public void add(Attribute attribute, Attribute attribute2) {
        Int2ObjectMap int2ObjectMap = (Int2ObjectMap)this.graph.get(attribute.getId());
        if (int2ObjectMap == null) {
            int2ObjectMap = new Int2ObjectMap();
            this.graph.put(attribute.getId(), int2ObjectMap);
        }
        int2ObjectMap.put(attribute.getId(), attribute);
        int2ObjectMap.put(attribute2.getId(), attribute2);
    }

    public void validate() {
        this.dependent = new Int2ObjectMap(this.graph.size());
        Int2ObjectMap int2ObjectMap = new Int2ObjectMap();
        for (int i = this.graph.size() - 1; i >= 0; --i) {
            int2ObjectMap.clear();
            int n = this.graph.getKeyAt(i);
            this.buildDep(n, int2ObjectMap);
            this.dependent.put(n, int2ObjectMap.getValues(new Attribute[int2ObjectMap.size()]));
        }
    }

    private void buildDep(int n, Int2ObjectMap int2ObjectMap) {
        Int2ObjectMap int2ObjectMap2 = (Int2ObjectMap)this.graph.get(n);
        if (int2ObjectMap2 != null) {
            for (n = int2ObjectMap2.size() - 1; n >= 0; --n) {
                if (int2ObjectMap.put(int2ObjectMap2.getKeyAt(n), int2ObjectMap2.getValueAt(n)) != null) continue;
                this.buildDep(int2ObjectMap2.getKeyAt(n), int2ObjectMap);
            }
        }
    }

    public Attribute[] getDependent(Attribute attribute) {
        Attribute[] attributeArray = (Attribute[])this.dependent.get(attribute.getId());
        return attributeArray != null ? attributeArray : attribute.toArray();
    }
}

