/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.openalea;

import de.grogra.ext.openalea.OpenAleaPlugin;
import de.grogra.ext.openalea.Server;
import de.grogra.imp.NewProject;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.Map;
import de.grogra.util.Utils;

public class ServerProject
extends NewProject {
    private static final String ITEM = "/openalea/server";

    public void run(Object object, Context context) {
        int n;
        Item item = Item.resolveItem((RegistryContext)context.getWorkbench(), (String)ITEM);
        try {
            n = Integer.parseInt((String)object);
        }
        catch (RuntimeException runtimeException) {
            n = this.getPort(context, Utils.getInt((Map)item, (Object)"port", (int)58070));
        }
        if (n == 0) {
            return;
        }
        super.run((Object)n, context);
    }

    protected void configure(Workbench workbench, Object object) {
        int n = (Integer)object;
        Server server = new Server((Context)workbench, n);
        if (!server.isServerReady()) {
            return;
        }
        server.start();
        workbench.setProperty("initial-layout", (Object)"/ui/layouts/http");
        workbench.setName(OpenAleaPlugin.I18N.msg("openaleaserver-name", (Object)Integer.toString(n)));
        workbench.ignoreIfModified();
        workbench.setProperty(ITEM, (Object)n);
    }

    public int getPort(Context context, int n) {
        String string = String.valueOf(n);
        if (context.getWindow() != null) {
            string = context.getWindow().showInputDialog(OpenAleaPlugin.I18N.msg("startopenaleaserver.title"), (Object)OpenAleaPlugin.I18N.msg("startopenaleaserver.msg-port"), string);
        }
        if (string == null) {
            return 0;
        }
        return Integer.valueOf(string);
    }
}

