/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.simple;

import de.grogra.reflect.Type;
import de.grogra.xl.impl.base.GraphImpl;
import de.grogra.xl.impl.simple.CompiletimeModel;
import de.grogra.xl.impl.simple.Node;
import de.grogra.xl.impl.simple.RuntimeModel;
import de.grogra.xl.impl.simple.SimpleProducer;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.HasModel;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.Producer;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.util.ObjectList;
import java.io.Serializable;

@HasModel(value=CompiletimeModel.class)
public class Graph
extends GraphImpl {
    final boolean canSupplyBackward;
    final ObjectList<Node> nodes = new ObjectList();

    public Graph(RuntimeModel runtimeModel, boolean bl) {
        super(runtimeModel);
        this.canSupplyBackward = bl;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean canEnumerateEdges(EdgeDirection edgeDirection, boolean bl, Serializable serializable) {
        if (edgeDirection == EdgeDirection.BOTH) {
            return false;
        }
        return this.canSupplyBackward || edgeDirection.contains((EdgeDirection)EdgeDirection.FORWARD);
    }

    protected void beginModifications() {
    }

    protected void commitModifications() {
    }

    public void enumerateNodes(Type type, QueryState queryState, int n, MatchConsumer matchConsumer, int n2) {
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            Node node = (Node)this.nodes.get(i);
            if (!type.isInstance((Object)node)) continue;
            queryState.amatch(n, (Object)node, matchConsumer, n2);
        }
    }

    public Object getRoot() {
        return this.nodes.get(0);
    }

    public void addNode(Object object) {
        if (((Node)object).index >= 0) {
            return;
        }
        ((Node)object).index = this.nodes.size;
        this.nodes.add((Object)((Node)object));
    }

    public void removeNode(Object object) {
        super.removeNode(object);
        int n = ((Node)object).index;
        if (n >= 0) {
            int n2;
            ((Node)object).index = -1;
            if (n < (n2 = --this.nodes.size)) {
                Node node = (Node)this.nodes.elements[n2];
                this.nodes.elements[n] = node;
                node.index = n;
            }
            this.nodes.elements[n2] = null;
        }
    }

    public void addEdgeBits(Object object, Object object2, int n) {
        ((Node)object).addEdgeBitsTo((Node)object2, n);
    }

    public void removeEdgeBits(Object object, Object object2, int n) {
        ((Node)object).removeEdgeBitsTo((Node)object2, n);
    }

    public Producer createProducer(QueryState queryState) {
        return new SimpleProducer(queryState);
    }
}

