/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.dom;

import de.grogra.xl.impl.base.Producer;
import de.grogra.xl.impl.dom.Graph;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.QueryState;
import org.w3c.dom.Node;

public class DOMProducer
extends Producer {
    private final Graph graph;

    public DOMProducer(QueryState queryState) {
        super(queryState);
        this.graph = (Graph)queryState.getGraph();
    }

    public Node producer$getRoot() {
        return (Node)this.graph.getRoot();
    }

    public DOMProducer operator$space(Node node) {
        this.addNodeImpl(node, true);
        return this;
    }

    public DOMProducer producer$push() {
        this.pushImpl();
        return this;
    }

    public DOMProducer producer$separate() {
        this.separateImpl();
        return this;
    }

    public DOMProducer producer$begin() {
        return this;
    }

    public void producer$end() {
    }

    public DOMProducer producer$pop(Object object) {
        this.popImpl();
        return this;
    }

    public DOMProducer operator$arrow(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$leftArrow(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$sub(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, n, (EdgeDirection)EdgeDirection.UNDIRECTED);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$gt(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, 256, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$lt(Node node, int n) {
        this.addEdgeImpl(this.getPreviousNode(), node, 256, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$plusArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 512, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$plusLeftArrow(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 512, (EdgeDirection)EdgeDirection.BACKWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public DOMProducer operator$and(Node node) {
        this.addEdgeImpl(this.getPreviousNode(), node, 16384, (EdgeDirection)EdgeDirection.FORWARD);
        this.addNodeImpl(node, false);
        return this;
    }

    public Node toNode(String string) {
        return this.graph.doc.createTextNode(string);
    }
}

