/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.impl.base;

import de.grogra.reflect.ClassLoaderAdapter;
import de.grogra.reflect.TypeLoader;
import de.grogra.xl.impl.base.ConnectionTransformation;
import de.grogra.xl.impl.base.Connector;
import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.impl.base.GraphImpl;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.base.NodeEdgePair;
import de.grogra.xl.impl.base.Operator;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.NodeData;
import de.grogra.xl.query.RuntimeModelException;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;

public class GraphQueueImpl
extends GraphQueue
implements ObjectConsumer {
    public static final int INCOMING = 1;
    public static final int OUTGOING = 2;
    static final int ADD_NODE = 1;
    static final int ADD_EDGES = 2;
    static final int ADD_SIMPLE_EDGES = 3;
    static final int ADD_UNDIRECTED_EDGES = 4;
    static final int DELETE_EDGES = 5;
    static final int DELETE_SIMPLE_EDGES = 6;
    static final int DELETE_NODE = 7;
    static final int COPY_INCOMING = 8;
    static final int MOVE_INCOMING = 9;
    static final int XCOPY_INCOMING = 10;
    static final int COPY_OUTGOING = 11;
    static final int MOVE_OUTGOING = 12;
    static final int XCOPY_OUTGOING = 13;
    static final int CONNECT_INCOMING = 14;
    static final int CONNECT_OUTGOING = 15;
    static final int CONNECT = 16;
    static final int CONNECT_ADJACENT = 17;
    static final int EMBED_INTERPRETIVE = 18;
    static final int EXECUTE = 19;
    final GraphImpl graph;
    final RuntimeModel model;
    private static final int SIMPLE_EDGE_MASK = 0x3FFFF00;
    private static final int SIMPLE_EDGE_SHIFT = 4;
    private final TypeLoader loader = new ClassLoaderAdapter(this.getClass().getClassLoader());
    EHashMap<NodeData> deletedNodes = new EHashMap((EHashMap.Entry[])new NodeData[1], 32, 0.75f);
    NodeData key = new NodeData();
    final ConnectionTransformation[] ctPool = new ConnectionTransformation[1];
    EHashMap<ConnectionTransformation> inConnTrans = new EHashMap((EHashMap.Entry[])this.ctPool, 32, 0.75f);
    EHashMap<ConnectionTransformation> outConnTrans = new EHashMap((EHashMap.Entry[])this.ctPool, 32, 0.75f);
    ConnectionTransformation ctKey = new ConnectionTransformation();
    private ConnectionTransformation curConnTrans;
    private boolean curConnTransOut;
    private EHashMap<ConnectionTransformation> otherConnTransMap;
    private ObjectList connNodes = new ObjectList();
    private IntList connEdges = new IntList();
    private final NodeEdgePair nodeEdgePair = new NodeEdgePair();

    public GraphQueueImpl(QueueDescriptor queueDescriptor, QueueCollection queueCollection) {
        super(queueDescriptor, true, false);
        this.setItemSize(1, 0, 0, 0, 0, 0, 1);
        this.setItemSize(2, 0, 1, 0, 0, 0, 2);
        this.setItemSize(3, 0, 0, 0, 0, 0, 2);
        this.setItemSize(4, 0, 1, 0, 0, 0, 2);
        this.setItemSize(5, 0, 1, 0, 0, 0, 2);
        this.setItemSize(6, 0, 0, 0, 0, 0, 2);
        this.setItemSize(7, 0, 0, 0, 0, 0, 1);
        this.setItemSize(8, 0, 1, 0, 0, 0, 2);
        this.setItemSize(9, 0, 1, 0, 0, 0, 2);
        this.setItemSize(10, 0, 3, 0, 0, 0, 2);
        this.setItemSize(11, 0, 1, 0, 0, 0, 2);
        this.setItemSize(12, 0, 1, 0, 0, 0, 2);
        this.setItemSize(13, 0, 3, 0, 0, 0, 2);
        this.setItemSize(14, 0, 0, 0, 0, 0, 3);
        this.setItemSize(15, 0, 0, 0, 0, 0, 3);
        this.setItemSize(16, 0, 0, 0, 0, 0, 4);
        this.setItemSize(17, 0, 1, 0, 0, 0, 2);
        this.setItemSize(18, 0, 0, 0, 0, 0, 3);
        this.setItemSize(19, 0, 0, 0, 0, 0, 1);
        this.graph = (GraphImpl)queueCollection.getGraph();
        this.model = (RuntimeModel)queueCollection.getModel();
    }

    protected RuntimeModel getModel() {
        return this.model;
    }

    public void addNode(Object object) {
        this.writeItem(1);
        this.writeObjectInQueue(object);
    }

    public void addEdgeBits(Object object, Object object2, int n) {
        if ((n & 0xFC0000FF) != 0) {
            this.writeItem(2);
            this.writeObjectInQueue(object);
            this.writeObjectInQueue(object2);
            this.writeInt(n);
        } else {
            this.writeItem(3 | n << 4);
            this.writeObjectInQueue(object);
            this.writeObjectInQueue(object2);
        }
    }

    public void addUndirectedEdgeBits(Object object, Object object2, int n) {
        this.writeItem(4);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
    }

    public void deleteEdgeBits(Object object, Object object2, int n) {
        if ((n & 0xFC0000FF) != 0) {
            this.writeItem(5);
            this.writeObjectInQueue(object);
            this.writeObjectInQueue(object2);
            this.writeInt(n);
        } else {
            this.writeItem(6 | n << 4);
            this.writeObjectInQueue(object);
            this.writeObjectInQueue(object2);
        }
    }

    public void deleteCurrentEdges(Object object, int n, boolean bl) {
        EdgeIterator edgeIterator = this.model.createEdgeIterator(object, (EdgeDirection)EdgeDirection.UNDIRECTED);
        while (edgeIterator.hasEdge()) {
            Object object2 = edgeIterator.source;
            Object object3 = edgeIterator.target;
            int n2 = edgeIterator.edgeBits;
            edgeIterator.moveToNext();
            if (!RuntimeModel.testEdgeBits(n2, n)) continue;
            n2 &= n;
            if (object2 == object) {
                if (!bl) continue;
                this.deleteEdgeBits(object2, object3, n2);
                continue;
            }
            if (bl) continue;
            this.deleteEdgeBits(object2, object3, n2);
        }
    }

    public void deleteNode(Object object) {
        this.writeItem(7);
        this.writeObjectInQueue(object);
    }

    public void copyIncoming(Object object, Object object2, int n) {
        if (n == 0) {
            return;
        }
        this.writeItem(8);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
    }

    public void moveIncoming(Object object, Object object2, int n) {
        if (n == 0) {
            return;
        }
        this.writeItem(9);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
    }

    public void copyIncoming(Object object, Object object2, int n, int n2, int n3) {
        if (n == 0 || (n2 & n) == 0 && n3 == 0) {
            return;
        }
        this.writeItem(10);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
        this.writeInt(n2);
        this.writeInt(n3);
    }

    public void copyOutgoing(Object object, Object object2, int n) {
        if (n == 0) {
            return;
        }
        this.writeItem(11);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
    }

    public void moveOutgoing(Object object, Object object2, int n) {
        if (n == 0) {
            return;
        }
        this.writeItem(12);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
    }

    public void copyOutgoing(Object object, Object object2, int n, int n2, int n3) {
        if (n == 0 || (n2 & n) == 0 && n3 == 0) {
            return;
        }
        this.writeItem(13);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
        this.writeInt(n2);
        this.writeInt(n3);
    }

    public void connectIncoming(Object object, Object object2, Operator operator) {
        this.writeItem(14);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeObjectInQueue(operator);
    }

    public void connectOutgoing(Object object, Object object2, Operator operator) {
        this.writeItem(15);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeObjectInQueue(operator);
    }

    public void connect(Object object, Object object2, Object object3, Connector connector) {
        connector.getClass();
        this.writeItem(16);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeObjectInQueue(object3);
        this.writeObjectInQueue(connector);
    }

    public void connectAdjacent(Object object, Object object2, int n) {
        if (n == 0) {
            return;
        }
        this.writeItem(17);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeInt(n);
    }

    public void embedInterpretive(Object object, Object object2, Object object3) {
        this.writeItem(18);
        this.writeObjectInQueue(object);
        this.writeObjectInQueue(object2);
        this.writeObjectInQueue(object3);
    }

    public void execute(Runnable runnable) {
        runnable.getClass();
        this.writeItem(19);
        this.writeObjectInQueue(runnable);
    }

    protected int maskConnectionEdges(int n) {
        return n;
    }

    protected TypeLoader getTypeLoader() {
        return this.loader;
    }

    public void clearSegmentsToExclude(int[] nArray) {
        if (!this.getDescriptor().equals(DELETE_NODE_DESCRIPTOR)) {
            return;
        }
        this.deletedNodes.clear();
        this.clearSegmentsToExcludeImpl(nArray);
    }

    protected GraphQueue.Processor createProcessor() {
        return new GraphQueue.Processor(this.getTypeLoader()){

            protected boolean process(int n) throws IOException, RuntimeModelException {
                switch (n & 0xFFF) {
                    case 1: {
                        if (!this.execute) {
                            return false;
                        }
                        GraphQueueImpl.this.graph.addNode(this.readObjectInQueue());
                        return true;
                    }
                    case 2: {
                        if (!this.execute) {
                            return false;
                        }
                        GraphQueueImpl.this.graph.addEdgeBits(this.readObjectInQueue(), this.readObjectInQueue(), this.readInt());
                        return true;
                    }
                    case 3: {
                        if (!this.execute) {
                            return false;
                        }
                        GraphQueueImpl.this.graph.addEdgeBits(this.readObjectInQueue(), this.readObjectInQueue(), n >>> 4 & 0x3FFFF00);
                        return true;
                    }
                    case 4: {
                        if (!this.execute) {
                            return false;
                        }
                        Object object = this.readObjectInQueue();
                        Object object2 = this.readObjectInQueue();
                        int n2 = this.readInt();
                        int n3 = GraphQueueImpl.this.model.getEdgeBits(object, object2);
                        if (n3 == 0 && (n3 = GraphQueueImpl.this.model.getEdgeBits(object2, object)) != 0) {
                            Object object3 = object;
                            object = object2;
                            object2 = object3;
                        }
                        int n4 = n2 & 0xFF;
                        int n5 = 0;
                        if (n4 != 0) {
                            if (n4 == (n3 & 0xFF)) {
                                n2 &= 0xFFFFFF00;
                            } else if ((n3 & 0xFF) != 0) {
                                n5 = 255;
                            }
                        }
                        if (n5 != 0) {
                            GraphQueueImpl.this.graph.removeEdgeBits(object, object2, n5);
                        }
                        if ((n2 &= ~n3 | 0xFF) != 0) {
                            GraphQueueImpl.this.graph.addEdgeBits(object, object2, n2);
                        }
                        return true;
                    }
                    case 5: {
                        if (!this.execute) {
                            return false;
                        }
                        GraphQueueImpl.this.graph.removeEdgeBits(this.readObjectInQueue(), this.readObjectInQueue(), this.readInt());
                        return true;
                    }
                    case 6: {
                        if (!this.execute) {
                            return false;
                        }
                        GraphQueueImpl.this.graph.removeEdgeBits(this.readObjectInQueue(), this.readObjectInQueue(), n >>> 4 & 0x3FFFF00);
                        return true;
                    }
                    case 7: {
                        Object object = this.readObjectInQueue();
                        if (this.execute) {
                            GraphQueueImpl.this.graph.removeNode(object);
                        } else if (this.checkApplicability) {
                            GraphQueueImpl.this.key.setNode(object);
                            if (GraphQueueImpl.this.deletedNodes.get((EHashMap.Entry)GraphQueueImpl.this.key) != null) {
                                this.clearSegment = true;
                            }
                        } else if (this.markApplicability) {
                            NodeData nodeData = (NodeData)GraphQueueImpl.this.deletedNodes.popEntryFromPool();
                            if (nodeData == null) {
                                nodeData = new NodeData();
                            }
                            nodeData.setNode(object);
                            GraphQueueImpl.this.deletedNodes.getOrPut((EHashMap.Entry)nodeData);
                        }
                        return true;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 16: {
                        int n6;
                        int n7;
                        int n8;
                        boolean bl;
                        boolean bl2;
                        if (!this.execute) {
                            return false;
                        }
                        Object object = this.readObjectInQueue();
                        Object object4 = this.readObjectInQueue();
                        boolean bl3 = false;
                        switch (n & 0xFFF) {
                            case 9: {
                                bl3 = true;
                            }
                            case 8: {
                                bl2 = true;
                                bl = false;
                                n8 = this.readInt();
                                n7 = -1;
                                n6 = 0;
                                break;
                            }
                            case 10: {
                                bl2 = true;
                                bl = false;
                                n8 = this.readInt();
                                n7 = this.readInt();
                                n6 = this.readInt();
                                break;
                            }
                            case 12: {
                                bl3 = true;
                            }
                            case 11: {
                                bl2 = false;
                                bl = true;
                                n8 = this.readInt();
                                n7 = -1;
                                n6 = 0;
                                break;
                            }
                            case 13: {
                                bl2 = false;
                                bl = true;
                                n8 = this.readInt();
                                n7 = this.readInt();
                                n6 = this.readInt();
                                break;
                            }
                            case 16: {
                                Object object5 = this.readObjectInQueue();
                                ((Connector)this.readObjectInQueue()).connect(object, object4, object5, GraphQueueImpl.this);
                                return true;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        n8 = GraphQueueImpl.this.maskConnectionEdges(n8);
                        EdgeIterator edgeIterator = GraphQueueImpl.this.model.createEdgeIterator(object, (EdgeDirection)EdgeDirection.UNDIRECTED);
                        while (edgeIterator.hasEdge()) {
                            Object object6 = edgeIterator.source;
                            Object object7 = edgeIterator.target;
                            int n9 = edgeIterator.edgeBits;
                            edgeIterator.moveToNext();
                            if (!RuntimeModel.testEdgeBits(n9, n8)) continue;
                            int n10 = (n9 &= n8 & n7) | n6;
                            if (object6 == object) {
                                if (!bl || object7 == object4) continue;
                                if (bl3 && n9 != 0) {
                                    GraphQueueImpl.this.graph.removeEdgeBits(object, object7, n9);
                                }
                                GraphQueueImpl.this.graph.addEdgeBits(object4, object7, n10);
                                continue;
                            }
                            if (!bl2 || object6 == object4) continue;
                            if (bl3 && n9 != 0) {
                                GraphQueueImpl.this.graph.removeEdgeBits(object6, object, n9);
                            }
                            GraphQueueImpl.this.graph.addEdgeBits(object6, object4, n10);
                        }
                        return true;
                    }
                    case 17: {
                        if (!this.execute) {
                            return false;
                        }
                        Object object = this.readObjectInQueue();
                        Object object8 = this.readObjectInQueue();
                        int n11 = this.readInt();
                        Object object9 = GraphQueueImpl.this.graph.getPredecessor(object);
                        if (object9 == null) {
                            return false;
                        }
                        EdgeIterator edgeIterator = GraphQueueImpl.this.model.createEdgeIterator(object8, (EdgeDirection)EdgeDirection.UNDIRECTED);
                        while (edgeIterator.hasEdge()) {
                            Object object10 = edgeIterator.source;
                            Object object11 = edgeIterator.target;
                            int n12 = edgeIterator.edgeBits;
                            edgeIterator.moveToNext();
                            if (object11 == object8 || !RuntimeModel.testEdgeBits(n12, n11)) continue;
                            GraphQueueImpl.this.graph.removeEdgeBits(object8, object11, n12);
                            if (object9 == object11) continue;
                            GraphQueueImpl.this.graph.addEdgeBits(object9, object11, n12);
                        }
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!this.execute) {
                            return false;
                        }
                        Object object = this.readObjectInQueue();
                        Object object12 = this.readObjectInQueue();
                        ConnectionTransformation connectionTransformation = (ConnectionTransformation)GraphQueueImpl.this.inConnTrans.popEntryFromPool();
                        if (connectionTransformation == null) {
                            connectionTransformation = new ConnectionTransformation();
                        }
                        connectionTransformation.setSource(object);
                        connectionTransformation.target = object12;
                        connectionTransformation.operator = (Operator)this.readObjectInQueue();
                        ((n & 0xFFF) == 14 ? GraphQueueImpl.this.inConnTrans : GraphQueueImpl.this.outConnTrans).add((EHashMap.Entry)connectionTransformation);
                        return false;
                    }
                    case 18: {
                        Object object;
                        if (!this.execute) {
                            return false;
                        }
                        Object object13 = this.readObjectInQueue();
                        Object object14 = this.readObjectInQueue();
                        Object object15 = this.readObjectInQueue();
                        EdgeIterator edgeIterator = GraphQueueImpl.this.model.createEdgeIterator(object13, (EdgeDirection)EdgeDirection.UNDIRECTED);
                        while (edgeIterator.hasEdge()) {
                            object = edgeIterator.source;
                            Object object16 = edgeIterator.target;
                            int n13 = edgeIterator.edgeBits;
                            edgeIterator.moveToNext();
                            if ((n13 &= 0x300) == 0 || object == object13) continue;
                            GraphQueueImpl.this.graph.removeEdgeBits(object, object13, n13);
                            GraphQueueImpl.this.graph.addEdgeBits(object, object14, n13 | 0x400);
                            break;
                        }
                        GraphQueueImpl.this.graph.addEdgeBits(object15, object13, 2304);
                        object = GraphQueueImpl.this.graph.createInterpretiveMark();
                        GraphQueueImpl.this.graph.addEdgeBits(object14, object, 8192);
                        GraphQueueImpl.this.graph.addEdgeBits(object, object15, 8192);
                        return true;
                    }
                    case 19: {
                        if (!this.execute) {
                            return false;
                        }
                        ((Runnable)this.readObjectInQueue()).run();
                        return true;
                    }
                }
                return super.process(n);
            }
        };
    }

    public void consume(Object object) {
        int n;
        NodeEdgePair nodeEdgePair = (NodeEdgePair)object;
        this.ctKey.setSource(nodeEdgePair.node);
        boolean bl = false;
        for (ConnectionTransformation connectionTransformation = (ConnectionTransformation)this.otherConnTransMap.get((EHashMap.Entry)this.ctKey); connectionTransformation != null; connectionTransformation = (ConnectionTransformation)connectionTransformation.next()) {
            int n2 = connectionTransformation.operator.match(this.curConnTrans.source, this.curConnTrans.operator, nodeEdgePair);
            if (n2 == 0) continue;
            bl = true;
            if (!this.curConnTransOut || n2 == 255) continue;
            this.connNodes.push(this.curConnTrans.target, connectionTransformation.target);
            this.connEdges.push(n2);
        }
        if (!bl && (n = this.curConnTrans.operator.getUnilateralEdgeBits(this.curConnTrans.source, nodeEdgePair)) != 0) {
            if (this.curConnTransOut) {
                this.connNodes.push(this.curConnTrans.target, nodeEdgePair.node);
            } else {
                this.connNodes.push(nodeEdgePair.node, this.curConnTrans.target);
            }
            this.connEdges.push(n);
        }
    }

    public boolean process(int[] nArray) throws RuntimeModelException {
        this.inConnTrans.clear();
        this.outConnTrans.clear();
        this.connNodes.clear();
        this.connEdges.clear();
        boolean bl = super.process(nArray);
        this.otherConnTransMap = this.inConnTrans;
        this.curConnTransOut = true;
        Object object = (ConnectionTransformation)this.outConnTrans.getFirstEntry();
        while (object != null) {
            this.curConnTrans = object;
            this.nodeEdgePair.node = object.source;
            object.operator.evaluate(this, this.nodeEdgePair);
            object = (ConnectionTransformation)object.listNext;
        }
        this.otherConnTransMap = this.outConnTrans;
        this.curConnTransOut = false;
        object = (ConnectionTransformation)this.inConnTrans.getFirstEntry();
        while (object != null) {
            this.curConnTrans = object;
            this.nodeEdgePair.node = object.source;
            object.operator.evaluate(this, this.nodeEdgePair);
            object = (ConnectionTransformation)object.listNext;
        }
        if (!this.connNodes.isEmpty()) {
            bl = true;
            while (!this.connNodes.isEmpty()) {
                object = this.connNodes.pop();
                this.graph.addEdgeBits(this.connNodes.pop(), object, this.connEdges.pop());
            }
        }
        this.inConnTrans.clear();
        this.outConnTrans.clear();
        this.connNodes.clear();
        this.connEdges.clear();
        return bl;
    }
}

