/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.numeric;

import de.grogra.numeric.FirstOrderDifferentialEquationsAdapter;
import de.grogra.numeric.Monitor;
import de.grogra.numeric.NumericException;
import de.grogra.numeric.ODE;
import de.grogra.numeric.Solver;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.events.EventException;
import org.apache.commons.math.ode.events.EventHandler;

public class FirstOrderIntegratorAdapter
implements Solver {
    public static final double MAX_CHECK_INTERVAL = 1.0;
    public static final double CONVERGENCE = 1.0E-4;
    public static final int MAX_ITERATION_COUNT = 100;
    FirstOrderIntegrator integrator;
    int n;
    Monitor monitor;
    final EventData data = new EventData();

    public FirstOrderIntegratorAdapter(FirstOrderIntegrator firstOrderIntegrator) {
        this.integrator = firstOrderIntegrator;
    }

    public void integrate(ODE oDE, double d, double[] dArray, double d2, double[] dArray2) throws NumericException {
        assert (dArray != null);
        assert (dArray2 != null);
        assert (dArray.length == dArray2.length);
        int n = dArray2.length;
        FirstOrderDifferentialEquationsAdapter firstOrderDifferentialEquationsAdapter = new FirstOrderDifferentialEquationsAdapter(oDE, n);
        try {
            double d3 = d;
            System.arraycopy(dArray, 0, dArray2, 0, n);
            while (Math.abs(d3 - d2) > 1.0E-4) {
                d3 = this.integrator.integrate((FirstOrderDifferentialEquations)firstOrderDifferentialEquationsAdapter, d3, dArray2, d2, dArray2);
                if (this.n <= 0) continue;
                this.data.t = Double.NaN;
                this.monitor.g(this.data.gout, d3, dArray2);
                boolean bl = false;
                for (int i = 0; i < this.n; ++i) {
                    if (!(Math.abs(this.data.gout[i]) < 2.0E-4)) continue;
                    bl |= this.monitor.handleEvent(i, d3, dArray2);
                }
                if (!bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new NumericException(exception);
        }
    }

    public void setMonitor(int n, final Monitor monitor) {
        assert (n == 0 || monitor != null);
        this.n = n;
        this.monitor = monitor;
        this.integrator.clearEventHandlers();
        this.data.gout = new double[n];
        int n2 = 0;
        while (n2 < n) {
            final int n3 = n2++;
            EventHandler eventHandler = new EventHandler(){
                final int i;
                {
                    this.i = n3;
                }

                public int eventOccurred(double d, double[] dArray, boolean bl) throws EventException {
                    return 0;
                }

                public double g(double d, double[] dArray) throws EventException {
                    assert (dArray != null);
                    if (Double.compare(FirstOrderIntegratorAdapter.this.data.t, d) != 0 || !Arrays.equals(FirstOrderIntegratorAdapter.this.data.y, dArray)) {
                        if (FirstOrderIntegratorAdapter.this.data.y == null || FirstOrderIntegratorAdapter.this.data.y.length != dArray.length) {
                            FirstOrderIntegratorAdapter.this.data.y = (double[])dArray.clone();
                        } else {
                            System.arraycopy(dArray, 0, FirstOrderIntegratorAdapter.this.data.y, 0, dArray.length);
                        }
                        FirstOrderIntegratorAdapter.this.data.t = d;
                        monitor.g(FirstOrderIntegratorAdapter.this.data.gout, d, dArray);
                    }
                    return FirstOrderIntegratorAdapter.this.data.gout[this.i];
                }

                public void resetState(double d, double[] dArray) throws EventException {
                    throw new EventException("NOT IMPLEMENTED", new Object[0]);
                }
            };
            this.integrator.addEventHandler(eventHandler, 1.0, 1.0E-4, 100);
        }
    }

    public void setOptions(Map map) {
    }

    public void setTolerances(double[] dArray, double[] dArray2) {
    }

    private static class EventData {
        double t;
        double[] y;
        double[] gout;

        private EventData() {
        }
    }
}

