/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class LegendGraphic
extends AbstractBlock
implements Block,
PublicCloneable {
    private boolean shapeVisible;
    private transient Shape shape;
    private RectangleAnchor shapeLocation;
    private RectangleAnchor shapeAnchor;
    private boolean shapeFilled;
    private transient Paint fillPaint;
    private boolean shapeOutlineVisible;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient Stroke lineStroke;
    private transient Paint linePaint;

    public LegendGraphic(Shape shape, Paint paint) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'fillPaint' argument.");
        }
        this.shapeVisible = true;
        this.shape = shape;
        this.shapeAnchor = RectangleAnchor.CENTER;
        this.shapeLocation = RectangleAnchor.CENTER;
        this.shapeFilled = true;
        this.fillPaint = paint;
        this.setPadding(2.0, 2.0, 2.0, 2.0);
    }

    public boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public void setShapeVisible(boolean bl) {
        this.shapeVisible = bl;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public void setShapeFilled(boolean bl) {
        this.shapeFilled = bl;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public void setShapeOutlineVisible(boolean bl) {
        this.shapeOutlineVisible = bl;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public RectangleAnchor getShapeAnchor() {
        return this.shapeAnchor;
    }

    public void setShapeAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.shapeAnchor = rectangleAnchor;
    }

    public RectangleAnchor getShapeLocation() {
        return this.shapeLocation;
    }

    public void setShapeLocation(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.shapeLocation = rectangleAnchor;
    }

    public boolean isLineVisible() {
        return this.lineVisible;
    }

    public void setLineVisible(boolean bl) {
        this.lineVisible = bl;
    }

    public Shape getLine() {
        return this.line;
    }

    public void setLine(Shape shape) {
        this.line = shape;
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setLinePaint(Paint paint) {
        this.linePaint = paint;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }

    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        LengthConstraintType lengthConstraintType = rectangleConstraint2.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint2.getHeightConstraintType();
        Size2D size2D = null;
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeNN(graphics2D);
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                size2D = new Size2D(rectangleConstraint2.getWidth(), rectangleConstraint2.getHeight());
            }
        }
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    protected Size2D arrangeNN(Graphics2D graphics2D) {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        if (this.line != null) {
            ((Rectangle2D)rectangle2D).setRect(this.line.getBounds2D());
        }
        if (this.shape != null) {
            rectangle2D = ((Rectangle2D)rectangle2D).createUnion(this.shape.getBounds2D());
        }
        return new Size2D(((RectangularShape)rectangle2D).getWidth(), ((RectangularShape)rectangle2D).getHeight());
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape;
        Point2D point2D;
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        rectangle2D = this.trimPadding(rectangle2D);
        if (this.lineVisible) {
            point2D = RectangleAnchor.coordinates((Rectangle2D)rectangle2D, (RectangleAnchor)this.shapeLocation);
            shape = ShapeUtilities.createTranslatedShape((Shape)this.getLine(), (RectangleAnchor)this.shapeAnchor, (double)point2D.getX(), (double)point2D.getY());
            graphics2D.setPaint(this.linePaint);
            graphics2D.setStroke(this.lineStroke);
            graphics2D.draw(shape);
        }
        if (this.shapeVisible) {
            point2D = RectangleAnchor.coordinates((Rectangle2D)rectangle2D, (RectangleAnchor)this.shapeLocation);
            shape = ShapeUtilities.createTranslatedShape((Shape)this.shape, (RectangleAnchor)this.shapeAnchor, (double)point2D.getX(), (double)point2D.getY());
            if (this.shapeFilled) {
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(shape);
            }
            if (this.shapeOutlineVisible) {
                graphics2D.setPaint(this.outlinePaint);
                graphics2D.setStroke(this.outlineStroke);
                graphics2D.draw(shape);
            }
        }
    }

    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        this.draw(graphics2D, rectangle2D);
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LegendGraphic)) {
            return false;
        }
        LegendGraphic legendGraphic = (LegendGraphic)object;
        if (this.shapeVisible != legendGraphic.shapeVisible) {
            return false;
        }
        if (!ShapeUtilities.equal((Shape)this.shape, (Shape)legendGraphic.shape)) {
            return false;
        }
        if (this.shapeFilled != legendGraphic.shapeFilled) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.fillPaint, (Paint)legendGraphic.fillPaint)) {
            return false;
        }
        if (this.shapeOutlineVisible != legendGraphic.shapeOutlineVisible) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.outlinePaint, (Paint)legendGraphic.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.outlineStroke, (Object)legendGraphic.outlineStroke)) {
            return false;
        }
        if (this.shapeAnchor != legendGraphic.shapeAnchor) {
            return false;
        }
        if (this.shapeLocation != legendGraphic.shapeLocation) {
            return false;
        }
        if (this.lineVisible != legendGraphic.lineVisible) {
            return false;
        }
        if (!ShapeUtilities.equal((Shape)this.line, (Shape)legendGraphic.line)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.linePaint, (Paint)legendGraphic.linePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.lineStroke, (Object)legendGraphic.lineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape((Shape)this.shape, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.fillPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.line, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.linePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.lineStroke, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.shape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.fillPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.line = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.linePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.lineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
    }
}

