/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.PublicCloneable;

public class CategoryStepRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5121079703118261470L;
    public static final int STAGGER_WIDTH = 5;
    private boolean stagger = false;
    private transient Line2D line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public CategoryStepRenderer() {
        this(false);
    }

    public CategoryStepRenderer(boolean bl) {
        this.stagger = bl;
    }

    public boolean getStagger() {
        return this.stagger;
    }

    public void setStagger(boolean bl) {
        this.stagger = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    protected void drawLine(Graphics2D graphics2D, PlotOrientation plotOrientation, double d, double d2, double d3, double d4) {
        if (plotOrientation == PlotOrientation.VERTICAL) {
            this.line.setLine(d, d2, d3, d4);
            graphics2D.draw(this.line);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.line.setLine(d2, d, d4, d3);
            graphics2D.draw(this.line);
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number;
        Number number2 = categoryDataset.getValue(n, n2);
        if (number2 == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d3 = 2.0 * d2 - d;
        double d4 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        if (n2 != 0 && (number = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d5 = number.doubleValue();
            double d6 = categoryAxis.getCategoryStart(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d7 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d8 = 2.0 * d7 - d6;
            double d9 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            if (this.getStagger()) {
                int n4 = n * 5;
                if ((double)n4 > d - d8) {
                    n4 = (int)(d - d8);
                }
                d = d8 + (double)n4;
            }
            this.drawLine(graphics2D, plotOrientation, d8, d9, d, d9);
            this.drawLine(graphics2D, plotOrientation, d, d9, d, d4);
        }
        this.drawLine(graphics2D, plotOrientation, d, d4, d3, d4);
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d2, d4, number2.doubleValue() < 0.0);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryStepRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CategoryStepRenderer categoryStepRenderer = (CategoryStepRenderer)object;
        return this.stagger == categoryStepRenderer.stagger;
    }
}

