/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;

public class ModuloAxis
extends NumberAxis {
    private Range fixedRange;
    private double displayStart;
    private double displayEnd;

    public ModuloAxis(String string, Range range) {
        super(string);
        this.fixedRange = range;
        this.displayStart = 270.0;
        this.displayEnd = 90.0;
    }

    public double getDisplayStart() {
        return this.displayStart;
    }

    public double getDisplayEnd() {
        return this.displayEnd;
    }

    public void setDisplayRange(double d, double d2) {
        this.displayStart = this.mapValueToFixedRange(d);
        this.displayEnd = this.mapValueToFixedRange(d2);
        if (this.displayStart < this.displayEnd) {
            this.setRange(this.displayStart, this.displayEnd);
        } else {
            this.setRange(this.displayStart, this.fixedRange.getUpperBound() + (this.displayEnd - this.fixedRange.getLowerBound()));
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void autoAdjustRange() {
        this.setRange(this.fixedRange, false, false);
    }

    public double valueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        double d3 = this.mapValueToFixedRange(d);
        if (this.displayStart < this.displayEnd) {
            d2 = this.trans(d3, rectangle2D, rectangleEdge);
        } else {
            double d4 = (this.displayStart + this.displayEnd) / 2.0;
            double d5 = this.fixedRange.getUpperBound() - this.displayStart;
            double d6 = this.displayEnd - this.fixedRange.getLowerBound();
            d2 = d3 > d4 ? this.transStart(d3, rectangle2D, rectangleEdge, d5, d6) : this.transEnd(d3, rectangle2D, rectangleEdge, d5, d6);
        }
        return d2;
    }

    private double trans(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d2 = rectangle2D.getX();
            d3 = rectangle2D.getX() + rectangle2D.getWidth();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d2 = rectangle2D.getMaxY();
            d3 = rectangle2D.getMaxY() - rectangle2D.getHeight();
        }
        if (this.isInverted()) {
            return d3 - (d - this.displayStart) / (this.displayEnd - this.displayStart) * (d3 - d2);
        }
        return d2 + (d - this.displayStart) / (this.displayEnd - this.displayStart) * (d3 - d2);
    }

    private double transStart(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getX() + rectangle2D.getWidth() * d2 / (d2 + d3);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMaxY() - rectangle2D.getHeight() * d2 / (d2 + d3);
        }
        if (this.isInverted()) {
            return d5 - (d - this.displayStart) / (this.fixedRange.getUpperBound() - this.displayStart) * (d5 - d4);
        }
        return d4 + (d - this.displayStart) / (this.fixedRange.getUpperBound() - this.displayStart) * (d5 - d4);
    }

    private double transEnd(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d5 = rectangle2D.getMaxX();
            d4 = rectangle2D.getMaxX() - rectangle2D.getWidth() * d3 / (d2 + d3);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMinY() + rectangle2D.getHeight() * d3 / (d2 + d3);
        }
        if (this.isInverted()) {
            return d5 - (d - this.fixedRange.getLowerBound()) / (this.displayEnd - this.fixedRange.getLowerBound()) * (d5 - d4);
        }
        return d4 + (d - this.fixedRange.getLowerBound()) / (this.displayEnd - this.fixedRange.getLowerBound()) * (d5 - d4);
    }

    private double mapValueToFixedRange(double d) {
        double d2 = this.fixedRange.getLowerBound();
        double d3 = this.fixedRange.getLength();
        if (d < d2) {
            return d2 + d3 + (d - d2) % d3;
        }
        return d2 + (d - d2) % d3;
    }

    public double java2DToValue(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        if (this.displayStart < this.displayEnd) {
            d2 = super.java2DToValue(d, rectangle2D, rectangleEdge);
        }
        return d2;
    }

    private double getDisplayLength() {
        if (this.displayStart < this.displayEnd) {
            return this.displayEnd - this.displayStart;
        }
        return this.fixedRange.getUpperBound() - this.displayStart + (this.displayEnd - this.fixedRange.getLowerBound());
    }

    private double getDisplayCentralValue() {
        return this.mapValueToFixedRange(this.displayStart + this.getDisplayLength() / 2.0);
    }

    public void resizeRange(double d) {
        this.resizeRange(d, this.getDisplayCentralValue());
    }

    public void resizeRange(double d, double d2) {
        if (d > 0.0) {
            double d3 = this.getDisplayLength() * d / 2.0;
            this.setDisplayRange(d2 - d3, d2 + d3);
        } else {
            this.setAutoRange(true);
        }
    }

    public double lengthToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        d2 = this.displayEnd > this.displayStart ? this.displayEnd - this.displayStart : this.fixedRange.getUpperBound() - this.displayStart + (this.displayEnd - this.fixedRange.getLowerBound());
        double d3 = 0.0;
        d3 = RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge) ? rectangle2D.getHeight() : rectangle2D.getWidth();
        return d / d2 * d3;
    }
}

