/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.docking.DockableToolBar;
import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingDockable;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.util.Map;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.InputMap;

class ToolBar
extends DockableToolBar
implements SwingDockable {
    PanelSupport support;

    ToolBar() {
        this.setRollover(true);
        this.setClosable(true);
        InputMap inputMap = this.getInputMap(2);
        ComponentInputMap componentInputMap = new ComponentInputMap(this);
        componentInputMap.setParent(inputMap);
        this.setInputMap(2, componentInputMap);
    }

    public PanelSupport getSupport() {
        return this.support;
    }

    public void initialize(PanelSupport panelSupport, Map map) {
        this.support = panelSupport;
        panelSupport.installUpdater(UIProperty.PANEL_TITLE, true, "setTitles", map);
        panelSupport.installUpdater(UIProperty.ICON, true, "setIconSource", map);
    }

    public void dispose() {
    }

    public void setIconSource(IconSource iconSource) {
        this.setIcon((Icon)IconAdapter.create((IconSource)iconSource, (Dimension)SwingToolkit.WINDOW_ICON_SIZE));
    }

    public void setMenu(Component component) {
        if (component == null) {
            this.removeAll();
        } else if (component != this) {
            throw new IllegalArgumentException();
        }
    }

    public Container getContentPane() {
        return this;
    }

    public void dockableClosed() {
        this.support.dockableClosed();
    }

    public void checkClose(Runnable runnable) {
        this.support.checkClose(runnable);
    }
}

