/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingPanel;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.util.Disposable;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextEditorSupport
extends PanelSupport
implements TextEditor,
ChangeListener,
ModifiableMap.Producer {
    private static final String UNDO_MANAGER = "de.grogra.pf.ui.swing.TextEditorSupport.UndoManager";
    private static final String HANDLER = "de.grogra.pf.ui.swing.TextEditorSupport.Handler";
    private static final String DOCUMENT = "de.grogra.pf.ui.swing.TextEditorSupport.Document";
    private static final String EDITOR = "de.grogra.pf.ui.swing.TextEditorSupport.Editor";
    private static final String[] KEYS = new String[]{"Name", "ShortDescription", "AcceleratorKey"};
    ActionImpl undoAction;
    ActionImpl redoAction;
    ActionImpl saveAction;
    ActionImpl cutAction;
    ActionImpl copyAction;
    ActionImpl pasteAction;
    ActionImpl closeAction;
    Object doUndo;
    Object doRedo;
    Object doSave;
    JTabbedPane tab;
    private static final int OPEN_DOC = 4;
    private static final int CLOSE_DOC = 5;
    private static final int UPDATE = 6;

    public TextEditorSupport() {
        super(new SwingPanel(null));
        Container container = ((SwingPanel)this.getComponent()).getContentPane();
        container.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        this.saveAction = new ActionImpl("save");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.saveAction));
        this.undoAction = new ActionImpl("undo");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.undoAction));
        this.redoAction = new ActionImpl("redo");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.redoAction));
        this.cutAction = new ActionImpl("cut");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.cutAction));
        this.copyAction = new ActionImpl("copy");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.copyAction));
        this.pasteAction = new ActionImpl("paste");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.pasteAction));
        this.closeAction = new ActionImpl("close");
        SwingToolkit.setDisabledIcon(jToolBar.add(this.closeAction));
        container.add((Component)jToolBar, "North");
        this.doUndo = new Object();
        this.doRedo = new Object();
        this.doSave = new Object();
        this.tab = new JTabbedPane(3, 1);
        container.add((Component)this.tab, "Center");
        this.tab.addChangeListener(this);
        this.mapProducer = this;
    }

    protected void configure(Map map) {
        super.configure(map);
        String[] stringArray = UI.getDocuments((Map)map);
        for (int i = 0; i < stringArray.length; ++i) {
            this.openDocument(stringArray[i], null);
        }
        String string = (String)map.get((Object)"selected", null);
        if (string != null) {
            this.openDocument(string, null);
        }
    }

    private void openDocumentSync(String string, String string2) {
        Serializable serializable;
        JTextArea jTextArea;
        block7: {
            for (int i = 0; i < this.tab.getTabCount(); ++i) {
                if (!string.equals(((Doc)((JComponent)this.tab.getComponentAt((int)i)).getClientProperty((Object)DOCUMENT)).systemId)) continue;
                this.tab.setSelectedIndex(i);
                jTextArea = (JTextArea)((JComponent)this.tab.getComponentAt(i)).getClientProperty(EDITOR);
                break block7;
            }
            final Doc doc = new Doc(this.getWorkbench(), string);
            jTextArea = new JTextArea(doc);
            jTextArea.setEditable(doc.editable);
            jTextArea.setTabSize(4);
            jTextArea.setFont(new Font("Monospaced", 0, 12));
            jTextArea.setDragEnabled(true);
            jTextArea.getInputMap().put(KeyStroke.getKeyStroke(83, 2), this.doSave);
            jTextArea.getActionMap().put(this.doSave, this.saveAction);
            jTextArea.getInputMap().put(KeyStroke.getKeyStroke(90, 2), this.doUndo);
            jTextArea.getActionMap().put(this.doUndo, this.undoAction);
            jTextArea.getInputMap().put(KeyStroke.getKeyStroke(89, 2), this.doRedo);
            jTextArea.getActionMap().put(this.doRedo, this.redoAction);
            serializable = new JScrollPane();
            ((JScrollPane)serializable).getViewport().add(jTextArea);
            final UndoManager undoManager = new UndoManager();
            ((JComponent)serializable).putClientProperty(UNDO_MANAGER, undoManager);
            ((JComponent)serializable).putClientProperty(DOCUMENT, doc);
            ((JComponent)serializable).putClientProperty(EDITOR, jTextArea);
            final JTextArea jTextArea2 = jTextArea;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Handler
            implements UndoableEditListener,
            Disposable,
            DocumentListener {
                Handler() {
                }

                @Override
                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    undoManager.addEdit(undoableEditEvent.getEdit());
                    TextEditorSupport.this.update(jTextArea2, undoManager, doc);
                }

                public void dispose() {
                    doc.removeUndoableEditListener(this);
                    doc.removeDocumentListener(this);
                    try {
                        jTextArea2.setDocument(null);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    TextEditorSupport.this.update(jTextArea2, undoManager, (Doc)documentEvent.getDocument());
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            }
            Handler handler = new Handler();
            ((JComponent)serializable).putClientProperty(HANDLER, handler);
            doc.addUndoableEditListener(handler);
            doc.addDocumentListener(handler);
            this.tab.addTab(String.valueOf(doc.getProperty("title")), (Icon)IconAdapter.create((IconSource)UI.getIcon((String)doc.systemId, (String)doc.mimeType.getMediaType(), null, (RegistryContext)this, (boolean)true), (Dimension)SwingToolkit.MENU_ICON_SIZE), (Component)serializable);
            this.tab.setSelectedComponent((Component)serializable);
            this.update(jTextArea, undoManager, doc);
        }
        jTextArea.requestFocus();
        Point[] pointArray = UI.parsePlainTextRange((String)string2);
        if (pointArray != null) {
            try {
                serializable = pointArray[0];
                int n = jTextArea.getLineStartOffset(((Point)serializable).y);
                if (((Point)serializable).x >= 0) {
                    n += ((Point)serializable).x;
                }
                if ((serializable = pointArray[1]) == null) {
                    jTextArea.setCaretPosition(n);
                } else {
                    jTextArea.select(n, ((Point)serializable).x >= 0 ? jTextArea.getLineStartOffset(((Point)serializable).y) + ((Point)serializable).x : jTextArea.getLineEndOffset(((Point)serializable).y));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public Object run(int n, int n2, Object object, Object object2) {
        block0 : switch (n) {
            case 4: {
                this.openDocumentSync((String)object, (String)object2);
                break;
            }
            case 5: {
                for (int i = 0; i < this.tab.getTabCount(); ++i) {
                    if (((JComponent)this.tab.getComponentAt(i)).getClientProperty(DOCUMENT) != object) continue;
                    Disposable disposable = (Disposable)((JComponent)this.tab.getComponentAt(i)).getClientProperty(HANDLER);
                    this.tab.removeTabAt(i);
                    disposable.dispose();
                    break block0;
                }
                break;
            }
            case 6: {
                this.update((JComponent)object);
                break;
            }
            default: {
                return super.run(n, n2, object, object2);
            }
        }
        return null;
    }

    public void openDocument(String string, String string2) {
        this.sync.invokeAndWait(4, 0, string, string2);
    }

    void closeDocument(Doc doc) {
        this.sync.invokeAndWait(5, doc);
    }

    void update(JTextArea jTextArea, UndoManager undoManager, Doc doc) {
        for (int i = 0; i < this.tab.getTabCount(); ++i) {
            if (((JComponent)this.tab.getComponentAt(i)).getClientProperty(DOCUMENT) != doc) continue;
            String string = String.valueOf(doc.getProperty("title"));
            if (doc.modified) {
                string = "* " + string + " *";
            }
            if (string.equals(this.tab.getTitleAt(i))) break;
            this.tab.setTitleAt(i, string);
            break;
        }
        this.undoAction.setEnabled(undoManager != null && undoManager.canUndo());
        this.redoAction.setEnabled(undoManager != null && undoManager.canRedo());
        this.saveAction.setEnabled(doc != null && doc.modified);
        this.cutAction.setEnabled(jTextArea != null);
        this.copyAction.setEnabled(jTextArea != null);
        this.pasteAction.setEnabled(jTextArea != null);
        this.closeAction.setEnabled(jTextArea != null);
    }

    void update(JComponent jComponent) {
        if (jComponent == null) {
            this.update(null, null, null);
        } else {
            this.update((JTextArea)jComponent.getClientProperty(EDITOR), (UndoManager)jComponent.getClientProperty(UNDO_MANAGER), (Doc)jComponent.getClientProperty(DOCUMENT));
        }
    }

    void actionPerformed(ActionEvent actionEvent) {
        final JComponent jComponent = (JComponent)this.tab.getSelectedComponent();
        if (jComponent == null) {
            return;
        }
        UndoManager undoManager = (UndoManager)jComponent.getClientProperty(UNDO_MANAGER);
        JTextArea jTextArea = (JTextArea)jComponent.getClientProperty(EDITOR);
        Doc doc = (Doc)jComponent.getClientProperty(DOCUMENT);
        String string = actionEvent.getActionCommand();
        if ("undo".equals(string)) {
            try {
                undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                cannotUndoException.printStackTrace();
            }
            this.update(jTextArea, undoManager, doc);
        } else if ("redo".equals(string)) {
            try {
                undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                cannotRedoException.printStackTrace();
            }
            this.update(jTextArea, undoManager, doc);
        } else if ("save".equals(string)) {
            this.getWorkbench().getJobManager().execute(new Command(){

                public String getCommandName() {
                    return null;
                }

                public void run(Object object, Context context) {
                    ((Doc)object).save();
                    TextEditorSupport.this.sync.invokeAndWait(6, jComponent);
                }
            }, (Object)doc, (Context)this, 10000);
        } else if ("cut".equals(string)) {
            jTextArea.cut();
        } else if ("copy".equals(string)) {
            jTextArea.copy();
        } else if ("paste".equals(string)) {
            jTextArea.paste();
        } else if ("close".equals(string)) {
            this.getWorkbench().getJobManager().execute(new Command(){

                public void run(Object object, Context context) {
                    if (TextEditorSupport.this.canClose((Doc)object)) {
                        TextEditorSupport.this.closeDocument((Doc)object);
                    }
                }

                public String getCommandName() {
                    return null;
                }
            }, (Object)doc, (Context)this, 10000);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.update((JComponent)this.tab.getSelectedComponent());
    }

    protected void disposeImpl() {
        for (int i = 0; i < this.tab.getTabCount(); ++i) {
            ((Disposable)((JComponent)this.tab.getComponentAt(i)).getClientProperty(HANDLER)).dispose();
        }
        super.disposeImpl();
    }

    public void checkClose(Runnable runnable) {
        this.executeCheckClose(runnable);
    }

    boolean canClose(Doc doc) {
        return !doc.modified || this.getWindow().showDialog(UI.I18N.msg("text.savequestion.title"), (Object)UI.I18N.msg("text.savequestion.msg", doc.getProperty("title")), 3) == 0;
    }

    public void checkClose(Command command) {
        for (int i = 0; i < this.tab.getTabCount(); ++i) {
            Doc doc = (Doc)((JComponent)this.tab.getComponentAt(i)).getClientProperty(DOCUMENT);
            if (this.canClose(doc)) continue;
            return;
        }
        command.run(null, (Context)this);
    }

    public String[] getDocuments() {
        int n = this.tab.getTabCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((Doc)((JComponent)this.tab.getComponentAt((int)i)).getClientProperty((Object)DOCUMENT)).systemId;
        }
        return stringArray;
    }

    public void addMappings(ModifiableMap modifiableMap) {
        UI.putDocuments((TextEditor)this, (ModifiableMap)modifiableMap);
        Component component = this.tab.getSelectedComponent();
        if (component != null) {
            modifiableMap.put((Object)"selected", (Object)((Doc)((JComponent)component).getClientProperty((Object)DOCUMENT)).systemId);
        }
    }

    private class ActionImpl
    extends AbstractAction {
        ActionImpl(String string) {
            super(string);
            this.setEnabled(false);
            this.putValue("ActionCommandKey", string);
            I18NBundle i18NBundle = UI.I18N;
            try {
                Object object = i18NBundle.getObject("text." + string + '.' + "Icon");
                if (object instanceof IconSource) {
                    this.putValue("SmallIcon", IconAdapter.create((IconSource)((IconSource)object), (Dimension)SwingToolkit.MENU_ICON_SIZE));
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            for (int i = 0; i < KEYS.length; ++i) {
                this.putValue(KEYS[i], i18NBundle.getStringOrNull("text." + string + '.' + KEYS[i]));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextEditorSupport.this.actionPerformed(actionEvent);
        }
    }

    class Doc
    extends PlainDocument
    implements Runnable {
        final String systemId;
        MimeType mimeType;
        final Workbench wb;
        final boolean editable;
        boolean modified;

        Doc(Workbench workbench, String string) {
            this.systemId = string;
            this.wb = workbench;
            FileSource fileSource = null;
            this.mimeType = MimeType.TEXT_PLAIN;
            try {
                fileSource = FileSource.createFileSource((String)string, (MimeType)IO.getMimeType((String)string), (RegistryContext)workbench, null);
                this.mimeType = fileSource.getFlavor().getMimeType();
                this.insertString(0, fileSource.readContent().toString(), null);
            }
            catch (BadLocationException badLocationException) {
                workbench.logInfo(null, (Throwable)badLocationException);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.putProperty("title", IO.toPath((String)string));
            this.editable = fileSource != null && !fileSource.isReadOnly();
            this.modified = false;
        }

        void save() {
            this.render(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileSource fileSource = FileSource.createFileSource((String)this.systemId, (MimeType)this.mimeType, (RegistryContext)this.wb, null);
            Writer writer = null;
            try {
                writer = fileSource.getWriter(false);
                writer.write(this.getText(0, this.getLength()));
                writer.flush();
                this.modified = false;
            }
            catch (IOException iOException) {
                this.wb.logGUIInfo(IO.I18N.msg("writefile.failed", (Object)fileSource.getSystemId()), (Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                this.wb.logInfo(null, (Throwable)badLocationException);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        this.wb.logGUIInfo(IO.I18N.msg("closefile.failed", (Object)fileSource.getSystemId()), (Throwable)iOException);
                    }
                }
            }
        }

        protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            super.postRemoveUpdate(defaultDocumentEvent);
            this.modified = true;
        }

        protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
            super.insertUpdate(defaultDocumentEvent, attributeSet);
            this.modified = true;
        }

        protected void fireRemoveUpdate(DocumentEvent documentEvent) {
            super.fireRemoveUpdate(documentEvent);
            this.modified = true;
        }

        protected void fireInsertUpdate(DocumentEvent documentEvent) {
            super.fireInsertUpdate(documentEvent);
            this.modified = true;
        }

        protected void fireChangedUpdate(DocumentEvent documentEvent) {
            super.fireChangedUpdate(documentEvent);
            this.modified = true;
        }
    }
}

