/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.util.LockProtectedCommand;
import de.grogra.util.Lockable;
import java.awt.EventQueue;

public abstract class Job
extends LockProtectedCommand
implements Runnable {
    private final Context ctx;
    private final int flags;
    private boolean started = false;
    private boolean done = false;

    public Job(Lockable lockable, boolean bl, int n, Context context) {
        super(lockable, bl, n);
        this.ctx = context;
        this.flags = n;
    }

    public Job(Context context) {
        this((Lockable)context.getWorkbench().getRegistry().getProjectGraph(), true, 10000, context);
    }

    public void execute() {
        if (this.started) {
            throw new IllegalStateException(this + " may only be executed once");
        }
        this.started = true;
        JobManager jobManager = this.ctx.getWorkbench().getJobManager();
        jobManager.runLater((Command)this, null, this.ctx, this.flags);
    }

    public void run() {
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done(Context context) {
        if (this.done) {
            return;
        }
        this.done = true;
        EventQueue.invokeLater(this);
        Job job = this;
        synchronized (job) {
            this.notifyAll();
        }
    }

    public boolean isDone() {
        return this.done;
    }

    protected void done() {
    }
}

