/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AWTToolkitBase
extends UIToolkit
implements WindowListener {
    private static final int[] FONT_MASKS = new int[]{2048, 4096, 8192, 16384, 32768};
    private static final String[] FONTS = new String[]{"Monospaced", "SansSerif", "Serif", "Dialog", "DialogInput"};

    protected Font getFont(int n) {
        int n2 = (n & 0x600) == 1536 ? 3 : ((n & 0x400) != 0 ? 1 : ((n & 0x200) != 0 ? 2 : 0));
        return (n & 0xFFFF) == 0 ? null : new Font((String)AWTToolkitBase.getFirstMatching((int)n, (int[])FONT_MASKS, (Object[])FONTS, null), n2, (n & 0xFF) != 0 ? n & 0xFF : 12);
    }

    protected abstract Container getContentPane(Object var1);

    public void addComponent(final Object object, final Object object2, final Object object3, final int n) {
        if (object2 != null) {
            if (EventQueue.isDispatchThread()) {
                this.getContentPane(object).add((Component)object2, object3, n);
            } else {
                AWTSynchronizer.staticInvokeAndWait(new Runnable(){

                    public void run() {
                        AWTToolkitBase.this.getContentPane(object).add((Component)object2, object3, n);
                    }
                });
            }
        }
    }

    public void removeComponent(Object object) {
        if (object != null) {
            final Component component = (Component)object;
            if (EventQueue.isDispatchThread()) {
                component.getParent().remove(component);
            } else {
                AWTSynchronizer.staticInvokeAndWait(new Runnable(){

                    public void run() {
                        component.getParent().remove(component);
                    }
                });
            }
        }
    }

    public int indexOf(Object object) {
        return AWTToolkitBase.indexOf((Component)object);
    }

    public int getComponentCount(Object object) {
        return object instanceof Container ? this.getContentPane(object).getComponentCount() : 0;
    }

    public Object getComponent(Object object, int n) {
        return this.getContentPane(object).getComponent(n);
    }

    public Object createLabeledComponent(Object object, Object object2) {
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)object2, "First");
        container.add((Component)object, "Center");
        return container;
    }

    public Object createLabel(String string, IconSource iconSource, Dimension dimension, int n) {
        Object object;
        if (iconSource != null && (n & 0x80000) == 0 && (object = iconSource.getPreferredIconSize(false)) != null) {
            dimension = object;
        }
        if ((object = IconAdapter.create((IconSource)iconSource, (Dimension)dimension)) != null) {
            object.getIcon().prepareIcon();
        }
        Component component = this.createLabel(string, (Icon)object, n);
        Font font = this.getFont(n);
        if (font != null) {
            component.setFont(font);
        }
        return component;
    }

    protected abstract Component createLabel(String var1, Icon var2, int var3);

    protected abstract void updateLabel(Component var1, String var2, Icon var3);

    public Object createContainer(int n) {
        return this.createContainer(new BorderLayout(n, n));
    }

    public Object createContainer(int n, int n2, int n3) {
        return this.createContainer(new GridLayout(n, n2, n3, n3));
    }

    public Object createContainer(final float[] fArray, final int n) {
        return this.createContainer(new LayoutManager(){

            public void removeLayoutComponent(Component component) {
            }

            public void layoutContainer(Container container) {
                Insets insets = container.getInsets();
                int n5 = insets.left;
                int n2 = container.getComponentCount();
                int n3 = container.getHeight() - insets.top - insets.bottom;
                float f = 0.0f;
                for (int i = n2 - 1; i >= 0; --i) {
                    f += fArray[i];
                }
                f = (float)(container.getWidth() - n5 - insets.right - (n2 - 1) * n) / f;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                float f2 = n5;
                for (int i = 0; i < n2; ++i) {
                    Component component = container.getComponent(i);
                    int n4 = (int)(f2 += fArray[i] * f) - n5;
                    component.setBounds(n5, insets.top, n4, n3);
                    f2 += (float)n;
                    n5 += n4 + n;
                }
            }

            public void addLayoutComponent(String string, Component component) {
            }

            public Dimension minimumLayoutSize(Container container) {
                Insets insets = container.getInsets();
                Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
                int n2 = 0;
                for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                    Dimension dimension2 = container.getComponent(i).getMinimumSize();
                    dimension.width += dimension2.width;
                    n2 = Math.max(n2, dimension2.height);
                    if (i <= 0) continue;
                    dimension.width += n;
                }
                dimension.height += n2;
                return dimension;
            }

            public Dimension preferredLayoutSize(Container container) {
                Insets insets = container.getInsets();
                Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
                int n2 = 0;
                for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                    Dimension dimension2 = container.getComponent(i).getPreferredSize();
                    dimension.width += dimension2.width;
                    n2 = Math.max(n2, dimension2.height);
                    if (i <= 0) continue;
                    dimension.width += n;
                }
                dimension.height += n2;
                return dimension;
            }
        });
    }

    protected abstract Container createContainer(LayoutManager var1);

    public Point getLocationOnScreen(Object object) {
        return ((Component)object).getLocationOnScreen();
    }

    public int getWidth(Object object) {
        return ((Component)object).getWidth();
    }

    public int getHeight(Object object) {
        return ((Component)object).getHeight();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public static int indexOf(Component component) {
        Container container = component.getParent();
        if (container != null) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (component != container.getComponent(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void printTree(Component component, String string) {
        if (component != null) {
            System.out.println('\n' + string + component.getClass().getName() + "\n\n" + component);
            if (component instanceof Container) {
                Container container = (Container)component;
                for (int i = 0; i < container.getComponentCount(); ++i) {
                    AWTToolkitBase.printTree(container.getComponent(i), string + "  ");
                }
            }
        }
    }

    public void revalidate(Object object) {
        Component component = (Component)object;
        component.invalidate();
        if (!component.isDisplayable()) {
            return;
        }
        do {
            if (component instanceof JComponent) {
                ((JComponent)component).revalidate();
                return;
            }
            if (!(component instanceof ScrollPane) && !(component instanceof Window)) continue;
            final Component component2 = component;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    component2.validate();
                }
            });
            return;
        } while ((component = component.getParent()) != null);
    }

    public void repaint(Object object) {
        ((Component)object).repaint();
    }
}

