/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.Dockable;

public interface LayoutConsumer {
    public static final LayoutConsumer DUMP_LAYOUT = new LayoutConsumer(){
        private int depth = 0;

        public void startLayout() {
            this.start("Layout");
        }

        public void endLayout() {
            this.end();
        }

        public void startMainWindow() {
            this.start("MainWindow");
        }

        public void endMainWindow() {
            this.end();
        }

        public void startFloatingWindow(String string, int n, int n2) {
            this.start("FloatingWindow[" + string + ',' + n + 'x' + n2 + ']');
        }

        public void endFloatingWindow() {
            this.end();
        }

        public void startSplit(int n, float f) {
            this.start("Split[" + n + ',' + f + ']');
        }

        public void endSplit() {
            this.end();
        }

        public void startTabbed(int n) {
            this.start("Tabbed[" + n + ']');
        }

        public void endTabbed() {
            this.end();
        }

        public void addDockable(Dockable dockable) {
            this.start("Dockable[" + dockable.getClass().getName() + ']');
            this.end();
        }

        private void start(String string) {
            for (int i = 0; i < this.depth; ++i) {
                System.err.print("  ");
            }
            System.err.println(string);
            ++this.depth;
        }

        private void end() {
            --this.depth;
        }
    };

    public void startLayout();

    public void endLayout();

    public void startMainWindow();

    public void endMainWindow();

    public void startFloatingWindow(String var1, int var2, int var3);

    public void endFloatingWindow();

    public void startSplit(int var1, float var2);

    public void endSplit();

    public void startTabbed(int var1);

    public void endTabbed();

    public void addDockable(Dockable var1);
}

