/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.dxf;

import de.grogra.ext.dxf.DXFExport;
import de.grogra.ext.dxf.ObjectBase;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.SceneTree;
import java.io.IOException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;

public class Frustum
extends ObjectBase {
    void exportImpl(SceneTree.Leaf leaf, SceneTree.InnerNode innerNode, DXFExport dXFExport) throws IOException {
        Point3d point3d = new Point3d();
        Matrix4d matrix4d = this.getTransformation();
        float f = leaf.getFloat(Attributes.BASE_RADIUS);
        float f2 = leaf.getFloat(Attributes.TOP_RADIUS);
        double d = leaf.getDouble(Attributes.LENGTH);
        PolygonArray polygonArray = new PolygonArray();
        polygonArray.dimension = 3;
        polygonArray.edgeCount = 4;
        int n = 2;
        point3d.set(0.0, 0.0, 0.0);
        matrix4d.transform(point3d);
        polygonArray.vertices.push((float)point3d.x).push((float)point3d.y).push((float)point3d.z);
        point3d.set(0.0, 0.0, d);
        matrix4d.transform(point3d);
        polygonArray.vertices.push((float)point3d.x).push((float)point3d.y).push((float)point3d.z);
        for (int i = 0; i < 20; ++i) {
            float f3 = (float)(Math.PI * 2 * (double)i / 20.0);
            float f4 = (float)Math.cos(f3);
            float f5 = (float)Math.sin(f3);
            Point3d point3d2 = new Point3d((double)(f * f4), (double)(f * f5), 0.0);
            matrix4d.transform(point3d2);
            Point3d point3d3 = new Point3d((double)(f2 * f4), (double)(f2 * f5), d);
            matrix4d.transform(point3d3);
            polygonArray.vertices.push((float)point3d2.x).push((float)point3d2.y).push((float)point3d2.z);
            polygonArray.vertices.push((float)point3d3.x).push((float)point3d3.y).push((float)point3d3.z);
            polygonArray.polygons.push(0).push(n).push(n + 2 * (20 - i > 1 ? 1 : -19)).push(0);
            polygonArray.polygons.push(1).push(n + 1).push(n + 1 + 2 * (20 - i > 1 ? 1 : -19)).push(1);
            polygonArray.polygons.push(n).push(n + 1).push(n + 3 + 2 * (20 - i > 1 ? 0 : -20)).push(n + 2 + 2 * (20 - i > 1 ? 0 : -20));
            n += 2;
        }
        this.mesh(polygonArray);
    }
}

