/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grammar;

import de.grogra.grammar.NumberLiteral;

public final class DoubleLiteral
extends NumberLiteral {
    private double value;

    public DoubleLiteral(String string) {
        super(8, string);
        this.value = Double.NEGATIVE_INFINITY;
    }

    public DoubleLiteral(double d) {
        super(8, null);
        this.value = d;
    }

    public double doubleValue() {
        if (this.value == Double.NEGATIVE_INFINITY) {
            this.value = new Double(super.getText());
            return this.value;
        }
        return this.value;
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public String getText() {
        String string = super.getText();
        if (string == null) {
            string = Double.toString(this.value);
            this.setText(string);
        }
        return string;
    }
}

