/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.turtle;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.VertexSequence;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.turtle.Attributes;
import de.grogra.turtle.TurtleModifier;
import de.grogra.turtle.TurtleState;
import de.grogra.turtle.TurtleStep;
import de.grogra.vecmath.Matrix34d;

public abstract class Shoot
extends TurtleStep
implements TurtleModifier,
VertexSequence.Vertex {
    private float[] localRegisters;
    public static final Node.NType $TYPE = new Node.NType(Shoot.class);
    public static final Node.NType.Field localRegisters$FIELD = new _Field("localRegisters", 0x200002, (Type)ClassAdapter.wrap(float[].class), null, 0);

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.TURTLE_MODIFIER);
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.BASE_OPEN));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.TOP_OPEN));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.SHAPE));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.RADIUS));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.PARAMETER));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.LOCAL_SCALE));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.HEARTWOOD));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.CARBON));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.TROPISM_STRENGTH));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.REL_POSITION));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.ORDER));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.INTERNODE_COUNT));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.GENERATIVE_DISTANCE));
        $TYPE.addAccessor((AttributeAccessor)new Node.AccessorBridge((Attribute)Attributes.DTG_COLOR));
        $TYPE.addAccessor((AttributeAccessor)new Node.FieldAttributeAccessor((Attribute)Attributes.SHADER, shader$FIELD){

            public Object getObject(Object object, Object object2, GraphState graphState) {
                return ((Shoot)object).getShaderOrColor(graphState);
            }
        });
    }

    public float[] getLocalRegisters() {
        return this.localRegisters;
    }

    public void setLocalRegisters(float[] fArray) {
        localRegisters$FIELD.setObject((Object)this, (Object)fArray);
    }

    public int getSymbolColor() {
        return 0xFFFFA0;
    }

    Shader getShaderOrColor(GraphState graphState) {
        if (this.getShader() != null) {
            return this.getShader();
        }
        int n = this.getInt(Attributes.DTG_COLOR, graphState);
        if (n >= 0) {
            return RGBAShader.forEGAColor((int)n);
        }
        return TurtleState.getBefore((Object)this, (GraphState)graphState).localShader;
    }

    protected boolean getBoolean(BooleanAttribute booleanAttribute, GraphState graphState) {
        return booleanAttribute != Attributes.BASE_OPEN && booleanAttribute != Attributes.TOP_OPEN && super.getBoolean(booleanAttribute, graphState);
    }

    protected float getFloat(FloatAttribute floatAttribute, GraphState graphState) {
        return floatAttribute == Attributes.RADIUS ? TurtleState.getBefore((Object)this, (GraphState)graphState).localDiameter / 2.0f : (floatAttribute == Attributes.PARAMETER ? TurtleState.getBefore((Object)this, (GraphState)graphState).localParameter : (floatAttribute == Attributes.REL_POSITION ? TurtleState.getBefore((Object)this, (GraphState)graphState).relPosition : (floatAttribute == Attributes.CARBON ? TurtleState.getBefore((Object)this, (GraphState)graphState).localCarbon : (floatAttribute == Attributes.HEARTWOOD ? TurtleState.getBefore((Object)this, (GraphState)graphState).localHeartwood : (floatAttribute == Attributes.TROPISM_STRENGTH ? TurtleState.getBefore((Object)this, (GraphState)graphState).localTropism : super.getFloat(floatAttribute, graphState))))));
    }

    protected int getInt(IntAttribute intAttribute, GraphState graphState) {
        return intAttribute == Attributes.ORDER ? TurtleState.getBefore((Object)this, (GraphState)graphState).order : (intAttribute == Attributes.GENERATIVE_DISTANCE ? TurtleState.getBefore((Object)this, (GraphState)graphState).generativeDistance : (intAttribute == Attributes.DTG_COLOR ? TurtleState.getBefore((Object)this, (GraphState)graphState).localColor : (intAttribute == Attributes.INTERNODE_COUNT ? TurtleState.getBefore((Object)this, (GraphState)graphState).internodeCount : (intAttribute == Attributes.LOCAL_SCALE ? TurtleState.getBefore((Object)this, (GraphState)graphState).localScale : super.getInt(intAttribute, graphState)))));
    }

    protected Object getObject(ObjectAttribute objectAttribute, Object object, GraphState graphState) {
        if (objectAttribute == Attributes.SHAPE) {
            return Cylinder.$TYPE.getRepresentative();
        }
        return super.getObject(objectAttribute, object, graphState);
    }

    public void execute(Object object, TurtleState turtleState, GraphState graphState) {
        turtleState.localLength = turtleState.length;
        turtleState.localDiameter = turtleState.diameter;
        turtleState.localColor = turtleState.color;
        turtleState.localShader = turtleState.shader;
        turtleState.localParameter = turtleState.parameter;
        turtleState.localCarbon = turtleState.carbon;
        turtleState.localHeartwood = turtleState.heartwood;
        turtleState.localInternodeCount = turtleState.internodeCount;
        turtleState.relPosition = 0.0f;
        ++turtleState.generativeDistance;
        turtleState.localScale = 0;
    }

    public Matrix34d getVertexTransformation(Object object, GraphState graphState) {
        Matrix34d matrix34d = GlobalTransformation.get((Object)object, (boolean)true, (GraphState)graphState, (boolean)true);
        float f = graphState.getFloat(object, true, Attributes.RADIUS);
        if (f != 1.0f) {
            matrix34d = new Matrix34d(matrix34d);
            matrix34d.m00 *= (double)f;
            matrix34d.m10 *= (double)f;
            matrix34d.m20 *= (double)f;
            matrix34d.m01 *= (double)f;
            matrix34d.m11 *= (double)f;
            matrix34d.m21 *= (double)f;
        }
        return matrix34d;
    }

    static /* synthetic */ float[] access$002(Shoot shoot, float[] fArray) {
        shoot.localRegisters = fArray;
        return fArray;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)localRegisters$FIELD);
        Shoot.initType();
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    Shoot.access$002((Shoot)object, (float[])object2);
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Shoot)object).getLocalRegisters();
                }
            }
            return super.getObject(object);
        }
    }
}

