/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grogra;

import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.TreeIterator;
import de.grogra.grogra.LSystem;
import de.grogra.grogra.ShootStructure;
import de.grogra.grogra.TreeInformation;
import de.grogra.pf.data.Dataseries;
import de.grogra.pf.data.Dataset;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.turtle.Attributes;
import de.grogra.turtle.Shoot;
import de.grogra.util.Configuration;
import de.grogra.util.ConfigurationSet;
import de.grogra.util.KeyDescription;
import de.grogra.util.KeyDescriptionImpl;
import de.grogra.util.Map;
import de.grogra.util.Quantity;
import de.grogra.util.StringMap;
import de.grogra.vecmath.Math2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Analysis {
    private static final byte INVISIBLE = 0;
    private static final byte MAX_TREES = 100;
    private static final short MAX_DAUGHTERS = 500;
    private static final int MAX_ORDER = 5;
    private static final int MAX_EUCU = 80;
    private static final int MAX_EUAX = 400;
    private static final int MAX_CUAX = 200;
    private static final int MIN_DISTANCE = 1;
    private static int countDaughters = 0;

    private Analysis() {
    }

    public static void performAndShow(Item item, Object object, Context context) {
        if (!(object instanceof ActionEditEvent)) {
            return;
        }
        ActionEditEvent actionEditEvent = (ActionEditEvent)object;
        if (actionEditEvent.isConsumed() || !((object = actionEditEvent.getSource()) instanceof Expression)) {
            return;
        }
        actionEditEvent.consume();
        Workbench workbench = context.getWorkbench();
        Object object2 = ((Expression)object).evaluate((RegistryContext)workbench, UI.getArgs((Context)context, (Map)((Expression)object)));
        if (object2 instanceof Dataset) {
            ((Dataset)object2).showInPanel(context.getPanel());
        }
    }

    public static Dataset elementary(Node node) {
        Object object;
        Dataseries dataseries;
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("elementary analysis");
        dataset.setColumnKey(0, (Comparable)((Object)"Generation")).setColumnKey(1, (Comparable)((Object)"#Shoots")).setColumnKey(2, (Comparable)((Object)"min. X")).setColumnKey(3, (Comparable)((Object)"min. Y")).setColumnKey(4, (Comparable)((Object)"min. Z")).setColumnKey(5, (Comparable)((Object)"max. X")).setColumnKey(6, (Comparable)((Object)"max. Y")).setColumnKey(7, (Comparable)((Object)"max. Z")).setColumnKey(8, (Comparable)((Object)"#terminal shoots")).setColumnKey(9, (Comparable)((Object)"aver. no. of daughter shoots of nonterminal shoots")).setColumnKey(10, (Comparable)((Object)"global sum of all shootlengths")).setColumnKey(11, (Comparable)((Object)"sum of shoot volumes")).setColumnKey(12, (Comparable)((Object)"stem volume")).setColumnKey(13, (Comparable)((Object)"sum branch volumes")).setColumnKey(14, (Comparable)((Object)"sum of shoot surface area")).setColumnKey(15, (Comparable)((Object)"stem surface area")).setColumnKey(16, (Comparable)((Object)"sum of branch surface area")).setColumnKey(17, (Comparable)((Object)"total no. of internodes")).setColumnKey(18, (Comparable)((Object)"sum of values of parameter N")).setColumnKey(19, (Comparable)((Object)"max. radius projection xy-plane")).setColumnKey(20, (Comparable)((Object)"average branching angle")).setColumnKey(21, (Comparable)((Object)"average contraction factor")).setColumnKey(22, (Comparable)((Object)"maximal shoot diameter")).setColumnKey(23, (Comparable)((Object)"#leafs")).setColumnKey(24, (Comparable)((Object)"#fruits"));
        int n = 0;
        Point3d point3d = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Point3d point3d2 = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        Vector3d vector3d7 = new Vector3d();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            Shoot shoot2;
            ++n;
            int n5 = 0;
            float f13 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            long l4 = graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT);
            float f14 = graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f;
            int n6 = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f13, (Vector3d)vector3d4, (Vector3d)vector3d5);
            vector3d5.sub((Tuple3d)vector3d4);
            dataseries = new TreeIterator((Node)shoot);
            object = shoot.getCurrentGraphState();
            while ((shoot2 = LSystem.nextShoot((TreeIterator)dataseries)) != null) {
                float f15;
                if (Analysis.getAssociatedMotherShoot((Node)shoot2) != shoot) continue;
                ++n5;
                if (n6 == object.getInt((Object)shoot2, true, Attributes.ORDER) || !((f15 = (float)object.getDouble((Object)shoot2, true, Attributes.LENGTH)) > 1.0E-9f)) continue;
                ++n2;
                Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)f15, (Vector3d)vector3d6, (Vector3d)vector3d7);
                vector3d7.sub((Tuple3d)vector3d6);
                float f16 = (float)Math.toDegrees(vector3d5.angle(vector3d7));
                if (f16 < 0.0f || f16 > 180.0f) {
                    System.out.println("WARNING: Angle between two shoots = " + f16);
                } else {
                    f12 += f16;
                }
                if ((double)f13 == 0.0) continue;
                f11 += f15 / f13;
            }
            if (n5 > 0) {
                n3 += n5;
            } else {
                ++n4;
            }
            f5 += f13;
            float f17 = (float)((double)(Math2.M_PI * f13) * (Math.pow(f14, 2.0) * 3.0) / 12.0);
            float f18 = Math2.M_PI * f14 * f13;
            f4 += f17;
            f8 += f18;
            if (n6 <= 0) {
                f3 += f17;
                f7 += f18;
            } else {
                f2 += f17;
                f6 += f18;
            }
            if (l4 > 0L) {
                l3 += l4;
            }
            if (l4 == -1L) {
                ++l2;
            }
            if (l4 == -2L) {
                ++l;
            }
            f += graphState.getFloat((Object)shoot, true, Attributes.PARAMETER);
            Matrix4d matrix4d = LSystem.transformation((Node)shoot);
            matrix4d.get(vector3d);
            vector3d2.set((Tuple3d)vector3d);
            Math2.min((Tuple3d)point3d, (Tuple3d)vector3d);
            Math2.max((Tuple3d)point3d2, (Tuple3d)vector3d);
            vector3d.set(0.0, 0.0, (double)shoot.getLength(shoot, graphState));
            Math2.transformPoint((Matrix4d)matrix4d, (Tuple3d)vector3d);
            vector3d3.set((Tuple3d)vector3d);
            Math2.min((Tuple3d)point3d, (Tuple3d)vector3d);
            Math2.max((Tuple3d)point3d2, (Tuple3d)vector3d);
            float f19 = (float)Math.sqrt(Math.pow(vector3d2.x, 2.0) + Math.pow(vector3d2.y, 2.0));
            if (f19 > f10) {
                f10 = f19;
            }
            if ((f19 = (float)Math.sqrt(Math.pow(vector3d3.x, 2.0) + Math.pow(vector3d3.y, 2.0))) > f10) {
                f10 = f19;
            }
            if (!(f14 > f9)) continue;
            f9 = f14;
        }
        dataseries = dataset.addRow();
        dataseries.set(1, (Number)new Integer(n)).set(2, (Number)new Double(point3d.x)).set(3, (Number)new Double(point3d.y)).set(4, (Number)new Double(point3d.z)).set(5, (Number)new Double(point3d2.x)).set(6, (Number)new Double(point3d2.y)).set(7, (Number)new Double(point3d2.z)).set(8, (Number)new Integer(n4)).set(9, (Number)new Double(n == n4 ? 0.0 : (double)(n3 / (n - n4)))).set(10, (Number)new Double(f5)).set(11, (Number)new Double(f4)).set(12, (Number)new Double(f3)).set(13, (Number)new Double(f2)).set(14, (Number)new Double(f8)).set(15, (Number)new Double(f7)).set(16, (Number)new Double(f6)).set(17, (Number)new Long(l3)).set(18, (Number)new Double(f)).set(19, (Number)new Double(f10)).set(20, (Number)new Double(n2 == 0 ? 0.0 : (double)(f12 / (float)n2))).set(21, (Number)new Double(n2 == 0 ? 0.0 : (double)(f11 / (float)n2))).set(22, (Number)new Double(f9)).set(23, (Number)new Long(l2)).set(24, (Number)new Long(l));
        object = LSystem.current();
        if (object != null) {
            dataseries.set(0, (Number)new Integer(object.generation));
        }
        return dataset;
    }

    public static Dataset basicTreeParameters(Node node) {
        int n;
        Dataseries dataseries;
        Shoot shoot;
        Shoot shoot2;
        Dataset dataset = new Dataset();
        dataset.setTitle("basic tree parameters");
        dataset.setColumnKey(0, (Comparable)((Object)"lowest z value")).setColumnKey(1, (Comparable)((Object)"highest z value")).setColumnKey(2, (Comparable)((Object)"latest height increment")).setColumnKey(3, (Comparable)((Object)"height of crown base")).setColumnKey(4, (Comparable)((Object)"maximal crown radius")).setColumnKey(5, (Comparable)((Object)"stem diameter at tree basis")).setColumnKey(6, (Comparable)((Object)"stem diameter at breast ht.")).setColumnKey(7, (Comparable)((Object)"branch diam. at crown base")).setColumnKey(8, (Comparable)((Object)"maximal branch diameter")).setColumnKey(9, (Comparable)((Object)"total nb. of growth units")).setColumnKey(10, (Comparable)((Object)"sum of all leaf values"));
        float f = 1.0E16f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0E16f;
        float f5 = 0.0f;
        float f6 = -1.0f;
        float f7 = -1.0f;
        float f8 = -1.0f;
        float f9 = -1.0f;
        long l = 0L;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = -1.0f;
        int n2 = -1;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Shoot shoot3 = null;
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null) {
            float f13;
            ++l;
            f10 += graphState.getFloat((Object)shoot2, true, Attributes.PARAMETER);
            int n3 = graphState.getInt((Object)shoot2, true, Attributes.ORDER);
            float f14 = (float)graphState.getDouble((Object)shoot2, true, Attributes.LENGTH);
            float f15 = graphState.getFloat((Object)shoot2, true, Attributes.RADIUS) * 2.0f;
            shoot = Analysis.getAssociatedMotherShoot((Node)shoot2);
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot2), (double)f14, (Vector3d)vector3d, (Vector3d)vector3d3);
            if (n3 == 0) {
                if (vector3d.z < (double)f) {
                    f = (float)vector3d.z;
                }
                if (vector3d3.z > (double)f2) {
                    f2 = (float)vector3d3.z;
                    f3 = f14;
                }
                if (shoot == null) {
                    f6 = f15;
                }
                if (vector3d.z <= 1300.0 && vector3d3.z > 1300.0) {
                    f7 = f15;
                }
            } else if (n3 == 1) {
                int n4;
                Shoot shoot4;
                if (shoot != null) {
                    shoot4 = Analysis.getAssociatedMotherShoot((Node)shoot);
                    dataseries = shoot.getCurrentGraphState();
                    n4 = dataseries.getInt((Object)shoot, true, Attributes.ORDER);
                    if (shoot4 != null && n4 == 1) {
                        Math2.getBeginOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (Vector3d)vector3d2);
                        if (n4 == 0 && vector3d2.z <= (double)f4) {
                            f4 = (float)vector3d2.z;
                            f8 = dataseries.getFloat((Object)shoot, true, Attributes.HEARTWOOD);
                        }
                    }
                }
                if (f15 > f9) {
                    f9 = f15;
                }
                float f16 = 0.0f;
                float f17 = 0.0f;
                n = 0;
                shoot4 = shoot2;
                n4 = n3;
                while (n4 > 0 && shoot4 != null) {
                    ++n;
                    f17 = (float)((double)f17 + shoot.getCurrentGraphState().getDouble((Object)shoot, true, Attributes.LENGTH));
                    n4 = shoot.getCurrentGraphState().getInt((Object)shoot, true, Attributes.ORDER);
                    Math2.getBeginOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (Vector3d)vector3d2);
                    f16 = (float)vector3d2.z;
                    shoot = Analysis.getAssociatedMotherShoot((Node)shoot);
                }
                if (n4 == 0 && f17 > f11) {
                    f11 = f17;
                    shoot3 = shoot2;
                    f12 = f16;
                    n2 = n;
                }
            }
            if (!((f13 = (float)Math.sqrt(Math.pow(vector3d3.x, 2.0) + Math.pow(vector3d3.y, 2.0))) > f5)) continue;
            f5 = f13;
        }
        if ((double)f4 > 1.0E15) {
            f4 = -1.0f;
        }
        if ((double)f > 1.0E15) {
            f = -1.0f;
        }
        dataseries = dataset.addRow();
        dataseries.set(0, (Number)new Double(f)).set(1, (Number)new Double(f2)).set(2, (Number)new Double(f3)).set(3, (Number)new Double(f4)).set(4, (Number)new Double(f5)).set(5, (Number)new Double(f6)).set(6, (Number)new Double(f7)).set(7, (Number)new Double(f8)).set(8, (Number)new Double(f9)).set(9, (Number)new Long(l)).set(10, (Number)new Double(f10));
        if (shoot3 != null) {
            dataset.setColumnKey(11, (Comparable)((Object)"max. S1 total length")).setColumnKey(12, (Comparable)((Object)"resp. z of S1 basis")).setColumnKey(13, (Comparable)((Object)"resp. nb. of WE"));
            dataseries.set(11, (Number)new Double(f11)).set(12, (Number)new Double(f12)).set(13, (Number)new Integer(n2));
            shoot = Analysis.getAssociatedMotherShoot((Node)shoot3);
            n = 14;
            while (shoot3.getCurrentGraphState().getInt((Object)shoot3, true, Attributes.ORDER) > 0 && shoot != null) {
                dataset.setColumnKey(n, (Comparable)((Object)"increments from end to basis"));
                dataseries.set(n, (Number)new Double(shoot3.getCurrentGraphState().getDouble((Object)shoot3, true, Attributes.LENGTH)));
                shoot3 = shoot;
                shoot = Analysis.getAssociatedMotherShoot((Node)shoot);
                ++n;
            }
        }
        return dataset;
    }

    public static Dataset coordinates(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("coordinates");
        dataset.setColumnKey(0, (Comparable)((Object)"ID of shoot")).setColumnKey(1, (Comparable)((Object)"x-coordinate")).setColumnKey(2, (Comparable)((Object)"y-coordinate"));
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            if (graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR) == 0) continue;
            Dataseries dataseries = dataset.addRow();
            Math2.getBeginOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (Vector3d)vector3d);
            dataseries.set(0, (Number)new Long(shoot.getId()));
            dataseries.set(1, (Number)new Double(vector3d.x));
            dataseries.set(2, (Number)new Double(vector3d.y));
        }
        return dataset;
    }

    public static Dataset diameterTable(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("diameter table");
        dataset.setColumnKey(0, (Comparable)((Object)"ID of shoot")).setColumnKey(1, (Comparable)((Object)"#daughter shoots")).setColumnKey(2, (Comparable)((Object)"diameter of shoot")).setColumnKey(3, (Comparable)((Object)"diameter of daughter 1")).setColumnKey(4, (Comparable)((Object)"diameter of daughter 2")).setColumnKey(5, (Comparable)((Object)"diameter of daughter 3")).setColumnKey(6, (Comparable)((Object)"diameter of daughter 4"));
        float[] fArray = new float[4];
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            Shoot shoot2;
            int n = graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT);
            if (graphState.getInt((Object)shoot, true, Attributes.ORDER) < 0 || n < 0) continue;
            int n2 = 0;
            fArray[3] = 0.0f;
            fArray[2] = 0.0f;
            fArray[1] = 0.0f;
            fArray[0] = 0.0f;
            GraphState graphState2 = node.getCurrentGraphState();
            TreeIterator treeIterator2 = new TreeIterator(node);
            while ((shoot2 = LSystem.nextShoot(treeIterator2)) != null) {
                Shoot shoot3 = Analysis.getAssociatedMotherShoot((Node)shoot2);
                if (shoot3 != shoot || n < 0 || ++n2 >= 5) continue;
                fArray[n2 - 1] = graphState2.getFloat((Object)shoot2, true, Attributes.RADIUS) * 2.0f;
            }
            if (n2 <= true || n2 >= 5) continue;
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Long(shoot.getId())).set(1, (Number)new Integer(n2)).set(2, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f)).set(3, (Number)new Double(fArray[0])).set(4, (Number)new Double(fArray[1])).set(5, (Number)new Double(fArray[2])).set(6, (Number)new Double(fArray[3]));
        }
        return dataset;
    }

    public static Dataset severalTreesAnalysis(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("elementary analysis of several trees");
        dataset.setColumnKey(0, (Comparable)((Object)"Tree id number")).setColumnKey(1, (Comparable)((Object)"maximal z value (height)")).setColumnKey(2, (Comparable)((Object)"maximal diameter")).setColumnKey(3, (Comparable)((Object)"BHD")).setColumnKey(4, (Comparable)((Object)"length sum")).setColumnKey(5, (Comparable)((Object)"sum of leaf values")).setColumnKey(6, (Comparable)((Object)"number of internodes")).setColumnKey(7, (Comparable)((Object)"total volume")).setColumnKey(8, (Comparable)((Object)"total surface"));
        int n = 0;
        int n2 = 0;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        TreeInformation[] treeInformationArray = new TreeInformation[100];
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            boolean bl = false;
            int n3 = 0;
            n2 = graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR);
            while (!bl && n3 < n) {
                if (treeInformationArray[n3] != null && treeInformationArray[n3].getColor() == n2) {
                    bl = true;
                    continue;
                }
                if (++n3 < 100) continue;
                System.out.println("Warning: Too many trees!");
            }
            if (!bl && n3 < 100) {
                if (n3 != n) {
                    System.out.println("Warning: Severe inconsistency!");
                }
                treeInformationArray[n3] = new TreeInformation();
                treeInformationArray[n3].setColor(n2);
                if (++n >= 100) {
                    System.out.println("Warning: Too many trees!");
                }
            }
            float f = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            float f2 = graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f;
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f, (Vector3d)vector3d, (Vector3d)vector3d2);
            if (vector3d2.z > (double)treeInformationArray[n3].getZval()) {
                treeInformationArray[n3].setZval((float)vector3d2.z);
            }
            if (f2 > treeInformationArray[n3].getDiameter()) {
                treeInformationArray[n3].setDiameter(f2);
            }
            if (graphState.getInt((Object)shoot, true, Attributes.ORDER) == 0 && vector3d.z <= 1300.0 && vector3d2.z > 1300.0) {
                treeInformationArray[n3].setBhd(f2);
            }
            treeInformationArray[n3].setLsum(f + treeInformationArray[n3].getLsum());
            treeInformationArray[n3].setNsum(graphState.getFloat((Object)shoot, true, Attributes.PARAMETER) + treeInformationArray[n3].getNsum());
            treeInformationArray[n3].setIsum((long)graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) + treeInformationArray[n3].getIsum());
            treeInformationArray[n3].setVolsum((float)((double)treeInformationArray[n3].getVolsum() + (double)Math2.M_PI * 0.25 * (double)f2 * (double)f2 * (double)f));
            treeInformationArray[n3].setSursum(treeInformationArray[n3].getSursum() + Math2.M_PI * f2 * f);
        }
        for (int i = 0; i < treeInformationArray.length && treeInformationArray[i] != null; ++i) {
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Integer(treeInformationArray[i].getColor())).set(1, (Number)new Double(treeInformationArray[i].getZval())).set(2, (Number)new Double(treeInformationArray[i].getDiameter())).set(3, (Number)new Double(treeInformationArray[i].getBhd())).set(4, (Number)new Double(treeInformationArray[i].getLsum())).set(5, (Number)new Double(treeInformationArray[i].getNsum())).set(6, (Number)new Long(treeInformationArray[i].getIsum())).set(7, (Number)new Double(treeInformationArray[i].getVolsum())).set(8, (Number)new Double(treeInformationArray[i].getSursum()));
        }
        return dataset;
    }

    public static Dataset listOfAllShoots(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("list of all shoots");
        dataset.setColumnKey(0, (Comparable)((Object)"shoot-ID")).setColumnKey(1, (Comparable)((Object)"predecessor-ID")).setColumnKey(2, (Comparable)((Object)"length")).setColumnKey(3, (Comparable)((Object)"heartwood diameter")).setColumnKey(4, (Comparable)((Object)"total diameter")).setColumnKey(5, (Comparable)((Object)"#internode")).setColumnKey(6, (Comparable)((Object)"color")).setColumnKey(7, (Comparable)((Object)"order")).setColumnKey(8, (Comparable)((Object)"generation no.")).setColumnKey(9, (Comparable)((Object)"generative-distance")).setColumnKey(10, (Comparable)((Object)"tropism")).setColumnKey(11, (Comparable)((Object)"n-value")).setColumnKey(12, (Comparable)((Object)"carbon")).setColumnKey(13, (Comparable)((Object)"rel. position on mother shoot")).setColumnKey(14, (Comparable)((Object)"x-value at begin of shoot")).setColumnKey(15, (Comparable)((Object)"y-value at begin of shoot")).setColumnKey(16, (Comparable)((Object)"z-value at begin of shoot")).setColumnKey(17, (Comparable)((Object)"x-value at end of shoot")).setColumnKey(18, (Comparable)((Object)"y-value at end of shoot")).setColumnKey(19, (Comparable)((Object)"z-value at end of shoot")).setColumnKey(20, (Comparable)((Object)"x-value of sl")).setColumnKey(21, (Comparable)((Object)"y-value of sl")).setColumnKey(22, (Comparable)((Object)"z-value of sl")).setColumnKey(23, (Comparable)((Object)"x-value of su")).setColumnKey(24, (Comparable)((Object)"y-value of su")).setColumnKey(25, (Comparable)((Object)"z-value of su")).setColumnKey(26, (Comparable)((Object)"x-value of sh")).setColumnKey(27, (Comparable)((Object)"y-value of sh")).setColumnKey(28, (Comparable)((Object)"z-value of sh"));
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        int n = 0;
        LSystem lSystem = LSystem.current();
        if (lSystem != null) {
            n = lSystem.getGenerationNo();
        }
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            float f = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            Matrix4d matrix4d = LSystem.transformation((Node)shoot);
            Math2.getBeginAndEndOfShoot((Matrix4d)matrix4d, (double)f, (Vector3d)vector3d, (Vector3d)vector3d2);
            Shoot shoot2 = Analysis.getAssociatedMotherShoot((Node)shoot);
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Long(shoot.getId())).set(1, (Number)new Long(shoot2 != null ? shoot2.getId() : -1L)).set(2, (Number)new Double(f)).set(3, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.HEARTWOOD))).set(4, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f)).set(5, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT))).set(6, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR))).set(7, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.ORDER))).set(8, (Number)new Integer(n)).set(9, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE))).set(10, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.TROPISM_STRENGTH))).set(11, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.PARAMETER))).set(12, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.CARBON))).set(13, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION))).set(14, (Number)new Double(vector3d.x)).set(15, (Number)new Double(vector3d.y)).set(16, (Number)new Double(vector3d.z)).set(17, (Number)new Double(vector3d2.x)).set(18, (Number)new Double(vector3d2.y)).set(19, (Number)new Double(vector3d2.z)).set(20, (Number)new Double(matrix4d.m00)).set(21, (Number)new Double(matrix4d.m10)).set(22, (Number)new Double(matrix4d.m20)).set(23, (Number)new Double(matrix4d.m01)).set(24, (Number)new Double(matrix4d.m11)).set(25, (Number)new Double(matrix4d.m21)).set(26, (Number)new Double(matrix4d.m02)).set(27, (Number)new Double(matrix4d.m12)).set(28, (Number)new Double(matrix4d.m22));
        }
        return dataset;
    }

    public static Dataset pathlengthAnalysis(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("pathlength analysis");
        dataset.setColumnKey(0, (Comparable)((Object)"shoot-ID")).setColumnKey(1, (Comparable)((Object)"diameter")).setColumnKey(2, (Comparable)((Object)"av.length")).setColumnKey(3, (Comparable)((Object)"max.length")).setColumnKey(4, (Comparable)((Object)"no. of longest terminal shoot")).setColumnKey(5, (Comparable)((Object)"length sum")).setColumnKey(6, (Comparable)((Object)"volume sum")).setColumnKey(7, (Comparable)((Object)"n sum")).setColumnKey(8, (Comparable)((Object)"order"));
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        float f = 0.0f;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            Shoot shoot2;
            int n = 0;
            float f2 = 0.0f;
            float f3 = 0.0f;
            Shoot shoot3 = shoot;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            GraphState graphState2 = node.getCurrentGraphState();
            TreeIterator treeIterator2 = new TreeIterator(node);
            float f7 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            while ((shoot2 = LSystem.nextShoot(treeIterator2)) != null) {
                boolean bl = false;
                float f8 = (float)graphState2.getDouble((Object)shoot2, true, Attributes.LENGTH);
                if (!(!Analysis.terminalShoot(shoot2, node) || f8 < 1.0E-9f && (graphState2.getFloat((Object)shoot2, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState2.getFloat((Object)shoot2, true, Attributes.REL_POSITION)) > 1.0E-9f)) {
                    bl = true;
                }
                float f9 = 0.0f;
                float f10 = 0.0f;
                Shoot shoot4 = shoot2;
                GraphState graphState3 = shoot4.getCurrentGraphState();
                while (shoot4 != null && shoot4 != shoot) {
                    f = (float)graphState3.getDouble((Object)shoot4, true, Attributes.LENGTH);
                    f9 = (float)((double)f9 + (double)f * (1.0 - (double)f10));
                    f10 = graphState3.getFloat((Object)shoot4, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState3.getFloat((Object)shoot4, true, Attributes.REL_POSITION);
                    shoot4 = Analysis.getAssociatedMotherShoot((Node)shoot4);
                }
                if (shoot4 != shoot) continue;
                f9 = (float)((double)f9 + (double)f7 * (1.0 - (double)f10));
                f6 += f8;
                f5 = (float)((double)f5 + (double)(f8 * 0.25f * Math2.M_PI) * Math.pow(graphState2.getFloat((Object)shoot2, true, Attributes.RADIUS) * 2.0f, 2.0));
                f4 += graphState2.getFloat((Object)shoot2, true, Attributes.PARAMETER);
                if (!bl) continue;
                f2 += f9;
                ++n;
                if (!(f9 > f3)) continue;
                f3 = f9;
                shoot3 = shoot2;
            }
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Long(shoot.getId())).set(1, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f)).set(2, (Number)new Double(n > 0 ? (double)(f2 / (float)n) : 0.0)).set(3, (Number)new Double(f3)).set(4, (Number)new Long(shoot3.getId())).set(5, (Number)new Double(f6)).set(6, (Number)new Double(f5)).set(7, (Number)new Double(f4)).set(8, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.ORDER)));
        }
        return dataset;
    }

    public static Dataset branchingPositions(Node node) {
        String string;
        Dataset dataset;
        Shoot shoot;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        int n = 0;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            Shoot shoot2;
            int n2 = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            if (n2 < 0 || graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) < 0) continue;
            double[] dArray = new double[42];
            Arrays.fill(dArray, -1.0);
            int n3 = 0;
            dArray[0] = shoot.getId();
            dataset = node.getCurrentGraphState();
            string = new TreeIterator(node);
            while ((shoot2 = LSystem.nextShoot((TreeIterator)string)) != null) {
                if (Analysis.getAssociatedMotherShoot((Node)shoot2) != shoot || dataset.getInt((Object)shoot2, true, Attributes.INTERNODE_COUNT) < 0 || dataset.getInt((Object)shoot2, true, Attributes.ORDER) <= n2 || ++n3 >= 41) continue;
                dArray[n3] = dataset.getFloat((Object)shoot2, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - dataset.getFloat((Object)shoot2, true, Attributes.REL_POSITION);
            }
            if (n3 <= 0) continue;
            dArray[41] = n3;
            n = n3 < 41 ? Math.max(n3, n) : 40;
            arrayList.add(dArray);
        }
        dataset = new Dataset();
        dataset.setTitle("branching positions");
        dataset.setColumnKey(0, (Comparable)((Object)"shoot-ID")).setColumnKey(1, (Comparable)((Object)"#daughters"));
        for (int i = 2; i < n + 2; ++i) {
            string = "daughter-" + (i - 1);
            dataset.setColumnKey(i, (Comparable)((Object)string));
        }
        for (double[] dArray : arrayList) {
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Double(dArray[0])).set(1, (Number)new Double(dArray[41]));
            for (int i = 2; i < n + 2; ++i) {
                dataseries.set(i, (Number)new Double(dArray[i - 1]));
            }
        }
        return dataset;
    }

    public static Dataset noOfDaughterShoots(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("number of daughter shoots");
        dataset.setColumnKey(0, (Comparable)((Object)"shoot-ID")).setColumnKey(1, (Comparable)((Object)"length")).setColumnKey(2, (Comparable)((Object)"diameter")).setColumnKey(3, (Comparable)((Object)"order")).setColumnKey(4, (Comparable)((Object)"age")).setColumnKey(5, (Comparable)((Object)"#daughter shoots")).setColumnKey(6, (Comparable)((Object)"#subapical daughter shoots")).setColumnKey(7, (Comparable)((Object)"#medial daughter shoots")).setColumnKey(8, (Comparable)((Object)"#basal daughter shoots")).setColumnKey(9, (Comparable)((Object)"sum of diametersquare of daughter shoots")).setColumnKey(10, (Comparable)((Object)"sum of diameters of daughter shoots")).setColumnKey(11, (Comparable)((Object)"z-value on shoottip")).setColumnKey(12, (Comparable)((Object)"x-value of direction vector of shoot")).setColumnKey(13, (Comparable)((Object)"y-value of direction vector of shoot")).setColumnKey(14, (Comparable)((Object)"z-value of direction vector of shoot")).setColumnKey(15, (Comparable)((Object)"leaf"));
        float f = 0.0f;
        int n = Analysis.findGenerationMax(node);
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            Shoot shoot2;
            int n2 = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            if (n2 < 0) continue;
            float f2 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            float f3 = graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f;
            int n3 = graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE);
            int n4 = n - n3;
            Matrix4d matrix4d = LSystem.transformation((Node)shoot);
            Math2.getEndOfShoot((Matrix4d)matrix4d, (double)f2, (Vector3d)vector3d);
            f = (float)vector3d.z;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            float f4 = 0.0f;
            float f5 = 0.0f;
            GraphState graphState2 = node.getCurrentGraphState();
            TreeIterator treeIterator2 = new TreeIterator(node);
            while ((shoot2 = LSystem.nextShoot(treeIterator2)) != null) {
                float f6;
                if (Analysis.getAssociatedMotherShoot((Node)shoot2) != shoot || graphState2.getInt((Object)shoot2, true, Attributes.INTERNODE_COUNT) < 0) continue;
                ++n8;
                float f7 = graphState2.getFloat((Object)shoot2, true, Attributes.RADIUS) * 2.0f;
                f5 = (float)((double)f5 + Math.pow(f7, 2.0));
                f4 += f7;
                if (graphState2.getInt((Object)shoot2, true, Attributes.ORDER) == n2) continue;
                float f8 = f6 = graphState2.getFloat((Object)shoot2, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState2.getFloat((Object)shoot2, true, Attributes.REL_POSITION);
                if ((double)f6 < 0.2) {
                    ++n7;
                    continue;
                }
                if ((double)f6 >= 0.2 && (double)f6 < 0.8) {
                    ++n6;
                    continue;
                }
                if (!((double)f6 >= 0.8)) continue;
                ++n5;
            }
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Long(shoot.getId())).set(1, (Number)new Double(f2)).set(2, (Number)new Double(f3)).set(3, (Number)new Integer(n2)).set(4, (Number)new Integer(n4)).set(5, (Number)new Integer(n8)).set(6, (Number)new Integer(n7)).set(7, (Number)new Integer(n6)).set(8, (Number)new Integer(n5)).set(9, (Number)new Double(f5)).set(10, (Number)new Double(f4)).set(11, (Number)new Double(f)).set(12, (Number)new Double(matrix4d.m02)).set(13, (Number)new Double(matrix4d.m12)).set(14, (Number)new Double(matrix4d.m22)).set(15, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) < 0 ? 1 : 0));
        }
        return dataset;
    }

    public static Dataset option3(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("number of daughter shoots");
        dataset.setColumnKey(0, (Comparable)((Object)"shoot-ID")).setColumnKey(1, (Comparable)((Object)"mother-ID")).setColumnKey(2, (Comparable)((Object)"order")).setColumnKey(3, (Comparable)((Object)"age")).setColumnKey(4, (Comparable)((Object)"relative position on mother shoot")).setColumnKey(5, (Comparable)((Object)"run of angle")).setColumnKey(6, (Comparable)((Object)"length")).setColumnKey(7, (Comparable)((Object)"diameter")).setColumnKey(8, (Comparable)((Object)"#internodes")).setColumnKey(9, (Comparable)((Object)"#daughters")).setColumnKey(10, (Comparable)((Object)"#sleeping daughter-shoots")).setColumnKey(11, (Comparable)((Object)"length of bigbrother")).setColumnKey(12, (Comparable)((Object)"length of mother")).setColumnKey(13, (Comparable)((Object)"color")).setColumnKey(14, (Comparable)((Object)"difference (gen - gen of mother)")).setColumnKey(15, (Comparable)((Object)"axisposition")).setColumnKey(16, (Comparable)((Object)"leaf"));
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        int n = Analysis.findGenerationMax(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            long l;
            float f;
            float f2;
            float f3;
            GraphState graphState2;
            int n2 = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            if (n2 < 0) continue;
            float f4 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            float f5 = graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f;
            int n3 = graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE);
            int n4 = n - n3;
            Shoot shoot2 = Analysis.bigBrother(shoot, node, true, null);
            if (shoot2 != null) {
                graphState2 = shoot2.getCurrentGraphState();
                f3 = (float)graphState2.getDouble((Object)shoot2, true, Attributes.LENGTH);
            } else {
                f3 = -1.0f;
            }
            Shoot shoot3 = Analysis.getAssociatedMotherShoot((Node)shoot);
            if (shoot3 != null) {
                graphState2 = shoot3.getCurrentGraphState();
                f2 = (float)graphState2.getDouble((Object)shoot3, true, Attributes.LENGTH);
                Matrix4d matrix4d = LSystem.transformation((Node)shoot);
                vector3d.x = matrix4d.m02;
                vector3d.y = matrix4d.m12;
                vector3d.z = matrix4d.m22;
                matrix4d = LSystem.transformation((Node)shoot3);
                vector3d2.x = matrix4d.m02;
                vector3d2.y = matrix4d.m12;
                vector3d2.z = matrix4d.m22;
                f = (float)Math.toDegrees(vector3d.angle(vector3d2));
                l = n3 - graphState2.getInt((Object)shoot3, true, Attributes.GENERATIVE_DISTANCE);
            } else {
                f2 = -1.0f;
                f = 0.0f;
                l = -1L;
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) >= 0) {
                GraphState graphState3;
                Shoot shoot4;
                graphState2 = node.getCurrentGraphState();
                TreeIterator treeIterator2 = new TreeIterator(node);
                while ((shoot4 = LSystem.nextShoot(treeIterator2)) != null) {
                    Shoot shoot5 = Analysis.getAssociatedMotherShoot((Node)shoot4);
                    if (shoot5 != shoot || graphState2.getInt((Object)shoot4, true, Attributes.INTERNODE_COUNT) < 0) continue;
                    ++n5;
                    graphState3 = shoot5.getCurrentGraphState();
                    if (graphState3.getInt((Object)shoot5, true, Attributes.GENERATIVE_DISTANCE) >= graphState2.getInt((Object)shoot4, true, Attributes.GENERATIVE_DISTANCE) - 1) continue;
                    ++n6;
                }
                n7 = 1;
                shoot4 = shoot;
                boolean bl = true;
                while (bl) {
                    if ((shoot4 = Analysis.getAssociatedMotherShoot((Node)shoot4)) == null) {
                        bl = false;
                        continue;
                    }
                    graphState3 = shoot4.getCurrentGraphState();
                    if (graphState3.getInt((Object)shoot4, true, Attributes.ORDER) != n2) {
                        bl = false;
                        continue;
                    }
                    ++n7;
                }
            }
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Long(shoot.getId())).set(1, (Number)new Long(shoot3 != null ? shoot3.getId() : -1L)).set(2, (Number)new Integer(n2)).set(3, (Number)new Integer(n4)).set(4, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION))).set(5, (Number)new Double(f)).set(6, (Number)new Double(f4)).set(7, (Number)new Double(f5)).set(8, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT))).set(9, (Number)new Integer(n5)).set(10, (Number)new Integer(n6)).set(11, (Number)new Double(f3)).set(12, (Number)new Double(f2)).set(13, (Number)new Double(graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR))).set(14, (Number)new Long(l)).set(15, (Number)new Integer(n7)).set(16, (Number)new Integer(graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) < 0 ? 1 : 0));
        }
        return dataset;
    }

    public static Dataset shootPopulation(Node node) {
        LSystem lSystem = LSystem.current();
        if (lSystem != null) {
            return lSystem.getShootPopulation();
        }
        return null;
    }

    public static Dataset lengthAndAngles(Node node) {
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("length and angles");
        dataset.setColumnKey(0, (Comparable)((Object)"shoot-ID")).setColumnKey(1, (Comparable)((Object)"mother-ID")).setColumnKey(2, (Comparable)((Object)"order")).setColumnKey(3, (Comparable)((Object)"age")).setColumnKey(4, (Comparable)((Object)"positionno of cluster")).setColumnKey(5, (Comparable)((Object)"relative position on mother shoot")).setColumnKey(6, (Comparable)((Object)"rel. position * length of mother")).setColumnKey(7, (Comparable)((Object)"run of angle")).setColumnKey(8, (Comparable)((Object)"length")).setColumnKey(9, (Comparable)((Object)"#cluster")).setColumnKey(10, (Comparable)((Object)"length of bigbrother")).setColumnKey(11, (Comparable)((Object)"length of cousine")).setColumnKey(12, (Comparable)((Object)"length of mother")).setColumnKey(13, (Comparable)((Object)"#internodes")).setColumnKey(14, (Comparable)((Object)"#internodes of mother")).setColumnKey(15, (Comparable)((Object)"#internodes of bigbrother")).setColumnKey(16, (Comparable)((Object)"leaf"));
        HashMap<Long, Float> hashMap = new HashMap<Long, Float>();
        HashMap<Long, Float> hashMap2 = new HashMap<Long, Float>();
        Shoot[] shootArray = new Shoot[500];
        float[] fArray = new float[500];
        float[] fArray2 = new float[500];
        float[] fArray3 = new float[500];
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        ConfigurationSet configurationSet = new ConfigurationSet("Length And Angles");
        KeyDescriptionImpl keyDescriptionImpl = new KeyDescriptionImpl("clusterDistance", Library.I18N, "analysis.clusterDistance", Type.FLOAT, Quantity.LENGTH);
        Configuration configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl}, (Map)new StringMap().putFloat("clusterDistance", 1.0f));
        configurationSet.add(configuration);
        Workbench.current().showConfigurationDialog(configurationSet);
        float f = ((Float)configurationSet.get((Object)"clusterDistance", null)).floatValue();
        float f2 = Analysis.findGenerationMax(node);
        Analysis.labelDaughters(node, hashMap, hashMap2, f, shootArray, fArray, fArray2, fArray3);
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            float f3;
            Dataseries dataseries;
            int n;
            float f4;
            float f5;
            int n2;
            float f6;
            int n3 = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            if (n3 < 0) continue;
            int n4 = (int)f2 - graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE);
            float f7 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            int n5 = graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT);
            Shoot shoot2 = n5 >= 0 ? Analysis.bigBrother(shoot, node, false, hashMap) : null;
            if (shoot2 != null) {
                f6 = (float)graphState.getDouble((Object)shoot2, true, Attributes.LENGTH);
                n2 = graphState.getInt((Object)shoot2, true, Attributes.INTERNODE_COUNT);
            } else {
                f6 = -1.0f;
                n2 = -1;
            }
            Shoot shoot3 = n5 >= 0 ? Analysis.cousine(shoot, node, hashMap) : null;
            float f8 = shoot3 != null ? (float)graphState.getDouble((Object)shoot3, true, Attributes.LENGTH) : -1.0f;
            Shoot shoot4 = Analysis.getAssociatedMotherShoot((Node)shoot);
            if (shoot4 != null) {
                f5 = (float)graphState.getDouble((Object)shoot4, true, Attributes.LENGTH);
                f4 = (graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION)) * f5;
                n = graphState.getInt((Object)shoot4, true, Attributes.INTERNODE_COUNT);
                dataseries = LSystem.transformation((Node)shoot);
                vector3d.x = dataseries.m02;
                vector3d.y = dataseries.m12;
                vector3d.z = dataseries.m22;
                dataseries = LSystem.transformation((Node)shoot4);
                vector3d2.x = dataseries.m02;
                vector3d2.y = dataseries.m12;
                vector3d2.z = dataseries.m22;
                f3 = (float)Math.toDegrees(vector3d.angle(vector3d2));
            } else {
                f5 = -1.0f;
                f4 = 0.0f;
                n = -1;
                f3 = 0.0f;
            }
            dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Long(shoot.getId())).set(1, (Number)new Long(shoot4 != null ? shoot4.getId() : -1L)).set(2, (Number)new Integer(n3)).set(3, (Number)new Integer(n4)).set(4, (Number)new Integer(Analysis.integ(hashMap.get(shoot.getId()).floatValue()))).set(5, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION))).set(6, (Number)new Double(f4)).set(7, (Number)new Double(f3)).set(8, (Number)new Double(f7)).set(9, (Number)new Integer(Analysis.integ(hashMap2.get(shoot.getId()).floatValue()))).set(10, (Number)new Double(f6)).set(11, (Number)new Double(f8)).set(12, (Number)new Double(f5)).set(13, (Number)new Double(n5)).set(14, (Number)new Long(n)).set(15, (Number)new Integer(n2)).set(16, (Number)new Integer(n5 < 0 ? 1 : 0));
        }
        return dataset;
    }

    public static Dataset crownLayers(Node node) {
        int n;
        Shoot shoot;
        int n2;
        int n3;
        Dataset dataset = new Dataset();
        dataset.setTitle("crown layers");
        dataset.setColumnKey(0, (Comparable)((Object)"layerno.")).setColumnKey(1, (Comparable)((Object)"height of the lower layerborder (in mm)")).setColumnKey(2, (Comparable)((Object)"sum of the length in the layer (in mm)")).setColumnKey(3, (Comparable)((Object)"sum of the n-value in the layer"));
        float[] fArray = new float[20];
        float[] fArray2 = new float[20];
        float[] fArray3 = new float[20];
        fArray3[0] = 0.0f;
        ConfigurationSet configurationSet = new ConfigurationSet("Crown Layers");
        KeyDescriptionImpl keyDescriptionImpl = new KeyDescriptionImpl("equidistantLayers", Library.I18N, "analysis.equidistantLayers", Type.BOOLEAN, null);
        Configuration configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl}, (Map)new StringMap().putBoolean("equidistantLayers", false));
        configurationSet.add(configuration);
        Workbench.current().showConfigurationDialog(configurationSet);
        boolean bl = (Boolean)configurationSet.get((Object)"equidistantLayers", null);
        if (!bl) {
            n3 = 0;
            n2 = 1;
            while (n2 <= 3) {
                configurationSet = new ConfigurationSet("Crown Layers");
                keyDescriptionImpl = new KeyDescriptionImpl("layerBound", Library.I18N.msg("analysis.layerBound", (Object)n2), Type.FLOAT, Quantity.LENGTH);
                configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl}, (Map)new StringMap().putFloat("layerBound", 1.0f));
                configurationSet.add(configuration);
                Workbench.current().showConfigurationDialog(configurationSet);
                fArray3[n2] = ((Float)configurationSet.get((Object)"layerBound", null)).floatValue();
                int n4 = n2++;
                fArray3[n4] = fArray3[n4] * 1000.0f;
            }
            for (n2 = 4; n2 <= 19; ++n2) {
                fArray3[n2] = 1000000.0f;
            }
        } else {
            n3 = 1;
            configurationSet = new ConfigurationSet("Crown Layers");
            keyDescriptionImpl = new KeyDescriptionImpl("layerDistance", Library.I18N, "analysis.layerDistance", Type.FLOAT, Quantity.LENGTH);
            configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl}, (Map)new StringMap().putFloat("layerDistance", 1.0f));
            configurationSet.add(configuration);
            Workbench.current().showConfigurationDialog(configurationSet);
            float f = ((Float)configurationSet.get((Object)"layerDistance", null)).floatValue();
            if (f <= 0.0f) {
                f = 100.0f;
                Workbench.current().getWindow().showDialog("Crown Layers", (Object)"Layer distance <= 0. Set to 100.", 2);
            }
            f *= 1000.0f;
            for (n2 = 1; n2 <= 19; ++n2) {
                fArray3[n2] = fArray3[n2 - 1] + f;
            }
        }
        Vector3d vector3d = new Vector3d();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        int n5 = 3 + n3 * 16;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            if (graphState.getInt((Object)shoot, true, Attributes.ORDER) < 0 || graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) < 0) continue;
            int n6 = 0;
            for (n = 0; n <= n5; ++n) {
                Math2.getBeginOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (Vector3d)vector3d);
                if (!(vector3d.z >= (double)fArray3[n])) continue;
                n6 = n;
            }
            int n7 = n6;
            fArray2[n7] = (float)((double)fArray2[n7] + graphState.getDouble((Object)shoot, true, Attributes.LENGTH));
            int n8 = n6;
            fArray[n8] = fArray[n8] + graphState.getFloat((Object)shoot, true, Attributes.PARAMETER);
        }
        for (n = 0; n <= n5; ++n) {
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Integer(n)).set(1, (Number)new Double(fArray3[n])).set(2, (Number)new Double(fArray2[n])).set(3, (Number)new Double(fArray[n]));
        }
        return dataset;
    }

    public static Dataset stemAnalysis(Node node) {
        Dataseries dataseries;
        Shoot shoot;
        Dataset dataset = new Dataset();
        dataset.setTitle("stem analysis");
        dataset.setColumnKey(0, (Comparable)((Object)"timestep")).setColumnKey(1, (Comparable)((Object)"z-coordinate (segmentcenter)")).setColumnKey(2, (Comparable)((Object)"radius"));
        float f = 42.0f;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            if (graphState.getInt((Object)shoot, true, Attributes.ORDER) != 0) continue;
            Math2.getBeginOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (Vector3d)vector3d);
            f = (float)vector3d.z;
            break;
        }
        if (node == null) {
            f = 0.0f;
        }
        ConfigurationSet configurationSet = new ConfigurationSet("Stem Analysis");
        KeyDescriptionImpl keyDescriptionImpl = new KeyDescriptionImpl("treeNumber", Library.I18N, "analysis.treeNumber", Type.INT, Quantity.LENGTH);
        Configuration configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl}, (Map)new StringMap().putFloat("treeNumber", 1.0f));
        configurationSet.add(configuration);
        Workbench.current().showConfigurationDialog(configurationSet);
        int n = (Integer)configurationSet.get((Object)"treeNumber", null);
        if (n <= 0) {
            n = 1;
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        float f2 = 0.0f;
        LSystem lSystem = LSystem.current();
        int n4 = lSystem != null ? lSystem.getGenerationNo() : 0;
        treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            int n5 = graphState.getInt((Object)shoot, true, Attributes.ORDER);
            float f3 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            if (Analysis.getAssociatedMotherShoot((Node)shoot) == null) {
                ++n2;
            }
            if (n3 > -1 && n3 == n2 - 1) break;
            if (n5 != 0 || !(f3 > 1.0E-9f) || n2 != n) continue;
            n3 = n2;
            if (!bl) {
                bl = true;
                dataseries = dataset.addRow();
                dataseries.set(0, (Number)new Integer(n4)).set(1, (Number)new Double(0.0)).set(2, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.RADIUS)));
            }
            Math2.getBeginAndEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)f3, (Vector3d)vector3d, (Vector3d)vector3d2);
            dataseries = dataset.addRow();
            dataseries.set(0, (Number)new Integer(n4)).set(1, (Number)new Double((vector3d.z + vector3d2.z) / 2.0 - (double)f)).set(2, (Number)new Double(graphState.getFloat((Object)shoot, true, Attributes.RADIUS)));
            f2 = (float)(vector3d2.z - (double)f);
        }
        dataseries = dataset.addRow();
        dataseries.set(0, (Number)new Integer(n4)).set(1, (Number)new Double(f2)).set(2, (Number)new Double(0.0));
        return dataset;
    }

    public static Dataset distributionAnalysis(Node node) {
        int n;
        Shoot shoot;
        Shoot shoot2;
        String[] stringArray;
        Dataset dataset = new Dataset();
        dataset.setTitle("distribution analysis");
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        int[][] nArray4 = new int[5][80];
        int[][] nArray5 = new int[5][400];
        int[][] nArray6 = new int[5][200];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean[] blArray = new boolean[16];
        HashMap<Long, Boolean> hashMap = new HashMap<Long, Boolean>();
        ConfigurationSet configurationSet = new ConfigurationSet("Distribution Analysis");
        KeyDescriptionImpl keyDescriptionImpl = new KeyDescriptionImpl("treeColor", Library.I18N, "analysis.treeColor", Type.STRING, null);
        Configuration configuration = new Configuration(new KeyDescription[]{keyDescriptionImpl}, (Map)new StringMap().putObject("treeColor", (Object)""));
        configurationSet.add(configuration);
        Workbench.current().showConfigurationDialog(configurationSet);
        String string = (String)configurationSet.get((Object)"treeColor", null);
        if (string != null && string.trim().length() > 0) {
            stringArray = string.split(",");
            int n5 = 0;
            for (int i = 0; i < stringArray.length && i < 16; ++i) {
                n5 = Integer.parseInt(stringArray[i].trim());
                if (n5 <= -1 || n5 >= 16) continue;
                blArray[n5] = true;
            }
        }
        stringArray = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null) {
            hashMap.put(shoot2.getId(), !blArray[stringArray.getInt((Object)shoot2, true, Attributes.DTG_COLOR)]);
        }
        treeIterator = new TreeIterator(node);
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null) {
            shoot = Analysis.getAssociatedMotherShoot((Node)shoot2);
            if (shoot == null || stringArray.getInt((Object)shoot2, true, Attributes.ORDER) != stringArray.getInt((Object)shoot, true, Attributes.ORDER) || blArray[stringArray.getInt((Object)shoot2, true, Attributes.DTG_COLOR)]) continue;
            hashMap.put(shoot.getId(), false);
        }
        treeIterator = new TreeIterator(node);
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null) {
            int n6;
            int n7 = stringArray.getInt((Object)shoot2, true, Attributes.ORDER);
            if (n7 < 0 || !((Boolean)hashMap.get(shoot2.getId())).booleanValue()) continue;
            int n8 = n6 = n7;
            if (n6 >= 5) {
                n6 = 4;
            }
            int n9 = n6;
            nArray3[n9] = nArray3[n9] + 1;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            GraphState graphState = shoot2.getCurrentGraphState();
            Shoot shoot3 = shoot2;
            while (shoot3 != null && graphState.getInt((Object)shoot3, true, Attributes.ORDER) == n8) {
                shoot = Analysis.getAssociatedMotherShoot((Node)shoot3);
                if (!blArray[graphState.getInt((Object)shoot3, true, Attributes.DTG_COLOR)]) {
                    int n13 = n6;
                    nArray[n13] = nArray[n13] + 1;
                    ++n10;
                    ++n12;
                    if (graphState.getInt((Object)shoot3, true, Attributes.LOCAL_SCALE) > 0 || shoot == null || graphState.getInt((Object)shoot, true, Attributes.ORDER) != n8) {
                        if (n10 >= 80) {
                            n10 = 79;
                        }
                        int[] nArray7 = nArray4[n6];
                        int n14 = n10;
                        nArray7[n14] = nArray7[n14] + 1;
                        if (n10 > n4) {
                            n4 = n10;
                        }
                        n10 = 0;
                        int n15 = n6;
                        nArray2[n15] = nArray2[n15] + 1;
                        ++n11;
                        if (shoot == null || graphState.getInt((Object)shoot, true, Attributes.ORDER) != n8) {
                            if (n12 >= 400) {
                                n12 = 399;
                            }
                            int[] nArray8 = nArray5[n6];
                            int n16 = n12;
                            nArray8[n16] = nArray8[n16] + 1;
                            if (n12 > n3) {
                                n3 = n12;
                            }
                            if (n11 >= 200) {
                                n11 = 199;
                            }
                            int[] nArray9 = nArray6[n6];
                            int n17 = n11;
                            nArray9[n17] = nArray9[n17] + 1;
                            if (n11 > n2) {
                                n2 = n11;
                            }
                        }
                    }
                }
                shoot3 = shoot;
            }
        }
        int n18 = 1;
        int n19 = 0;
        Dataseries dataseries = dataset.addRow();
        dataset.setColumnKey(0, (Comparable)((Object)"number of elementary units : total"));
        dataseries.set(0, (Number)Analysis.sumArray(nArray));
        for (n = 0; n < 5; ++n) {
            dataset.setColumnKey(n18, (Comparable)((Object)("order " + n)));
            dataseries.set(n18++, (Number)nArray[n]);
        }
        dataset.setColumnKey(n18, (Comparable)((Object)"number of compound units : total"));
        dataseries.set(n18++, (Number)Analysis.sumArray(nArray2));
        for (n = 0; n < 5; ++n) {
            dataset.setColumnKey(n18, (Comparable)((Object)("order " + n)));
            dataseries.set(n18++, (Number)nArray2[n]);
        }
        dataset.setColumnKey(n18, (Comparable)((Object)"number of axes : total"));
        dataseries.set(n18++, (Number)Analysis.sumArray(nArray3));
        for (n = 0; n < 5; ++n) {
            dataset.setColumnKey(n18, (Comparable)((Object)("order " + n)));
            dataseries.set(n18++, (Number)nArray3[n]);
        }
        dataset.setColumnKey(n18, (Comparable)((Object)"Elementary units per compound unit : number"));
        dataseries.set(n18++, (Number)n19);
        dataset.setColumnKey(n18, (Comparable)((Object)"total"));
        dataseries.set(n18++, (Number)Analysis.sumArray(nArray4, 0));
        for (n = 0; n < 5; ++n) {
            dataset.setColumnKey(n18, (Comparable)((Object)("order " + n)));
            dataseries.set(n18++, (Number)nArray4[n][0]);
        }
        dataset.setColumnKey(n18, (Comparable)((Object)"Elementary units per axis : number"));
        dataseries.set(n18++, (Number)n19);
        dataset.setColumnKey(n18, (Comparable)((Object)"total"));
        dataseries.set(n18++, (Number)Analysis.sumArray(nArray5, 0));
        for (n = 0; n < 5; ++n) {
            dataset.setColumnKey(n18, (Comparable)((Object)("order " + n)));
            dataseries.set(n18++, (Number)nArray5[n][0]);
        }
        dataset.setColumnKey(n18, (Comparable)((Object)"Compound units per axis : number"));
        dataseries.set(n18++, (Number)n19);
        dataset.setColumnKey(n18, (Comparable)((Object)"total"));
        dataseries.set(n18++, (Number)Analysis.sumArray(nArray6, 0));
        for (n = 0; n < 5; ++n) {
            dataset.setColumnKey(n18, (Comparable)((Object)("order " + n)));
            dataseries.set(n18++, (Number)nArray6[n][0]);
        }
        ++n19;
        int n20 = Analysis.lastEntryInArray(nArray4);
        int n21 = Analysis.lastEntryInArray(nArray5);
        int n22 = Analysis.lastEntryInArray(nArray6);
        int n23 = Math.max(Math.max(n20, n21), n22);
        if (n23 > 0) {
            while (n19 < n23) {
                n18 = 0;
                dataseries = dataset.addRow();
                for (n18 = 0; n18 < 18; ++n18) {
                    dataseries.set(n18, (Number)-1);
                }
                n18 = Analysis.fillRow(dataseries, nArray4, n18, n19, n20);
                n18 = Analysis.fillRow(dataseries, nArray5, n18, n19, n21);
                n18 = Analysis.fillRow(dataseries, nArray6, n18, n19, n22);
                ++n19;
            }
        }
        return dataset;
    }

    public static Dataset topologicalAnalysis(Node node) {
        Dataset dataset = new Dataset();
        dataset.setTitle("topological analysis");
        dataset.setColumnKey(0, (Comparable)((Object)"number of components")).setColumnKey(1, (Comparable)((Object)"number of links")).setColumnKey(2, (Comparable)((Object)"number of exterior links")).setColumnKey(3, (Comparable)((Object)"discrepancy")).setColumnKey(4, (Comparable)((Object)"altitude (max.top.depth)")).setColumnKey(5, (Comparable)((Object)"mean top. depth b")).setColumnKey(6, (Comparable)((Object)"top. index qa")).setColumnKey(7, (Comparable)((Object)"top. index qb")).setColumnKey(8, (Comparable)((Object)"mean exterior link length")).setColumnKey(9, (Comparable)((Object)"mean interior link length"));
        ShootStructure shootStructure = null;
        ShootStructure shootStructure2 = Analysis.createGROGRAShootStructure(node);
        Analysis.fusaxes(shootStructure2);
        while (shootStructure != null) {
            Analysis.split(shootStructure, shootStructure2);
        }
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (shootStructure = shootStructure2; shootStructure != null; shootStructure = shootStructure.getSuccessor()) {
            shootStructure.setGenerativeDistance(0L);
            if (shootStructure.getColor() != 0 || shootStructure.getLength() > 1.0E-9f) {
                ++l6;
                shootStructure.setYke(0.0f);
            } else {
                shootStructure.setYke(1.0f);
            }
            if (shootStructure.getMother() != null) continue;
            ++n;
        }
        for (shootStructure = shootStructure2; shootStructure != null; shootStructure = shootStructure.getSuccessor()) {
            if (shootStructure.getMother() == null) continue;
            shootStructure.getMother().setGenerativeDistance(shootStructure.getMother().getGenerativeDistance() + 1L);
        }
        for (shootStructure = shootStructure2; shootStructure != null; shootStructure = shootStructure.getSuccessor()) {
            if (shootStructure.getGenerativeDistance() == 0L) {
                if (!(shootStructure.getYke() < 1.0E-9f)) continue;
                ++l5;
                f4 += shootStructure.getLength();
                l = 0L;
                for (ShootStructure shootStructure3 = shootStructure; shootStructure3 != null; shootStructure3 = shootStructure3.getMother()) {
                    if (!(shootStructure3.getYke() < 1.0E-9f)) continue;
                    ++l;
                }
                if (l > l3) {
                    l3 = l;
                }
                l2 += l;
                continue;
            }
            if (!(shootStructure.getYke() < 1.0E-9f)) continue;
            f3 += shootStructure.getLength();
            l4 += 2L - shootStructure.getGenerativeDistance();
        }
        f7 = l5 > 0L ? (float)l2 / (float)l5 : 0.0f;
        f2 = l5 > 0L ? f4 / (float)l5 : 0.0f;
        f = l6 - l5 > 0L ? f3 / ((float)l6 - (float)l5) : 0.0f;
        float f8 = (float)(Math.log(l5) / Math.log(2.0));
        f6 = ((float)l3 - 1.0f - f8) / ((float)l5 - 1.0f - f8);
        f5 = l5 > 0L ? (f7 - 1.0f - f8) / (((float)l5 + 1.0f) / 2.0f - 1.0f / (float)l5 - f8) : 0.0f;
        Dataseries dataseries = dataset.addRow();
        dataseries.set(0, (Number)n).set(1, (Number)l6).set(2, (Number)l5).set(3, (Number)l4).set(4, (Number)l3).set(5, (Number)Float.valueOf(f7)).set(6, (Number)Float.valueOf(f6)).set(7, (Number)Float.valueOf(f5)).set(8, (Number)Float.valueOf(f2)).set(9, (Number)Float.valueOf(f));
        return dataset;
    }

    public static Dataset axesAnalysis(Node node) {
        Dataset dataset = new Dataset();
        dataset.setTitle("topological analysis");
        dataset.setColumnKey(0, (Comparable)((Object)"number of the axis")).setColumnKey(1, (Comparable)((Object)"branching order")).setColumnKey(2, (Comparable)((Object)"length of the axis")).setColumnKey(3, (Comparable)((Object)"diameter")).setColumnKey(4, (Comparable)((Object)"color")).setColumnKey(5, (Comparable)((Object)"number of daughter axes")).setColumnKey(6, (Comparable)((Object)"average interbranch distance (pos(n) - pos(1))/(n-1)")).setColumnKey(7, (Comparable)((Object)"std deviation of interbranch distance"));
        ShootStructure shootStructure = Analysis.createGROGRAShootStructure(node);
        ShootStructure[] shootStructureArray = new ShootStructure[500];
        float[] fArray = new float[500];
        float[] fArray2 = new float[500];
        Analysis.fuse(shootStructure);
        long l = 0L;
        for (ShootStructure shootStructure2 = shootStructure; shootStructure2 != null; shootStructure2 = shootStructure2.getSuccessor()) {
            ++l;
            Analysis.createArraysForSplit(shootStructure2, shootStructure, 2, fArray, fArray2, shootStructureArray);
            float f = countDaughters < 2 ? -1.0f : (fArray2[countDaughters] - fArray2[1]) / (float)(countDaughters - 1);
            float f2 = 0.0f;
            if (countDaughters >= 3) {
                for (int i = 2; i <= countDaughters; ++i) {
                    f2 += (fArray[i] - f) * (fArray[i] - f);
                }
                f2 = (float)Math.sqrt((double)f2 / (double)(countDaughters - 2));
            }
            Dataseries dataseries = dataset.addRow();
            dataseries.set(0, (Number)l).set(1, (Number)shootStructure2.getOrder()).set(2, (Number)Float.valueOf(shootStructure2.getLength())).set(3, (Number)Float.valueOf(shootStructure2.getHeartwoodDiameter())).set(4, (Number)shootStructure2.getColor()).set(5, (Number)countDaughters).set(6, (Number)Float.valueOf(f)).set(7, (Number)Float.valueOf(f2));
        }
        return dataset;
    }

    private static void fuse(ShootStructure shootStructure) {
        if (shootStructure != null) {
            ShootStructure shootStructure2 = shootStructure;
            while (shootStructure2 != null) {
                ShootStructure shootStructure3 = shootStructure2.getMother();
                ShootStructure shootStructure4 = shootStructure2.getSuccessor();
                if (shootStructure3 != null && shootStructure2.getOrder() == shootStructure3.getOrder() && shootStructure2.getOrder() >= 0) {
                    Analysis.fusion(shootStructure3, shootStructure2, shootStructure);
                }
                shootStructure2 = shootStructure4;
            }
        }
    }

    private static void split(ShootStructure shootStructure, ShootStructure shootStructure2) {
        ShootStructure shootStructure3 = null;
        ShootStructure shootStructure4 = null;
        ShootStructure shootStructure5 = null;
        ShootStructure shootStructure6 = null;
        ShootStructure shootStructure7 = null;
        ShootStructure shootStructure8 = null;
        ShootStructure[] shootStructureArray = new ShootStructure[500];
        float[] fArray = new float[500];
        float[] fArray2 = new float[500];
        Vector3d vector3d = new Vector3d();
        boolean bl = false;
        shootStructure3 = shootStructure.getSuccessor();
        if (shootStructure == null || shootStructure2 == null || shootStructure.getLength() < 1.0E-9f) {
            System.out.println("Exceptional situation in aufspalte (null or l.<epsilon)");
            shootStructure = shootStructure3;
            bl = true;
        } else if (shootStructure == shootStructure2) {
            shootStructure7 = null;
            shootStructure6 = null;
        } else {
            shootStructure7 = shootStructure2;
            shootStructure8 = shootStructure7.getSuccessor();
            while (shootStructure8 != null && shootStructure8 != shootStructure) {
                shootStructure7 = shootStructure8;
                shootStructure8 = shootStructure7.getSuccessor();
            }
            shootStructure6 = shootStructure.getMother();
        }
        if (!bl) {
            Analysis.createArraysForSplit(shootStructure, shootStructure2, 0, fArray, fArray2, shootStructureArray);
            shootStructure5 = shootStructure7;
            for (int i = 1; i <= countDaughters + 1; ++i) {
                int n;
                if (!(fArray[i] > fArray[i - 1] + 1.0E-9f) && (i != countDaughters + 1 || !(fArray[i] <= fArray[0] + 1.0E-9f))) continue;
                shootStructure4 = new ShootStructure();
                shootStructure4.setMother(shootStructure6);
                shootStructure4.setLength(fArray[i] - fArray[i - 1]);
                shootStructure4.setDiameter(shootStructure.getDiameter());
                shootStructure4.setHeartwoodDiameter(shootStructure.getHeartwoodDiameter());
                if (shootStructure.getLength() > 1.0E-9f) {
                    shootStructure4.setN(shootStructure4.getLength() * shootStructure.getN() / shootStructure.getLength());
                } else {
                    shootStructure4.setN(shootStructure.getN());
                }
                shootStructure4.setInternodeCount(0);
                if (shootStructure.getN() > 1.0E-9f) {
                    shootStructure4.setInternodeCount(Analysis.integ(shootStructure4.getN() / shootStructure.getN() * (float)shootStructure.getInternodeCount()));
                }
                shootStructure4.setColor(shootStructure.getColor());
                shootStructure4.setOrder(shootStructure.getOrder());
                shootStructure4.setGenerativeDistance(shootStructure.getGenerativeDistance());
                shootStructure4.setScale(0);
                shootStructure4.setQ(0.0f);
                vector3d.scale((double)fArray[i - 1], (Tuple3d)shootStructure.getSh());
                shootStructure4.getBeginOfShoot().add((Tuple3d)shootStructure.getBeginOfShoot(), (Tuple3d)vector3d);
                vector3d.scale((double)fArray[i], (Tuple3d)shootStructure.getSh());
                shootStructure4.getEndOfShoot().add((Tuple3d)shootStructure.getBeginOfShoot(), (Tuple3d)vector3d);
                shootStructure4.setSh(shootStructure.getSh());
                shootStructure4.setSl(shootStructure.getSl());
                shootStructure4.setSu(shootStructure.getSu());
                shootStructure4.setSuccessor(null);
                shootStructure4.setXka(0.0f);
                shootStructure4.setYka(0.0f);
                shootStructure4.setXke(0.0f);
                shootStructure4.setYke(0.0f);
                shootStructure4.setForwardChain(shootStructure.getForwardChain());
                if (shootStructure5 == null) {
                    shootStructure2 = shootStructure4;
                    shootStructure4.setId(1L);
                } else {
                    shootStructure5.setSuccessor(shootStructure4);
                    shootStructure4.setId(shootStructure5.getId() + 1L);
                }
                for (n = i - 1; fArray[n] == fArray[i - 1] && n > 0; --n) {
                    shootStructureArray[n].setMother(shootStructure6);
                    shootStructureArray[n].setQ(0.0f);
                }
                shootStructure5 = shootStructure4;
                shootStructure6 = shootStructure4;
                if (!(fArray[i] > shootStructure.getLength() - 1.0E-9f)) continue;
                for (n = i; n <= countDaughters; ++n) {
                    shootStructureArray[n].setMother(shootStructure4);
                    shootStructureArray[n].setQ(0.0f);
                }
                shootStructure4.setSuccessor(shootStructure3);
            }
            shootStructure = null;
            shootStructure = shootStructure3;
        }
    }

    private static void createArraysForSplit(ShootStructure shootStructure, ShootStructure shootStructure2, int n, float[] fArray, float[] fArray2, ShootStructure[] shootStructureArray) {
        int n2;
        float[] fArray3 = new float[500];
        ShootStructure shootStructure3 = null;
        if (shootStructure == null) {
            System.out.println("Exceptional situation in erztarray (null).");
            return;
        }
        countDaughters = 0;
        for (n2 = 0; n2 < 500; ++n2) {
            fArray2[n2] = 0.0f;
            fArray[n2] = 0.0f;
            if (n >= 2) continue;
            shootStructureArray[n2] = null;
            fArray3[n2] = 1.0f;
        }
        ShootStructure shootStructure4 = shootStructure2;
        while (shootStructure4 != null) {
            if (shootStructure4.getMother() == shootStructure && (n == 0 || shootStructure4.getOrder() != shootStructure.getOrder())) {
                if (countDaughters < 498) {
                    ++countDaughters;
                } else {
                    System.out.println("Overflow in erztarray (too many daughters)!");
                }
                if (n < 2) {
                    shootStructureArray[Analysis.countDaughters] = shootStructure4;
                }
                fArray2[Analysis.countDaughters] = (1.0f - shootStructure4.getQ()) * shootStructure.getLength();
                shootStructure4 = shootStructure4.getSuccessor();
            }
            for (n2 = 2; n2 <= countDaughters; ++n2) {
                int n3;
                float f = fArray2[n2];
                if (n < 2) {
                    shootStructure3 = shootStructureArray[n2];
                }
                for (n3 = 1; fArray2[n3] <= f && n3 < n2; ++n3) {
                }
                if (n3 >= n2) continue;
                for (int i = n2; i > n3; --i) {
                    fArray2[i] = fArray2[i - 1];
                    if (n >= 2) continue;
                    shootStructureArray[i] = shootStructureArray[i - 1];
                }
                fArray2[n3] = f;
                if (n >= 2) continue;
                shootStructureArray[n3] = shootStructure3;
            }
            fArray2[Analysis.countDaughters + 1] = shootStructure.getLength();
            if (n < 2) {
                for (n2 = 0; n2 <= countDaughters + 1; ++n2) {
                    fArray3[n2] = Analysis.localMinimalDistanceGROGRA(shootStructure, (fArray2[n2] + fArray2[n2 + 1]) / 2.0f);
                }
                for (n2 = 0; n2 < 500; ++n2) {
                    fArray[n2] = fArray2[n2];
                }
                continue;
            }
            for (n2 = 1; n2 <= countDaughters + 1; ++n2) {
                fArray[n2] = fArray2[n2] - fArray2[n2 - 1];
            }
        }
    }

    private static float localMinimalDistanceGROGRA(ShootStructure shootStructure, float f) {
        float f2 = 0.0f;
        if (f2 < 1.0f) {
            f2 = 1.0f;
        }
        if (shootStructure.getInternodeCount() < 0) {
            f2 = 0.0f;
        }
        if (f2 > 1.0E9f) {
            System.out.println("Very large effective crit. distance found for axis nb. " + shootStructure.getId() + " (eff. CD: " + f2 + ")");
            System.out.println("   cannot be used in dissection. Maintaining former length.");
            f2 = shootStructure.getLength() - 1.0E-9f;
        }
        return f2;
    }

    private static void fusaxes(ShootStructure shootStructure) {
        ShootStructure shootStructure2;
        ShootStructure shootStructure3;
        if (shootStructure == null) {
            System.out.println("WARNING: Exceptional situation in fusaxes (NULL).");
            return;
        }
        for (shootStructure3 = shootStructure; shootStructure3 != null; shootStructure3 = shootStructure3.getSuccessor()) {
            shootStructure3.setYke(1.0f);
            shootStructure3.setGenerativeDistance(0L);
        }
        for (shootStructure3 = shootStructure; shootStructure3 != null; shootStructure3 = shootStructure3.getSuccessor()) {
            shootStructure2 = shootStructure3.getMother();
            if (shootStructure2 == null || shootStructure3.getOrder() != shootStructure2.getOrder()) continue;
            shootStructure2.setYke(0.0f);
        }
        ShootStructure shootStructure4 = shootStructure;
        while (shootStructure4 != null) {
            if (shootStructure4.getOrder() >= 0 && (double)shootStructure4.getYke() > 0.5) {
                shootStructure3 = shootStructure4.getMother();
                if (shootStructure3 != null) {
                    ShootStructure shootStructure5 = shootStructure3.getForwardChain();
                    if (shootStructure5 != null) {
                        if (shootStructure5.getForwardChain() == shootStructure4.getForwardChain() && shootStructure3.getInternodeCount() >= 0 && shootStructure4.getInternodeCount() >= 0) {
                            Analysis.fusion(shootStructure3, shootStructure4, shootStructure);
                            shootStructure4 = shootStructure3;
                            shootStructure4.setYke(1.0f);
                            continue;
                        }
                        shootStructure4 = shootStructure4.getSuccessor();
                        continue;
                    }
                    shootStructure4 = shootStructure4.getSuccessor();
                    continue;
                }
                shootStructure4 = shootStructure4.getSuccessor();
                continue;
            }
            shootStructure4 = shootStructure4.getSuccessor();
        }
        for (shootStructure3 = shootStructure; shootStructure3 != null; shootStructure3 = shootStructure3.getSuccessor()) {
            shootStructure2 = shootStructure3.getMother();
            if (shootStructure2 == null) continue;
            shootStructure2.setGenerativeDistance(1L);
        }
    }

    private static void fusion(ShootStructure shootStructure, ShootStructure shootStructure2, ShootStructure shootStructure3) {
        Vector3d vector3d = new Vector3d();
        if (shootStructure == null || shootStructure2 == null) {
            System.out.println("Error: NULL occurred in function  f u s i o n");
            return;
        }
        if (shootStructure.getInternodeCount() < 0 || shootStructure2.getInternodeCount() < 0) {
            System.out.println("Warning: suspicious fusion (izahl < 0)!");
        }
        float f = shootStructure.getLength();
        float f2 = shootStructure2.getLength();
        float f3 = f + f2;
        shootStructure.setLength(f3);
        shootStructure.setDiameter(shootStructure2.getDiameter());
        shootStructure.setN(shootStructure.getN() + shootStructure2.getN());
        shootStructure.setInternodeCount(shootStructure.getInternodeCount() + shootStructure2.getInternodeCount());
        vector3d.scale((double)f3, (Tuple3d)shootStructure.getSh());
        vector3d.add((Tuple3d)shootStructure.getBeginOfShoot());
        shootStructure.setEndOfShoot((Vector3d)vector3d.clone());
        ShootStructure shootStructure4 = null;
        for (ShootStructure shootStructure5 = shootStructure3; shootStructure5 != null; shootStructure5 = shootStructure5.getSuccessor()) {
            if (shootStructure5.getMother() == shootStructure && shootStructure5 != shootStructure2) {
                if (f3 > 1.0E-9f) {
                    shootStructure5.setQ(1.0f - f / f3 * (1.0f - shootStructure5.getQ()));
                } else {
                    shootStructure5.setQ(1.0f);
                }
            }
            if (shootStructure5.getMother() == shootStructure2) {
                if (f3 > 1.0E-9f) {
                    shootStructure5.setQ(1.0f - (f / f3 + (1.0f - shootStructure5.getQ()) * (f2 / f3)));
                } else {
                    shootStructure5.setQ(0.0f);
                }
                shootStructure5.setOrder(shootStructure.getOrder() + shootStructure5.getOrder() - shootStructure2.getOrder());
                Vector3d vector3d2 = (Vector3d)shootStructure.getSh().clone();
                vector3d2.sub((Tuple3d)shootStructure2.getSh());
                if (vector3d2.length() >= (double)1.0E-5f) {
                    vector3d.scale((double)f3, (Tuple3d)shootStructure.getSh());
                    vector3d.scale(1.0 - (double)shootStructure5.getQ());
                    vector3d.add((Tuple3d)shootStructure.getBeginOfShoot());
                    vector3d.sub((Tuple3d)shootStructure5.getBeginOfShoot());
                    Analysis.relocate(shootStructure5, vector3d, shootStructure3);
                }
                shootStructure5.setMother(shootStructure);
            }
            if (shootStructure5.getSuccessor() != shootStructure2) continue;
            shootStructure4 = shootStructure5;
        }
        if (shootStructure4 != null) {
            shootStructure4.setSuccessor(shootStructure2.getSuccessor());
        }
        shootStructure2 = null;
    }

    private static void relocate(ShootStructure shootStructure, Vector3d vector3d, ShootStructure shootStructure2) {
        if (shootStructure == null) {
            System.out.println("Exceptional situation in verschiebe (NULL).");
            return;
        }
        for (ShootStructure shootStructure3 = shootStructure2; shootStructure3 != null; shootStructure3 = shootStructure3.getSuccessor()) {
            boolean bl = false;
            for (ShootStructure shootStructure4 = shootStructure3; shootStructure4 != null && !bl; shootStructure4 = shootStructure4.getMother()) {
                if (shootStructure4 != shootStructure) continue;
                bl = true;
            }
            if (!bl) continue;
            shootStructure3.getBeginOfShoot().add((Tuple3d)vector3d);
            shootStructure3.getEndOfShoot().add((Tuple3d)vector3d);
        }
    }

    private static int fillRow(Dataseries dataseries, int[][] nArray, int n, int n2, int n3) {
        if (n2 < n3) {
            dataseries.set(n++, (Number)n2);
            dataseries.set(n++, (Number)Analysis.sumArray(nArray, n2));
            for (int i = 0; i < 5; ++i) {
                dataseries.set(n++, (Number)nArray[i][n2]);
            }
        } else {
            dataseries.set(n++, (Number)-1);
            dataseries.set(n++, (Number)-1);
            for (int i = 0; i < 5; ++i) {
                dataseries.set(n++, (Number)-1);
            }
        }
        return n;
    }

    private static int lastEntryInArray(int[][] nArray) {
        int n;
        for (n = nArray.length - 1; n > -1; --n) {
            for (int n2 : nArray[n]) {
                if (n2 == 0) continue;
                return n + 1;
            }
        }
        return n;
    }

    private static int sumArray(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return n;
    }

    private static int sumArray(int[][] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            n2 += nArray[i][n];
        }
        return n2;
    }

    private static Shoot cousine(Shoot shoot, Node node, HashMap<Long, Float> hashMap) {
        Shoot shoot2;
        if (shoot == null || node == null) {
            System.out.println("Warning: NULL in method COUSINE!");
            return null;
        }
        TreeIterator treeIterator = new TreeIterator(node);
        int n = 0;
        Shoot shoot3 = shoot;
        while (shoot3 != null && Analysis.integ(hashMap.get(shoot3.getId()).floatValue()) == 0) {
            shoot3 = Analysis.getAssociatedMotherShoot((Node)shoot3);
            ++n;
        }
        if (shoot3 == null) {
            return null;
        }
        int n2 = Analysis.integ(hashMap.get(shoot3.getId()).floatValue());
        if ((shoot3 = Analysis.getAssociatedMotherShoot((Node)shoot3)) == null) {
            return null;
        }
        if (Analysis.integ(hashMap.get(shoot3.getId()).floatValue()) != 0 || Analysis.getAssociatedMotherShoot((Node)shoot3) == null) {
            return null;
        }
        Shoot shoot4 = Analysis.getAssociatedMotherShoot((Node)shoot3);
        ++n;
        Shoot shoot5 = null;
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null && shoot5 == null) {
            int n3;
            shoot3 = shoot2;
            for (n3 = 0; shoot3 != null && Analysis.integ(hashMap.get(shoot3.getId()).floatValue()) == 0 && n3 < n; ++n3) {
                shoot3 = Analysis.getAssociatedMotherShoot((Node)shoot3);
            }
            if (shoot3 == null || n3 != n || Analysis.integ(hashMap.get(shoot3.getId()).floatValue()) != n2 || Analysis.getAssociatedMotherShoot((Node)shoot3) != shoot4) continue;
            shoot5 = shoot2;
        }
        return shoot5;
    }

    private static void labelDaughters(Node node, HashMap<Long, Float> hashMap, HashMap<Long, Float> hashMap2, float f, Shoot[] shootArray, float[] fArray, float[] fArray2, float[] fArray3) {
        Shoot shoot;
        float f2 = f;
        float f3 = 1.0E9f;
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            hashMap.put(shoot.getId(), Float.valueOf(0.0f));
        }
        treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            int n;
            Analysis.createArraysForLabeling(shoot, node, 1, false, 0.0f, f2, f3, shootArray, fArray, fArray2, fArray3, hashMap);
            while (Analysis.modifeinschr(0, fArray2, fArray3)) {
            }
            if (countDaughters > 0) {
                float f4 = fArray2[countDaughters];
                n = 1;
                for (int i = countDaughters; i > 0; --i) {
                    float f5 = fArray2[i];
                    if (f5 < f4 - 1.0E-9f) {
                        ++n;
                    }
                    if (graphState.getInt((Object)shoot, true, Attributes.ORDER) >= 0) {
                        hashMap.put(shootArray[i].getId(), Float.valueOf(n));
                    } else {
                        hashMap.put(shootArray[i].getId(), Float.valueOf(0.0f));
                    }
                    f4 = f5;
                }
            } else {
                n = 0;
            }
            hashMap2.put(shoot.getId(), Float.valueOf(n));
        }
    }

    private static boolean modifeinschr(int n, float[] fArray, float[] fArray2) {
        boolean bl;
        int n2;
        int n3;
        if (countDaughters == 0) {
            return false;
        }
        switch (n) {
            case 2: {
                n3 = 0;
                n2 = countDaughters;
                break;
            }
            case 1: {
                n3 = 1;
                n2 = countDaughters;
                break;
            }
            default: {
                n3 = 1;
                n2 = countDaughters - 1;
            }
        }
        float f = fArray[countDaughters + 1];
        float f2 = 100000.0f;
        int n4 = 0;
        for (int i = n2; i >= n3; --i) {
            float f3 = fArray[i + 1] - fArray[i];
            if (!(f3 > 1.0E-9f) || !(f3 / fArray2[i] < f2)) continue;
            f2 = f3 / fArray2[i];
            n4 = i;
        }
        if ((double)f2 < 1.0 && f > 1.0E-9f) {
            int n5;
            bl = true;
            float f4 = fArray[n4];
            float f5 = fArray[n4 + 1];
            float f6 = (f4 + f5) / 2.0f;
            if (n == 2 && f4 < 1.0E-9f) {
                f6 = 0.0f;
            }
            if (n > 0 && f5 > f - 1.0E-9f) {
                f6 = f;
            }
            if (n == 2 && f4 < 1.0E-9f && f5 > f - 1.0E-9f) {
                return false;
            }
            for (n5 = n4; n5 >= n3 && fArray[n5] > f4 - 1.0E-9f; --n5) {
                fArray[n5] = f6;
            }
            for (n5 = n4 + 1; n5 <= n2 + 1 && fArray[n5] < f5 + 1.0E-9f; ++n5) {
                if (f6 < 1.0E-9f && n5 == countDaughters + 1) {
                    bl = false;
                    continue;
                }
                fArray[n5] = f6;
            }
        } else {
            return false;
        }
        return bl;
    }

    private static void createArraysForLabeling(Shoot shoot, Node node, int n, boolean bl, float f, float f2, float f3, Shoot[] shootArray, float[] fArray, float[] fArray2, float[] fArray3, HashMap<Long, Float> hashMap) {
        int n2;
        Shoot shoot2;
        if (shoot == null) {
            System.out.println("Given shoot s in createArraysForLabeling is null!");
            return;
        }
        countDaughters = 0;
        if (n < 2) {
            for (int i = 0; i < 500; ++i) {
                fArray3[i] = f2;
            }
        }
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        Shoot shoot3 = null;
        float f4 = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null) {
            if (Analysis.getAssociatedMotherShoot((Node)shoot2) != shoot || n != 0 && graphState.getInt((Object)shoot2, true, Attributes.ORDER) == graphState.getInt((Object)shoot, true, Attributes.ORDER)) continue;
            if (countDaughters < 498) {
                ++countDaughters;
            } else {
                System.out.println("To many daughters in createArraysForLabeling");
            }
            if (n < 2) {
                shootArray[Analysis.countDaughters] = shoot2;
            }
            fArray[Analysis.countDaughters] = (1.0f - (graphState.getFloat((Object)shoot2, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot2, true, Attributes.REL_POSITION))) * f4;
        }
        for (n2 = 2; n2 <= countDaughters; ++n2) {
            int n3;
            float f5 = fArray[n2];
            if (n < 2) {
                shoot3 = shootArray[n2];
            }
            for (n3 = 1; fArray[n3] <= f5 && n3 < n2; ++n3) {
            }
            if (n3 >= n2) continue;
            for (int i = n2; i > n3; --i) {
                fArray[i] = fArray[i - 1];
                if (n >= 2) continue;
                shootArray[i] = shootArray[i - 1];
            }
            fArray[n3] = f5;
            if (n >= 2) continue;
            shootArray[n3] = shoot3;
        }
        fArray[Analysis.countDaughters + 1] = f4;
        if (n < 2) {
            for (n2 = 0; n2 <= countDaughters + 1; ++n2) {
                fArray3[n2] = Analysis.localMinimalDistance(shoot, (fArray[n2] + fArray[n2 + 1]) / 2.0f, bl, f, graphState, f2, f3, hashMap);
            }
            for (n2 = 0; n2 < 500; ++n2) {
                fArray2[n2] = fArray[n2];
            }
        } else {
            for (n2 = 1; n2 <= countDaughters + 1; ++n2) {
                fArray2[n2] = fArray[n2] - fArray[n2 - 1];
            }
        }
    }

    private static float localMinimalDistance(Shoot shoot, float f, boolean bl, float f2, GraphState graphState, float f3, float f4, HashMap<Long, Float> hashMap) {
        float f5;
        float[] fArray = new float[]{0.0f, 0.0f};
        Shoot shoot2 = null;
        if (bl) {
            Analysis.durna(shoot, f, fArray, shoot2, graphState);
            if (shoot2 == null) {
                System.out.println("Warning: NULL occurred in localMinimalDistance");
                f5 = 0.0f;
            } else {
                f5 = f2 * hashMap.get(shoot.getId()).floatValue() * 1000.0f;
            }
        } else {
            f5 = 0.0f;
        }
        if (f5 < f3) {
            f5 = f3;
        }
        if (graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT) < 0) {
            f5 = 0.0f;
        }
        if (f5 > f4) {
            System.out.println("Very large crit. distance found for axis nb. " + shoot.getId() + " cannot be used in dissection. Maintaining former length.");
            f5 = (float)(graphState.getDouble((Object)shoot, true, Attributes.LENGTH) - (double)1.0E-9f);
        }
        return f5;
    }

    private static void durna(Shoot shoot, float f, float[] fArray, Shoot shoot2, GraphState graphState) {
        float f2;
        Shoot shoot3 = Analysis.getAssociatedMotherShoot((Node)shoot);
        Shoot shoot4 = null;
        float f3 = (float)graphState.getDouble((Object)shoot3, true, Attributes.LENGTH);
        for (f2 = f; shoot3 != null && f2 > f3; f2 -= f3) {
            shoot4 = shoot3;
            if ((shoot3 = Analysis.getForwardChaining((Node)shoot3)) == null) continue;
            f3 = (float)graphState.getDouble((Object)shoot3, true, Attributes.LENGTH);
        }
        if (shoot3 == null) {
            if (shoot4 == null) {
                shoot2 = Analysis.getForwardChaining((Node)shoot);
                fArray[0] = graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f;
                fArray[1] = (float)((double)graphState.getFloat((Object)shoot, true, Attributes.PARAMETER) / (graphState.getDouble((Object)shoot, true, Attributes.LENGTH) + (double)1.0E-9f));
            } else {
                shoot2 = shoot4;
                fArray[0] = graphState.getFloat((Object)shoot4, true, Attributes.RADIUS) * 2.0f;
                float f4 = (float)graphState.getDouble((Object)shoot4, true, Attributes.LENGTH);
                fArray[1] = f4 < 1.0E-9f ? 0.0f : graphState.getFloat((Object)shoot4, true, Attributes.PARAMETER) / f4;
            }
        } else {
            shoot2 = shoot3;
            float f5 = graphState.getFloat((Object)shoot3, true, Attributes.HEARTWOOD);
            if (f3 < 1.0E-9f) {
                fArray[0] = f5;
                fArray[1] = 0.0f;
            } else {
                fArray[0] = f5 + f2 / f3 * (graphState.getFloat((Object)shoot3, true, Attributes.RADIUS) * 2.0f - f5);
                fArray[1] = graphState.getFloat((Object)shoot3, true, Attributes.PARAMETER) / f3;
            }
        }
    }

    private static Shoot bigBrother(Shoot shoot, Node node, boolean bl, HashMap<Long, Float> hashMap) {
        Shoot shoot2;
        if (shoot == null || node == null) {
            return null;
        }
        if (!bl && Analysis.integ(hashMap.get(shoot.getId()).floatValue()) == 0) {
            return shoot;
        }
        Shoot shoot3 = null;
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null && shoot3 == null) {
            if (Analysis.getAssociatedMotherShoot((Node)shoot2) != Analysis.getAssociatedMotherShoot((Node)shoot) || !bl && Analysis.integ(hashMap.get(shoot2.getId()).floatValue()) != 0) continue;
            shoot3 = shoot2;
        }
        return shoot3;
    }

    private static void outerbox(Node node, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5) {
        Shoot shoot;
        Vector3d vector3d6 = new Vector3d();
        Vector3d vector3d7 = new Vector3d();
        Vector3d vector3d8 = new Vector3d();
        Vector3d vector3d9 = new Vector3d();
        if (node == null) {
            return;
        }
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        boolean bl = true;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            Math2.getBeginOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (Vector3d)vector3d9);
            Math2.onbco((Vector3d)vector3d8, (Vector3d)vector3d9, (Vector3d)vector3d, (Vector3d)vector3d2, (Vector3d)vector3d3);
            Math2.getEndOfShoot((Matrix4d)LSystem.transformation((Node)shoot), (double)graphState.getDouble((Object)shoot, true, Attributes.LENGTH), (Vector3d)vector3d9);
            if (bl) {
                vector3d6.x = vector3d7.x = vector3d8.x;
                vector3d6.y = vector3d7.y = vector3d8.y;
                vector3d6.z = vector3d7.z = vector3d8.z;
                bl = false;
                Math2.onbco((Vector3d)vector3d8, (Vector3d)vector3d9, (Vector3d)vector3d, (Vector3d)vector3d2, (Vector3d)vector3d3);
                if (vector3d8.x < vector3d6.x) {
                    vector3d6.x = vector3d8.x;
                }
                if (vector3d8.y < vector3d6.y) {
                    vector3d6.y = vector3d8.y;
                }
                if (vector3d8.z < vector3d6.z) {
                    vector3d6.z = vector3d8.z;
                }
                if (vector3d8.x > vector3d7.x) {
                    vector3d7.x = vector3d8.x;
                }
                if (vector3d8.y > vector3d7.y) {
                    vector3d7.y = vector3d8.y;
                }
                if (!(vector3d8.z > vector3d7.z)) continue;
                vector3d7.z = vector3d8.z;
                continue;
            }
            if (vector3d8.x < vector3d6.x) {
                vector3d6.x = vector3d8.x;
            }
            if (vector3d8.y < vector3d6.y) {
                vector3d6.y = vector3d8.y;
            }
            if (vector3d8.z < vector3d6.z) {
                vector3d6.z = vector3d8.z;
            }
            if (vector3d8.x > vector3d7.x) {
                vector3d7.x = vector3d8.x;
            }
            if (vector3d8.y > vector3d7.y) {
                vector3d7.y = vector3d8.y;
            }
            if (vector3d8.z > vector3d7.z) {
                vector3d7.z = vector3d8.z;
            }
            Math2.onbco((Vector3d)vector3d8, (Vector3d)vector3d9, (Vector3d)vector3d, (Vector3d)vector3d2, (Vector3d)vector3d3);
            if (vector3d8.x < vector3d6.x) {
                vector3d6.x = vector3d8.x;
            }
            if (vector3d8.y < vector3d6.y) {
                vector3d6.y = vector3d8.y;
            }
            if (vector3d8.z < vector3d6.z) {
                vector3d6.z = vector3d8.z;
            }
            if (vector3d8.x > vector3d7.x) {
                vector3d7.x = vector3d8.x;
            }
            if (vector3d8.y > vector3d7.y) {
                vector3d7.y = vector3d8.y;
            }
            if (!(vector3d8.z > vector3d7.z)) continue;
            vector3d7.z = vector3d8.z;
        }
        vector3d5 = (Vector3d)vector3d7.clone();
        vector3d5.sub((Tuple3d)vector3d6);
        vector3d9 = (Vector3d)vector3d.clone();
        vector3d9.scale(vector3d6.x);
        vector3d8 = (Vector3d)vector3d2.clone();
        vector3d8.scale(vector3d6.y);
        vector3d9.add((Tuple3d)vector3d8);
        vector3d8 = (Vector3d)vector3d3.clone();
        vector3d8.scale(vector3d6.z);
        vector3d9.add((Tuple3d)vector3d8);
        vector3d4 = vector3d9;
    }

    private static int integ(float f) {
        if (f > 2.1474836E9f) {
            return Integer.MAX_VALUE;
        }
        if (f < -2.1474836E9f) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor(f + 1.0E-9f);
    }

    private static int findGenerationMax(Node node) {
        Shoot shoot;
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        int n = 0;
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            int n2 = graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE);
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static boolean terminalShoot(Shoot shoot, Node node) {
        Shoot shoot2;
        boolean bl = true;
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        while ((shoot2 = LSystem.nextShoot(treeIterator)) != null && bl) {
            if (Analysis.getAssociatedMotherShoot((Node)shoot2) != shoot) continue;
            float f = graphState.getFloat((Object)shoot2, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot2, true, Attributes.REL_POSITION);
            if (!(f < 1.0E-9f)) continue;
            bl = false;
        }
        return bl;
    }

    private static Shoot getForwardChaining(Node node) {
        while ((node = node.findAdjacent(false, true, 256)) != null && !(node instanceof Shoot)) {
        }
        return (Shoot)node;
    }

    private static Shoot getAssociatedMotherShoot(Node node) {
        while ((node = node.findAdjacent(true, false, 768)) != null && !(node instanceof Shoot)) {
        }
        return (Shoot)node;
    }

    private static ShootStructure createGROGRAShootStructure(Node node) {
        Object object;
        Shoot shoot;
        GraphState graphState = node.getCurrentGraphState();
        TreeIterator treeIterator = new TreeIterator(node);
        ShootStructure shootStructure = null;
        ShootStructure shootStructure2 = null;
        ShootStructure shootStructure3 = null;
        HashMap<Long, ShootStructure> hashMap = new HashMap<Long, ShootStructure>();
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            shootStructure3 = shootStructure2;
            shootStructure2 = new ShootStructure();
            if (shootStructure == null) {
                shootStructure = shootStructure2;
            }
            object = new Vector3d();
            Vector3d vector3d = new Vector3d();
            float f = (float)graphState.getDouble((Object)shoot, true, Attributes.LENGTH);
            Matrix4d matrix4d = LSystem.transformation((Node)shoot);
            Math2.getBeginAndEndOfShoot((Matrix4d)matrix4d, (double)f, (Vector3d)object, (Vector3d)vector3d);
            hashMap.put(shoot.getId(), shootStructure2);
            shootStructure2.setBeginOfShoot((Vector3d)object);
            shootStructure2.setColor(graphState.getInt((Object)shoot, true, Attributes.DTG_COLOR));
            shootStructure2.setDiameter(graphState.getFloat((Object)shoot, true, Attributes.RADIUS) * 2.0f);
            shootStructure2.setEndOfShoot(vector3d);
            shootStructure2.setGenerativeDistance(graphState.getInt((Object)shoot, true, Attributes.GENERATIVE_DISTANCE));
            shootStructure2.setHeartwoodDiameter(graphState.getFloat((Object)shoot, true, Attributes.HEARTWOOD));
            shootStructure2.setId(shoot.getId());
            shootStructure2.setInternodeCount(graphState.getInt((Object)shoot, true, Attributes.INTERNODE_COUNT));
            shootStructure2.setLength(f);
            shootStructure2.setMother(shootStructure3);
            shootStructure2.setN(graphState.getFloat((Object)shoot, true, Attributes.PARAMETER));
            shootStructure2.setOrder(graphState.getInt((Object)shoot, true, Attributes.ORDER));
            shootStructure2.setQ(graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION) == 0.0f ? 0.0f : 1.0f - graphState.getFloat((Object)shoot, true, Attributes.REL_POSITION));
            shootStructure2.setScale(graphState.getInt((Object)shoot, true, Attributes.LOCAL_SCALE));
            shootStructure2.setSh(new Vector3d(matrix4d.m02, matrix4d.m12, matrix4d.m22));
            shootStructure2.setSl(new Vector3d(matrix4d.m00, matrix4d.m10, matrix4d.m20));
            shootStructure2.setSu(new Vector3d(matrix4d.m01, matrix4d.m11, matrix4d.m21));
            if (shootStructure3 != null) {
                shootStructure3.setSuccessor(shootStructure2);
            }
            shootStructure2.setXka(0.0f);
            shootStructure2.setYka(0.0f);
            shootStructure2.setXke(0.0f);
            shootStructure2.setYke(0.0f);
        }
        shootStructure2.setSuccessor(null);
        treeIterator = new TreeIterator(node);
        while ((shoot = LSystem.nextShoot(treeIterator)) != null) {
            shootStructure2 = (ShootStructure)hashMap.get(shoot.getId());
            object = Analysis.getForwardChaining((Node)shoot);
            if (object != null) {
                shootStructure2.setForwardChain((ShootStructure)hashMap.get(object.getId()));
                continue;
            }
            shootStructure2.setForwardChain(null);
        }
        return shootStructure;
    }
}

