/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.GRSVertex;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.Transaction;
import de.grogra.rgg.model.PropertyQueue;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.xl.impl.base.GraphQueue;
import de.grogra.xl.impl.queues.Queue;
import de.grogra.xl.impl.queues.QueueCollection;
import de.grogra.xl.impl.queues.QueueDescriptor;
import de.grogra.xl.query.RuntimeModelException;
import de.grogra.xl.util.ByteList;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongList;
import de.grogra.xl.util.ObjectList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VVQueue
implements Queue {
    private static final byte END = 0;
    private static final byte INSERT_BEFORE = 1;
    private static final byte INSERT_AFTER = 2;
    private static final byte MAKE_FOLLOWER = 3;
    private static final byte REMOVE = 4;
    private static final byte REPLACE = 5;
    private static final byte SET_NEIGHBORS = 6;
    private static final byte ADD_NEIGHBOR = 7;
    private static final byte SPLIT_EDGE = 8;
    private PropertyQueue makePersistentQueue;
    private final ByteList actions = new ByteList();
    private final LongList vertices = new LongList();
    private final IntList segments = new IntList();
    public static final QueueDescriptor<VVQueue> DESCRIPTOR = new Descriptor();
    private final RGGGraph rggGraph;
    private final GraphManager graph;
    private int actionIndex;
    private int vertexIndex;
    private final int[] index = new int[1];
    private Transaction xa;
    private ObjectList<GRSVertex> newVertices;
    private static final PersistenceField NEIGHBOR = GRSVertex.neighbors$FIELD.getArrayChain(1);

    VVQueue(QueueCollection queueCollection, PropertyQueue propertyQueue) {
        this.rggGraph = (RGGGraph)queueCollection.getGraph();
        this.graph = this.rggGraph.manager;
        this.makePersistentQueue = propertyQueue;
    }

    public QueueDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    private void addVertex(GRSVertex gRSVertex) {
        if (gRSVertex.getId() < 0L) {
            this.makePersistentQueue.makePersistent((Node)gRSVertex);
        }
        this.vertices.add(gRSVertex.getId());
    }

    public void insertBefore(GRSVertex gRSVertex, GRSVertex gRSVertex2, GRSVertex gRSVertex3) {
        this.actions.add((byte)1);
        this.addVertex(gRSVertex);
        this.addVertex(gRSVertex2);
        this.addVertex(gRSVertex3);
    }

    public void insertAfter(GRSVertex gRSVertex, GRSVertex gRSVertex2, GRSVertex gRSVertex3) {
        this.actions.add((byte)2);
        this.addVertex(gRSVertex);
        this.addVertex(gRSVertex2);
        this.addVertex(gRSVertex3);
    }

    public void makeFollower(GRSVertex gRSVertex, GRSVertex gRSVertex2, GRSVertex gRSVertex3) {
        this.actions.add((byte)3);
        this.addVertex(gRSVertex);
        this.addVertex(gRSVertex2);
        this.addVertex(gRSVertex3);
    }

    public void remove(GRSVertex gRSVertex, GRSVertex gRSVertex2) {
        this.actions.add((byte)4);
        this.addVertex(gRSVertex);
        this.addVertex(gRSVertex2);
    }

    public void replace(GRSVertex gRSVertex, GRSVertex gRSVertex2, GRSVertex gRSVertex3) {
        this.actions.add((byte)5);
        this.addVertex(gRSVertex);
        this.addVertex(gRSVertex2);
        this.addVertex(gRSVertex3);
    }

    public VVQueue setNeighbors(GRSVertex gRSVertex) {
        this.actions.add((byte)6);
        this.addVertex(gRSVertex);
        return this;
    }

    public void addNeighbor(GRSVertex gRSVertex) {
        this.actions.add((byte)7);
        this.addVertex(gRSVertex);
    }

    public VVQueue operator$shl(GRSVertex gRSVertex) {
        this.addNeighbor(gRSVertex);
        return this;
    }

    public void splitEdge(GRSVertex gRSVertex, GRSVertex gRSVertex2, GRSVertex gRSVertex3) {
        this.actions.add((byte)8);
        this.addVertex(gRSVertex);
        this.addVertex(gRSVertex2);
        this.addVertex(gRSVertex3);
    }

    private byte nextAction() {
        if (this.actionIndex < this.actions.size()) {
            return this.actions.get(this.actionIndex++);
        }
        ++this.actionIndex;
        return 0;
    }

    private GRSVertex nextVertex() {
        long l;
        GRSVertex gRSVertex;
        if ((gRSVertex = (GRSVertex)this.graph.getObject(l = this.vertices.get(this.vertexIndex++))) == null) {
            throw new NoSuchElementException("Node " + l + " does not exist.");
        }
        return gRSVertex;
    }

    private void makeChild(GRSVertex gRSVertex, GRSVertex gRSVertex2) {
        Node node;
        Node node2 = gRSVertex2.findAdjacent(true, false, 768);
        if (node2 != null && (node = gRSVertex.findAdjacent(true, false, 768)) != node2) {
            if (node != null) {
                node.removeEdgeBitsTo((Node)gRSVertex, -1, this.xa);
            }
            this.newVertices.add((Object)gRSVertex);
            node2.addEdgeBitsTo((Node)gRSVertex, 512, this.xa);
        }
    }

    public boolean process(int[] nArray) throws RuntimeModelException {
        this.xa = this.graph.getActiveTransaction();
        this.newVertices = this.rggGraph.getThreadData0().newGRSVertices;
        this.newVertices.clear();
        this.actionIndex = 0;
        this.vertexIndex = 0;
        boolean bl = false;
        if (nArray == null) {
            while (this.actionIndex < this.actions.size) {
                bl |= this.applyNext();
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                int n2;
                if (nArray[i] < 0 || (n2 = 2 * nArray[i]) >= this.segments.size) continue;
                this.actionIndex = this.segments.get(n2);
                this.vertexIndex = this.segments.get(n2 + 1);
                int n3 = n = (n2 += 2) == this.segments.size ? this.actions.size : this.segments.get(n2);
                while (this.actionIndex < n) {
                    bl |= this.applyNext();
                }
            }
        }
        this.xa = null;
        return bl;
    }

    private boolean applyNext() {
        switch (this.nextAction()) {
            case 1: {
                GRSVertex gRSVertex = this.nextVertex();
                GRSVertex gRSVertex2 = this.nextVertex();
                GRSVertex gRSVertex3 = this.nextVertex();
                ObjectList objectList = gRSVertex3.getNeighbors();
                int n = objectList.indexOf((Object)gRSVertex2);
                if (n < 0) {
                    return false;
                }
                this.makeChild(gRSVertex, gRSVertex3);
                this.index[0] = n;
                NEIGHBOR.insertObject((Object)gRSVertex3, this.index, (Object)gRSVertex, this.xa);
                return true;
            }
            case 2: {
                GRSVertex gRSVertex = this.nextVertex();
                GRSVertex gRSVertex4 = this.nextVertex();
                GRSVertex gRSVertex5 = this.nextVertex();
                ObjectList objectList = gRSVertex5.getNeighbors();
                int n = objectList.indexOf((Object)gRSVertex4);
                if (n < 0) {
                    return false;
                }
                this.makeChild(gRSVertex, gRSVertex5);
                this.index[0] = n < objectList.size - 1 ? n + 1 : 0;
                NEIGHBOR.insertObject((Object)gRSVertex5, this.index, (Object)gRSVertex, this.xa);
                return true;
            }
            case 3: {
                GRSVertex gRSVertex = this.nextVertex();
                GRSVertex gRSVertex6 = this.nextVertex();
                GRSVertex gRSVertex7 = this.nextVertex();
                ObjectList objectList = gRSVertex7.getNeighbors();
                int n = objectList.indexOf((Object)gRSVertex);
                if (n >= 0) {
                    this.makeChild(gRSVertex6, gRSVertex7);
                    this.index[0] = n < objectList.size - 1 ? n + 1 : 0;
                    NEIGHBOR.insertObject((Object)gRSVertex7, this.index, (Object)gRSVertex6, this.xa);
                    return true;
                }
                n = objectList.indexOf((Object)gRSVertex6);
                if (n >= 0) {
                    this.makeChild(gRSVertex, gRSVertex7);
                    this.index[0] = n;
                    NEIGHBOR.insertObject((Object)gRSVertex7, this.index, (Object)gRSVertex, this.xa);
                    return true;
                }
                return false;
            }
            case 4: {
                GRSVertex gRSVertex = this.nextVertex();
                GRSVertex gRSVertex8 = this.nextVertex();
                int n = gRSVertex8.getNeighborIndex(gRSVertex);
                if (n < 0) {
                    return false;
                }
                this.index[0] = n;
                NEIGHBOR.removeObject((Object)gRSVertex8, this.index, this.xa);
                return true;
            }
            case 5: {
                GRSVertex gRSVertex = this.nextVertex();
                GRSVertex gRSVertex9 = this.nextVertex();
                GRSVertex gRSVertex10 = this.nextVertex();
                int n = gRSVertex10.getNeighborIndex(gRSVertex9);
                if (n < 0) {
                    return false;
                }
                this.makeChild(gRSVertex, gRSVertex10);
                this.index[0] = n;
                NEIGHBOR.setObject((Object)gRSVertex10, this.index, (Object)gRSVertex, this.xa);
                return true;
            }
            case 6: {
                GRSVertex gRSVertex = this.nextVertex();
                ObjectList objectList = new ObjectList(10);
                while (this.nextAction() == 7) {
                    GRSVertex gRSVertex11 = this.nextVertex();
                    this.makeChild(gRSVertex11, gRSVertex);
                    objectList.add((Object)gRSVertex11);
                }
                --this.actionIndex;
                objectList.trimToSize();
                GRSVertex.neighbors$FIELD.setObject((Object)gRSVertex, null, (Object)objectList, this.xa);
                return true;
            }
            case 8: {
                GRSVertex gRSVertex = this.nextVertex();
                GRSVertex gRSVertex12 = this.nextVertex();
                GRSVertex gRSVertex13 = this.nextVertex();
                this.makeChild(gRSVertex, gRSVertex12);
                int n = gRSVertex12.getNeighborIndex(gRSVertex13);
                if (n >= 0) {
                    this.index[0] = n;
                    NEIGHBOR.setObject((Object)gRSVertex12, this.index, (Object)gRSVertex, this.xa);
                }
                if ((n = gRSVertex13.getNeighborIndex(gRSVertex12)) >= 0) {
                    this.index[0] = n;
                    NEIGHBOR.setObject((Object)gRSVertex13, this.index, (Object)gRSVertex, this.xa);
                }
                ObjectList objectList = new ObjectList(2);
                objectList.add((Object)gRSVertex12);
                objectList.add((Object)gRSVertex13);
                GRSVertex.neighbors$FIELD.setObject((Object)gRSVertex, null, (Object)objectList, this.xa);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public void clearSegmentsToExclude(int[] nArray) {
    }

    public void clear() {
        this.actions.clear();
        this.vertices.clear();
        this.segments.clear();
    }

    public void markSegment(int n) {
        n = (n + 1) * 2;
        while (this.segments.size < n) {
            this.segments.push(this.actions.size, this.vertices.size);
        }
    }

    public void resetToSegment(int n) {
        n = (n + 1) * 2;
        this.actions.setSize(this.segments.elements[n - 2]);
        this.vertices.setSize(this.segments.elements[n - 1]);
        this.segments.setSize(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Descriptor
    extends QueueDescriptor<VVQueue> {
        protected QueueDescriptor[] queuesToProcessBefore() {
            return new QueueDescriptor[]{GraphQueue.LAST_QUEUE};
        }

        protected QueueDescriptor[] queuesToProcessAfter() {
            return QueueDescriptor.DESCRIPTOR_0;
        }

        public VVQueue createQueue(QueueCollection queueCollection) {
            return new VVQueue(queueCollection, (PropertyQueue)queueCollection.getQueue((QueueDescriptor)PropertyQueue.MAKE_PERSISTENT));
        }
    }
}

