/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.imp3d.objects.NURBSSurface;
import de.grogra.pf.ui.Workbench;
import de.grogra.reflect.Type;
import de.grogra.rgg.BooleanNode;
import de.grogra.rgg.ByteNode;
import de.grogra.rgg.CharNode;
import de.grogra.rgg.DoubleNode;
import de.grogra.rgg.FloatNode;
import de.grogra.rgg.IntNode;
import de.grogra.rgg.Library;
import de.grogra.rgg.LongNode;
import de.grogra.rgg.ObjectNode;
import de.grogra.rgg.ShortNode;
import de.grogra.rgg.model.RGGGraph;
import de.grogra.util.ThreadContext;
import de.grogra.xl.impl.base.EdgeIterator;
import de.grogra.xl.impl.base.Graph;
import de.grogra.xl.impl.base.RuntimeModel;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.util.ObjectList;

public class Runtime
extends RuntimeModel {
    public static final Runtime INSTANCE = new Runtime();
    private static final int EXTENT = ThreadContext.registerProperty();
    final ObjectList<Iterator> iterators = new ObjectList();

    public void setCurrentGraph(Graph graph) {
        ThreadContext threadContext = ThreadContext.current();
        threadContext.setProperty(EXTENT, (Object)graph);
        Workbench workbench = Workbench.current((ThreadContext)threadContext);
        if (workbench != null) {
            workbench.setProperty(((Object)((Object)this)).getClass().getName(), (Object)graph);
        }
    }

    public RGGGraph currentGraph() {
        ThreadContext threadContext = ThreadContext.current();
        RGGGraph rGGGraph = (RGGGraph)((Object)threadContext.getProperty(EXTENT));
        Workbench workbench = Workbench.current((ThreadContext)threadContext);
        if (rGGGraph != null && workbench != null && rGGGraph.manager != workbench.getRegistry().getProjectGraph()) {
            threadContext.setProperty(EXTENT, null);
            rGGGraph = null;
        }
        if (rGGGraph == null && workbench != null) {
            rGGGraph = (RGGGraph)((Object)workbench.getProperty(((Object)((Object)this)).getClass().getName()));
            threadContext.setProperty(EXTENT, (Object)rGGGraph);
        }
        return rGGGraph;
    }

    public void setCurrentGraph(GraphManager graphManager) {
        this.setCurrentGraph(new RGGGraph(this, graphManager));
    }

    public boolean isNode(Object object) {
        return object instanceof Node;
    }

    public Class getNodeType() {
        return Node.class;
    }

    public void addEdgeBits(Object object, Object object2, int n) {
        ((Node)object).addEdgeBitsTo((Node)object2, n, null);
    }

    public int getEdgeBits(Object object, Object object2) {
        return ((Node)object).getEdgeBitsTo((Node)object2);
    }

    public synchronized EdgeIterator createEdgeIterator(Object object, EdgeDirection edgeDirection) {
        Iterator iterator = this.iterators.isEmpty() ? new Iterator() : (Iterator)((Object)this.iterators.pop());
        iterator.node = (Node)object;
        iterator.direction = edgeDirection.getCode();
        iterator.set(((Node)object).getFirstEdge());
        return iterator;
    }

    public boolean isWrapperFor(Object object, Type type) {
        switch (type.getTypeId()) {
            case 2: {
                return object instanceof BooleanNode;
            }
            case 3: {
                return object instanceof ByteNode;
            }
            case 4: {
                return object instanceof ShortNode;
            }
            case 5: {
                return object instanceof CharNode;
            }
            case 6: {
                return object instanceof IntNode;
            }
            case 7: {
                return object instanceof LongNode;
            }
            case 8: {
                return object instanceof FloatNode;
            }
            case 9: {
                return object instanceof DoubleNode;
            }
            case 0: {
                return object instanceof ObjectNode || object instanceof NURBSCurve || object instanceof NURBSSurface;
            }
        }
        throw new AssertionError();
    }

    public boolean unwrapBoolean(Object object) {
        return Library.booleanValue((Node)object);
    }

    public byte unwrapByte(Object object) {
        return Library.byteValue((Node)object);
    }

    public short unwrapShort(Object object) {
        return Library.shortValue((Node)object);
    }

    public char unwrapChar(Object object) {
        return Library.charValue((Node)object);
    }

    public int unwrapInt(Object object) {
        return Library.intValue((Node)object);
    }

    public long unwrapLong(Object object) {
        return Library.longValue((Node)object);
    }

    public float unwrapFloat(Object object) {
        return Library.floatValue((Node)object);
    }

    public double unwrapDouble(Object object) {
        return Library.doubleValue((Node)object);
    }

    public Object unwrapObject(Object object) {
        return Library.objectValue((Node)object);
    }

    private final class Iterator
    extends EdgeIterator {
        Node node;
        int direction;
        private Edge edge;

        private Iterator() {
        }

        void set(Edge edge) {
            while (true) {
                this.edge = edge;
                if (edge == null) {
                    this.source = null;
                    this.target = null;
                    return;
                }
                this.source = edge.getSource();
                this.target = edge.getTarget();
                this.edgeBits = edge.getEdgeBits();
                switch (this.direction) {
                    case 0: {
                        if (this.source != this.node) break;
                        return;
                    }
                    case 1: {
                        if (this.target != this.node) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                edge = edge.getNext(this.node);
            }
        }

        public boolean hasEdge() {
            if (this.edge != null) {
                return true;
            }
            this.dispose();
            return false;
        }

        public void moveToNext() {
            this.set(this.edge.getNext(this.node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.edge = null;
            this.source = null;
            this.target = null;
            Runtime runtime = Runtime.this;
            synchronized (runtime) {
                this.node = null;
                Runtime.this.iterators.push((Object)this);
            }
        }
    }
}

