/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg.model;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.GraphState;
import de.grogra.graph.Instantiator;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.NURBSCurve;
import de.grogra.imp3d.objects.NURBSSurface;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineSurface;
import de.grogra.rgg.Reference;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;

public class Instantiation {
    public static final Instantiator INSTANTIATOR = new Instantiator(){

        public boolean instantiate(ArrayPath arrayPath, Visitor visitor) {
            Node node = (Node)arrayPath.getNode(-1);
            if (node instanceof de.grogra.xl.modules.Instantiator) {
                Instantiation instantiation = new Instantiation();
                instantiation.initialize(arrayPath, visitor);
                ((de.grogra.xl.modules.Instantiator)node).instantiate((Object)instantiation);
                instantiation.clear();
            }
            return true;
        }
    };
    private ArrayPath path;
    private Visitor visitor;
    private GraphState gs;
    private IntList stack = new IntList();
    private ObjectList retStack = new ObjectList();
    private int stopCount;
    private int edges;
    private boolean instEdge;
    private Node node;
    private int nodeEdges;
    private long nodeIid;
    private long id;
    private int depth;
    private static final long BRANCH_INCREMENT = 0x100000000L;

    public void initialize(ArrayPath arrayPath, Visitor visitor) {
        this.path = arrayPath;
        this.visitor = visitor;
        this.gs = visitor.getGraphState();
        this.stopCount = -1;
        this.id = 0L;
        this.node = null;
        this.instEdge = true;
        this.depth = -1;
        this.pushImpl();
    }

    public int getDepth() {
        return this.depth;
    }

    public Instantiation operator$space(Node node) {
        this.instantiate(node);
        return this;
    }

    public static Node toNode(BSplineCurve bSplineCurve) {
        return new NURBSCurve(bSplineCurve);
    }

    public static Node toNode(BSplineSurface bSplineSurface) {
        return new NURBSSurface(bSplineSurface);
    }

    public static Node toNode(Reference reference) {
        return reference.resolveNode();
    }

    private void pushImpl() {
        this.instantiate();
        this.stack.push(this.gs.getInstancingPathIndex());
        this.stack.push((int)this.id);
        this.id += 0x100000000L;
        this.edges = 512;
    }

    public Instantiation producer$push() {
        this.pushImpl();
        --this.depth;
        return this;
    }

    public Instantiation producer$begin() {
        ++this.depth;
        return this;
    }

    public void producer$end() {
        this.instantiate();
        --this.depth;
    }

    private void popImpl() {
        this.instantiate();
        this.id = (this.id - 0x100000000L & 0xFFFFFFFF00000000L) + (long)this.stack.pop();
        int n = this.stack.pop();
        while (this.gs.getInstancingPathIndex() > n) {
            switch (this.stopCount) {
                case -1: 
                case 0: {
                    this.visitor.visitLeave(this.retStack.pop(), (Path)this.path, true);
                }
                case 1: {
                    this.visitor.visitLeave(this.retStack.pop(), (Path)this.path, false);
                    this.stopCount = -1;
                    break;
                }
                default: {
                    this.stopCount -= 2;
                }
            }
            this.path.popNode();
            this.path.popEdgeSet();
            this.gs.deinstantiate();
            this.gs.deinstantiate();
        }
    }

    public Instantiation producer$pop(Object object) {
        ++this.depth;
        this.popImpl();
        return this;
    }

    public void clear() {
        this.popImpl();
    }

    public void instantiate(Node node) {
        if (node == null) {
            return;
        }
        this.instantiate();
        this.node = node;
        this.nodeEdges = this.edges;
        this.nodeIid = this.id++;
        this.gs.instantiateEdge(this.nodeEdges, true, this.nodeIid);
        this.gs.instantiate((Object)node, true, this.nodeIid);
        this.edges = 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiate() {
        Node node;
        while ((node = this.node) != null) {
            Object object;
            this.node = null;
            this.path.pushEdges(this.nodeEdges, true, this.nodeIid, this.instEdge);
            this.instEdge = false;
            this.path.pushNode((Object)node, this.nodeIid);
            if (this.stopCount >= 0) {
                this.stopCount += 2;
                continue;
            }
            Object object2 = this.visitor.visitEnter((Path)this.path, false);
            this.retStack.push(object2);
            if (object2 == Visitor.STOP) {
                this.stopCount = 1;
            } else {
                object2 = this.visitor.visitEnter((Path)this.path, true);
                this.retStack.push(object2);
                if (object2 == Visitor.STOP) {
                    this.stopCount = 0;
                }
            }
            if (this.stopCount >= 0) continue;
            if (node instanceof de.grogra.xl.modules.Instantiator) {
                ((de.grogra.xl.modules.Instantiator)node).instantiate((Object)this);
            } else {
                Instantiator instantiator = node.getInstantiator();
                if (instantiator != null) {
                    boolean bl = true;
                    object = this.visitor.visitInstanceEnter();
                    if (object != Visitor.STOP) {
                        try {
                            this.gs.beginInstancing((Object)node, this.path.getObjectId(-1));
                            bl = instantiator.instantiate(this.path, this.visitor);
                        }
                        finally {
                            this.gs.endInstancing();
                        }
                    }
                    if (!(bl & this.visitor.visitInstanceLeave(object))) continue;
                }
            }
            for (object = node.getFirstEdge(); object != null; object = object.getNext(node)) {
                Node node2 = object.getTarget();
                if (node2 == node || !object.testEdgeBits(768)) continue;
                this.pushImpl();
                this.instantiate(node2);
                this.popImpl();
            }
        }
    }

    public GraphState getGraphState() {
        return this.gs;
    }
}

