/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.rgg;

import de.grogra.graph.Graph;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.ray2.SceneVisitor;
import de.grogra.imp3d.ray2.VolumeListener;
import de.grogra.math.RGBColor;
import de.grogra.persistence.Transaction;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray2.Options;
import de.grogra.rgg.Library;
import de.grogra.rgg.RGGRoot;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.MeshVolume;
import de.grogra.vecmath.geom.Volume;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.LongList;
import de.grogra.xl.util.LongToIntHashMap;
import de.grogra.xl.util.Operators;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvoidIntersection
implements Options,
VolumeListener {
    private int RayCount;
    private Vector3d direction;
    private Point3d origin;
    private Point3d rayOrigin;
    private ArrayList<Line> rays;
    private int[] hitList;
    private double[] hitDistance;
    private double hitRatio = 0.0;
    private double hitRatioPoint = 0.0;
    private boolean prepareScene = true;
    private float rangeWidth = 1.0f;
    private float rangeHeight = 1.0f;
    private float predictedLength = 0.1f;
    public static final int NO_HIT = 0;
    public static final int FRIENDLY_HIT = 1;
    public static final int UNFRIENDLY_HIT = 2;
    private Class<?> favorNodeType;
    private ArrayList<Node> favorNodes;
    private LongList favorVolumeID;
    private float disToNodeSurface = 0.1f;
    private double minParameter;
    private int minDistRay = -1;
    private Vector3d freeVec = new Vector3d();
    private Vector3d unfreeVec = new Vector3d();
    boolean allLinesFree;
    boolean allLinesUnFree;
    private Node originNode;
    private long originVolumeID;
    private Volume originVolume;
    private transient boolean[] visibleLayers;
    private transient int currentGroupIndex;
    private transient int nextGroupIndex;
    private transient int grouping;
    private transient IntList groupToVolumeId;
    private transient LongToIntHashMap nodeToGroup;
    private IntersectionList ilist;
    private Intersection is;
    private SceneVisitor scene;
    private Spectrum3d spec;
    private ArrayList<Line> friendlyRays;
    private ArrayList<Line> normals;
    private boolean allLinesFriendlyFree = true;

    public AvoidIntersection() {
        this(100);
    }

    public AvoidIntersection(int n) {
        int n2;
        this.RayCount = n;
        this.rays = new ArrayList(n + 1);
        this.hitList = new int[n + 1];
        this.hitDistance = new double[n + 1];
        this.friendlyRays = new ArrayList(n + 1);
        this.normals = new ArrayList(n + 1);
        this.favorVolumeID = new LongList();
        if (this.nodeToGroup == null) {
            this.nodeToGroup = new LongToIntHashMap();
            this.groupToVolumeId = new IntList();
        } else {
            this.nodeToGroup.clear();
            this.groupToVolumeId.clear();
        }
        this.visibleLayers = new boolean[16];
        for (n2 = 0; n2 < 16; ++n2) {
            this.visibleLayers[n2] = true;
        }
        this.grouping = 0;
        this.nextGroupIndex = 1;
        this.currentGroupIndex = -1;
        this.spec = new Spectrum3d();
        for (n2 = 0; n2 <= n; ++n2) {
            this.rays.add(new Line());
            this.friendlyRays.add(new Line());
            this.normals.add(new Line());
        }
        this.hitRatioPoint = 1.0 / (double)n;
        this.minParameter = 0.0;
        this.favorNodes = new ArrayList();
    }

    public void setLayerVisible(int n, boolean bl) {
        if (n > 0) {
            this.visibleLayers[n] = bl;
        }
    }

    public void setPrepareScene() {
        this.prepareScene = true;
    }

    public void setRange(float f, float f2) {
        this.setRange(f, f2, 0.0f);
    }

    public void setRange(float f, float f2, float f3) {
        if (f >= 0.0f) {
            this.rangeWidth = f;
        }
        if (f2 >= 0.0f) {
            this.rangeHeight = f2;
        }
        this.predictedLength = f3;
    }

    public void setFavorNodeType(Class<?> clazz) {
        this.favorNodeType = clazz;
    }

    public void addFavorNode(Node node) {
        if (node != null) {
            this.favorNodes.add(node);
        }
    }

    public void setDistance2Surface(float f) {
        this.disToNodeSurface = f;
    }

    public void prepareScene() {
        if (this.prepareScene || this.scene == null) {
            if (this.scene != null) {
                this.scene.dispose();
            }
            this.grouping = 0;
            this.nextGroupIndex = 1;
            this.currentGroupIndex = -1;
            this.favorVolumeID.clear();
            this.nodeToGroup.clear();
            this.groupToVolumeId.clear();
            this.scene = new SceneVisitor(Workbench.current(), (Graph)Workbench.current().getRegistry().getProjectGraph(), 1.0E-5f, (Options)this, null, this.visibleLayers, (VolumeListener)this, (Spectrum)this.spec);
            this.prepareScene = false;
        } else {
            this.originVolumeID = this.groupToVolumeId.get(this.nodeToGroup.get(this.originNode.getId()));
            this.originVolume = (Volume)this.scene.getOctree().volumes.get((int)this.originVolumeID);
        }
        this.minDistRay = -1;
        this.setListToZero(this.rays);
        this.setListToZero(this.friendlyRays);
        this.setListToZero(this.normals);
        this.ilist = new IntersectionList();
        this.is = new Intersection(new IntersectionList());
    }

    public boolean look(Null nullVal, float f) {
        return this.look(nullVal, f, 1.0f, false);
    }

    public boolean look(Null nullVal, float f, float f2, boolean bl) {
        this.originNode = nullVal;
        this.prepareScene();
        this.is.volume = this.originVolume;
        this.origin = Library.location((Node)nullVal);
        this.direction = Library.direction((Node)nullVal);
        this.rayOrigin = new Point3d(this.origin);
        Vector3d vector3d = new Vector3d(this.direction);
        if (this.predictedLength != 0.0f) {
            vector3d.normalize();
            vector3d.scale((double)this.predictedLength);
            this.rayOrigin.scaleAdd((double)this.predictedLength, (Tuple3d)vector3d, (Tuple3d)this.origin);
        }
        Line line = this.rays.get(0);
        line.origin.set((Tuple3d)this.rayOrigin);
        line.direction.set((Tuple3d)this.direction);
        line.start = 1.0E-4;
        line.end = f;
        this.hitList[0] = 0;
        this.hitDistance[0] = 0.0;
        this.hitRatio = 0.0;
        this.minParameter = 0.0;
        this.shootRays(line, this.rangeWidth, this.rangeHeight);
        this.getNewDirection(0);
        Null nullVal2 = Library.tropism((Node)nullVal, this.direction, f2);
        Transaction transaction = nullVal.getGraph().getActiveTransaction();
        Node node = nullVal.findAdjacent(true, false, -1);
        if (node != null) {
            node.getEdgeTo((Node)nullVal).remove(transaction);
        }
        node.addEdgeBitsTo((Node)nullVal2, 256, transaction);
        nullVal2.addEdgeBitsTo((Node)nullVal, 256, transaction);
        if (bl) {
            this.showLines();
        }
        return this.allLinesUnFree || !this.allLinesFriendlyFree;
    }

    private void traceRay(int n) {
        int n2 = this.ilist.size;
        this.hitList[n] = 0;
        this.hitDistance[n] = 0.0;
        this.ilist.clear();
        Line line = this.rays.get(n);
        this.scene.computeIntersections(line, 1, this.ilist, this.is, null);
        if (this.ilist.size > n2) {
            Intersection intersection;
            int n3 = 0;
            do {
                intersection = this.ilist.elements[n3++];
            } while ((long)intersection.volume.getId() == this.originVolumeID && n3 < this.ilist.size);
            if (intersection.parameter < Double.POSITIVE_INFINITY && (long)intersection.volume.getId() != this.originVolumeID) {
                if (!this.belongsToObject(intersection.volume.getId())) {
                    this.hitList[n] = 2;
                    this.hitDistance[n] = intersection.parameter;
                    this.hitRatio += this.hitRatioPoint;
                } else {
                    this.hitList[n] = 1;
                    Line line2 = intersection.line;
                    line2.end = intersection.parameter;
                    this.rays.set(n, line2);
                    Line line3 = this.normals.get(n);
                    Line line4 = this.friendlyRays.get(n);
                    line3.origin.set((Tuple3d)intersection.getPoint());
                    line3.direction.set((Tuple3d)intersection.getNormal());
                    line3.end = 1.0;
                    line4.origin.set((Tuple3d)this.rayOrigin);
                    line4.direction.set((Tuple3d)line2.direction);
                    line4.end = 1.0;
                    if (intersection.parameter < this.minParameter || this.minParameter == 0.0) {
                        this.minParameter = intersection.parameter;
                        this.minDistRay = n;
                    }
                }
            }
            this.ilist.setSize(n2);
        }
    }

    private Vector3d getTangentDirection(int n) {
        Line line = this.normals.get(n);
        Vector3d vector3d = new Vector3d(line.direction);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.scaleAdd((double)this.disToNodeSurface, (Tuple3d)vector3d, line.origin);
        if (!this.allLinesFriendlyFree) {
            Point3d point3d = new Point3d();
            point3d.add((Tuple3d)this.direction, (Tuple3d)this.rayOrigin);
            double d = vector3d2.x * vector3d.x + vector3d2.y * vector3d.y + vector3d2.z * vector3d.z;
            double d2 = d - vector3d.x * point3d.x - vector3d.y * point3d.y - vector3d.z * point3d.z;
            vector3d2.normalize();
            vector3d2.scaleAdd(-(d2 /= -vector3d.x * vector3d.x + -vector3d.y * vector3d.y + -vector3d.z * vector3d.z), (Tuple3d)vector3d, (Tuple3d)point3d);
        }
        vector3d2.sub((Tuple3d)this.rayOrigin);
        return vector3d2;
    }

    private void getNewDirection(int n) {
        this.freeVec.set(0.0, 0.0, 0.0);
        this.unfreeVec.set(0.0, 0.0, 0.0);
        this.allLinesFree = true;
        this.allLinesUnFree = true;
        this.allLinesFriendlyFree = true;
        Line line = this.rays.get(0);
        block5: for (int i = 1; i < this.hitList.length; ++i) {
            Vector3d vector3d = this.rays.get((int)i).direction;
            switch (this.hitList[i]) {
                case 0: {
                    this.allLinesUnFree = false;
                    this.freeVec.add((Tuple3d)vector3d);
                    continue block5;
                }
                case 2: {
                    this.allLinesFree = false;
                    vector3d.scale(this.hitDistance[i] < Double.POSITIVE_INFINITY ? 1.0 / this.hitDistance[i] : 0.0);
                    this.unfreeVec.add((Tuple3d)vector3d);
                    continue block5;
                }
                case 1: {
                    this.allLinesFriendlyFree = false;
                }
            }
        }
        if (this.allLinesUnFree && n == 0) {
            this.hitRatio = 0.0;
            this.shootRays(this.rays.get(0), this.rangeWidth * 20.0f, this.rangeHeight * 20.0f);
            this.getNewDirection(++n);
        } else if (!this.allLinesFree) {
            this.freeVec.scale(10.0 / (this.hitRatio * (double)(this.rangeWidth * this.rangeHeight)));
            this.freeVec.sub((Tuple3d)this.unfreeVec);
            this.freeVec.normalize();
            this.direction.set((Tuple3d)this.freeVec);
        }
        if (n == 0 && this.minDistRay > -1) {
            if (this.allLinesFriendlyFree) {
                this.setListToZero(this.rays);
                this.setListToZero(this.friendlyRays);
                this.setListToZero(this.normals);
                this.minParameter = 0.0;
                this.prepareScene = true;
                this.prepareScene();
                this.is.volume = this.originVolume;
                this.shootInAllDirection(line);
            }
            if (this.minDistRay > -1) {
                this.direction = this.getTangentDirection(this.minDistRay);
            }
        }
    }

    private void shootRays(Line line, float f, float f2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d(line.direction);
        if (this.direction.x != 0.0) {
            vector3d.x = -this.direction.y;
            vector3d.y = this.direction.x;
            vector3d.z = 0.0;
        } else {
            vector3d.x = 0.0;
            vector3d.y = -this.direction.z;
            vector3d.z = this.direction.y;
        }
        vector3d2.cross(vector3d3, vector3d);
        vector3d.normalize();
        vector3d2.normalize();
        for (int i = 1; i <= this.RayCount; ++i) {
            Line line2 = this.rays.get(i);
            vector3d3.scaleAdd((double)this.random(-f, f), (Tuple3d)vector3d, (Tuple3d)this.direction);
            vector3d3.scaleAdd((double)this.random(-f2, f2), (Tuple3d)vector3d2, (Tuple3d)vector3d3);
            vector3d3.normalize();
            line2.origin.set((Tuple3d)this.rayOrigin);
            line2.direction.set((Tuple3d)vector3d3);
            line2.start = line.start;
            line2.end = line.end;
            this.traceRay(i);
        }
    }

    private void shootInAllDirection(Line line) {
        Vector3d vector3d = new Vector3d();
        for (int i = 1; i <= this.RayCount; ++i) {
            Line line2 = this.rays.get(i);
            vector3d.x = Math.sin(this.random(0.0f, 360.0f));
            vector3d.y = Math.sin(this.random(0.0f, 360.0f));
            vector3d.z = Math.sin(this.random(0.0f, 360.0f));
            vector3d.normalize();
            line2.origin.set((Tuple3d)this.rayOrigin);
            line2.direction.set((Tuple3d)vector3d);
            line2.start = line.start;
            line2.end = line.end;
            this.traceRay(i);
        }
    }

    private void setListToZero(ArrayList<Line> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Line line = arrayList.get(i);
            line.origin.set(0.0, 0.0, 0.0);
            line.direction.set(0.0, 0.0, 0.0);
            line.start = 0.0;
            line.end = 0.0;
        }
    }

    private boolean belongsToObject(long l) {
        int n;
        if (this.favorVolumeID.size() > 0 && (n = 0) < this.favorVolumeID.size) {
            return l == this.favorVolumeID.get(n);
        }
        return false;
    }

    private boolean isFavorNode(long l) {
        int n;
        if (this.favorNodes.size() > 0 && (n = 0) < this.favorNodes.size()) {
            return l == this.favorNodes.get(n).getId();
        }
        return false;
    }

    private de.grogra.imp3d.objects.Line drawLine(int n) {
        if (n >= 0 && n <= this.RayCount) {
            Line line = this.rays.get(n);
            double d = this.hitDistance[n] > 0.0 && this.hitDistance[n] < Double.POSITIVE_INFINITY && this.hitDistance[n] > 0.001 ? this.hitDistance[n] : line.end;
            line.direction.normalize();
            de.grogra.imp3d.objects.Line line2 = new de.grogra.imp3d.objects.Line((float)line.origin.x, (float)line.origin.y, (float)line.origin.z, (float)(line.direction.x * d), (float)(line.direction.y * d), (float)(line.direction.z * d));
            if (n != 0) {
                RGBColor rGBColor;
                switch (this.hitList[n]) {
                    case 2: {
                        rGBColor = new RGBColor(1.0f, 0.4f, 0.0f);
                        rGBColor.scale((float)this.hitDistance[n] / (float)line.end);
                        break;
                    }
                    case 1: {
                        rGBColor = RGBColor.GREEN;
                        break;
                    }
                    default: {
                        rGBColor = RGBColor.YELLOW;
                    }
                }
                line2.setColor((Color3f)rGBColor);
            } else {
                line2.setColor((Color3f)RGBColor.GREEN);
            }
            return line2;
        }
        return null;
    }

    private void showLines() {
        Transaction transaction = this.originNode.getGraph().getActiveTransaction();
        for (int i = 1; i <= this.RayCount; ++i) {
            RGGRoot.getRoot(this.originNode.getGraph()).addEdgeBitsTo((Node)this.drawLine(i), 512, transaction);
            if (this.hitList[i] != 1) continue;
            Line line = this.friendlyRays.get(i);
            de.grogra.imp3d.objects.Line line2 = new de.grogra.imp3d.objects.Line((float)line.origin.x, (float)line.origin.y, (float)line.origin.z, (float)(line.direction.x * line.end), (float)(line.direction.y * line.end), (float)(line.direction.z * line.end));
            line2.setColor((Color3f)RGBColor.MAGENTA);
            RGGRoot.getRoot(this.originNode.getGraph()).addEdgeBitsTo((Node)line2, 512, transaction);
            line = this.normals.get(i);
            line2 = new de.grogra.imp3d.objects.Line((float)line.origin.x, (float)line.origin.y, (float)line.origin.z, (float)(line.direction.x * line.end * (double)this.disToNodeSurface), (float)(line.direction.y * line.end * (double)this.disToNodeSurface), (float)(line.direction.z * line.end * (double)this.disToNodeSurface));
            line2.setColor((Color3f)RGBColor.ORANGE);
            RGGRoot.getRoot(this.originNode.getGraph()).addEdgeBitsTo((Node)line2, 512, transaction);
        }
        de.grogra.imp3d.objects.Line line = new de.grogra.imp3d.objects.Line((float)this.rayOrigin.x, (float)this.rayOrigin.y, (float)this.rayOrigin.z, (float)(this.direction.x * (double)this.predictedLength), (float)(this.direction.y * (double)this.predictedLength), (float)(this.direction.z * (double)this.predictedLength));
        line.setColor((Color3f)RGBColor.WHITE);
        RGGRoot.getRoot(this.originNode.getGraph()).addEdgeBitsTo((Node)line, 512, transaction);
    }

    private float random(float f, float f2) {
        return Operators.getRandomGenerator().nextFloat() * (f2 - f) + f;
    }

    public Object get(String string, Object object) {
        return object;
    }

    public void volumeCreated(Object object, boolean bl, Volume volume) {
        assert (bl);
        long l = ((Node)object).getId();
        boolean bl2 = false;
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nextGroupIndex++;
            this.nodeToGroup.put(l, this.currentGroupIndex);
            Type[] typeArray = object.getClass().getGenericInterfaces();
            if (typeArray.length > 0) {
                for (int i = 0; i < typeArray.length; ++i) {
                    if (!typeArray[i].equals(this.favorNodeType)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (this.isFavorNode(l) || bl2) {
                this.favorVolumeID.add((long)volume.getId());
            }
            if (this.originNode != null && this.originNode.getId() == l) {
                this.originVolume = volume;
                this.originVolumeID = volume.getId();
            }
        } else if (this.grouping == 1 && volume instanceof MeshVolume) {
            this.favorVolumeID.add((long)volume.getId());
        }
        this.groupToVolumeId.set(this.currentGroupIndex, volume.getId());
    }

    public void beginGroup(Object object, boolean bl) {
        assert (bl);
        if (this.grouping == 0) {
            this.currentGroupIndex = this.nodeToGroup.get(((Node)object).getId());
            if (this.currentGroupIndex == 0) {
                this.currentGroupIndex = this.nextGroupIndex++;
                this.nodeToGroup.put(((Node)object).getId(), this.currentGroupIndex);
            }
        }
        ++this.grouping;
    }

    public void endGroup() {
        if (--this.grouping < 0) {
            throw new IllegalStateException();
        }
    }
}

