/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MTGVoxel {
    private int branchIndex;
    private Vector3d min;
    private Vector3d max;
    private double deltax;
    private double deltay;
    private double deltaz;
    public static int voxelsNumber;

    public MTGVoxel(int n, Vector3d vector3d, Vector3d vector3d2) {
        this.branchIndex = n;
        vector3d = new Vector3d();
        vector3d2 = new Vector3d();
        this.min = vector3d;
        this.max = vector3d2;
        ++voxelsNumber;
        this.deltaz = 0.0;
        this.deltay = 0.0;
        this.deltax = 0.0;
    }

    public MTGVoxel(int n) {
        this.branchIndex = n;
        ++voxelsNumber;
        this.deltaz = 0.0;
        this.deltay = 0.0;
        this.deltax = 0.0;
        this.min = new Vector3d();
        this.max = new Vector3d();
        this.min.x = Double.MAX_VALUE;
        this.min.y = Double.MAX_VALUE;
        this.min.z = Double.MAX_VALUE;
        this.max.x = Double.MIN_VALUE;
        this.max.y = Double.MIN_VALUE;
        this.max.z = Double.MIN_VALUE;
    }

    public void setMin(Vector3d vector3d) {
        this.min = vector3d;
    }

    public void setMax(Vector3d vector3d) {
        this.max = vector3d;
    }

    public Vector3d getMin() {
        return this.min;
    }

    public Vector3d getMax() {
        return this.max;
    }

    public int getBranchIndex() {
        return this.branchIndex;
    }

    public double getDeltax() {
        return this.deltax;
    }

    public void setDeltax(double d) {
        this.deltax = d;
    }

    public double getDeltay() {
        return this.deltay;
    }

    public void setDeltay(double d) {
        this.deltay = d;
    }

    public double getDeltaz() {
        return this.deltaz;
    }

    public void setDeltaz(double d) {
        this.deltaz = d;
    }

    public void translate() {
        Vector3d vector3d = new Vector3d(this.deltax, this.deltay, this.deltaz);
        this.min.add((Tuple3d)vector3d);
        this.max.add((Tuple3d)vector3d);
    }

    public boolean equals(MTGVoxel mTGVoxel) {
        return mTGVoxel.getBranchIndex() == this.branchIndex;
    }
}

