/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.mtg.MTGVoxel;
import java.util.ArrayList;
import javax.vecmath.Vector3d;

public class MTGSquares {
    private double deltaPlant;
    private ArrayList<MTGVoxel> voxels;

    public MTGSquares(double d) {
        this.deltaPlant = d;
        this.voxels = new ArrayList();
    }

    public Vector3d getMin(int n) {
        if (this.voxels.size() - 1 >= n) {
            return this.voxels.get(n).getMin();
        }
        return null;
    }

    public Vector3d getMax(int n) {
        if (this.voxels.size() - 1 >= n) {
            return this.voxels.get(n).getMax();
        }
        return null;
    }

    public void addVoxel(MTGVoxel mTGVoxel) {
        boolean bl = false;
        for (int i = 0; i < this.voxels.size(); ++i) {
            if (!this.voxels.get(i).equals(mTGVoxel)) continue;
            bl = true;
        }
        if (!bl) {
            this.voxels.add(mTGVoxel);
        }
    }

    public void computePositions(int n) {
        double d = 0.0;
        double d2 = this.deltaPlant;
        for (int i = 0; i < this.voxels.size(); ++i) {
            double d3;
            double d4;
            Vector3d vector3d;
            Vector3d vector3d2;
            if (i % n != 0) {
                vector3d2 = this.voxels.get(i).getMin();
                vector3d = this.voxels.get(i - 1).getMax();
                d4 = vector3d2.y;
                d3 = vector3d.y;
                if (this.deltaPlant > 0.0) {
                    this.voxels.get(i).setDeltay(d3 + this.deltaPlant - d4);
                } else {
                    this.voxels.get(i).setDeltay(-this.deltaPlant + d);
                    d -= -this.deltaPlant;
                }
            } else {
                d = 0.0;
                d2 -= this.deltaPlant;
            }
            if (i >= n) {
                vector3d2 = this.voxels.get(i).getMin();
                vector3d = this.voxels.get(i - n).getMax();
                d4 = vector3d2.x;
                d3 = vector3d.x;
                if (this.deltaPlant > 0.0) {
                    this.voxels.get(i).setDeltax(d3 + this.deltaPlant - d4);
                } else {
                    this.voxels.get(i).setDeltax(d2);
                }
            }
            this.voxels.get(i).translate();
        }
    }
}

