/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.impl.Node;
import de.grogra.imp.View;
import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGModuleBuilder;
import de.grogra.mtg.MTGTranslator;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.VirtualFileReaderSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.SourceFile;
import de.grogra.util.MimeType;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.vfs.MemoryFileSystem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;

public class MTGFilter
extends FilterBase
implements ObjectSource {
    MTGTranslator mtgTranslator;
    String filename;

    public MTGFilter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.NODE);
    }

    public MTGFilter(FileSource fileSource) {
        super(null, (FilterSource)fileSource);
        this.setFlavor(IOFlavor.NODE);
    }

    public Object getObject(FileSource fileSource) throws IOException {
        try {
            this.mtgTranslator = new MTGTranslator(fileSource.getFileSystem().getReader(fileSource.getFile()), fileSource.getSystemId());
            if (this.mtgTranslator.translateMTGFileHeader() != 8) {
                int n = this.mtgTranslator.getLineCounter();
                String string = this.mtgTranslator.getErrorMessage();
                JOptionPane.showMessageDialog(null, "Unable to load MTG file headers. Please check syntax at line: " + String.valueOf(n) + ". " + string, "MTG Loading", 2);
                return null;
            }
            MTGModuleBuilder mTGModuleBuilder = new MTGModuleBuilder(this.mtgTranslator.getMTGRootNode(), this.getSystemId(), this.getGeneratedFileName((VirtualFileReaderSource)fileSource, false));
            Object object = this.generateFileAndCompile((VirtualFileReaderSource)fileSource, mTGModuleBuilder);
            if (object == null) {
                String string = mTGModuleBuilder.getErrorMessage();
                JOptionPane.showMessageDialog(null, "Unable to generate XL modules." + string, "MTG Loading", 2);
                return null;
            }
            if (this.mtgTranslator.translateMTGFileBody() != 0) {
                int n = this.mtgTranslator.getLineCounter();
                String string = this.mtgTranslator.getErrorMessage();
                JOptionPane.showMessageDialog(null, "Unable to load MTG file headers. Please check syntax at line: " + String.valueOf(n) + ". " + string, "MTG Loading", 2);
                return null;
            }
            this.initSelectableScales();
            return this.mtgTranslator.getMTGRootNode();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Object getObject() {
        VirtualFileReaderSource virtualFileReaderSource = (VirtualFileReaderSource)this.getSource();
        try {
            this.mtgTranslator = new MTGTranslator(virtualFileReaderSource.getFileSystem().getReader(virtualFileReaderSource.getFile()), virtualFileReaderSource.getSystemId());
            if (this.mtgTranslator.translateMTGFileHeader() != 8) {
                int n = this.mtgTranslator.getLineCounter();
                String string = this.mtgTranslator.getErrorMessage();
                JOptionPane.showMessageDialog(null, "Unable to load MTG file headers. Please check syntax at line: " + String.valueOf(n) + ". " + string, "MTG Loading", 2);
                return null;
            }
            MTGModuleBuilder mTGModuleBuilder = new MTGModuleBuilder(this.mtgTranslator.getMTGRootNode(), this.getSystemId(), this.getGeneratedFileName(virtualFileReaderSource, false));
            Object object = this.generateFileAndCompile(virtualFileReaderSource, mTGModuleBuilder);
            if (object == null) {
                String string = mTGModuleBuilder.getErrorMessage();
                JOptionPane.showMessageDialog(null, "Unable to generate XL modules." + string, "MTG Loading", 2);
                return null;
            }
            if (this.mtgTranslator.translateMTGFileBody() != 0) {
                int n = this.mtgTranslator.getLineCounter();
                String string = this.mtgTranslator.getErrorMessage();
                JOptionPane.showMessageDialog(null, "Unable to load MTG file headers. Please check syntax at line: " + String.valueOf(n) + ". " + string, "MTG Loading", 2);
                return null;
            }
            this.initSelectableScales();
            return this.mtgTranslator.getMTGRootNode();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void initSelectableScales() {
        boolean[] blArray = new boolean[View.SCALE_COUNT];
        for (int i = 0; i < View.SCALE_COUNT; ++i) {
            blArray[i] = false;
        }
        Workbench.current().setProperty(MTGKeys.MTG_SCALES_VISIBLE, (Object)blArray);
        Workbench.current().setProperty(MTGKeys.MTG_SCALES_CHANGED, (Object)new Boolean(false));
    }

    private String getGeneratedFileName(VirtualFileReaderSource virtualFileReaderSource, boolean bl) {
        Object object = virtualFileReaderSource.getFile();
        String string = null;
        if (virtualFileReaderSource.getFileSystem() instanceof MemoryFileSystem) {
            string = virtualFileReaderSource.getFileSystem().getName(object);
        } else if (virtualFileReaderSource.getFileSystem() instanceof LocalFileSystem) {
            File file = (File)object;
            string = file.getName();
        }
        if (string.endsWith(".mtg")) {
            string = string.substring(0, string.length() - 4);
        }
        if (bl) {
            return string + "-generated.xl";
        }
        return string + "-generated";
    }

    private void deleteGeneratedFile(VirtualFileReaderSource virtualFileReaderSource) {
        String string = this.getGeneratedFileName(virtualFileReaderSource, true);
        try {
            FileSystem fileSystem = Registry.current().getFileSystem();
            Object object = fileSystem.getParent(virtualFileReaderSource.getFile());
            Object object2 = fileSystem.getFile(object, string);
            if (object2 != null) {
                fileSystem.delete(object2);
            }
        }
        finally {
            return;
        }
        {
        }
    }

    private void removeGeneratedFileFromFileExpl(VirtualFileReaderSource virtualFileReaderSource) {
        String string = this.getGeneratedFileName(virtualFileReaderSource, true);
        Item item = Workbench.current().getRegistry().getDirectory("/project/objects/files", null);
        for (Node node = item.getBranch(); node != null; node = node.getSuccessor()) {
            SourceFile sourceFile;
            if (!(node instanceof SourceFile) || !(sourceFile = (SourceFile)node).getName().equals("pfs:" + string)) continue;
            sourceFile.remove();
        }
    }

    private Object generateFileAndCompile(VirtualFileReaderSource virtualFileReaderSource, MTGModuleBuilder mTGModuleBuilder) {
        try {
            FileSystem fileSystem = Registry.current().getFileSystem();
            String string = this.getGeneratedFileName(virtualFileReaderSource, true);
            this.deleteGeneratedFile(virtualFileReaderSource);
            this.removeGeneratedFileFromFileExpl(virtualFileReaderSource);
            Object object = null;
            object = fileSystem instanceof MemoryFileSystem ? fileSystem.create(fileSystem.getRoot(), string, false) : fileSystem.create(fileSystem.getParent(virtualFileReaderSource.getFile()), string, false);
            FileSource fileSource = new FileSource(fileSystem, object, IO.toSystemId((FileSystem)fileSystem, (Object)object), new MimeType("text/x-grogra-xl", null), Registry.current(), null);
            OutputStream outputStream = fileSource.getOutputStream(false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            mTGModuleBuilder.writeTypes(bufferedWriter);
            bufferedWriter.flush();
            outputStream.flush();
            if (fileSystem instanceof MemoryFileSystem) {
                ((MemoryFileSystem)fileSystem).closeQuiet(object);
            }
            SourceFile sourceFile = new SourceFile(IO.toSystemId((FileSystem)Registry.current().getFileSystem(), (Object)object), new MimeType("text/x-grogra-xl", null));
            Registry.current().getDirectory("/project/objects/files", null).addUserItem((Item)sourceFile);
            sourceFile.activate();
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

