/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.vmx;

import de.grogra.xl.vmx.Authorization;
import de.grogra.xl.vmx.VMXState;

public abstract class AbruptCompletion
extends RuntimeException {
    final VMXState vmx;

    AbruptCompletion(VMXState vMXState) {
        this.vmx = vMXState;
    }

    public abstract int getLabel();

    public abstract void dispose();

    public static final class Nonlocal
    extends Error {
        final VMXState vmx;
        VMXState.VMXFrame frame;
        AbruptCompletion reason;

        Nonlocal(VMXState vMXState) {
            this.vmx = vMXState;
        }

        public AbruptCompletion getReason(Authorization authorization) {
            if (this.vmx.isCurrentFrame(this.frame)) {
                this.vmx.check(authorization);
                AbruptCompletion abruptCompletion = this.reason;
                this.reason = null;
                this.vmx.dispose(this);
                return abruptCompletion;
            }
            throw this;
        }
    }

    public static final class Throw
    extends AbruptCompletion {
        public static final int LABEL = -2;
        Throwable cause;

        Throw(VMXState vMXState) {
            super(vMXState);
            this.initCause(null);
        }

        public int getLabel() {
            return -2;
        }

        public void dispose() {
            this.cause = null;
            this.vmx.dispose(this);
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Throwable getCauseAndDispose() {
            Throwable throwable = this.cause;
            this.cause = null;
            this.vmx.dispose(this);
            return throwable;
        }
    }

    public static final class Break
    extends AbruptCompletion {
        int label;

        Break(VMXState vMXState) {
            super(vMXState);
        }

        public void dispose() {
            this.vmx.dispose(this);
        }

        public int getLabel() {
            return this.label;
        }
    }

    public static final class Return
    extends AbruptCompletion {
        public static final int LABEL = -1;
        int etype;
        int ival;
        long lval;
        float fval;
        double dval;
        Object aval;

        Return(VMXState vMXState) {
            super(vMXState);
        }

        public int getLabel() {
            return -1;
        }

        public void dispose() {
            this.aval = null;
            this.vmx.dispose(this);
        }

        public int getTypeId() {
            return this.etype;
        }

        public int iget() {
            if ((1 << this.etype & 0x7C) == 0) {
                throw new IllegalStateException("type = " + this.etype + ", expected I_VALUE");
            }
            this.dispose();
            return this.ival;
        }

        public long lget() {
            if (this.etype != 7) {
                throw new IllegalStateException("type = " + this.etype + ", expected LONG");
            }
            this.dispose();
            return this.lval;
        }

        public float fget() {
            if (this.etype != 8) {
                throw new IllegalStateException("type = " + this.etype + ", expected FLOAT");
            }
            this.dispose();
            return this.fval;
        }

        public double dget() {
            if (this.etype != 9) {
                throw new IllegalStateException("type = " + this.etype + ", expected DOUBLE");
            }
            this.dispose();
            return this.dval;
        }

        public Object aget() {
            if (this.etype != 0) {
                throw new IllegalStateException("type = " + this.etype + ", expected OBJECT");
            }
            Object object = this.aval;
            this.dispose();
            return object;
        }

        public void vget() {
            if (this.etype != 1) {
                throw new IllegalStateException("type = " + this.etype + ", expected VOID");
            }
            this.dispose();
        }
    }
}

