/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.Cache;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.ContextDependentBase;
import de.grogra.math.BSpline;
import de.grogra.math.BSplineCurveList;
import de.grogra.math.BSplineSurface;
import de.grogra.math.KnotVectorImpl;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.xl.util.FloatList;
import javax.vecmath.SingularMatrixException;

public class SkinnedSurface
extends ContextDependentBase
implements BSplineSurface {
    BSplineCurveList profiles;
    int vDegree = 3;
    boolean interpolateProfiles = true;
    boolean centripetalParameters = true;
    public static final Type $TYPE = new Type(SkinnedSurface.class);
    public static final SCOType.Field profiles$FIELD = Type._addManagedField($TYPE, "profiles", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(BSplineCurveList.class), null, 0);
    public static final SCOType.Field vDegree$FIELD = Type._addManagedField($TYPE, "vDegree", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field interpolateProfiles$FIELD = Type._addManagedField($TYPE, "interpolateProfiles", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 2);
    public static final SCOType.Field centripetalParameters$FIELD = Type._addManagedField($TYPE, "centripetalParameters", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public boolean isInterpolateProfiles() {
        return this.interpolateProfiles;
    }

    public void setInterpolateProfiles(boolean bl) {
        this.interpolateProfiles = bl;
    }

    public boolean isCentripetalParameters() {
        return this.centripetalParameters;
    }

    public void setCentripetalParameters(boolean bl) {
        this.centripetalParameters = bl;
    }

    public int getVDegree() {
        return this.vDegree;
    }

    public void setVDegree(int n) {
        this.vDegree = n;
    }

    public BSplineCurveList getProfiles() {
        return this.profiles;
    }

    public void setProfiles(BSplineCurveList bSplineCurveList) {
        profiles$FIELD.setObject((Object)this, (Object)bSplineCurveList);
    }

    public SkinnedSurface() {
        this(null);
    }

    public SkinnedSurface(BSplineCurveList bSplineCurveList) {
        this.profiles = bSplineCurveList;
    }

    public boolean dependsOnContext() {
        return this.profiles.dependsOnContext();
    }

    public void writeStamp(Cache.Entry entry, GraphState graphState) {
        super.writeStamp(entry, graphState);
        this.profiles.writeStamp(entry, graphState);
    }

    protected float[] getCache(GraphState graphState) {
        Object[] objectArray;
        FloatList floatList;
        float[] fArray = (float[])graphState.getObjectContext().getValue((Object)this);
        if (fArray != null) {
            return fArray;
        }
        int n = 0;
        boolean bl = false;
        int n2 = this.profiles.getSize(graphState);
        int n3 = Math.min(this.vDegree, n2 - 1);
        if (n2 <= 0) {
            floatList = new FloatList(3);
        } else {
            floatList = new FloatList(8 + n2 + n3 + this.profiles.getSize(0, graphState) * (1 + 4 * n2));
            objectArray = BSpline.makeCompatible(floatList, this.profiles, 0.001f, 4, true, graphState);
            if (objectArray != null && objectArray[2] > true) {
                n = (int)objectArray[0];
                bl = objectArray[1];
                n2 = (int)objectArray[2];
            } else {
                n2 = 0;
            }
        }
        if (n2 > 0) {
            n3 = Math.min(this.vDegree, n2 - 1);
            objectArray = new float[n2];
            KnotVectorImpl knotVectorImpl = new KnotVectorImpl(new float[n2 + n3 + 1]);
            fArray = floatList.elements;
            BSpline.calculateKnotsAndParameters(fArray, n2 - 1, n * 4, n3, this.centripetalParameters, knotVectorImpl, objectArray);
            try {
                if (n3 > 1 && this.interpolateProfiles) {
                    BSpline.interpolate(fArray, n2 - 1, n * 4, n3, knotVectorImpl, objectArray, new float[n2], new float[n3 + 1], new float[n3 + 1]);
                }
                for (int i = 0; i <= n2 + n3; ++i) {
                    floatList.push(knotVectorImpl.getKnot(0, i, null));
                }
            }
            catch (SingularMatrixException singularMatrixException) {
                n = 0;
                bl = false;
                n2 = 0;
            }
        }
        floatList.push(0.0f);
        floatList.push(0.0f);
        floatList.push(0.0f);
        fArray = floatList.elements;
        fArray[fArray.length - 3] = n;
        fArray[fArray.length - 2] = (float)bl;
        fArray[fArray.length - 1] = n2;
        graphState.getObjectContext().setValue((Object)this, (Object)fArray);
        return fArray;
    }

    public int getUDegree(GraphState graphState) {
        float[] fArray = this.getCache(graphState);
        return (int)fArray[fArray.length - 2];
    }

    public int getVDegree(GraphState graphState) {
        return Math.min(this.vDegree, this.getVSize(graphState) - 1);
    }

    public int getUSize(GraphState graphState) {
        float[] fArray = this.getCache(graphState);
        return (int)fArray[fArray.length - 3];
    }

    public int getVSize(GraphState graphState) {
        float[] fArray = this.getCache(graphState);
        return (int)fArray[fArray.length - 1];
    }

    public int getVertexIndex(int n, int n2, GraphState graphState) {
        return n2 * this.getUSize(graphState) + n;
    }

    public int getDimension(GraphState graphState) {
        return 4;
    }

    public int getVertex(float[] fArray, int n, GraphState graphState) {
        float[] fArray2 = this.getCache(graphState);
        n *= 4;
        int n2 = 4 > fArray.length ? fArray.length : 4;
        for (int i = 0; i < n2; ++i) {
            fArray[i] = fArray2[n++];
        }
        return n2;
    }

    public float getKnot(int n, int n2, GraphState graphState) {
        float[] fArray = this.getCache(graphState);
        int n3 = (int)fArray[fArray.length - 3];
        return fArray[n == 0 ? n3 * this.getVSize(graphState) * 4 + n2 : n3 * (this.getVSize(graphState) * 4 + 1) + (int)fArray[fArray.length - 2] + 1 + n2];
    }

    public boolean isRational(GraphState graphState) {
        return true;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 4;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(SkinnedSurface skinnedSurface, SCOType sCOType) {
            super((Object)skinnedSurface, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 2: {
                    ((SkinnedSurface)object).interpolateProfiles = bl;
                    return;
                }
                case 3: {
                    ((SkinnedSurface)object).centripetalParameters = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((SkinnedSurface)object).isInterpolateProfiles();
                }
                case 3: {
                    return ((SkinnedSurface)object).isCentripetalParameters();
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 1: {
                    ((SkinnedSurface)object).vDegree = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 1: {
                    return ((SkinnedSurface)object).getVDegree();
                }
            }
            return super.getInt(object, n);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 0: {
                    ((SkinnedSurface)object).profiles = (BSplineCurveList)object2;
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((SkinnedSurface)object).getProfiles();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new SkinnedSurface();
        }
    }
}

