/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.math;

import de.grogra.graph.Cache;
import de.grogra.graph.GraphState;
import de.grogra.math.BSplineCurve;
import de.grogra.math.BSplineCurveList;
import de.grogra.math.BSplineOfVertices;
import de.grogra.math.BSplineSurface;
import de.grogra.math.KnotVector;
import de.grogra.math.KnotVectorImpl;
import de.grogra.math.Pool;
import de.grogra.math.VertexGridImpl;
import de.grogra.math.VertexListImpl;
import de.grogra.util.EnumerationType;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import javax.vecmath.Tuple4f;

public final class BSpline {
    public static final EnumerationType SPLINE_PLANE_TYPE = new EnumerationType("splinePlane", new String[]{"XY", "XZ", "YZ"});

    private BSpline() {
    }

    public static boolean isValid(BSplineCurve bSplineCurve, GraphState graphState) {
        int n;
        return bSplineCurve != null && (n = bSplineCurve.getDegree(graphState)) > 0 && bSplineCurve.getSize(graphState) > n;
    }

    public static boolean isValid(BSplineSurface bSplineSurface, GraphState graphState) {
        int n;
        return bSplineSurface != null && (n = bSplineSurface.getUDegree(graphState)) > 0 && bSplineSurface.getUSize(graphState) > n && (n = bSplineSurface.getVDegree(graphState)) > 0 && bSplineSurface.getVSize(graphState) > n;
    }

    public static float getDefaultKnot(int n, int n2, boolean bl, boolean bl2, int n3) {
        if (!bl && n3 <= n2) {
            return 0.0f;
        }
        if (!bl && n3 >= n) {
            return 1.0f;
        }
        if (!bl2) {
            return (float)(n3 - n2) / (float)(n - n2);
        }
        return n3 > 0 ? (float)((n3 - 1) / n2 * n2) / (float)(n - 1) : (float)((1 - n3) / n2 * n2) / (float)(1 - n);
    }

    public static void makeDefaultKnotVector(float[] fArray, int n, int n2, int n3, boolean bl) {
        for (int i = n2 + n3; i >= 0; --i) {
            fArray[n + i] = BSpline.getDefaultKnot(n2, n3, bl, false, i);
        }
    }

    public static int findSpan(int n, int n2, float f, KnotVector knotVector, int n3, GraphState graphState) {
        int n4;
        if (f <= knotVector.getKnot(n3, n2, graphState)) {
            return n2;
        }
        if (f >= knotVector.getKnot(n3, n + 1, graphState)) {
            return n;
        }
        int n5 = n2;
        int n6 = n + 1;
        while (true) {
            if (f < knotVector.getKnot(n3, n4 = n5 + n6 >> 1, graphState)) {
                n6 = n4;
                continue;
            }
            if (!(f >= knotVector.getKnot(n3, n4 + 1, graphState))) break;
            n5 = n4;
        }
        return n4;
    }

    public static void calculateBasisFunctions(float[] fArray, int n, KnotVector knotVector, int n2, int n3, float f, GraphState graphState, float[] fArray2, float[] fArray3) {
        fArray[0] = 1.0f;
        for (int i = 1; i <= n; ++i) {
            fArray2[i] = f - knotVector.getKnot(n2, n3 + 1 - i, graphState);
            fArray3[i - 1] = knotVector.getKnot(n2, n3 + i, graphState) - f;
            float f2 = 0.0f;
            for (int j = 0; j < i; ++j) {
                float f3 = fArray[j] / (fArray3[j] + fArray2[i - j]);
                fArray[j] = f2 + fArray3[j] * f3;
                f2 = fArray2[i - j] * f3;
            }
            fArray[i] = f2;
        }
    }

    public static void calculateDerivatives(float[] fArray, int n, KnotVector knotVector, int n2, int n3, float f, int n4, GraphState graphState, float[] fArray2, float[] fArray3, float[] fArray4) {
        int n5;
        fArray4[0] = 1.0f;
        int n6 = n + 1;
        for (n5 = 1; n5 <= n; ++n5) {
            fArray2[n5] = f - knotVector.getKnot(n2, n3 + 1 - n5, graphState);
            fArray3[n5 - 1] = knotVector.getKnot(n2, n3 + n5, graphState) - f;
            float f2 = 0.0f;
            for (int i = 0; i < n5; ++i) {
                float f3 = fArray3[i] + fArray2[n5 - i];
                fArray4[n5 * n6 + i] = f3;
                float f4 = fArray4[i * n6 + n5 - 1] / f3;
                fArray4[i * n6 + n5] = f2 + fArray3[i] * f4;
                f2 = fArray2[n5 - i] * f4;
            }
            fArray4[n5 * (n6 + 1)] = f2;
        }
        for (n5 = n; n5 >= 0; --n5) {
            fArray[n5] = fArray4[n5 * n6 + n];
        }
        for (n5 = 0; n5 <= n; ++n5) {
            fArray2[0] = 1.0f;
            for (int i = 1; i <= n4; ++i) {
                int n7;
                float f5 = 0.0f;
                int n8 = n5 - i;
                int n9 = n - i;
                if (n5 >= i) {
                    fArray3[0] = fArray2[0] / fArray4[(n9 + 1) * n6 + n8];
                    f5 = fArray3[0] * fArray4[n8 * n6 + n9];
                }
                n3 = n5 - 1 <= n9 ? i - 1 : n - n5;
                int n10 = n7 = n8 >= -1 ? 1 : -n8;
                while (n7 <= n3) {
                    fArray3[n7] = (fArray2[n7] - fArray2[n7 - 1]) / fArray4[(n9 + 1) * n6 + n8 + n7];
                    f5 += fArray3[n7] * fArray4[(n8 + n7) * n6 + n9];
                    ++n7;
                }
                if (n5 <= n9) {
                    fArray3[i] = -fArray2[i - 1] / fArray4[(n9 + 1) * n6 + n5];
                    f5 += fArray3[i] * fArray4[n5 * n6 + n9];
                }
                fArray[i * n6 + n5] = f5;
                float[] fArray5 = fArray2;
                fArray2 = fArray3;
                fArray3 = fArray5;
            }
        }
        n3 = n;
        for (n5 = 1; n5 <= n4; ++n5) {
            for (int i = n; i >= 0; --i) {
                int n11 = n5 * n6 + i;
                fArray[n11] = fArray[n11] * (float)n3;
            }
            n3 *= n - n5;
        }
    }

    public static void evaluate(float[] fArray, BSplineCurve bSplineCurve, float f, GraphState graphState) {
        int n;
        int n2 = bSplineCurve.getDegree(graphState);
        int n3 = Math.min(fArray.length, bSplineCurve.getDimension(graphState));
        for (n = n3 - 1; n >= 0; --n) {
            fArray[n] = 0.0f;
        }
        n = BSpline.findSpan(bSplineCurve.getSize(graphState) - 1, n2, f, bSplineCurve, 0, graphState);
        Pool pool = Pool.get(graphState);
        float[] fArray2 = pool.getFloatArray(0, n2 + 1);
        float[] fArray3 = pool.getFloatArray(1, Math.max(n2 + 1, n3));
        float[] fArray4 = pool.getFloatArray(2, n2 + 1);
        BSpline.calculateBasisFunctions(fArray2, n2, bSplineCurve, 0, n, f, graphState, fArray3, fArray4);
        n -= n2;
        while (n2 >= 0) {
            f = fArray2[n2];
            bSplineCurve.getVertex(fArray3, n + n2, graphState);
            for (int i = n3 - 1; i >= 0; --i) {
                int n4 = i;
                fArray[n4] = fArray[n4] + f * fArray3[i];
            }
            --n2;
        }
    }

    public static void evaluate(float[] fArray, BSplineSurface bSplineSurface, float f, float f2, GraphState graphState) {
        int n;
        int n2 = bSplineSurface.getUSize(graphState) - 1;
        int n3 = bSplineSurface.getUDegree(graphState);
        int n4 = bSplineSurface.getVSize(graphState) - 1;
        int n5 = bSplineSurface.getVDegree(graphState);
        int n6 = BSpline.findSpan(n2, n3, f, bSplineSurface, 0, graphState);
        int n7 = BSpline.findSpan(n4, n5, f2, bSplineSurface, 1, graphState);
        Pool pool = Pool.get(graphState);
        float[] fArray2 = pool.getFloatArray(0, n3 + 1);
        float[] fArray3 = pool.getFloatArray(1, n5 + 1);
        float[] fArray4 = pool.getFloatArray(2, Math.max(fArray.length, Math.max(n3, n5)) + 1);
        float[] fArray5 = pool.getFloatArray(3, Math.max(n3, n5) + 1);
        BSpline.calculateBasisFunctions(fArray2, n3, bSplineSurface, 0, n6, f, graphState, fArray4, fArray5);
        BSpline.calculateBasisFunctions(fArray3, n5, bSplineSurface, 1, n7, f2, graphState, fArray4, fArray5);
        n2 = Math.min(fArray.length, bSplineSurface.getDimension(graphState));
        for (n = n2 - 1; n >= 0; --n) {
            fArray[n] = 0.0f;
        }
        n6 -= n3;
        n7 -= n5;
        while (n5 >= 0) {
            f2 = fArray3[n5];
            for (n4 = n3; n4 >= 0; --n4) {
                f = fArray2[n4] * f2;
                bSplineSurface.getVertex(fArray4, bSplineSurface.getVertexIndex(n6 + n4, n7 + n5, graphState), graphState);
                for (n = n2 - 1; n >= 0; --n) {
                    int n8 = n;
                    fArray[n8] = fArray[n8] + f * fArray4[n];
                }
            }
            --n5;
        }
    }

    public static void calculateKnotsAndParameters(float[] fArray, int n, int n2, int n3, boolean bl, KnotVectorImpl knotVectorImpl, float[] fArray2) {
        int n4;
        int n5 = n + n3 + 1;
        float f = 0.0f;
        for (n4 = n; n4 > 0; --n4) {
            float f2 = 0.0f;
            for (int i = 0; i < n2; ++i) {
                float f3 = fArray[n4 * n2 + i] - fArray[(n4 - 1) * n2 + i];
                f2 += f3 * f3;
            }
            fArray2[n4] = bl ? (float)Math.sqrt(Math.sqrt(f2)) : (float)Math.sqrt(f2);
            f += fArray2[n4];
        }
        for (n4 = n3; n4 >= 0; --n4) {
            knotVectorImpl.data[n4] = 0.0f;
            knotVectorImpl.data[n5 - n4] = 1.0f;
        }
        fArray2[0] = 0.0f;
        fArray2[n] = 1.0f;
        f = 1.0f / f;
        for (n4 = 1; n4 < n; ++n4) {
            fArray2[n4] = fArray2[n4 - 1] + f * fArray2[n4];
        }
        f = 0.0f;
        for (n4 = 1; n4 < n3; ++n4) {
            f += fArray2[n4];
        }
        float f4 = 1.0f / (float)n3;
        for (int i = 0; i < n - n3; ++i) {
            knotVectorImpl.data[n3 + i + 1] = f4 * (f += fArray2[i + n3] - fArray2[i]);
        }
    }

    public static void interpolate(float[] fArray, int n, int n2, int n3, KnotVectorImpl knotVectorImpl, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        GMatrix gMatrix = new GMatrix(n + 1, n + 1);
        for (int i = 0; i <= n; ++i) {
            int n4 = BSpline.findSpan(n, n3, fArray2[i], knotVectorImpl, 0, null);
            BSpline.calculateBasisFunctions(fArray3, n3, knotVectorImpl, 0, n4, fArray2[i], null, fArray4, fArray5);
            for (int j = 0; j <= n3; ++j) {
                gMatrix.setElement(i, n4 - n3 + j, (double)fArray3[j]);
            }
        }
        GMatrix gMatrix2 = new GMatrix(n + 1, n + 1);
        GVector gVector = new GVector(n + 1);
        gMatrix.LUD(gMatrix2, gVector);
        GVector gVector2 = new GVector(n + 1);
        GVector gVector3 = new GVector(n + 1);
        for (int i = 0; i < n2; ++i) {
            int n5;
            for (n5 = 0; n5 <= n; ++n5) {
                gVector2.setElement(n5, (double)fArray[n5 * n2 + i]);
            }
            gVector3.LUDBackSolve(gMatrix2, gVector2, gVector);
            for (n5 = 0; n5 <= n; ++n5) {
                fArray[n5 * n2 + i] = (float)gVector3.getElement(n5);
            }
        }
    }

    public static void refineKnotVector(BSplineCurve bSplineCurve, float[] fArray, float[] fArray2, int n, float[] fArray3, int n2, GraphState graphState, float[] fArray4) {
        int n3;
        int n4 = bSplineCurve.getSize(graphState) - 1;
        int n5 = bSplineCurve.getDegree(graphState);
        int n6 = n4 + n5 + 1;
        int n7 = fArray.length - 1;
        int n8 = BSpline.findSpan(n4, n5, fArray[0], bSplineCurve, 0, graphState);
        int n9 = BSpline.findSpan(n4, n5, fArray[n7], bSplineCurve, 0, graphState) + 1;
        int n10 = bSplineCurve.getDimension(graphState);
        for (n3 = n8 - n5; n3 >= 0; --n3) {
            bSplineCurve.getVertex(fArray4, n3, graphState);
            FloatList.arraycopy((float[])fArray4, (int)0, (float[])fArray3, (int)(n2 + n3 * n10), (int)n10);
        }
        for (n3 = n9 - 1; n3 <= n4; ++n3) {
            bSplineCurve.getVertex(fArray4, n3, graphState);
            FloatList.arraycopy((float[])fArray4, (int)0, (float[])fArray3, (int)(n2 + (n3 + n7 + 1) * n10), (int)n10);
        }
        for (n3 = n8; n3 >= 0; --n3) {
            fArray2[n + n3] = bSplineCurve.getKnot(0, n3, graphState);
        }
        for (n3 = n9 + n5; n3 <= n6; ++n3) {
            fArray2[n + n3 + n7 + 1] = bSplineCurve.getKnot(0, n3, graphState);
        }
        int n11 = n9 + n5 - 1;
        int n12 = n9 + n5 + n7;
        for (n3 = n7; n3 >= 0; --n3) {
            float f;
            while (n11 > n8) {
                float f2;
                f = bSplineCurve.getKnot(0, n11, graphState);
                if (!(fArray[n3] <= f2)) break;
                fArray2[n + n12] = f;
                bSplineCurve.getVertex(fArray4, --n11 - n5, graphState);
                FloatList.arraycopy((float[])fArray4, (int)0, (float[])fArray3, (int)(n2 + (--n12 - n5) * n10), (int)n10);
            }
            int n13 = n2 + (n12 - n5) * n10;
            FloatList.arraycopy((float[])fArray3, (int)n13, (float[])fArray3, (int)(n13 - n10), (int)n10);
            for (n13 = 1; n13 <= n5; ++n13) {
                int n14 = n2 + (n12 - n5 + n13) * n10;
                f = fArray2[n + n12 + n13] - fArray[n3];
                if (f == 0.0f) {
                    FloatList.arraycopy((float[])fArray3, (int)n14, (float[])fArray3, (int)(n14 - n10), (int)n10);
                    continue;
                }
                f /= fArray2[n + n12 + n13] - bSplineCurve.getKnot(0, n11 - n5 + n13, graphState);
                for (int i = n10 - 1; i >= 0; --i) {
                    fArray3[n14 - n10 + i] = f * fArray3[n14 - n10 + i] + (1.0f - f) * fArray3[n14 + i];
                }
            }
            fArray2[n + n12--] = fArray[n3];
        }
    }

    public static void raiseDegreeInsertKnots(BSplineCurve bSplineCurve, boolean bl, int[] nArray, int n, float[] fArray, int[] nArray2, float[] fArray2, GraphState graphState, float[] fArray3) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = bSplineCurve.getSize(graphState);
        int n6 = bSplineCurve.getDegree(graphState) + 1;
        int n7 = bSplineCurve.getDimension(graphState);
        int n8 = fArray3.length;
        for (n3 = nArray.length - 2; n3 >= 0; --n3) {
            if (nArray[n3] <= 0) continue;
            while (n4 < n6) {
                bSplineCurve.getVertex(fArray3, --n5, graphState);
                FloatList.arraycopy((float[])fArray3, (int)(2 * n7), (float[])fArray3, (int)n7, (int)n7);
                FloatList.arraycopy((float[])fArray3, (int)0, (float[])fArray3, (int)(2 * n7), (int)n7);
                for (n2 = 1; n2 <= n4; ++n2) {
                    float f = (float)(n6 - n2) / (bSplineCurve.getKnot(0, n5 + n6, graphState) - bSplineCurve.getKnot(0, n5 + n2, graphState));
                    for (int i = n7 - 1; i >= 0; --i) {
                        float f2;
                        fArray3[i] = f2 = f * (fArray3[n7 + i] - fArray3[i]);
                        fArray3[n7 + i] = fArray3[(2 + n2) * n7 + i];
                        fArray3[(2 + n2) * n7 + i] = f2;
                    }
                }
                if (!bl && (n2 = n6 - 2 - n5) >= 0) {
                    int n9 = (2 + n6 + n2) * n7;
                    FloatList.arraycopy((float[])fArray3, (int)((2 + n2) * n7), (float[])fArray3, (int)n9, (int)n7);
                    while (--n2 >= 0) {
                        float f = (bSplineCurve.getKnot(0, n6 - 1, graphState) - bSplineCurve.getKnot(0, n5 + n6, graphState)) / (float)(n6 - n2 - 1);
                        for (int i = n7 - 1; i >= 0; --i) {
                            int n10 = --n9;
                            fArray3[n10] = fArray3[n10] + f * fArray3[n9 + n7];
                        }
                    }
                }
                ++n4;
            }
            n2 = nArray[n3];
            FloatList.arraycopy((float[])fArray3, (int)(((n4 -= nArray[n3]) + 2) * n7), (float[])fArray3, (int)(n8 -= n7 * n2), (int)(n7 * n2));
        }
        if (!bl) {
            FloatList.arraycopy((float[])fArray3, (int)((2 + n6) * n7), (float[])fArray3, (int)n8, (int)((n6 - 2) * n7));
        }
        n3 = 0;
        for (int i = 0; i < nArray.length - 1; ++i) {
            n3 = nArray[i];
            for (int j = n; j > n - nArray2[i + 1]; --j) {
                for (n2 = 1; n2 <= n4; ++n2) {
                    float f = (fArray[n5 + n] - fArray[n5 - 1 + n2]) / (float)(n + 1 - n2);
                    for (int k = n7 - 1; k >= 0; --k) {
                        int n11 = (1 + n2) * n7 + k;
                        fArray3[n11] = fArray3[n11] + f * fArray3[(2 + n2) * n7 + k];
                    }
                }
                if (n3 > 0) {
                    FloatList.arraycopy((float[])fArray3, (int)n8, (float[])fArray3, (int)((n6 - n3 + 2) * n7), (int)(n7 * n3));
                    n8 += n7 * n3;
                    n3 = 0;
                }
                n4 = j < n6 ? j : n6 - 1;
                FloatList.arraycopy((float[])fArray3, (int)(2 * n7), (float[])fArray2, (int)(n7 * n5++), (int)n7);
            }
        }
    }

    public static int[] makeCompatible(FloatList floatList, BSplineCurveList bSplineCurveList, float f, int n, boolean bl, GraphState graphState) {
        int[] nArray;
        int n2;
        int n3;
        int n4 = bSplineCurveList.getSize(graphState);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            n3 = bSplineCurveList.getDegree(i, graphState);
            if (n3 <= 0 || bSplineCurveList.getSize(i, graphState) <= n3) continue;
            ++n7;
            int n8 = bSplineCurveList.getDimension(i, graphState);
            n6 += n8;
            if (n8 <= n5) continue;
            n5 = n8;
        }
        if (n7 == 0) {
            return null;
        }
        if (bSplineCurveList.areCurvesCompatible(graphState)) {
            int n9;
            n3 = bSplineCurveList.getDegree(0, graphState);
            n2 = bSplineCurveList.getSize(0, graphState);
            nArray = new int[3];
            float[] fArray = new float[n5];
            for (n9 = 0; n9 < n4; ++n9) {
                int n10 = (n > 0 ? n : bSplineCurveList.getDimension(n9, graphState)) - 1;
                boolean bl2 = bSplineCurveList.isRational(n9, graphState);
                for (int i = 0; i < n2; ++i) {
                    int n11 = bSplineCurveList.getVertex(fArray, n9, i, graphState);
                    if (bl2 && bl) {
                        --n11;
                    }
                    for (int j = 0; j <= n10; ++j) {
                        if (bl) {
                            floatList.push(j < n11 ? fArray[j] : (j < n10 ? 0.0f : (bl2 ? fArray[n11] : 1.0f)));
                            continue;
                        }
                        floatList.push(j < n11 ? fArray[j] : 0.0f);
                    }
                }
            }
            for (n9 = 0; n9 <= n2 + n3; ++n9) {
                floatList.push(bSplineCurveList.getKnot(0, n9, graphState));
            }
        } else {
            float f2;
            boolean[] blArray = new boolean[n4];
            float[] fArray = new float[n4];
            float[] fArray2 = new float[n4];
            int[] nArray2 = new int[Math.max(3, n4)];
            nArray = nArray2;
            int[] nArray3 = new int[n4];
            int[] nArray4 = new int[n4];
            IntList intList = new IntList();
            IntList intList2 = new IntList();
            FloatList floatList2 = new FloatList();
            FloatList floatList3 = new FloatList();
            IntList intList3 = new IntList();
            n3 = 0;
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = bSplineCurveList.getSize(i, graphState);
                nArray3[i] = bSplineCurveList.getDegree(i, graphState);
                int n12 = nArray3[i];
                if (n12 <= 0 || nArray2[i] <= n12) continue;
                if (n12 > n3) {
                    n3 = n12;
                }
                float f3 = bSplineCurveList.getKnot(i, n12, graphState);
                fArray[i] = f2 = 1.0f / (bSplineCurveList.getKnot(i, nArray2[i], graphState) - f3);
                fArray2[i] = -f2 * f3;
                boolean bl3 = blArray[i] = (f3 - bSplineCurveList.getKnot(i, 0, graphState)) * f2 < f;
                if (n12 + 1 >= nArray2[i]) continue;
                f3 = (bSplineCurveList.getKnot(i, n12 + 1, graphState) - f3) * f2;
                nArray4[i] = n12 + 1;
                n12 = floatList3.binarySearch(f3);
                if (n12 < 0) {
                    n12 ^= 0xFFFFFFFF;
                }
                floatList3.add(n12, f3);
                intList3.add(n12, i);
            }
            if (n3 == 0) {
                nArray = null;
                n2 = 0;
            } else {
                int n13;
                BSpline.writeKnot(0.0f, n3 + 1, intList2, floatList2);
                float f4 = -1.0f;
                float f5 = -1.0f;
                while (true) {
                    int n14;
                    int n15;
                    boolean bl4;
                    float f6 = f2 = (bl4 = floatList3.isEmpty()) ? 0.0f : floatList3.removeAt(0);
                    if (bl4 || f2 >= f5) {
                        if (f4 >= 0.0f) {
                            n15 = 0;
                            n14 = intList.size - n4;
                            for (int i = 0; i < n4; ++i) {
                                int n16 = intList.elements[n14 + i] + n3 - nArray3[i];
                                if (n16 <= n15) continue;
                                n15 = n16;
                            }
                            BSpline.writeKnot(f4, n15, intList2, floatList2);
                        }
                        if (bl4) break;
                        f4 = f2;
                        f5 = f2 + f;
                        for (n15 = 0; n15 < n4; ++n15) {
                            intList.add(0);
                        }
                    }
                    n15 = intList3.removeAt(0);
                    n14 = nArray4[n15];
                    while (++n14 < nArray2[n15]) {
                        float f7;
                        f2 = fArray[n15] * bSplineCurveList.getKnot(n15, n14, graphState) + fArray2[n15];
                        if (f7 < f5) continue;
                    }
                    int n17 = intList.size - n4 + n15;
                    intList.elements[n17] = intList.elements[n17] + (n14 - nArray4[n15]);
                    nArray4[n15] = n14;
                    if (n14 >= nArray2[n15]) continue;
                    n14 = floatList3.binarySearch(f2);
                    if (n14 < 0) {
                        n14 ^= 0xFFFFFFFF;
                    }
                    floatList3.add(n14, f2);
                    intList3.add(n14, n15);
                }
                BSpline.writeKnot(1.0f, n3 + 1, intList2, floatList2);
                int[] nArray5 = intList2.toArray();
                float[] fArray3 = floatList2.toArray();
                int[] nArray6 = new int[nArray5.length];
                n2 = fArray3.length - n3 - 1;
                float[] fArray4 = new float[n6 * (2 + n3 + fArray3.length)];
                VertexListImpl vertexListImpl = new VertexListImpl(new float[n5 * n2], 0);
                float[] fArray5 = vertexListImpl.data;
                BSplineOfVertices bSplineOfVertices = new BSplineOfVertices(vertexListImpl, 0, false, false);
                bSplineOfVertices.knots = new float[fArray3.length];
                for (n13 = 0; n13 < n4; ++n13) {
                    int n18;
                    int n19;
                    if (nArray3[n13] <= 0 || nArray2[n13] <= nArray3[n13]) continue;
                    int n20 = vertexListImpl.dimension = bSplineCurveList.getDimension(n13, graphState);
                    for (n19 = nArray2[n13] - 1; n19 >= 0; --n19) {
                        bSplineCurveList.getVertex(fArray4, n13, n19, graphState);
                        for (n18 = n20 - 1; n18 >= 0; --n18) {
                            fArray5[n19 * n20 + n18] = fArray4[n18];
                        }
                    }
                    n19 = 0;
                    for (n18 = nArray6.length - 2; n18 > 0; --n18) {
                        nArray6[n18] = intList.elements[n13 + (n18 - 1) * n4];
                        n19 |= nArray6[n18] != nArray5[n18] ? 1 : 0;
                    }
                    if (n19 != 0 || !blArray[n13] || nArray3[n13] != n3) {
                        bSplineOfVertices.degree = nArray3[n13];
                        bSplineOfVertices.size = nArray2[n13];
                        for (n18 = nArray2[n13] + nArray3[n13]; n18 >= 0; --n18) {
                            bSplineOfVertices.knots[n18] = fArray[n13] * bSplineCurveList.getKnot(n13, n18, graphState) + fArray2[n13];
                        }
                        int n21 = nArray3[n13] + 1;
                        nArray6[nArray6.length - 1] = n21;
                        nArray6[0] = n21;
                        BSpline.raiseDegreeInsertKnots(bSplineOfVertices, blArray[n13], nArray6, n3, fArray3, nArray5, fArray5, graphState, fArray4);
                    }
                    n18 = (n > 0 ? n : n20) - 1;
                    boolean bl5 = bSplineCurveList.isRational(n13, graphState);
                    int n22 = bl5 && bl ? n20 - 1 : n20;
                    for (int i = 0; i < n2; ++i) {
                        int n23 = i * n20;
                        for (int j = 0; j <= n18; ++j) {
                            if (bl) {
                                floatList.push(j < n22 ? fArray5[n23 + j] : (j < n18 ? 0.0f : (bl5 ? fArray5[n23 + n22] : 1.0f)));
                                continue;
                            }
                            floatList.push(j < n22 ? fArray5[n23 + j] : 0.0f);
                        }
                    }
                }
                for (n13 = 0; n13 <= n2 + n3; ++n13) {
                    floatList.push(fArray3[n13]);
                }
            }
        }
        if (nArray != null) {
            nArray[0] = n2;
            nArray[1] = n3;
            nArray[2] = n7;
        }
        return nArray;
    }

    private static void writeKnot(float f, int n, IntList intList, FloatList floatList) {
        intList.add(n);
        while (--n >= 0) {
            floatList.add(f);
        }
    }

    public static void decomposeSplineConnection(BezierSegmentVisitor bezierSegmentVisitor, BSplineCurve bSplineCurve, Pool pool, GraphState graphState) {
        int n = bSplineCurve.getDegree(graphState);
        int n2 = bSplineCurve.getDimension(graphState);
        Pool pool2 = Pool.push(graphState);
        float[] fArray = pool2.getFloatArray(0, (n + 1) * n2);
        float[] fArray2 = pool2.getFloatArray(1, n2);
        float[] fArray3 = pool2.getFloatArray(2, n2);
        float[] fArray4 = pool2.getFloatArray(3, n2);
        float[] fArray5 = pool2.getFloatArray(4, n2);
        float[] fArray6 = pool.getFloatArray(0, 3);
        bSplineCurve.getVertex(fArray2, 0, graphState);
        bSplineCurve.getVertex(fArray4, 1, graphState);
        double d = Math.sqrt((fArray2[0] - fArray4[0]) * (fArray2[0] - fArray4[0]) + (fArray2[1] - fArray4[1]) * (fArray2[1] - fArray4[1]));
        float f = (float)((double)fArray6[0] * Math.sqrt(d) / 6.0);
        fArray5[0] = (fArray2[0] + fArray4[0]) / 2.0f;
        fArray5[1] = (fArray2[1] + fArray4[1]) / 2.0f;
        if (fArray2[0] != fArray4[0]) {
            float f2 = (fArray4[1] - fArray2[1]) / (fArray4[0] - fArray2[0]);
            if (fArray2[0] < fArray4[0]) {
                fArray3[1] = fArray5[1] + (float)((double)f / Math.sqrt(1.0f + f2 * f2));
                fArray3[0] = fArray5[0] - (fArray3[1] - fArray5[1]) * f2;
            } else {
                fArray3[1] = fArray5[1] - (float)((double)f / Math.sqrt(1.0f + f2 * f2));
                fArray3[0] = fArray5[0] - (fArray3[1] - fArray5[1]) * f2;
            }
        } else {
            float f3 = (fArray4[0] - fArray2[0]) / (fArray4[1] - fArray2[1]);
            if (fArray2[1] < fArray4[1]) {
                fArray3[0] = fArray5[0] - (float)((double)f / Math.sqrt(1.0f + f3 * f3));
                fArray3[1] = fArray5[1] - (fArray3[0] - fArray5[0]) * f3;
            } else {
                fArray3[0] = fArray5[0] + (float)((double)f / Math.sqrt(1.0f + f3 * f3));
                fArray3[1] = fArray5[1] - (fArray3[0] - fArray5[0]) * f3;
            }
        }
        fArray6[1] = fArray3[0] - fArray5[0];
        fArray6[2] = fArray3[1] - fArray5[1];
        FloatList.arraycopy((float[])fArray2, (int)0, (float[])fArray, (int)0, (int)n2);
        FloatList.arraycopy((float[])fArray3, (int)0, (float[])fArray, (int)(1 * n2), (int)n2);
        FloatList.arraycopy((float[])fArray4, (int)0, (float[])fArray, (int)(2 * n2), (int)n2);
        bezierSegmentVisitor.visit(100, fArray, n2, n, 100.0f, 100.0f);
        pool2.pop(graphState);
    }

    public static void decompose(BezierSegmentVisitor bezierSegmentVisitor, BSplineCurve bSplineCurve, boolean bl, GraphState graphState) {
        int n = bSplineCurve.getSize(graphState) - 1;
        int n2 = bSplineCurve.getDegree(graphState);
        int n3 = bSplineCurve.getDimension(graphState);
        int n4 = n + n2 + 1;
        int n5 = n2;
        int n6 = n2 + 1;
        Pool pool = Pool.push(graphState);
        float[] fArray = pool.getFloatArray(0, n6 * n3);
        float[] fArray2 = pool.getFloatArray(1, n2 * n3);
        float[] fArray3 = pool.getFloatArray(2, n6);
        for (int i = n2; i >= 0; --i) {
            bSplineCurve.getVertex(fArray, i, graphState);
            if (i <= 0) continue;
            FloatList.arraycopy((float[])fArray, (int)0, (float[])fArray, (int)(i * n3), (int)n3);
        }
        if (bSplineCurve.getKnot(0, n5, graphState) == 10000.0f) {
            bezierSegmentVisitor.visit(100, fArray, n3, n2, 100.0f, 100.0f);
        } else {
            int n7;
            int n8;
            float f;
            float f2 = f = bSplineCurve.getKnot(0, n5, graphState);
            float f3 = 1.0f / (bSplineCurve.getKnot(0, n + 1, graphState) - f);
            if (n5 > 1 && bSplineCurve.getKnot(0, 1, graphState) < f) {
                n8 = n2;
                while (bSplineCurve.getKnot(0, --n8, graphState) >= f) {
                }
                FloatList.arraycopy((float[])fArray, (int)0, (float[])fArray2, (int)0, (int)(n3 * (n8 + 1)));
                for (n7 = 1; n7 <= n8; ++n7) {
                    for (int i = 0; i <= n8 - n7; ++i) {
                        float f4 = bSplineCurve.getKnot(0, i + n7, graphState);
                        f4 = (f - f4) / (bSplineCurve.getKnot(0, i + n2 + 1, graphState) - f4);
                        for (int j = n3 - 1; j >= 0; --j) {
                            fArray2[i * n3 + j] = f4 * fArray2[(i + 1) * n3 + j] + (1.0f - f4) * fArray2[i * n3 + j];
                        }
                    }
                }
                FloatList.arraycopy((float[])fArray2, (int)0, (float[])fArray, (int)0, (int)(n3 * n8));
            }
            n8 = -1;
            while (n6 <= n + 1) {
                n7 = n6;
                float f5 = bSplineCurve.getKnot(0, n6, graphState);
                while (n6 < n4 && bSplineCurve.getKnot(0, n6 + 1, graphState) <= f5) {
                    ++n6;
                }
                int n9 = n6 - n7 + 1;
                if (n9 < n2) {
                    float f6 = f5 - f;
                    for (n7 = n2; n7 > n9; --n7) {
                        fArray3[n7 - n9 - 1] = f6 / (bSplineCurve.getKnot(0, n5 + n7, graphState) - f);
                    }
                    int n10 = n2 - n9;
                    for (int i = 1; i <= n10; ++i) {
                        int n11 = n9 + i;
                        int n12 = (n2 + 1) * n3;
                        for (int j = n2; j >= n11; --j) {
                            float f7 = fArray3[j - n11];
                            for (n7 = n3; n7 > 0; --n7) {
                                fArray[--n12] = f7 * fArray[n12] + (1.0f - f7) * fArray[n12 - n3];
                            }
                        }
                        if (n6 >= n4) continue;
                        FloatList.arraycopy((float[])fArray, (int)(n2 * n3), (float[])fArray2, (int)((n10 - i) * n3), (int)n3);
                    }
                }
                bezierSegmentVisitor.visit(++n8, fArray, n3, n2, bl ? (f - f2) * f3 : f, bl ? (f5 - f2) * f3 : f5);
                if (n6 > n) break;
                n5 = n2 - n9;
                for (n7 = n2; n7 >= n5; --n7) {
                    bSplineCurve.getVertex(fArray, n6 - n2 + n7, graphState);
                    if (n7 <= 0) continue;
                    FloatList.arraycopy((float[])fArray, (int)0, (float[])fArray, (int)(n7 * n3), (int)n3);
                }
                FloatList.arraycopy((float[])fArray2, (int)0, (float[])fArray, (int)0, (int)(n5 * n3));
                n5 = n6++;
                f = f5;
            }
        }
        pool.pop(graphState);
    }

    public static void decompose(final BezierPatchVisitor bezierPatchVisitor, final BSplineSurface bSplineSurface, final boolean bl, final GraphState graphState, final VertexGridImpl vertexGridImpl) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper
        implements BSplineCurve,
        BezierSegmentVisitor {
            private final boolean uvPermuted;
            private final int firstDir;
            private final int d;
            private final boolean rational;
            private int dir;
            private float[] data;
            private final int[] deg;
            private final int[] size;
            private int findex;
            private float fLeft;
            private float fRight;
            private final float[] cpoData;

            Helper() {
                this.deg = new int[]{bSplineSurface.getUDegree(graphState), bSplineSurface.getVDegree(graphState)};
                this.size = new int[]{bSplineSurface.getUSize(graphState), bSplineSurface.getVSize(graphState)};
                this.uvPermuted = this.size[1] > this.size[0];
                this.firstDir = this.uvPermuted ? 1 : 0;
                this.dir = this.firstDir;
                this.d = bSplineSurface.getDimension(graphState);
                this.rational = bSplineSurface.isRational(graphState);
                if (vertexGridImpl != null) {
                    int n = this.d - (this.rational ? 1 : 0);
                    vertexGridImpl.setDimension(n);
                    this.cpoData = new float[n * this.size[0] * this.size[1]];
                    vertexGridImpl.setData(this.cpoData);
                    vertexGridImpl.setUCount(this.size[0]);
                } else {
                    this.cpoData = null;
                }
            }

            public boolean dependsOnContext() {
                return true;
            }

            public void writeStamp(Cache.Entry entry, GraphState graphState2) {
            }

            @Override
            public int getDegree(GraphState graphState2) {
                return this.deg[this.dir];
            }

            @Override
            public boolean isRational(GraphState graphState2) {
                return this.rational;
            }

            @Override
            public int getSize(GraphState graphState2) {
                return this.size[this.dir];
            }

            @Override
            public int getDimension(GraphState graphState2) {
                return this.d * (this.dir == this.firstDir ? this.size[this.dir ^ 1] : this.deg[this.firstDir] + 1);
            }

            @Override
            public int getVertex(float[] fArray, int n, GraphState graphState2) {
                if (this.dir == this.firstDir) {
                    if (this.dir == 0) {
                        for (int i = this.size[1] - 1; i >= 0; --i) {
                            bSplineSurface.getVertex(fArray, bSplineSurface.getVertexIndex(n, i, graphState2), graphState2);
                            if (this.cpoData != null) {
                                if (this.rational) {
                                    int n2 = (n + i * this.size[0]) * (this.d - 1);
                                    float f = 1.0f / fArray[this.d - 1];
                                    for (int j = this.d - 2; j >= 0; --j) {
                                        this.cpoData[n2 + j] = fArray[j] * f;
                                    }
                                } else {
                                    FloatList.arraycopy((float[])fArray, (int)0, (float[])this.cpoData, (int)((n + i * this.size[0]) * this.d), (int)this.d);
                                }
                            }
                            if (i <= 0) continue;
                            FloatList.arraycopy((float[])fArray, (int)0, (float[])fArray, (int)(i * this.d), (int)this.d);
                        }
                    } else {
                        for (int i = this.size[0] - 1; i >= 0; --i) {
                            bSplineSurface.getVertex(fArray, bSplineSurface.getVertexIndex(i, n, graphState2), graphState2);
                            if (this.cpoData != null) {
                                if (this.rational) {
                                    int n3 = (i + n * this.size[0]) * (this.d - 1);
                                    float f = 1.0f / fArray[this.d - 1];
                                    for (int j = this.d - 2; j >= 0; --j) {
                                        this.cpoData[n3 + j] = fArray[j] * f;
                                    }
                                } else {
                                    FloatList.arraycopy((float[])fArray, (int)0, (float[])this.cpoData, (int)((i + n * this.size[0]) * this.d), (int)this.d);
                                }
                            }
                            if (i <= 0) continue;
                            FloatList.arraycopy((float[])fArray, (int)0, (float[])fArray, (int)(i * this.d), (int)this.d);
                        }
                    }
                    return this.size[this.dir ^ 1] * this.d;
                }
                n *= this.d;
                int n4 = this.deg[this.firstDir] + 1;
                int n5 = this.size[this.dir] * this.d;
                for (int i = 0; i < n4; ++i) {
                    FloatList.arraycopy((float[])this.data, (int)(n + n5 * i), (float[])fArray, (int)(this.d * i), (int)this.d);
                }
                return this.d * n4;
            }

            @Override
            public float getKnot(int n, int n2, GraphState graphState2) {
                return bSplineSurface.getKnot(this.dir, n2, graphState2);
            }

            @Override
            public void visit(int n, float[] fArray, int n2, int n3, float f, float f2) {
                if (this.dir == this.firstDir) {
                    this.data = fArray;
                    this.dir = this.firstDir ^ 1;
                    this.findex = n;
                    this.fLeft = f;
                    this.fRight = f2;
                    BSpline.decompose(this, this, bl, graphState);
                    this.dir = this.firstDir;
                } else {
                    bezierPatchVisitor.visit(this.findex, n, fArray, this.d, this.deg[this.firstDir], n3, this.fLeft, this.fRight, f, f2, this.uvPermuted);
                }
            }
        }
        Helper helper = new Helper();
        BSpline.decompose(helper, helper, bl, graphState);
    }

    public static void set(Tuple4f tuple4f, float[] fArray, int n, boolean bl) {
        tuple4f.w = bl ? fArray[--n] : 1.0f;
        tuple4f.x = fArray[0];
        tuple4f.y = n > 1 ? fArray[1] : 0.0f;
        tuple4f.z = n > 2 ? fArray[2] : 0.0f;
    }

    public static void set(Tuple4f tuple4f, float[] fArray, int n, int n2, boolean bl) {
        tuple4f.w = bl ? fArray[--n2 + n] : 1.0f;
        tuple4f.x = fArray[n];
        tuple4f.y = n2 > 1 ? fArray[n + 1] : 0.0f;
        tuple4f.z = n2 > 2 ? fArray[n + 2] : 0.0f;
    }

    public static int set(float[] fArray, float f, float f2) {
        switch (fArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                fArray[0] = f;
                return 1;
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
        return 2;
    }

    public static int set(float[] fArray, float f, float f2, float f3) {
        switch (fArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                fArray[0] = f;
                return 1;
            }
            case 2: {
                fArray[0] = f;
                fArray[1] = f2;
                return 2;
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        return 3;
    }

    public static int set(float[] fArray, float f, float f2, float f3, float f4) {
        switch (fArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                fArray[0] = f;
                return 1;
            }
            case 2: {
                fArray[0] = f;
                fArray[1] = f2;
                return 2;
            }
            case 3: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                return 3;
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        return 4;
    }

    public static int set(float[] fArray, float f, float f2, float f3, float f4, float f5, float f6) {
        switch (fArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                fArray[0] = f;
                return 1;
            }
            case 2: {
                fArray[0] = f;
                fArray[1] = f2;
                return 2;
            }
            case 3: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                return 3;
            }
            case 4: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = f4;
                return 4;
            }
            case 5: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = f4;
                fArray[4] = f5;
                return 5;
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        return 6;
    }

    public static int set(float[] fArray, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        switch (fArray.length) {
            case 0: {
                return 0;
            }
            case 1: {
                fArray[0] = f;
                return 1;
            }
            case 2: {
                fArray[0] = f;
                fArray[1] = f2;
                return 2;
            }
            case 3: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                return 3;
            }
            case 4: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = f4;
                return 4;
            }
            case 5: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = f4;
                fArray[4] = f5;
                return 5;
            }
            case 6: {
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = f4;
                fArray[4] = f5;
                fArray[5] = f6;
                return 6;
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray[6] = f7;
        return 7;
    }

    public static interface BezierPatchVisitor {
        public void visit(int var1, int var2, float[] var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, boolean var11);
    }

    public static interface BezierSegmentVisitor {
        public void visit(int var1, float[] var2, int var3, int var4, float var5, float var6);
    }
}

