/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.parser;

import de.grogra.grammar.BooleanLiteral;
import de.grogra.grammar.CharStart;
import de.grogra.grammar.SingleLineCommentStart;
import de.grogra.grammar.StartEndCommentStart;
import de.grogra.grammar.StringStart;
import de.grogra.grammar.Token;
import de.grogra.grammar.Tokenizer;
import de.grogra.xl.parser.XLTokenTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

public final class XLTokenizer
extends Tokenizer
implements XLTokenTypes {
    private static XLTokenizer INSTANCE = new XLTokenizer();

    public XLTokenizer(Reader reader, String string) {
        this();
        this.setSource(new BufferedReader(reader), string);
    }

    public XLTokenizer() {
        super(104);
        if (INSTANCE != null) {
            this.copyTokenTablesFrom(INSTANCE);
            return;
        }
        this.addToken((Token)new StartEndCommentStart("/*", "*/"));
        this.addToken((Token)new SingleLineCommentStart());
        this.addToken((Token)new StringStart());
        this.addToken((Token)new CharStart());
        this.addToken((Token)new BooleanLiteral(false), "false");
        this.addToken((Token)new BooleanLiteral(true), "true");
        this.addToken(13, "package");
        this.addToken(14, "module");
        this.addToken(15, "class");
        this.addToken(16, "interface");
        this.addToken(19, "import");
        this.addToken(21, "extends");
        this.addToken(22, "implements");
        this.addToken(25, "super");
        this.addToken(30, "throws");
        this.addToken(31, ";");
        this.addToken(34, "=");
        this.addToken(37, "void");
        this.addToken(38, "boolean");
        this.addToken(39, "byte");
        this.addToken(40, "short");
        this.addToken(41, "char");
        this.addToken(42, "int");
        this.addToken(43, "long");
        this.addToken(44, "float");
        this.addToken(45, "double");
        this.addToken(61, "<");
        this.addToken(62, ">");
        this.addToken(63, "---");
        this.addToken(64, "<->");
        this.addToken(65, "<+");
        this.addToken(66, "+>");
        this.addToken(67, "-+-");
        this.addToken(68, "<+>");
        this.addToken(69, "</");
        this.addToken(70, "/>");
        this.addToken(71, "-/-");
        this.addToken(72, "</>");
        this.addToken(77, "(*");
        this.addToken(82, ".");
        this.addToken(85, "-");
        this.addToken(86, "<-");
        this.addToken(87, "->");
        this.addToken(90, "?");
        this.addToken(91, "*");
        this.addToken(92, "+");
        this.addToken(96, "==>");
        this.addToken(97, "==>>");
        this.addToken(98, "::>");
        this.addToken(104, "~");
        this.addToken(105, "!");
        this.addToken(108, "/");
        this.addToken(109, "%");
        this.addToken(110, "**");
        this.addToken(111, "<<");
        this.addToken(112, ">>");
        this.addToken(113, ">>>");
        this.addToken(114, "<=");
        this.addToken(115, ">=");
        this.addToken(116, "<=>");
        this.addToken(117, "!=");
        this.addToken(118, "==");
        this.addToken(119, "|");
        this.addToken(120, "^");
        this.addToken(121, "&");
        this.addToken(122, "||");
        this.addToken(123, "&&");
        this.addToken(128, "this");
        this.addToken(130, "if");
        this.addToken(131, "return");
        this.addToken(132, "yield");
        this.addToken(133, "throw");
        this.addToken(134, "synchronized");
        this.addToken(135, "assert");
        this.addToken(137, "break");
        this.addToken(138, "continue");
        this.addToken(139, "try");
        this.addToken(140, "catch");
        this.addToken(141, "finally");
        this.addToken(144, "for");
        this.addToken(146, "while");
        this.addToken(147, "do");
        this.addToken(148, "switch");
        this.addToken(150, "case");
        this.addToken(151, "default");
        this.addToken(152, "null");
        this.addToken(154, "<--");
        this.addToken(155, "-->");
        this.addToken(156, "<-->");
        this.addToken(157, "instanceof");
        this.addToken(159, "`");
        this.addToken(160, "+=");
        this.addToken(161, "-=");
        this.addToken(162, "*=");
        this.addToken(163, "/=");
        this.addToken(164, "%=");
        this.addToken(165, "**=");
        this.addToken(166, ">>=");
        this.addToken(167, ">>>=");
        this.addToken(168, "<<=");
        this.addToken(169, "&=");
        this.addToken(170, "^=");
        this.addToken(171, "|=");
        this.addToken(172, ":=");
        this.addToken(173, ":'=");
        this.addToken(174, ":+=");
        this.addToken(175, ":-=");
        this.addToken(176, ":*=");
        this.addToken(177, ":/=");
        this.addToken(178, ":%=");
        this.addToken(179, ":**=");
        this.addToken(180, ":|=");
        this.addToken(181, ":&=");
        this.addToken(182, ":^=");
        this.addToken(183, ":<<=");
        this.addToken(184, ":>>=");
        this.addToken(185, ":>>>=");
        this.addToken(186, "++");
        this.addToken(187, "--");
        this.addToken(190, "in");
        this.addToken(191, "::");
        this.addToken(197, "new");
        this.addToken(200, "@");
        this.addToken(201, "private");
        this.addToken(202, "public");
        this.addToken(203, "protected");
        this.addToken(204, "static");
        this.addToken(205, "transient");
        this.addToken(206, "final");
        this.addToken(207, "abstract");
        this.addToken(208, "native");
        this.addToken(209, "volatile");
        this.addToken(210, "strictfp");
        this.addToken(212, "const");
        this.addToken(213, "...");
        this.addToken(218, "else");
        this.addToken(219, "(");
        this.addToken(220, ")");
        this.addToken(221, "[");
        this.addToken(222, "]");
        this.addToken(223, "{");
        this.addToken(224, "}");
        this.addToken(225, ":");
        this.addToken(226, ",");
        this.addToken(227, "=>");
        this.addToken(228, "*)");
    }

    protected Token convert(Token token) {
        String string;
        if (token.getType() == 11 && (string = token.getText()).charAt(0) == '$') {
            if (string.equals("$yield")) {
                token.setText("yield");
            } else if (string.equals("$module")) {
                token.setText("module");
            } else if (string.equals("$in")) {
                token.setText("in");
            }
        }
        return token;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        XLTokenizer xLTokenizer = new XLTokenizer();
        xLTokenizer.setSource(new BufferedReader(new FileReader(file)), file.getName());
        while (xLTokenizer.getToken().getType() != 1) {
        }
        xLTokenizer = new XLTokenizer();
        xLTokenizer.setSource(new BufferedReader(new FileReader(file)), file.getName());
        long l = System.currentTimeMillis();
        int n = 0;
        while (xLTokenizer.nextToken().getType() != 1) {
            ++n;
        }
        l = System.currentTimeMillis() - l;
        System.err.println(l + " ms, " + (float)file.length() / (float)l + " byte/ms");
        System.err.println(n + " tokens");
    }
}

