/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Field;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.TypeLoader;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Assignment;
import de.grogra.xl.expr.Completable;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.GetProperty;
import de.grogra.xl.property.CompiletimeModel;
import de.grogra.xl.property.RuntimeModel;
import de.grogra.xl.property.RuntimeModelFactory;
import de.grogra.xl.vmx.VMXState;

public final class PropertyAssignment
extends Assignment
implements Completable {
    private Expression instance;
    private Expression indices;
    private Expression expr;
    private int indexCount;
    private CompiletimeModel.Property property;
    private RuntimeModel.Property rtProperty;
    private String modelString;
    private String propertyString;
    private Field propertyField;

    public PropertyAssignment(GetProperty getProperty, int n) {
        super(getProperty.getType(), n);
        this.property = getProperty.getProperty();
        this.modelString = this.property.getModel().getRuntimeName();
        this.propertyString = this.property.getRuntimeName();
    }

    public void complete(MethodScope methodScope) {
        if (this.getExpressionCount() > 2) {
            methodScope.createLocalForVMX();
        }
        this.propertyField = methodScope.getDeclaredType().getFieldForProperty(this.property);
    }

    private RuntimeModel.Property pushIndices(VMXState vMXState) {
        Expression expression;
        for (expression = this.indices; expression != this.expr; expression = expression.getNextExpression()) {
            expression.push(vMXState);
        }
        if (this.rtProperty == null) {
            expression = this.getTypeLoader();
            this.rtProperty = RuntimeModelFactory.getInstance().modelForName(this.modelString, expression.getClassLoader()).propertyForName(this.propertyString, (TypeLoader)expression);
        }
        return this.rtProperty;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        boolean bl;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            bl = this.expr.evaluateBoolean(vMXState);
            property.setBoolean(object, vMXState.popIntArray(this.indexCount), bl);
        } else {
            bl = property.getBoolean(object, vMXState.peekIntArray(this.indexCount));
            vMXState.ipush(bl ? 1 : 0);
            boolean bl2 = this.expr.evaluateBoolean(vMXState);
            property.setBoolean(object, vMXState.popIntArray(this.indexCount), bl2);
            if (this.assignmentType == 1) {
                bl = bl2;
            }
        }
        return bl;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        byte by;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            by = this.expr.evaluateByte(vMXState);
            property.setByte(object, vMXState.popIntArray(this.indexCount), by);
        } else {
            by = property.getByte(object, vMXState.peekIntArray(this.indexCount));
            vMXState.ipush((int)by);
            byte by2 = this.expr.evaluateByte(vMXState);
            property.setByte(object, vMXState.popIntArray(this.indexCount), by2);
            if (this.assignmentType == 1) {
                by = by2;
            }
        }
        return by;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        short s;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            s = this.expr.evaluateShort(vMXState);
            property.setShort(object, vMXState.popIntArray(this.indexCount), s);
        } else {
            s = property.getShort(object, vMXState.peekIntArray(this.indexCount));
            vMXState.ipush((int)s);
            short s2 = this.expr.evaluateShort(vMXState);
            property.setShort(object, vMXState.popIntArray(this.indexCount), s2);
            if (this.assignmentType == 1) {
                s = s2;
            }
        }
        return s;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        char c;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            c = this.expr.evaluateChar(vMXState);
            property.setChar(object, vMXState.popIntArray(this.indexCount), c);
        } else {
            c = property.getChar(object, vMXState.peekIntArray(this.indexCount));
            vMXState.ipush((int)c);
            char c2 = this.expr.evaluateChar(vMXState);
            property.setChar(object, vMXState.popIntArray(this.indexCount), c2);
            if (this.assignmentType == 1) {
                c = c2;
            }
        }
        return c;
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int n;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            n = this.expr.evaluateInt(vMXState);
            property.setInt(object, vMXState.popIntArray(this.indexCount), n);
        } else {
            n = property.getInt(object, vMXState.peekIntArray(this.indexCount));
            vMXState.ipush(n);
            int n2 = this.expr.evaluateInt(vMXState);
            property.setInt(object, vMXState.popIntArray(this.indexCount), n2);
            if (this.assignmentType == 1) {
                n = n2;
            }
        }
        return n;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long l;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            l = this.expr.evaluateLong(vMXState);
            property.setLong(object, vMXState.popIntArray(this.indexCount), l);
        } else {
            l = property.getLong(object, vMXState.peekIntArray(this.indexCount));
            vMXState.lpush(l);
            long l2 = this.expr.evaluateLong(vMXState);
            property.setLong(object, vMXState.popIntArray(this.indexCount), l2);
            if (this.assignmentType == 1) {
                l = l2;
            }
        }
        return l;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        float f;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            f = this.expr.evaluateFloat(vMXState);
            property.setFloat(object, vMXState.popIntArray(this.indexCount), f);
        } else {
            f = property.getFloat(object, vMXState.peekIntArray(this.indexCount));
            vMXState.fpush(f);
            float f2 = this.expr.evaluateFloat(vMXState);
            property.setFloat(object, vMXState.popIntArray(this.indexCount), f2);
            if (this.assignmentType == 1) {
                f = f2;
            }
        }
        return f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        double d;
        Object object = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            d = this.expr.evaluateDouble(vMXState);
            property.setDouble(object, vMXState.popIntArray(this.indexCount), d);
        } else {
            d = property.getDouble(object, vMXState.peekIntArray(this.indexCount));
            vMXState.dpush(d);
            double d2 = this.expr.evaluateDouble(vMXState);
            property.setDouble(object, vMXState.popIntArray(this.indexCount), d2);
            if (this.assignmentType == 1) {
                d = d2;
            }
        }
        return d;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object object;
        Object object2 = this.instance.evaluateObject(vMXState);
        RuntimeModel.Property property = this.pushIndices(vMXState);
        if (this.assignmentType == 0) {
            object = this.expr.evaluateObject(vMXState);
            property.setObject(object2, vMXState.popIntArray(this.indexCount), object);
        } else {
            object = property.getObject(object2, vMXState.peekIntArray(this.indexCount));
            vMXState.apush(object);
            Object object3 = this.expr.evaluateObject(vMXState);
            property.setObject(object2, vMXState.popIntArray(this.indexCount), object3);
            if (this.assignmentType == 1) {
                object = object3;
            }
        }
        return object;
    }

    public void link(boolean bl) {
        Expression expression;
        this.instance = this.getExpression(0, 0, bl);
        this.indices = this.instance.getNextExpression();
        this.indexCount = 0;
        if (expression == null) {
            this.expr = this.indices;
        } else {
            for (expression = this.indices.getNextExpression(); expression != null; expression = expression.getNextExpression()) {
                ++this.indexCount;
                this.expr = expression;
            }
        }
    }

    private void writeIndices(BytecodeWriter bytecodeWriter, boolean bl) {
        if (this.indexCount > 0) {
            bytecodeWriter.visitVMX();
            bytecodeWriter.visiticonst(this.indexCount);
            bytecodeWriter.visitMethodInsn(VMX_TYPE, bl ? "popIntArray" : "peekIntArray");
        } else {
            bytecodeWriter.visitFieldInsn(178, VMXState.class, "INT_0", "[I");
        }
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        bytecodeWriter.visitFieldInsn(178, this.propertyField, null);
        this.instance.write(bytecodeWriter, false);
        for (Expression expression = this.indices; expression != this.expr; expression = expression.getNextExpression()) {
            bytecodeWriter.visitVMX();
            expression.write(bytecodeWriter, false);
            bytecodeWriter.visitMethodInsn(VMX_TYPE, "ipush");
        }
        switch (this.assignmentType) {
            case 0: {
                this.expr.write(bytecodeWriter, false);
                if (!bl) {
                    bytecodeWriter.visitDupX2(this.etype);
                }
                this.writeIndices(bytecodeWriter, true);
                bytecodeWriter.visitSwap(this.etype, 0);
                bytecodeWriter.visitMethodInsn(this.propertyField.getType(), "set" + Reflection.getTypeSuffix((int)this.etype));
                break;
            }
            case 2: {
                if (!bl) {
                    bytecodeWriter.visitInsn(92);
                    this.writeIndices(bytecodeWriter, false);
                    bytecodeWriter.visitMethodInsn(this.propertyField.getType(), "get" + Reflection.getTypeSuffix((int)this.etype));
                    bytecodeWriter.visitCheckCast(this.getType());
                    bytecodeWriter.visitDupX2(this.etype);
                    this.expr.write(bytecodeWriter, false);
                    this.writeIndices(bytecodeWriter, true);
                    bytecodeWriter.visitSwap(this.etype, 0);
                    bytecodeWriter.visitMethodInsn(this.propertyField.getType(), "set" + Reflection.getTypeSuffix((int)this.etype));
                    break;
                }
            }
            case 1: {
                bytecodeWriter.visitInsn(92);
                this.writeIndices(bytecodeWriter, false);
                bytecodeWriter.visitMethodInsn(this.propertyField.getType(), "get" + Reflection.getTypeSuffix((int)this.etype));
                bytecodeWriter.visitCheckCast(this.getType());
                this.expr.write(bytecodeWriter, false);
                if (!bl) {
                    bytecodeWriter.visitDupX2(this.etype);
                }
                this.writeIndices(bytecodeWriter, true);
                bytecodeWriter.visitSwap(this.etype, 0);
                bytecodeWriter.visitMethodInsn(this.propertyField.getType(), "set" + Reflection.getTypeSuffix((int)this.etype));
            }
        }
    }
}

