/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Break;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.lang.Filter;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public class FilterGuard
extends Expression
implements LocalAccess,
Generator {
    private Expression expr;
    private Expression statement;
    private Expression breakExpr;
    private VMXState.Local vmxLocal;
    private Local local;

    public FilterGuard(Type type, Local local) {
        super(type);
        this.local = local;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.ipush(filter.ival);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return false;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.ipush(filter.ival);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.ipush(filter.ival);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.ipush(filter.ival);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return '\u0000';
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.ipush(filter.ival);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.lpush(filter.lval);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return 0L;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.fpush(filter.fval);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return 0.0f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            vMXState.dpush(filter.dval);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return 0.0;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Filter filter = (Filter)vMXState.aget(this.vmxLocal, null);
        this.expr.evaluateAsVoid(vMXState);
        if (filter.accept) {
            if (filter.aval != null && !this.getType().isInstance(filter.aval)) {
                throw new ClassCastException(filter.aval.getClass().getName() + " " + this.getType().getName());
            }
            vMXState.apush(filter.aval);
            this.statement.evaluateAsVoid(vMXState);
        }
        if (filter.isFinished()) {
            this.breakExpr.evaluateAsVoid(vMXState);
        }
        return null;
    }

    public int getLocalCount() {
        return 1;
    }

    public int getAccessType(int n) {
        return 3;
    }

    public Local getLocal(int n) {
        return this.local;
    }

    public void setLocal(int n, Local local) {
        this.local = local;
    }

    public void complete(MethodScope methodScope) {
        this.vmxLocal = this.local.createVMXLocal();
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
        this.add(new Break(breakTarget.getLabel()));
    }

    public void link(boolean bl) {
        this.checkExpressionCount(3);
        this.expr = this.getFirstExpression();
        this.statement = this.expr.getNextExpression();
        this.breakExpr = this.statement.getNextExpression();
    }

    protected String paramString() {
        return super.paramString() + ',' + this.local + ',' + this.vmxLocal;
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        this.expr.write(bytecodeWriter, true);
        bytecodeWriter.visitLoad(this.vmxLocal, this.local.getType());
        bytecodeWriter.visitInsn(89);
        bytecodeWriter.visitFieldInsn(180, Filter.class, "accept", "Z");
        Label label = new Label();
        bytecodeWriter.visitJumpInsn(153, label);
        bytecodeWriter.visitFieldInsn(180, Filter.class, Reflection.getJVMPrefix((int)this.etype) + "val", Reflection.getType((int)Reflection.getJVMTypeId((Type)this.getType())).getDescriptor());
        bytecodeWriter.visitVM2T(this.etype);
        this.statement.write(bytecodeWriter, true);
        bytecodeWriter.visitLoad(this.vmxLocal, this.local.getType());
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitMethodInsn(Filter.class, "isFinished");
        Label label2 = new Label();
        bytecodeWriter.visitJumpInsn(153, label2);
        this.breakExpr.write(bytecodeWriter, true);
        bytecodeWriter.visitLabel(label2);
        if (!bl) {
            bytecodeWriter.visitNull(this.etype);
        }
    }
}

