/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.BooleanConst;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.IllegalOperandTypeException;
import de.grogra.xl.expr.IntConst;
import de.grogra.xl.expr.ObjectConst;
import org.objectweb.asm.Label;

public abstract class Comparison
extends EvalExpression {
    protected Expression expr1;
    protected Expression expr2;
    protected int ctype = -1;

    public Comparison() {
        super(Type.BOOLEAN);
    }

    public abstract int getSupportedTypes();

    public final int getSupportedTypes(int n) {
        return n == 0 || n == 1 ? this.getSupportedTypes() : 0;
    }

    public void link(boolean bl) {
        this.checkExpressionCount(2);
        this.expr1 = this.getExpression(0);
        this.expr2 = this.getExpression(1);
        this.ctype = this.expr1.etype;
        if (this.ctype != this.expr2.etype) {
            throw new AssertionError();
        }
    }

    public Expression compile(Scope scope, Expression expression, Expression expression2) {
        int n = this.getPromotedType(expression, expression2);
        int n2 = this.getSupportedTypes();
        if (n >= 0) {
            int n3 = n;
            while (Reflection.isWideningConversion((int)n, (int)n3)) {
                if ((1 << n3 & n2) != 0) {
                    if (n3 != 0) {
                        Type type = Reflection.getType((int)n3);
                        expression = expression.implicitConversion(scope, type);
                        expression2 = expression2.implicitConversion(scope, type);
                    } else if (!Reflection.isCastableFrom((Type)expression.getType(), (Type)expression2.getType()) && !Reflection.isCastableFrom((Type)expression2.getType(), (Type)expression.getType())) {
                        throw new IllegalOperandTypeException(I18N.msg("expr.illegal-optype", (Object)this.getClass().getName()));
                    }
                    return this.add(expression).add(expression2);
                }
                ++n3;
            }
        }
        throw new IllegalOperandTypeException(I18N.msg("expr.illegal-optype", (Object)this.getClass().getName()));
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        this.writeConditional(bytecodeWriter, bl);
    }

    public boolean isConditional() {
        return true;
    }

    protected boolean isNullOrBooleanConst(Expression expression) {
        return this.ctype == 6 && expression instanceof IntConst ? ((IntConst)expression).value == 0 : (this.ctype == 0 && expression instanceof ObjectConst ? ((ObjectConst)expression).value == null : this.ctype == 2);
    }

    int writeBooleanEquals(BytecodeWriter bytecodeWriter, Label label, Label label2, boolean bl) {
        Expression expression;
        Expression expression2;
        if (this.isNullOrBooleanConst(this.expr1)) {
            expression2 = this.expr2;
            expression = this.expr1;
        } else {
            expression2 = this.expr1;
            expression = this.expr2;
        }
        if (expression instanceof BooleanConst) {
            boolean bl2 = ((BooleanConst)expression).value == bl;
            return expression2.writeConditional(bytecodeWriter, bl2 ? label : label2, bl2 ? label2 : label);
        }
        expression2.write(bytecodeWriter, false);
        Label label3 = new Label();
        expression.writeConditional(bytecodeWriter, null, label3);
        bytecodeWriter.visiticonst(1);
        bytecodeWriter.visitInsn(130);
        bytecodeWriter.visitLabel(label3);
        if (label2 == null) {
            if (label != null) {
                bytecodeWriter.visitJumpInsn(bl ? 153 : 154, label);
            } else {
                bytecodeWriter.visitInsn(87);
            }
        } else {
            bytecodeWriter.visitJumpInsn(bl ? 154 : 153, label2);
            if (label != null) {
                bytecodeWriter.visitJumpInsn(167, label);
            }
        }
        return 0;
    }

    int writeIntObjectComparison(BytecodeWriter bytecodeWriter, Label label, Label label2, int n, int n2, int n3, int n4, int n5, int n6) {
        Expression expression;
        Expression expression2;
        if (this.isNullOrBooleanConst(this.expr1)) {
            expression2 = this.expr2;
            expression = this.expr1;
            n = n3;
            n2 = n4;
        } else {
            expression2 = this.expr1;
            expression = this.expr2;
        }
        if (this.isNullOrBooleanConst(expression)) {
            expression2.write(bytecodeWriter, false);
            if (label2 == null) {
                if (label != null) {
                    bytecodeWriter.visitJumpInsn(n, label);
                } else {
                    bytecodeWriter.visitInsn(87);
                }
            } else {
                bytecodeWriter.visitJumpInsn(n2, label2);
                if (label != null) {
                    bytecodeWriter.visitJumpInsn(167, label);
                }
            }
        } else {
            expression2.write(bytecodeWriter, false);
            expression.write(bytecodeWriter, false);
            if (label2 == null) {
                if (label != null) {
                    bytecodeWriter.visitJumpInsn(n5, label);
                } else {
                    bytecodeWriter.visitInsn(88);
                }
            } else {
                bytecodeWriter.visitJumpInsn(n6, label2);
                if (label != null) {
                    bytecodeWriter.visitJumpInsn(167, label);
                }
            }
        }
        return 0;
    }

    int writeLFDComparison(BytecodeWriter bytecodeWriter, Label label, Label label2, int n, int n2, int n3) {
        this.expr1.write(bytecodeWriter, false);
        this.expr2.write(bytecodeWriter, false);
        bytecodeWriter.visitInsn(n);
        if (label2 == null) {
            if (label != null) {
                bytecodeWriter.visitJumpInsn(n2, label);
            } else {
                bytecodeWriter.visitInsn(87);
            }
        } else {
            bytecodeWriter.visitJumpInsn(n3, label2);
            if (label != null) {
                bytecodeWriter.visitJumpInsn(167, label);
            }
        }
        return 0;
    }
}

