/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.VMXState;

public final class Block
extends BreakTarget {
    private final boolean sequential;

    public Block() {
        this(false);
    }

    public static Block createSequentialBlock() {
        return new Block(true);
    }

    private Block(boolean bl) {
        this.sequential = bl;
    }

    public boolean isRequired(int n) {
        return false;
    }

    public boolean isSequentialBlock() {
        return this.sequential;
    }

    public boolean isEmpty() {
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            if (expression instanceof Block && ((Block)expression).isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void evaluate(VMXState vMXState) {
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            expression.evaluateAsVoid(vMXState);
        }
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        this.writeChildren(bytecodeWriter);
    }

    protected String paramString() {
        return super.paramString() + ",iterated=" + this.sequential;
    }
}

