/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.Extension;
import de.grogra.xl.compiler.InvalidQueryModel;
import de.grogra.xl.compiler.UseExtension;
import de.grogra.xl.compiler.scope.ImportOnDemandScope;
import de.grogra.xl.compiler.scope.InstanceScope;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.Package;
import de.grogra.xl.lang.ConversionType;
import de.grogra.xl.lang.ImplicitDoubleToFloat;
import de.grogra.xl.lang.UseConversions;
import de.grogra.xl.modules.DefaultModuleSuperclass;
import de.grogra.xl.modules.InstantiationProducerType;
import de.grogra.xl.property.CompiletimeModel;
import de.grogra.xl.property.UseModel;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scope {
    private Scope enclosing;
    private de.grogra.xl.query.CompiletimeModel queryModel;
    private boolean queryModelSet = false;
    private boolean d2FIsImplicit;
    private boolean d2FIsImplicitSet = false;
    private CompiletimeModel propertyModel;
    private Type<?> propertyModelAnnotationType;
    private boolean propertyModelSet = false;
    private Extension extension;
    private boolean extensionSet;
    private boolean conversionSet;
    private String[] conversions;

    Scope(Scope scope) {
        this.enclosing = scope;
    }

    public void insert(Scope scope) {
        Scope scope2 = this.enclosing;
        this.enclosing = scope;
        if (scope != null) {
            scope.getRoot().enclosing = scope2;
        }
    }

    public Scope getEnclosingScope() {
        return this.enclosing;
    }

    public final Scope getRoot() {
        Scope scope = this;
        while (scope.enclosing != null) {
            scope = scope.enclosing;
        }
        return scope;
    }

    public boolean encloses(Scope scope) {
        while (scope != null) {
            scope = scope.enclosing;
            if (scope != this) continue;
            return true;
        }
        return false;
    }

    public final boolean isShadowedBy(Scope scope) {
        if (this instanceof ImportOnDemandScope) {
            return !(scope instanceof ImportOnDemandScope);
        }
        if (scope instanceof ImportOnDemandScope) {
            return false;
        }
        if (this instanceof InstanceScope && !((InstanceScope)this).shadowsEnclosing) {
            return !(scope instanceof InstanceScope) || ((InstanceScope)scope).shadowsEnclosing || this.encloses(scope);
        }
        if (scope instanceof InstanceScope && !((InstanceScope)scope).shadowsEnclosing) {
            return false;
        }
        return this.encloses(scope);
    }

    public Type getOwnerOf(Member member) {
        return Reflection.getEnclosingType((Type)this.getDeclaredType(), (Member)member);
    }

    public CClass getDeclaredType() {
        return this.enclosing == null ? null : this.enclosing.getDeclaredType();
    }

    public Member getDeclaredEntity() {
        return null;
    }

    private <T extends Annotation> de.grogra.reflect.Annotation<T> getAnnotation(Class<T> clazz) {
        Member member = this.getDeclaredEntity();
        if (member == null) {
            return null;
        }
        Compiler compiler = this.getCompiler();
        return compiler != null ? compiler.getAnnotation(member, clazz, false) : Reflection.getDeclaredAnnotation((Member)member, clazz);
    }

    public de.grogra.xl.query.CompiletimeModel getQueryModel(Compiler compiler, AST aST) {
        if (!this.queryModelSet) {
            de.grogra.reflect.Annotation<de.grogra.xl.query.UseModel> annotation = this.getAnnotation(de.grogra.xl.query.UseModel.class);
            if (annotation != null) {
                this.queryModel = compiler.createModel(de.grogra.xl.query.CompiletimeModel.class, (Type)annotation.value("value"), aST);
                if (this.queryModel == null) {
                    this.queryModel = InvalidQueryModel.INSTANCE;
                }
            } else if (this.enclosing != null) {
                this.queryModel = this.enclosing.getQueryModel(compiler, aST);
            }
            this.queryModelSet = true;
        }
        return this.queryModel;
    }

    public CompiletimeModel getPropertyModel(Type type, Compiler compiler, AST aST) {
        if (!this.propertyModelSet) {
            de.grogra.reflect.Annotation<UseModel> annotation = this.getAnnotation(UseModel.class);
            if (annotation != null) {
                this.propertyModelAnnotationType = (Type)annotation.value("type");
                this.propertyModel = compiler.createModel(CompiletimeModel.class, (Type)annotation.value("model"), aST);
            }
            this.propertyModelSet = true;
        }
        if (this.propertyModelAnnotationType != null && Reflection.isSupertypeOrSame(this.propertyModelAnnotationType, (Type)type)) {
            return this.propertyModel;
        }
        if (this.enclosing != null) {
            return this.enclosing.getPropertyModel(type, compiler, aST);
        }
        return null;
    }

    public Extension getExtension() {
        if (!this.extensionSet) {
            de.grogra.reflect.Annotation<UseExtension> annotation = this.getAnnotation(UseExtension.class);
            if (annotation != null) {
                try {
                    this.extension = (Extension)((Type)annotation.value("value")).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.enclosing != null) {
                this.extension = this.enclosing.getExtension();
            }
            this.extensionSet = true;
        }
        return this.extension;
    }

    public Package getPackage() {
        return this.enclosing == null ? null : this.enclosing.getPackage();
    }

    public boolean isStatic() {
        return this.enclosing.isStatic();
    }

    public void findMembers(String string, int n, Members members) {
        if (this.enclosing != null) {
            this.enclosing.findMembers(string, n, members);
        }
    }

    public boolean isD2FImplicit() {
        if (!this.d2FIsImplicitSet) {
            de.grogra.reflect.Annotation<ImplicitDoubleToFloat> annotation = this.getAnnotation(ImplicitDoubleToFloat.class);
            if (annotation != null) {
                this.d2FIsImplicit = Boolean.TRUE.equals(annotation.value("value"));
            } else if (this.enclosing != null) {
                this.d2FIsImplicit = this.enclosing.isD2FImplicit();
            }
            this.d2FIsImplicitSet = true;
        }
        return this.d2FIsImplicit;
    }

    public boolean isEnabledConversion(ConversionType conversionType) {
        if (!this.conversionSet) {
            de.grogra.reflect.Annotation<UseConversions> annotation = this.getAnnotation(UseConversions.class);
            if (annotation != null) {
                this.conversions = (String[])annotation.value("value");
            } else if (this.enclosing != null) {
                this.enclosing.isEnabledConversion(conversionType);
                this.conversions = this.enclosing.conversions;
            } else {
                this.conversions = new String[]{ConversionType.VALUE_OF.name(), ConversionType.TO_TYPE.name(), ConversionType.TO_TYPE_IN_SCOPE.name(), ConversionType.CONVERSION_CONSTRUCTOR.name()};
            }
            this.conversionSet = true;
        }
        for (int i = 0; i < this.conversions.length; ++i) {
            if (!this.conversions[i].equals(conversionType.name())) continue;
            return true;
        }
        return false;
    }

    public Type<?> getDefaultModuleSuperclass() {
        Scope scope = this;
        while (scope != null) {
            de.grogra.reflect.Annotation<DefaultModuleSuperclass> annotation = scope.getAnnotation(DefaultModuleSuperclass.class);
            if (annotation != null) {
                return (Type)annotation.value("value");
            }
            scope = scope.enclosing;
        }
        return Type.OBJECT;
    }

    public Type<?> getInstantiationProducerType() {
        Scope scope = this;
        while (scope != null) {
            de.grogra.reflect.Annotation<InstantiationProducerType> annotation = scope.getAnnotation(InstantiationProducerType.class);
            if (annotation != null) {
                return (Type)annotation.value("value");
            }
            scope = scope.enclosing;
        }
        return null;
    }

    public Compiler getCompiler() {
        return this.enclosing != null ? this.enclosing.getCompiler() : null;
    }

    public void dump() {
        System.err.println(this);
        Scope scope = this;
        while ((scope = scope.getEnclosingScope()) != null) {
            System.err.print("  ");
            System.err.println(scope);
        }
    }
}

