/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.OpenArgument;
import de.grogra.xl.compiler.pattern.ArgumentDescription;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.pattern.PatternData;
import de.grogra.xl.compiler.pattern.Place;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.query.Pattern;

public final class SimplePatternData
extends PatternData {
    private final ArgumentDescription[] args;
    private final Place[] places;
    private final int in;
    private final int out;
    private final Pattern predicate;

    SimplePatternData(AST aST, Pattern pattern, ArgumentDescription[] argumentDescriptionArray, int n, int n2, int n3, int n4, AST aST2, int n5, int n6, PatternBuilder patternBuilder) {
        super(aST, n3, n4, aST2, n5, n6, patternBuilder);
        if (argumentDescriptionArray == null || argumentDescriptionArray.length < pattern.getParameterCount()) {
            ArgumentDescription[] argumentDescriptionArray2 = new ArgumentDescription[pattern.getParameterCount()];
            if (argumentDescriptionArray != null) {
                System.arraycopy(argumentDescriptionArray, 0, argumentDescriptionArray2, 0, argumentDescriptionArray.length);
            }
            argumentDescriptionArray = argumentDescriptionArray2;
        }
        this.predicate = pattern;
        this.args = argumentDescriptionArray;
        this.places = new Place[pattern.getParameterCount()];
        this.in = n;
        this.out = n2;
    }

    boolean hasInPlace() {
        return this.getInArgument() >= 0;
    }

    boolean hasOutPlace() {
        return this.getOutArgument() >= 0;
    }

    Place getInPlace(boolean bl) {
        int n = this.getInArgument();
        if (n < 0) {
            return null;
        }
        Place place = this.places[n];
        if (place == null && bl) {
            place = this.builder.getPlace(this, n);
        }
        return place;
    }

    Place getOutPlace(boolean bl) {
        int n = this.getOutArgument();
        if (n < 0) {
            return null;
        }
        Place place = this.places[n];
        if (place == null && bl) {
            place = this.builder.getPlace(this, n);
        }
        return place;
    }

    Type getLastNodeType() {
        int n = this.getOutArgument();
        return n < 0 ? this.builder.nodeType : this.predicate.getParameterType(n);
    }

    int getLabelArgument() {
        if (!this.isInClosed() || !this.isOutClosed() || this.inKind == 0 || this.outKind == 0 || this.in != this.out) {
            return -1;
        }
        return this.in;
    }

    Place[] getPlaces() {
        return this.places;
    }

    public Pattern getPattern() {
        return this.predicate;
    }

    private int getOutArgument() {
        return this.outKind == 0 ? -1 : this.out;
    }

    private int getInArgument() {
        return this.inKind == 0 ? -1 : this.in;
    }

    public String toString() {
        return "Simple " + this.dataId + " [" + this.predicate.getClass().getName() + ']';
    }

    void createSubPatterns() {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            ArgumentDescription argumentDescription = this.args[i];
            if (argumentDescription == null) continue;
            Expression expression = argumentDescription.expr;
            if (expression == null) {
                expression = argumentDescription.local.createGet();
            }
            this.addExpression(expression, this.predicate.getParameterType(i)).getPlaces()[0].map(this, i, this.pos);
        }
    }

    void mapLabeledArgs() {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            ArgumentDescription argumentDescription = this.args[i];
            if (argumentDescription == null) continue;
            if (argumentDescription.place != null) {
                argumentDescription.place.map(this, i, argumentDescription.ast);
                this.args[i] = null;
                continue;
            }
            if (argumentDescription.local != null && argumentDescription.local.isVariable(this.builder)) {
                this.builder.getPlace(argumentDescription.local).map(this, i, argumentDescription.ast);
                this.args[i] = null;
                continue;
            }
            if (!(argumentDescription.expr instanceof OpenArgument)) continue;
            AST aST = Compiler.getAST(argumentDescription.expr);
            if (aST != null) {
                Local local = this.builder.getScope().findLocal(aST.getText(), true);
                if (local == null || !local.isVariable(this.builder)) {
                    local = this.builder.declareVariable(aST, this.predicate.getParameterType(i));
                }
                this.builder.getPlace(local).map(this, i, aST);
            }
            this.args[i] = null;
        }
    }

    void mapUnlabeledArgs() {
        if (this.args == null) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.builder.getPlace(this, i);
        }
    }
}

