/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.IntersectionType;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.I18NBundle;
import de.grogra.util.Utils;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.ProblemReporter;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.pattern.Argument;
import de.grogra.xl.compiler.pattern.ArgumentDescription;
import de.grogra.xl.compiler.pattern.CompositeData;
import de.grogra.xl.compiler.pattern.PatternData;
import de.grogra.xl.compiler.pattern.PatternWrapper;
import de.grogra.xl.compiler.pattern.Place;
import de.grogra.xl.compiler.pattern.SimplePatternData;
import de.grogra.xl.compiler.pattern.TraversalData;
import de.grogra.xl.compiler.scope.BlockScope;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.Constant;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.GetLocal;
import de.grogra.xl.expr.InvokeVirtual;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.expr.ObjectConst;
import de.grogra.xl.expr.Return;
import de.grogra.xl.query.BuiltInPattern;
import de.grogra.xl.query.CompiletimeModel;
import de.grogra.xl.query.CompoundPattern;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.EdgePattern;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.query.TypePattern;
import de.grogra.xl.query.WrappedTypePattern;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.ExpressionPattern;
import de.grogra.xl.vmx.Routine;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder {
    public static boolean DEBUG = false;
    private static final I18NBundle I18N = Compiler.I18N;
    private static final Class TARGET_TYPE_MARK = Place.Mapping.class;
    private static final Type QS_TYPE = ClassAdapter.wrap(QueryState.class);
    protected final CompiletimeModel model;
    protected final PatternBuilder enclosing;
    protected final BlockScope scope;
    protected final Compiler compiler;
    protected final ProblemReporter problems;
    protected final Type nodeType;
    private final Local queryState;
    private int context;
    private int nextEdgeType = 1;
    private boolean includeJoinInContext = true;
    private boolean beginning = true;
    private boolean ending = false;
    private PatternData lastPred;
    private Type lastNodeType;
    private boolean allowOpenEnds;
    final ObjectList predicates = new ObjectList();
    private final ObjectList predicateStack = new ObjectList();
    private int textualPosition = 0;
    private final HashMap placesForLocals;
    private final ObjectList allPlaces;
    private final ObjectList variables = new ObjectList();
    private final ObjectList compositeChildren = new ObjectList();
    private final ObjectList<TraversalData> traversals = new ObjectList();
    private ObjectConst targetTypeExpr = new ObjectConst(null, Type.CLASS);
    private final int[] nextId;
    static final int NULL_ARGUMENT = 0;
    static final int CLOSED_ARGUMENT = 1;
    static final int OPEN_ARGUMENT = 2;

    public PatternBuilder(CompiletimeModel compiletimeModel, PatternBuilder patternBuilder, BlockScope blockScope, AST aST) {
        this.model = compiletimeModel;
        this.enclosing = patternBuilder;
        this.scope = blockScope;
        this.compiler = TypeScope.get(blockScope).getCompiler();
        this.problems = this.compiler.problems;
        this.nodeType = compiletimeModel.getNodeType();
        this.placesForLocals = patternBuilder != null ? patternBuilder.placesForLocals : new HashMap();
        this.allPlaces = patternBuilder != null ? patternBuilder.allPlaces : new ObjectList();
        this.nextId = patternBuilder != null ? patternBuilder.nextId : new int[3];
        this.queryState = patternBuilder != null ? patternBuilder.queryState : blockScope.declareLocal("qs.", 4112L, (Type)ClassAdapter.wrap(QueryState.class), aST);
        this.lastNodeType = this.nodeType;
    }

    public Local getQueryState() {
        return this.queryState;
    }

    int nextPlaceId() {
        int n = this.nextId[0];
        this.nextId[0] = n + 1;
        return n;
    }

    int nextPatternId() {
        int n = this.nextId[1];
        this.nextId[1] = n + 1;
        return n;
    }

    int nextArgumentId() {
        int n = this.nextId[2];
        this.nextId[2] = n + 1;
        return n;
    }

    public boolean enclosesOrEquals(PatternBuilder patternBuilder) {
        while (patternBuilder != null) {
            if (patternBuilder == this) {
                return true;
            }
            patternBuilder = patternBuilder.enclosing;
        }
        return false;
    }

    public void allowOpenEnds() {
        this.allowOpenEnds = true;
    }

    public CompiletimeModel getModel() {
        return this.model;
    }

    public BlockScope getScope() {
        return this.scope;
    }

    private ArgumentDescription[] getArgumentDescriptions(ObjectList objectList, int n) {
        ArgumentDescription[] argumentDescriptionArray = new ArgumentDescription[objectList.size() + n];
        for (int i = 0; i < objectList.size; ++i) {
            Local local = (Local)objectList.get(i);
            argumentDescriptionArray[n + i] = (local.getModifiersEx() & 0x20000000000L) != 0L ? null : new ArgumentDescription(null, local);
        }
        return argumentDescriptionArray;
    }

    public Local declareAuxVariable(Type type) {
        Local local = this.declareVariable("term.", type, null);
        local.getMethodScope().removeLocal(local);
        return local;
    }

    public Local declareWrapper(Local local, Type type, AST aST) {
        Local local2;
        assert (local.isVariable(this));
        local.wrapper = local2 = this.declareVariable(this.compiler.verifyNotDeclared('$' + local.getName(), this.scope, aST), type, aST);
        local2.wrapped = local;
        return local2;
    }

    public Local declareVariable(AST aST, Type type) {
        return this.declareVariable(aST.getText(), type, aST);
    }

    private Local declareVariable(String string, Type type, AST aST) {
        Object object;
        if (type.getTypeId() == 0) {
            object = new IntersectionType(this.compiler.getPackage().getName());
            object.intersect(type);
            type = object;
        }
        object = this.scope.declareLocal(this.compiler.verifyNotDeclared(string, this.scope, aST), 16L, type, aST);
        ((Local)object).setVariable(this);
        this.variables.add(object);
        return object;
    }

    Place createPlace(Local local) {
        if (local != null && local.wrapped != null) {
            local = local.wrapped;
        }
        Place place = new Place(local, this);
        this.allPlaces.add((Object)place);
        return place;
    }

    Place getPlace(Expression expression) {
        Local local;
        if (expression instanceof GetLocal && (local = ((GetLocal)expression).getLocal(0)).isVariable(this)) {
            return this.getPlace(local);
        }
        return null;
    }

    Place getPlace(Local local) {
        Place place;
        if (this.enclosing != null && local.isVariable(this.enclosing)) {
            return this.enclosing.getPlace(local);
        }
        assert (local.isVariable(this));
        if (local.wrapped != null) {
            local = local.wrapped;
        }
        if ((place = (Place)this.placesForLocals.get(local)) == null) {
            place = this.createPlace(local);
            this.placesForLocals.put(local, place);
        }
        return place.resolve();
    }

    Place getPlace(PatternData patternData, int n) {
        Place place = patternData.getPlaces()[n];
        if (place == null) {
            place = this.createPlace(null);
            place.map(patternData, n, patternData.pos);
        }
        return place;
    }

    public Local[] getDeclaredVariables() {
        ObjectList objectList = new ObjectList();
        for (int i = 0; i < this.variables.size(); ++i) {
            if ((((Local)this.variables.get(i)).getModifiers() & 0x1000) != 0) continue;
            objectList.add(this.variables.get(i));
        }
        return (Local[])objectList.toArray((Object[])new Local[objectList.size()]);
    }

    private void completeTraversal(TraversalData traversalData) {
        traversalData.child.computeDependenciesFromLocalAccess(this.predicates);
        for (int i = 0; i < traversalData.child.dependsOn.size(); ++i) {
            traversalData.addDependency((PatternData)traversalData.child.dependsOn.get(i));
        }
        ObjectList objectList = new ObjectList();
        traversalData.child.getArguments((ObjectList<? super Argument>)objectList);
        for (int i = objectList.size() - 1; i >= 0; --i) {
            Argument argument = (Argument)objectList.get(i);
            if ((argument.local.getModifiers() & 0x1000) == 0 && argument.local.isVariable(this)) continue;
            objectList.remove(i);
        }
        traversalData.complete(objectList);
        traversalData.addLocalAccess(traversalData.child);
    }

    private void complete(CompositeData compositeData) {
        Object object;
        int n;
        Object object2;
        int n2;
        Object object3;
        int n3;
        for (n3 = 0; n3 < this.compositeChildren.size(); ++n3) {
            CompositeData compositeData2 = (CompositeData)this.compositeChildren.get(n3);
            compositeData2.builder.complete(compositeData2);
        }
        for (n3 = 0; n3 < this.traversals.size(); ++n3) {
            this.completeTraversal((TraversalData)this.traversals.get(n3));
        }
        ObjectList objectList = new ObjectList();
        int n4 = this.predicates.size();
        int n5 = 0;
        while (n5 < n4) {
            object3 = (PatternData)this.predicates.get(n5);
            ((PatternData)object3).index = n5++;
            ((PatternData)object3).getArguments((ObjectList<? super Argument>)objectList);
        }
        Pattern[] patternArray = new Pattern[n4];
        object3 = new boolean[n4];
        short[][] sArrayArray = new short[n4][];
        short[][] sArrayArray2 = new short[n4][];
        for (n2 = 0; n2 < n4; ++n2) {
            sArrayArray[n2] = ((PatternData)this.predicates.get(n2)).completeArguments(objectList);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = (PatternData)this.predicates.get(n2);
            ((PatternData)object2).computeDependenciesFromLocalAccess(this.predicates);
            ((PatternData)object2).computeAllFollowers();
            patternArray[n2] = ((PatternData)object2).getPattern();
            object3[n2] = ((PatternData)object2).context;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            ((PatternData)this.predicates.get(n2)).convertFollowersToDependencies();
        }
        Type[] typeArray = new Type[objectList.size()];
        object2 = new boolean[objectList.size()];
        boolean[] blArray = new boolean[objectList.size()];
        Argument[] argumentArray = new Argument[objectList.size()];
        short[][] sArrayArray3 = new short[objectList.size()][];
        for (n = objectList.size() - 1; n >= 0; --n) {
            ObjectList objectList2;
            object = (Argument)objectList.get(n);
            object2[n] = ((Argument)object).node;
            if (((Argument)object).node) {
                Object object4;
                int n6;
                objectList2 = new ObjectList();
                if (!((Argument)object).place.foldings.isEmpty()) {
                    for (n6 = ((Argument)object).place.foldings.size() - 1; n6 >= 0; --n6) {
                        Place place;
                        object4 = (Local)((Argument)object).place.foldings.get(n6);
                        if (!((Local)object4).isVariable(this) || !this.enclosesOrEquals((place = this.getPlace((Local)object4)).getBuilder())) continue;
                        objectList2.add((Object)place);
                    }
                }
                if (!((Argument)object).place.placeFoldings.isEmpty()) {
                    for (n6 = ((Argument)object).place.placeFoldings.size() - 1; n6 >= 0; --n6) {
                        object4 = (Place)((Argument)object).place.placeFoldings.get(n6);
                        if (!this.enclosesOrEquals(((Place)object4).getBuilder())) continue;
                        objectList2.add(object4);
                    }
                }
                if (!objectList2.isEmpty()) {
                    short[] sArray = new short[objectList2.size()];
                    sArrayArray3[n] = sArray;
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = (short)objectList.indexOf((Object)((Place)objectList2.get(i)).getNodeArgument());
                    }
                }
            }
            blArray[n] = ((Argument)object).context;
            objectList2 = ((Argument)object).getType();
            typeArray[n] = objectList2 instanceof IntersectionType ? ((IntersectionType)objectList2).simplify() : objectList2;
            argumentArray[n] = object;
        }
        for (n = 0; n < n4; ++n) {
            object = (PatternData)this.predicates.get(n);
            if (((PatternData)object).dependsOn.isEmpty()) {
                sArrayArray2[n] = Utils.SHORT_0;
            } else {
                sArrayArray2[n] = new short[((PatternData)object).dependsOn.size];
                for (int i = sArrayArray2[n].length - 1; i >= 0; --i) {
                    sArrayArray2[n][i] = (short)((PatternData)((PatternData)object).dependsOn.get((int)i)).index;
                }
            }
            if (((PatternData)object).targetTypeExpr == null) continue;
            Type type = typeArray[sArrayArray[n][0]];
            if (type instanceof IntersectionType && type.getDeclaredInterfaceCount() == 1 && Reflection.equal((Type)this.model.getNodeType(), (Type)type.getSupertype())) {
                type = type.getDeclaredInterface(0);
            }
            ((PatternData)object).targetTypeExpr.value = type;
        }
        compositeData.complete(new CompoundPattern(typeArray, (boolean[])object2, blArray, patternArray, (boolean[])object3, (short[][])sArrayArray, (short[][])sArrayArray2, (short[][])sArrayArray3, compositeData.getInPlace(false) == null ? -1 : objectList.indexOf((Object)compositeData.getInPlace(false).getNodeArgument()), compositeData.getOutPlace(false) == null ? -1 : objectList.indexOf((Object)compositeData.getOutPlace(false).getNodeArgument()), compositeData.getMatchDirection().getCode(), compositeData.getCompositeType(), compositeData.isOptional(), compositeData.getContinueLabel()), argumentArray);
    }

    public CompositeData createCompositePattern() {
        assert (this.enclosing == null);
        CompositeData compositeData = this.createCompositePattern(false, (EdgeDirection)EdgeDirection.UNDIRECTED, null, this.textualPosition++, -1);
        for (int i = 0; i < this.allPlaces.size(); ++i) {
            Place place = (Place)this.allPlaces.get(i);
            if (place != place.resolve()) {
                this.allPlaces.remove(i--);
                continue;
            }
            place.mapToArguments();
        }
        this.complete(compositeData);
        if (DEBUG) {
            System.err.println(this);
            System.err.println("Places:");
            ObjectList objectList = new ObjectList();
            for (int i = 0; i < this.allPlaces.size(); ++i) {
                Place place = (Place)this.allPlaces.get(i);
                System.err.println("  " + place);
                place.getArguments(objectList);
                for (int j = 0; j < objectList.size(); ++j) {
                    System.err.println("    " + objectList.get(j));
                    for (int k = 0; k < place.mappings.size(); ++k) {
                        Place.Mapping mapping = (Place.Mapping)place.mappings.get(k);
                        if (mapping.getArgument() != objectList.get(j)) continue;
                        System.err.println("      -> " + mapping.pred + ", Index " + mapping.index);
                    }
                }
                objectList.clear();
            }
            this.dumpPatterns(compositeData, "");
        }
        return compositeData;
    }

    private void dumpPatterns(CompositeData compositeData, String string) {
        System.err.print(string);
        System.err.println("Pattern components of " + compositeData);
        for (int i = 0; i < this.predicates.size(); ++i) {
            PatternData patternData = (PatternData)this.predicates.get(i);
            System.err.println(string + "  " + patternData);
            for (int j = 0; j < patternData.getPlaces().length; ++j) {
                Place place = patternData.getPlaces()[j];
                Place.Mapping mapping = place.getMapping(patternData, j);
                System.err.println(string + "    " + j + " -> " + place + ", " + mapping.getArgument());
            }
            if (patternData.builder != this) {
                patternData.builder.dumpPatterns((CompositeData)patternData, string + "      ");
            }
            if (patternData instanceof TraversalData) {
                CompositeData compositeData2 = ((TraversalData)patternData).child;
                compositeData2.builder.dumpPatterns(compositeData2, string + "      ");
            }
            System.err.println(string + "    Depends on " + patternData.dependsOn);
        }
    }

    private CompositeData createCompositePattern(boolean bl, EdgeDirection edgeDirection, AST aST, int n, int n2) {
        int n3;
        int n4;
        this.addSeparation(aST);
        PatternData patternData = null;
        PatternData patternData2 = null;
        int n5 = this.predicates.size();
        for (n4 = 0; n4 < n5; ++n4) {
            PatternData patternData3 = (PatternData)this.predicates.get(n4);
            if (patternData3.context) {
                ++this.context;
            }
            patternData3.createSubPatterns();
            if (patternData3.context) {
                --this.context;
            }
            if (patternData3.context || patternData3.level != 0) continue;
            if (patternData == null && patternData3.hasInPlace()) {
                patternData = patternData3;
            }
            if (!patternData3.hasOutPlace()) continue;
            patternData2 = patternData3;
        }
        int n6 = patternData != null ? (patternData.isInClosed() ? 1 : 2) : (n4 = 0);
        int n7 = patternData2 != null ? (patternData2.isOutClosed() ? 1 : 2) : (n3 = 0);
        if (bl) {
            if (patternData == null || patternData2 == null) {
                this.problems.addSemanticError(I18N, "compiler.pattern-not-traversable", aST);
                return null;
            }
            if (patternData.getInPlace(false) == patternData2.getOutPlace(false)) {
                this.problems.addSemanticError(I18N, "compiler.closed-pattern-not-traversable", aST);
                return null;
            }
            n4 = 2;
            n3 = 2;
        }
        CompositeData compositeData = new CompositeData(patternData != null ? patternData.getInPlace(false) : null, n4, patternData2 != null ? patternData2.getOutPlace(false) : null, n3, edgeDirection, aST, n, n2, this);
        compositeData.addLocalAccess(this.predicates);
        return compositeData;
    }

    public final SimplePatternData addNodePattern(AST aST, BuiltInPattern builtInPattern, ArgumentDescription[] argumentDescriptionArray, AST aST2) {
        return this.add(new SimplePatternData(aST, (Pattern)builtInPattern, argumentDescriptionArray, 0, 0, 1, 1, aST2, this.textualPosition++, this.predicateStack.size(), this), true);
    }

    public final SimplePatternData addNodePattern(AST aST, PatternWrapper patternWrapper, ArgumentDescription[] argumentDescriptionArray, AST aST2) {
        return this.add(new SimplePatternData(aST, patternWrapper, argumentDescriptionArray, patternWrapper.getInParameter(), patternWrapper.getOutParameter(), 1, 1, aST2, this.textualPosition++, this.predicateStack.size(), this), true);
    }

    public final SimplePatternData addRelationPattern(AST aST, BuiltInPattern builtInPattern, ArgumentDescription[] argumentDescriptionArray, boolean bl, AST aST2) {
        return this.add(new SimplePatternData(aST, (Pattern)builtInPattern, argumentDescriptionArray, bl ? 1 : 0, bl ? 0 : 1, 2, 2, aST2, this.textualPosition++, this.predicateStack.size(), this), true);
    }

    public final SimplePatternData addRelationPattern(AST aST, PatternWrapper patternWrapper, ArgumentDescription[] argumentDescriptionArray, boolean bl, AST aST2) {
        return this.add(new SimplePatternData(aST, patternWrapper, argumentDescriptionArray, bl ? patternWrapper.getOutParameter() : patternWrapper.getInParameter(), bl ? patternWrapper.getInParameter() : patternWrapper.getOutParameter(), 2, 2, aST2, this.textualPosition++, this.predicateStack.size(), this), true);
    }

    public final SimplePatternData addPattern(AST aST, Pattern pattern, ArgumentDescription[] argumentDescriptionArray, AST aST2) {
        return this.addPattern(aST, pattern, argumentDescriptionArray, aST2, true);
    }

    protected final SimplePatternData addPattern(AST aST, Pattern pattern, ArgumentDescription[] argumentDescriptionArray, AST aST2, boolean bl) {
        SimplePatternData simplePatternData;
        if (pattern != null) {
            int n = this.textualPosition++;
            simplePatternData = new SimplePatternData(aST, pattern, argumentDescriptionArray, -1, -1, 0, 0, aST2, n, this.predicateStack.size(), this);
        } else {
            simplePatternData = null;
        }
        return this.add(simplePatternData, bl);
    }

    public Type getLastNodeType() {
        return this.lastNodeType;
    }

    <T extends PatternData> T add(T t, boolean bl) {
        if (t != null) {
            this.predicates.add(t);
            t.mapLabeledArgs();
            boolean bl2 = t.context = this.context > 0;
            if (t.label != null) {
                if (t.getLabelArgument() < 0) {
                    this.problems.addSemanticError(I18N, "compiler.pattern-not-labelable", t.label);
                } else {
                    this.getPlace(this.declareVariable(t.label, t.getPattern().getParameterType(t.getLabelArgument()))).map(t, t.getLabelArgument(), t.label);
                }
            }
        }
        if (bl) {
            Place place;
            if (t != null) {
                this.lastNodeType = t.getLastNodeType();
            }
            if (t != null && this.lastPred != null) {
                this.lastPred.next = t;
                t.prev = this.lastPred;
            }
            if (this.lastPred != null && (place = this.lastPred.getOutPlace(false)) != null) {
                Place place2;
                if (t != null && (place2 = t.getInPlace(true)) != null) {
                    place.setNode(!this.lastPred.context && this.lastPred.isOutClosed(), this.lastPred.context, t.pos);
                    place2.setNode(!t.context && t.isInClosed(), t.context, t.pos);
                    if (this.lastPred.isOutClosed() && t.isInClosed()) {
                        boolean bl3;
                        boolean bl4 = bl3 = this.includeJoinInContext && (this.lastPred.context || t.context);
                        if (bl3) {
                            this.beginContext(t.pos);
                        }
                        this.join(this.nextEdgeType, place, place2, t.pos);
                        if (bl3) {
                            this.endContext(t.pos);
                        }
                    } else {
                        place.merge(place2, t.pos);
                    }
                } else if (place.label == null) {
                    if (this.lastPred.isOutClosed() || this.ending && this.allowOpenEnds) {
                        place.setNode(!this.lastPred.context, this.lastPred.context, this.lastPred.pos);
                    } else {
                        this.problems.addSemanticError(I18N, "compiler.dangling-out-term", this.lastPred.pos);
                    }
                }
            } else if (t != null && t.hasInPlace()) {
                Place place3 = t.getInPlace(true);
                if (t.isInClosed() || this.beginning && this.allowOpenEnds) {
                    place3.setNode(!t.context, t.context, t.pos);
                } else {
                    this.problems.addSemanticError(I18N, "compiler.dangling-in-term", t.pos);
                }
            }
            this.lastPred = t;
            this.nextEdgeType = 1;
            this.includeJoinInContext = true;
        }
        this.beginning = false;
        if (t != null) {
            t.mapUnlabeledArgs();
        }
        return t;
    }

    public void addVariableReference(Local local, AST aST) {
        this.addNodePattern(null, (BuiltInPattern)new TypePattern(local.getType()), new ArgumentDescription[]{new ArgumentDescription(aST, local)}, aST);
    }

    public TraversalData addTraversal(AST aST, PatternBuilder patternBuilder, EdgeDirection edgeDirection, Expression expression, Expression expression2, boolean bl, AST aST2) {
        CompositeData compositeData;
        if ((compositeData = patternBuilder.createCompositePattern(true, edgeDirection, aST2, this.textualPosition++, -1)) == null) {
            return null;
        }
        this.compositeChildren.add((Object)compositeData);
        TraversalData traversalData = new TraversalData(compositeData, compositeData.inKind, compositeData.outKind, expression, expression2, aST2, this.textualPosition++, this.predicateStack.size(), this, bl);
        this.traversals.add((Object)traversalData);
        return this.add(traversalData, true);
    }

    public CompositeData addComposite(AST aST, PatternBuilder patternBuilder, EdgeDirection edgeDirection, boolean bl, AST aST2) {
        CompositeData compositeData = patternBuilder.createCompositePattern(false, edgeDirection, aST2, this.textualPosition++, this.predicateStack.size());
        if (bl) {
            compositeData.setOptional();
        }
        compositeData.atomic = true;
        this.compositeChildren.add((Object)compositeData);
        this.scope.receiveLocals(patternBuilder.scope, null);
        while (!patternBuilder.variables.isEmpty()) {
            Local local = (Local)patternBuilder.variables.pop();
            if ((local.getModifiers() & 0x1000) != 0) continue;
            local.setVariable(this);
            this.variables.add((Object)local);
        }
        return this.add(compositeData, true);
    }

    public void addAny(AST aST, AST aST2) {
        this.addType(aST, this.nodeType, aST2);
    }

    public void addSeparation(AST aST) {
        this.ending = true;
        this.addPattern(null, null, null, aST);
        this.ending = false;
    }

    protected void join(int n, Place place, Place place2, AST aST) {
        this.addPattern(null, (Pattern)new EdgePattern(this.nodeType, this.model.getEdgeType(), this.model.getStandardEdgeFor(n), 0), new ArgumentDescription[]{new ArgumentDescription(aST, place), new ArgumentDescription(aST, place2), null}, aST, false);
    }

    public void addStandardEdge(AST aST, EdgeDirection edgeDirection, int n, AST aST2) {
        this.addConstantEdge(aST, edgeDirection, this.model.getEdgeType(), this.model.getStandardEdgeFor(n), aST2);
    }

    private static int getForwardCode(EdgeDirection edgeDirection) {
        return edgeDirection == EdgeDirection.BACKWARD ? 0 : edgeDirection.getCode();
    }

    public SimplePatternData addConstantEdge(AST aST, EdgeDirection edgeDirection, Type type, Serializable serializable, AST aST2) {
        return this.addRelationPattern(aST, (BuiltInPattern)new EdgePattern(this.nodeType, type, serializable, PatternBuilder.getForwardCode(edgeDirection)), null, edgeDirection == EdgeDirection.BACKWARD, aST2);
    }

    public void addEdge(AST aST, EdgeDirection edgeDirection, Expression expression, AST aST2) {
        Type type = this.getModel().getEdgeTypeFor(expression.getType());
        if ((expression = this.compiler.methodInvocationConversion(expression, type, this.scope, aST2)) instanceof Constant && (Reflection.isPrimitive((Type)expression.getType()) || expression.hasType(Serializable.class))) {
            this.addConstantEdge(aST, edgeDirection, type, (Serializable)expression.evaluateAsObject(null), aST2);
        } else {
            this.addRelationPattern(aST, (BuiltInPattern)new EdgePattern(this.nodeType, type, PatternBuilder.getForwardCode(edgeDirection)), new ArgumentDescription[]{null, null, new ArgumentDescription(aST2, expression)}, edgeDirection == EdgeDirection.BACKWARD, aST2);
        }
    }

    public void addEdgePattern(AST aST, PatternWrapper patternWrapper, ArgumentDescription[] argumentDescriptionArray, EdgeDirection edgeDirection, AST aST2) {
        if (!patternWrapper.isFirstInOut()) {
            throw new IllegalArgumentException();
        }
        SimplePatternData simplePatternData = this.addConstantEdge(aST, edgeDirection, patternWrapper.getParameterType(0), null, aST2);
        argumentDescriptionArray[0] = new ArgumentDescription(aST2, simplePatternData.getPlaces()[2]);
        this.addPattern(null, patternWrapper, argumentDescriptionArray, aST2, false);
    }

    public void addType(AST aST, Type type, AST aST2) {
        this.addNodePattern(aST, (BuiltInPattern)new TypePattern(type), new ArgumentDescription[1], aST2);
    }

    public void addWrappedType(AST aST, Type type, Expression expression, AST aST2) {
        this.addNodePattern(aST, (BuiltInPattern)new WrappedTypePattern(this.compiler.getWrapperTypeFor(type, this.model, aST2), type), new ArgumentDescription[]{null, new ArgumentDescription(aST2, expression)}, aST2);
    }

    public void addCondition(AST aST, Expression expression, AST aST2) {
        this.beginContext(aST2);
        ObjectList objectList = new ObjectList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        MethodScope methodScope = this.declareRoutine(expression, objectList, hashSet, hashSet2);
        ExpressionPattern expressionPattern = PatternBuilder.createCondition(methodScope, expression, objectList, -1, -1);
        SimplePatternData simplePatternData = this.addPattern(aST, (Pattern)expressionPattern, this.getArgumentDescriptions(objectList, 0), aST2);
        simplePatternData.addRoutine(methodScope);
        simplePatternData.setLocalAccess(hashSet, hashSet2);
        this.endContext(aST2);
    }

    public void addGuard(AST aST, Expression expression, AST aST2) {
        expression = this.compiler.assignmentConversion(expression, Type.BOOLEAN, this.scope, aST2);
        ObjectList objectList = new ObjectList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        MethodScope methodScope = this.declareRoutine(expression, objectList, hashSet, hashSet2);
        ExpressionPattern expressionPattern = PatternBuilder.createCondition(methodScope, expression, objectList, 0, 0);
        SimplePatternData simplePatternData = this.addNodePattern(aST, (BuiltInPattern)expressionPattern, this.getArgumentDescriptions(objectList, 0), aST2);
        simplePatternData.addRoutine(methodScope);
        simplePatternData.setLocalAccess(hashSet, hashSet2);
    }

    public static final Expression createArgument(Type type) {
        return Local.DUMMY.createGet().setType(type);
    }

    public static final Expression createTargetTypeArgument() {
        return new ObjectConst(TARGET_TYPE_MARK, Type.CLASS);
    }

    private void findVariables(Expression expression, ObjectList objectList, HashSet hashSet, HashSet hashSet2, HashMap hashMap, MethodScope methodScope) {
        Object object;
        if (expression instanceof LocalAccess) {
            object = (LocalAccess)((Object)expression);
            for (int i = object.getLocalCount() - 1; i >= 0; --i) {
                Local local;
                Local local2 = object.getLocal(i);
                if (local2 == Local.DUMMY) {
                    assert (object instanceof GetLocal);
                    local = methodScope.declareParameter("termparam.", 0x20000000010L, expression.getType());
                    objectList.add((Object)local);
                    object.setLocal(i, local);
                    continue;
                }
                if (local2.isVariable(this)) {
                    local = (Local)hashMap.get(local2);
                    if (local == null) {
                        local = methodScope.declareParameter(local2.getSimpleName() + '.', 16L, local2.getType());
                        hashMap.put(local2, local);
                        objectList.add((Object)local2);
                        hashSet.add(local2);
                    }
                    object.setLocal(i, local);
                    continue;
                }
                if ((object.getAccessType(i) & 3) != 0) {
                    hashSet.add(local2);
                }
                if ((object.getAccessType(i) & 0x3C) == 0) continue;
                hashSet2.add(local2);
            }
        } else if (expression instanceof ObjectConst) {
            object = (ObjectConst)expression;
            if (((ObjectConst)object).value == TARGET_TYPE_MARK) {
                assert (this.targetTypeExpr == null);
                this.targetTypeExpr = object;
            }
        }
        for (expression = expression.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            this.findVariables(expression, objectList, hashSet, hashSet2, hashMap, methodScope);
        }
    }

    protected MethodScope declareRoutine(Expression expression, ObjectList objectList, HashSet hashSet, HashSet hashSet2) {
        MethodScope methodScope = new MethodScope(this.scope.getMethodScope());
        this.findVariables(expression, objectList, hashSet, hashSet2, new HashMap(), methodScope);
        return methodScope;
    }

    private static int index(int n, ObjectList objectList) {
        return n >= 0 ? n : objectList.size() + n;
    }

    public void addRelation(AST aST, Expression expression, boolean bl, AST aST2) {
        ObjectList objectList = new ObjectList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        MethodScope methodScope = this.declareRoutine(expression, objectList, hashSet, hashSet2);
        ExpressionPattern expressionPattern = PatternBuilder.createCondition(methodScope, expression, objectList, PatternBuilder.index(0, objectList), PatternBuilder.index(1, objectList));
        SimplePatternData simplePatternData = this.addRelationPattern(aST, (BuiltInPattern)expressionPattern, this.getArgumentDescriptions(objectList, 0), bl, aST2);
        simplePatternData.addRoutine(methodScope);
        simplePatternData.setLocalAccess(hashSet, hashSet2);
    }

    public void addBlock(Expression expression, AST aST) {
        this.beginContext(aST);
        ObjectList objectList = new ObjectList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        MethodScope methodScope = this.declareRoutine(expression, objectList, hashSet, hashSet2);
        ExpressionPattern expressionPattern = PatternBuilder.createBlock(methodScope, expression, objectList);
        SimplePatternData simplePatternData = new SimplePatternData(null, (Pattern)expressionPattern, this.getArgumentDescriptions(objectList, 0), -1, -1, 0, 0, aST, this.textualPosition++, -1, this);
        simplePatternData.addRoutine(methodScope);
        simplePatternData.setLocalAccess(hashSet, hashSet2);
        this.lastPred.addFollower(simplePatternData);
        this.add(simplePatternData, false);
        this.endContext(aST);
    }

    public void addPathExpression(AST aST, Expression expression, boolean bl, AST aST2) {
        ObjectList objectList = new ObjectList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.targetTypeExpr = null;
        MethodScope methodScope = this.declareRoutine(expression, objectList, hashSet, hashSet2);
        ExpressionPattern expressionPattern = PatternBuilder.createExpression(methodScope, expression, objectList);
        SimplePatternData simplePatternData = this.addRelationPattern(aST, (BuiltInPattern)expressionPattern, this.getArgumentDescriptions(objectList, 1), !bl, aST2);
        if (this.targetTypeExpr != null) {
            simplePatternData.targetTypeExpr = this.targetTypeExpr;
            this.targetTypeExpr = null;
        }
        simplePatternData.addRoutine(methodScope);
        simplePatternData.setLocalAccess(hashSet, hashSet2);
    }

    public void addExpression(AST aST, Expression expression, AST aST2) {
        this.addExpression(aST, expression, aST2, false, null, 0);
    }

    SimplePatternData addExpression(AST aST, Expression expression, AST aST2, boolean bl, ArgumentDescription argumentDescription, int n) {
        SimplePatternData simplePatternData;
        ObjectList objectList = new ObjectList();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        MethodScope methodScope = this.declareRoutine(expression, objectList, hashSet, hashSet2);
        ExpressionPattern expressionPattern = PatternBuilder.createExpression(methodScope, expression, objectList);
        ArgumentDescription[] argumentDescriptionArray = this.getArgumentDescriptions(objectList, 1);
        if (bl) {
            argumentDescriptionArray[0] = argumentDescription;
            simplePatternData = new SimplePatternData(null, (Pattern)expressionPattern, argumentDescriptionArray, -1, -1, 0, 0, aST2, n, -1, this);
            this.add(simplePatternData, false);
        } else {
            simplePatternData = this.addNodePattern(aST, (BuiltInPattern)expressionPattern, argumentDescriptionArray, aST2);
        }
        simplePatternData.addRoutine(methodScope);
        simplePatternData.setLocalAccess(hashSet, hashSet2);
        return simplePatternData;
    }

    public void addFolding(AST aST) {
        Local local = this.scope.findLocal(aST.getText(), true);
        if (local == null) {
            this.problems.addSemanticError(I18N.msg("compiler.no-member-in-scope", (Object)I18N.msg("member.variable"), (Object)aST.getText()), aST);
            return;
        }
        if (!local.isVariable(this)) {
            this.problems.addSemanticError(I18N.msg("compiler.qvar-expected", (Object)aST.getText()), aST);
            return;
        }
        if (local.getPatternBuilder() != this) {
            this.problems.addSemanticError(I18N.msg("compiler.qvar-at-higher-level", (Object)aST.getText()), aST);
            return;
        }
        if (this.lastPred == null) {
            return;
        }
        this.lastPred.getInPlace((boolean)true).foldings.add((Object)local);
    }

    public void beginTree(AST aST) {
        if (this.lastPred == null) {
            this.problems.addSemanticError(I18N, "compiler.missing-parent-for-branch", aST);
            return;
        }
        if (!this.lastPred.isOutClosed()) {
            this.problems.addSemanticError(I18N, "compiler.out-term-of-parent-not-closed", aST);
        }
        this.predicateStack.push((Object)this.lastPred);
        this.nextEdgeType = 2;
        this.includeJoinInContext = false;
    }

    public void endTree(AST aST) {
        this.addSeparation(aST);
        if (!this.predicateStack.isEmpty()) {
            this.lastPred = (PatternData)this.predicateStack.pop();
        }
    }

    public void beginContext(AST aST) {
        ++this.context;
    }

    public void endContext(AST aST) {
        if (this.context == 0) {
            throw new IllegalStateException();
        }
        --this.context;
    }

    static ExpressionPattern createExpression(MethodScope methodScope, Expression expression, ObjectList objectList) {
        Type[] typeArray = new Type[objectList.size + 1];
        typeArray[0] = expression.getType();
        for (int i = objectList.size; i > 0; --i) {
            typeArray[i] = ((Local)objectList.get(i - 1)).getType();
        }
        Local local = methodScope.declareParameter("qs.", 16L, QS_TYPE);
        Local local2 = methodScope.declareParameter("tp.", 16L, Type.INT);
        Local local3 = methodScope.declareParameter("cons.", 16L, (Type)ClassAdapter.wrap(MatchConsumer.class));
        Local local4 = methodScope.declareParameter("arg.", 16L, Type.INT);
        XMethod xMethod = methodScope.createAndDeclareMethod("expr", Type.VOID);
        Block block = Block.createSequentialBlock();
        methodScope.addExpression(block);
        block.add(new InvokeVirtual(Reflection.findMethodWithPrefixInTypes((Type)QS_TYPE, (String)("m" + Reflection.getJVMPrefix((Type)expression.getType()) + "match;"), (boolean)false, (boolean)true)).add(local.createGet()).add(local2.createGet()).add(expression).add(local3.createGet()).add(local4.createGet()));
        return new ExpressionPattern(typeArray, -1, -1, 0, (Routine)xMethod);
    }

    static ExpressionPattern createCondition(MethodScope methodScope, Expression expression, ObjectList objectList, int n, int n2) {
        return PatternBuilder.create(methodScope, expression, objectList, 1, n, n2);
    }

    static ExpressionPattern createBlock(MethodScope methodScope, Expression expression, ObjectList objectList) {
        return PatternBuilder.create(methodScope, expression, objectList, 2, -1, -1);
    }

    private static ExpressionPattern create(MethodScope methodScope, Expression expression, ObjectList objectList, int n, int n2, int n3) {
        Type[] typeArray = new Type[objectList.size];
        for (int i = objectList.size - 1; i >= 0; --i) {
            typeArray[i] = ((Local)objectList.get(i)).getType();
        }
        XMethod xMethod = methodScope.createAndDeclareMethod(n == 1 ? "condition" : (n == 2 ? "block" : "unknown"), n == 1 ? Type.BOOLEAN : Type.VOID);
        if (n == 1) {
            methodScope.addExpression(new Return(methodScope, Type.BOOLEAN).add(expression));
        } else {
            methodScope.addExpression(expression);
        }
        return new ExpressionPattern(typeArray, n2, n3, n, (Routine)xMethod);
    }
}

