/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.pattern.Argument;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.pattern.PatternData;
import de.grogra.xl.compiler.pattern.Place;
import de.grogra.xl.compiler.pattern.TraversalData;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.expr.Block;
import de.grogra.xl.query.CompoundPattern;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.Pattern;

public final class CompositeData
extends PatternData {
    private final Place inPlace;
    private final Place outPlace;
    private EdgeDirection matchDirection;
    private Place[] places;
    private CompoundPattern predicate;
    private static final int NO_BREAK = 0;
    private static final int BREAK = 1;
    private static final int BREAK_AND_CONTINUE = 2;
    private static final int OPTIONAL = 3;
    private int predicateType = 0;
    private TraversalData brokenPattern;

    CompositeData(Place place, int n, Place place2, int n2, EdgeDirection edgeDirection, AST aST, int n3, int n4, PatternBuilder patternBuilder) {
        super(null, n, n2, aST, n3, n4, patternBuilder);
        this.inPlace = place;
        this.outPlace = place2;
        this.matchDirection = edgeDirection;
    }

    public void setBreak(TraversalData traversalData) {
        this.predicateType = 2;
        this.atomic = true;
        this.matchDirection = EdgeDirection.FORWARD;
        this.brokenPattern = traversalData;
        this.addDependency(traversalData);
    }

    public void setBreak() {
        this.predicateType = 1;
        this.atomic = true;
        this.matchDirection = EdgeDirection.FORWARD;
    }

    public void setOptional() {
        this.predicateType = 3;
        this.atomic = true;
        this.matchDirection = EdgeDirection.FORWARD;
    }

    Type getLastNodeType() {
        return this.builder.getLastNodeType();
    }

    Block getSubRoutines() {
        Block block = new Block();
        for (int i = 0; i < this.builder.predicates.size(); ++i) {
            block.add(((PatternData)this.builder.predicates.get(i)).getAllRoutines());
        }
        return block;
    }

    boolean hasInPlace() {
        return this.inPlace != null;
    }

    boolean hasOutPlace() {
        return this.outPlace != null;
    }

    Place getInPlace(boolean bl) {
        return this.inPlace != null ? this.inPlace.resolve() : null;
    }

    Place getOutPlace(boolean bl) {
        return this.outPlace != null ? this.outPlace.resolve() : null;
    }

    int getLabelArgument() {
        return -1;
    }

    void complete(CompoundPattern compoundPattern, Argument[] argumentArray) {
        this.predicate = compoundPattern;
        this.places = new Place[argumentArray.length];
        for (int i = 0; i < argumentArray.length; ++i) {
            argumentArray[i].place.map(this, i, null).initParam(argumentArray[i]);
        }
    }

    EdgeDirection getMatchDirection() {
        return this.matchDirection;
    }

    int getCompositeType() {
        return this.predicateType == 1 || this.predicateType == 2 ? 2 : (this.atomic ? 1 : 0);
    }

    boolean isOptional() {
        return this.predicateType == 3;
    }

    Place[] getPlaces() {
        return this.places;
    }

    public Pattern getPattern() {
        return this.predicate;
    }

    public String toString() {
        return "Composite " + this.dataId;
    }

    public int getIndexOfVariable(Local local) {
        for (int i = 0; i < this.places.length; ++i) {
            if (this.places[i].getMapping((PatternData)this, (int)i).getArgument().local != local) continue;
            return i;
        }
        return -1;
    }

    String getContinueLabel() {
        if (this.predicateType != 2) {
            return null;
        }
        return this.brokenPattern.getIdentifier();
    }

    void createSubPatterns() {
    }

    void mapLabeledArgs() {
    }

    void mapUnlabeledArgs() {
    }
}

