/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import antlr.collections.AST;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.RecognitionExceptionList;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.CompilerTokenTypes;
import de.grogra.xl.compiler.ProblemReporter;
import de.grogra.xl.compiler.pattern.PatternWrapper;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.Package;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.Expression;

final class Resolver
implements CompilerTokenTypes,
Members.Resolution {
    static final int RETURN_VAR = 0x100000;
    static final int TYPES_OBSCURE_PREDICATES = 0x200000;
    static final int FIND_STATIC_MEMBERS = 0x400000;
    private final Members members;
    private final Compiler compiler;
    private Object qualifier;
    private String simpleName;
    private Scope initialScope;
    private int resolutionTypes;

    public boolean allowsAmbiguousMembers(Member member) {
        return (this.resolutionTypes & 0x400000) != 0 || member instanceof Method || member instanceof PatternWrapper;
    }

    public boolean isApplicable(Member member, Members.Applicability applicability, Scope scope) {
        return true;
    }

    public Type[] getArgumentTypes() {
        return Type.TYPE_0;
    }

    private boolean isObscuredByOverride(Member member, Member member2) {
        return (this.resolutionTypes & 0x200000) != 0 && member instanceof PatternWrapper && member2 instanceof Type && !Reflection.equal((Type)((PatternWrapper)member).getPatternType(), (Type)((Type)member2));
    }

    public boolean isLessThan(Member member, Members.Applicability applicability, Member member2, Members.Applicability applicability2, Scope scope) {
        return (this.resolutionTypes & 0x400000) != 0 ? member2 instanceof Type && !(member instanceof Type) : this.isObscuredByOverride(member, member2) || !this.isObscuredByOverride(member2, member) && Members.getMemberType(member) > Members.getMemberType(member2);
    }

    Resolver(Compiler compiler) {
        this.compiler = compiler;
        this.members = new Members(compiler);
    }

    void reset() {
        this.members.reset();
        this.qualifier = null;
        this.simpleName = null;
    }

    Field resolveField(Scope scope, Type type, AST aST, int n) {
        if (Reflection.isInvalid((Type)type)) {
            return null;
        }
        this.members.resetName(aST);
        this.resolutionTypes = 2 | n;
        this.members.addMatches(scope, type, this.resolutionTypes);
        try {
            Field field = (Field)this.members.resolve(this);
            this.initialScope = this.members.getScopeForResult();
            return field;
        }
        catch (RecognitionException recognitionException) {
            this.compiler.problems.add(recognitionException);
            return null;
        }
    }

    Scope getInitialScope() {
        return this.initialScope;
    }

    private Object resolveName0(AST aST, int n, int n2, Scope scope) throws RecognitionException {
        switch (aST.getType()) {
            case 11: {
                String string;
                this.simpleName = string = aST.getText();
                this.members.resetName(aST);
                this.resolutionTypes = n;
                this.members.addMatches(scope, n);
                Member member = this.members.resolve(this);
                this.initialScope = this.members.getScopeForResult();
                if (member instanceof Local && (n & 0x100000) == 0) {
                    return ((Local)member).createExpression(scope, aST);
                }
                if (member instanceof Field) {
                    MethodScope methodScope = MethodScope.get(scope);
                    if (methodScope != null && methodScope.isIllegalUseBeforeDeclaration((Field)member)) {
                        this.compiler.problems.addSemanticError(Compiler.I18N.msg("compiler.use-before-declaration", (Object)string), aST);
                    }
                    if ((n & 0x100000) == 0) {
                        if (this.compiler.run != 2) {
                            return null;
                        }
                        return this.compiler.compileFieldExpression((Field)member, this.compiler.compileInstance((Member)((Field)member), this.initialScope, scope, aST), scope, aST);
                    }
                }
                return member;
            }
            case 82: {
                AST aST2 = aST = aST.getFirstChild();
                Object object = this.resolveName0(aST, n2, n2, scope);
                n &= 0xFFFFBFFF;
                this.qualifier = object;
                if (object == null) {
                    return null;
                }
                aST = aST.getNextSibling();
                assert (aST.getType() == 11);
                this.simpleName = aST.getText();
                if (object instanceof Package) {
                    int n3 = n;
                    if ((n & 0x1000) != 0) {
                        n |= 0x40;
                    }
                    if ((n &= 0xFFFFEFE4) == 0) {
                        if (this.compiler.run != 2) {
                            return null;
                        }
                        while (aST2.getType() == 82) {
                            aST2 = aST2.getFirstChild();
                        }
                        throw ProblemReporter.createSemanticError(Compiler.I18N.msg("compiler.no-member-in-scope", (Object)Members.getMembersDescription(n3, false), (Object)aST2.getText()), aST2);
                    }
                    this.members.resetName(aST);
                    this.resolutionTypes = n;
                    this.members.addMatches((Package)object, n);
                    return this.members.resolve(this);
                }
                return this.resolveName0(object, aST, n & 0xFFFFEFFF, scope);
            }
        }
        throw new AssertionError(aST);
    }

    private Object resolveName0(Object object, AST aST, int n, Scope scope) throws RecognitionException {
        if (object == null) {
            return null;
        }
        assert (aST.getType() == 11);
        if (object instanceof Type) {
            if (Reflection.isInvalid((Type)((Type)object))) {
                return null;
            }
            this.members.resetName(aST);
            this.resolutionTypes = n &= 0xFFFFFFAE;
            this.members.addMatches(scope, (Type)object, n);
            object = this.members.resolve(this);
            if (object instanceof Field && (n & 0x100000) == 0) {
                return this.compiler.run == 2 ? this.compiler.compileFieldExpression((Field)object, null, scope, aST) : null;
            }
            return object;
        }
        if (this.compiler.run == 2) {
            if (object instanceof Expression) {
                n &= 0xFFFFFF8A;
                Expression expression = (Expression)object;
                if (Reflection.isInvalid((Type)expression.getType())) {
                    return null;
                }
                this.members.resetName(aST);
                this.resolutionTypes = n;
                this.members.addMatches(scope, expression.getType(), n);
                object = this.members.resolve(this);
                if (object instanceof Field && (n & 0x100000) == 0) {
                    return this.compiler.compileFieldExpression((Field)object, expression, scope, aST);
                }
                return object;
            }
            throw new AssertionError(object);
        }
        return null;
    }

    Object resolveName(AST aST, int n, int n2, Scope scope) {
        try {
            this.qualifier = null;
            return this.resolveName0(aST, n, n2, scope);
        }
        catch (RecognitionException recognitionException) {
            this.compiler.problems.add(recognitionException);
            return null;
        }
    }

    Object resolveName(Object object, AST aST, int n, Scope scope) {
        try {
            return this.resolveName0(object, aST, n, scope);
        }
        catch (RecognitionException recognitionException) {
            this.compiler.problems.add(recognitionException);
            return null;
        }
    }

    Member resolveStaticMember(Type type, AST aST, Scope scope) {
        return (Member)this.resolveName(type, aST, 4194862, scope);
    }

    Object getQualifier() {
        return this.qualifier;
    }

    String getSimpleName() {
        return this.simpleName;
    }

    Type resolveTypeName(AST aST, Scope scope) {
        Type type = (Type)this.resolveName(aST, 32, 4128, scope);
        return type == null ? Type.INVALID : type;
    }

    Member resolvePatternOrMethodOrTypeName(AST aST, Scope scope) {
        return (Member)this.resolveName(aST, 44, 4131, scope);
    }

    Object resolveExpressionOrPatternOrMethodName(AST aST, Scope scope) {
        return this.resolveName(aST, 15, 4131, scope);
    }

    Member resolveCanonicalTypeOrPackageName(AST aST, Scope scope) {
        return (Member)this.resolveName(aST, 22560, 22560, scope);
    }

    Type resolveCanonicalTypeName(AST aST, Scope scope) {
        Type type = (Type)this.resolveName(aST, 18464, 22560, scope);
        return type == null ? Type.INVALID : type;
    }

    Expression resolveExpressionName(AST aST, Scope scope) {
        return (Expression)this.resolveName(aST, 3, 4131, scope);
    }

    Object resolveExpressionOrTypeName(AST aST, Scope scope) {
        return this.resolveName(aST, 35, 4131, scope);
    }

    Object resolveExpressionOrPatternOrMethodOrTypeName(AST aST, Scope scope) {
        return this.resolveName(aST, 0x20002F, 4131, scope);
    }

    Object resolveExpressionOrMethodOrTypeName(AST aST, Scope scope) {
        return this.resolveName(aST, 43, 4131, scope);
    }

    Member resolveMethodOrTypeName(AST aST, Scope scope) {
        return (Member)this.resolveName(aST, 40, 4131, scope);
    }

    Type resolveTypeName(Type type, AST aST, Scope scope) {
        return (Type)this.resolveName(type, aST, 32, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object resolveIfDeclared(AST aST, int n, Scope scope) {
        this.compiler.problems.disableAdd();
        Object object = null;
        try {
            object = this.resolveName(aST, n | 0x800, 0, scope);
        }
        finally {
            RecognitionExceptionList recognitionExceptionList = this.compiler.problems.enableAdd();
            if (recognitionExceptionList.containsErrors()) {
                object = null;
            } else {
                this.compiler.problems.addAll(recognitionExceptionList);
            }
        }
        return object;
    }
}

