/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import antlr.TokenStream;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.Tokenizer;
import de.grogra.reflect.Field;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import de.grogra.xl.compiler.ASMTypeLoader;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CompilationUnit;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.CompilerOptions;
import de.grogra.xl.compiler.ProblemReporter;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.CompilationUnitScope;
import de.grogra.xl.compiler.scope.PackageImportOnDemand;
import de.grogra.xl.parser.JavaTokenizer;
import de.grogra.xl.parser.Parser;
import de.grogra.xl.parser.XLParser;
import de.grogra.xl.parser.XLTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;

public final class Main {
    private static String[] args;
    private static int argIndex;
    private static String param;
    private static String encoding;
    private static boolean verbose;
    private static boolean dumpAST;
    private static ArrayList parsers;
    private static ProblemReporter problems;
    private static boolean ok;

    private Main() {
    }

    private static void showHelpAndExit(String string) {
        if (string != null) {
            System.err.println(string);
        }
        System.err.println("Usage: xlc <options> <source files> <exec option>");
        System.err.println("where possible options include:");
        System.err.println("  -g                      Generate all debugging info");
        System.err.println("  -g:none                 Generate no debugging info");
        System.err.println("  -g:{lines,vars,source}  Generate only some debugging info");
        System.err.println("  -nowarn                 Generate no warnings");
        System.err.println("  -verbose                Output messages about what the compiler is doing");
        System.err.println("  -classpath <path>       Specify where to find user class files");
        System.err.println("  -cp <path>              Specify where to find user class files");
        System.err.println("  -bootclasspath <path>   Override location of bootstrap class files");
        System.err.println("  -extdirs <dirs>         Override location of installed extensions");
        System.err.println("  -d <directory>          Specify where to place generated class files");
        System.err.println("  -encoding <encoding>    Specify character encoding used by source files");
        System.err.println("  -source <release>       Provide source compatibility with specified release");
        System.err.println("  -target <release>       Generate class files for specific VM version");
        System.err.println("  -help                   Print a synopsis of standard options");
        System.err.println();
        System.err.println("  -Xeaa {true|false}      Enable Autoconversion Annotation (default: false)");
        System.err.println("  -Xasv {true|false}      Allow Autoconversion with static valueOf (default: true)");
        System.err.println("  -Xasto {true|false}     Allow Autoconversion with static toX (default: true)");
        System.err.println("  -Xato {true|false}      Allow Autoconversion with toX (default: true)");
        System.err.println("  -Xactor {true|false}    Allow Autoconversion with constructor (default: true)");
        System.err.println();
        System.err.println("  -Xast                   Print abstract syntax tree");
        System.err.println("  -Xmember                List compiled types and their members");
        System.err.println("  -Xexpr                  Print compiled expression trees for methods");
        System.err.println();
        System.err.println("The exec option has to be specified after the source files:");
        System.err.println("  -Xexec <class> <args>   Execute main-method of given class after compilation");
        System.exit(1);
    }

    private static void exit(String string) {
        System.err.println(string);
        System.exit(1);
    }

    private static boolean parse(String string) throws IOException {
        if (verbose) {
            System.err.print("Parsing " + string + " ... ");
        }
        Tokenizer tokenizer = string.toLowerCase().endsWith(".java") ? new JavaTokenizer() : new XLTokenizer();
        FileInputStream fileInputStream = new FileInputStream(string);
        tokenizer.setSource(new BufferedReader(encoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, encoding)), string.substring(string.lastIndexOf(File.separatorChar) + 1));
        XLParser xLParser = new XLParser((TokenStream)tokenizer);
        xLParser.setDumpTree(dumpAST);
        try {
            xLParser.parse();
            if (verbose) {
                System.err.println("OK");
            }
            parsers.add(xLParser);
            problems.addAll(xLParser.getExceptionList());
            return true;
        }
        catch (RecognitionException recognitionException) {
            if (verbose) {
                System.err.println("Syntax error");
            }
            problems.addAll(xLParser.getExceptionList());
            return false;
        }
    }

    private static boolean checkArgWithParam(String string) {
        if (args[argIndex].equals(string)) {
            if (++argIndex == args.length) {
                Main.showHelpAndExit("Missing argument to " + string);
            }
            param = args[argIndex];
            return true;
        }
        return false;
    }

    private static int parseVersion(String string) {
        if ("1.4".equals(string)) {
            return 48;
        }
        if ("1.5".equals(string) || "5".equals(string)) {
            return 49;
        }
        Main.showHelpAndExit("Unsupported version " + string);
        return 0;
    }

    public static void main(String[] stringArray) throws Exception {
        Method method = Main.run(stringArray);
        if (method != null) {
            parsers = null;
            problems = null;
            String[] stringArray2 = new String[stringArray.length - argIndex];
            System.arraycopy(stringArray, argIndex, stringArray2, 0, stringArray2.length);
            method.invoke(null, new Object[]{stringArray2});
        }
        System.exit(ok ? 0 : 1);
    }

    private static Method run(String[] stringArray) throws Exception {
        Object object;
        CompilationUnit[] compilationUnitArray;
        Object object2;
        Object object3;
        CompilationUnitScope[] compilationUnitScopeArray;
        args = stringArray;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        File file = new File(System.getProperty("user.dir"));
        String string = null;
        String string2 = System.getProperty("user.dir");
        String string3 = System.getProperty("java.ext.dirs", null);
        String string4 = null;
        CompilerOptions compilerOptions = new CompilerOptions();
        for (argIndex = 0; argIndex < stringArray.length && (compilationUnitScopeArray = stringArray[argIndex]).startsWith("-"); ++argIndex) {
            if (compilationUnitScopeArray.equals("-help")) {
                Main.showHelpAndExit(null);
                continue;
            }
            if (compilationUnitScopeArray.equals("-g")) {
                compilerOptions.sourceInfo = true;
                compilerOptions.lineNumberInfo = true;
                compilerOptions.localInfo = true;
                continue;
            }
            if (compilationUnitScopeArray.startsWith("-g:")) {
                compilerOptions.sourceInfo = false;
                compilerOptions.lineNumberInfo = false;
                compilerOptions.localInfo = false;
                object3 = new StringTokenizer(compilationUnitScopeArray.substring(3), ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    if (((String)object2).equals("lines")) {
                        compilerOptions.lineNumberInfo = true;
                        continue;
                    }
                    if (((String)object2).equals("vars")) {
                        compilerOptions.localInfo = true;
                        continue;
                    }
                    if (((String)object2).equals("source")) {
                        compilerOptions.sourceInfo = true;
                        continue;
                    }
                    if (((String)object2).equals("none")) continue;
                    Main.showHelpAndExit("Unknown debugging info " + (String)object2);
                }
                continue;
            }
            if (compilationUnitScopeArray.equals("-nowarn")) {
                bl3 = false;
                continue;
            }
            if (compilationUnitScopeArray.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (compilationUnitScopeArray.equals("-Xast")) {
                dumpAST = true;
                continue;
            }
            if (compilationUnitScopeArray.equals("-Xmember")) {
                bl2 = true;
                continue;
            }
            if (compilationUnitScopeArray.equals("-Xexpr")) {
                bl = true;
                continue;
            }
            if (Main.checkArgWithParam("-d")) {
                file = new File(param);
                continue;
            }
            if (Main.checkArgWithParam("-classpath") || Main.checkArgWithParam("-cp")) {
                string2 = param;
                continue;
            }
            if (Main.checkArgWithParam("-sourcepath")) {
                System.err.println("The -sourcepath option has not yet been implemented, it is ignored");
                continue;
            }
            if (Main.checkArgWithParam("-bootclasspath")) {
                string4 = param;
                continue;
            }
            if (Main.checkArgWithParam("-extdirs")) {
                string3 = param;
                continue;
            }
            if (Main.checkArgWithParam("-source")) {
                Main.parseVersion(param);
                continue;
            }
            if (Main.checkArgWithParam("-target")) {
                compilerOptions.javaVersion = Main.parseVersion(param);
                continue;
            }
            if (Main.checkArgWithParam("-Xeaa")) {
                compilerOptions.enableAutoconversionAnnotation = Boolean.valueOf(param);
                continue;
            }
            if (Main.checkArgWithParam("-Xasv")) {
                compilerOptions.allowConversionWithStaticValueOf = Boolean.valueOf(param);
                continue;
            }
            if (Main.checkArgWithParam("-Xasto")) {
                compilerOptions.allowConversionWithStaticToX = Boolean.valueOf(param);
                continue;
            }
            if (Main.checkArgWithParam("-Xato")) {
                compilerOptions.allowConversionWithToX = Boolean.valueOf(param);
                continue;
            }
            if (Main.checkArgWithParam("-Xactor")) {
                compilerOptions.allowConversionWithCtor = Boolean.valueOf(param);
                continue;
            }
            if (Main.checkArgWithParam("-encoding")) {
                encoding = param;
                continue;
            }
            Main.showHelpAndExit("Unknown option " + (String)compilationUnitScopeArray);
        }
        if (verbose) {
            compilationUnitScopeArray = System.getProperties().entrySet().iterator();
            while (compilationUnitScopeArray.hasNext()) {
                object3 = (Map.Entry)compilationUnitScopeArray.next();
                System.err.println(object3.getKey() + " = " + object3.getValue());
            }
        }
        if (argIndex == stringArray.length) {
            Main.showHelpAndExit(null);
        }
        if (!file.isDirectory()) {
            Main.exit("The output directory " + file + " does not exist.");
        }
        Utils.resetTime();
        parsers = new ArrayList();
        problems = new ProblemReporter(bl3 ? -1L : 0L, 0L);
        while (argIndex < stringArray.length) {
            if ((compilationUnitScopeArray = stringArray[argIndex++]).equals("-Xexec")) {
                if (argIndex == stringArray.length) {
                    Main.showHelpAndExit("Missing argument to -Xexec");
                }
                string = stringArray[argIndex++];
                break;
            }
            if (compilationUnitScopeArray.startsWith("@")) {
                int n;
                compilationUnitScopeArray = compilationUnitScopeArray.substring(1).trim();
                object3 = new FileReader((String)compilationUnitScopeArray);
                object2 = new StringBuffer(1000);
                compilationUnitArray = (CompilationUnit[])new char[1024];
                while ((n = ((Reader)object3).read((char[])compilationUnitArray)) >= 0) {
                    ((StringBuffer)object2).append((char[])compilationUnitArray, 0, n);
                }
                ((InputStreamReader)object3).close();
                object = new StringTokenizer(((StringBuffer)object2).toString());
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ok &= Main.parse(((StringTokenizer)object).nextToken());
                }
                continue;
            }
            ok &= Main.parse((String)compilationUnitScopeArray);
        }
        if (verbose) {
            Utils.printTime((String)"Parsing done.");
        }
        object3 = new ASMTypeLoader(null, Main.class.getClassLoader());
        object2 = new LocalFileSystem("output", file);
        if (parsers.isEmpty()) {
            compilationUnitScopeArray = null;
            ok = false;
        } else {
            Object object4;
            compilationUnitArray = new CompilationUnit[parsers.size()];
            Object[] objectArray = string3 != null ? ASMTypeLoader.getExtensionClassPath(string3) : new File[]{};
            object = string4 != null ? ASMTypeLoader.getClassPath(string4) : ASMTypeLoader.getBootClassPath((File[])objectArray);
            Object[] objectArray2 = ASMTypeLoader.getClassPath(string2);
            ((ASMTypeLoader)object3).addFiles((FileSystem)LocalFileSystem.FILE_ADAPTER, (Object[])object, false);
            ((ASMTypeLoader)object3).addFiles((FileSystem)LocalFileSystem.FILE_ADAPTER, objectArray, false);
            ((ASMTypeLoader)object3).addFiles((FileSystem)LocalFileSystem.FILE_ADAPTER, objectArray2, true);
            if (verbose) {
                System.err.println("Bootpath    = " + Arrays.toString((Object[])object));
                System.err.println("Extensions  = " + Arrays.toString(objectArray));
                System.err.println("Classpath   = " + Arrays.toString(objectArray2));
                Utils.printTime((String)"Scanning of classpath done.");
            }
            ClassPath classPath = new ClassPath((ASMTypeLoader)object3);
            BytecodeWriter bytecodeWriter = new BytecodeWriter(compilerOptions);
            for (int i = 0; i < parsers.size(); ++i) {
                object4 = (Parser)((Object)parsers.get(i));
                compilationUnitArray[i] = new CompilationUnit(classPath, object4.getAST(), object4.getFilename(), ((Parser)((Object)object4)).getExceptionList(), new PackageImportOnDemand(null, classPath.getPackage("java.lang", false)), compilerOptions, null);
            }
            Compiler compiler = new Compiler();
            compiler.problems = problems;
            object4 = null;
            if (verbose) {
                object4 = new PrintWriter(System.err);
                compiler.setVerbose((PrintWriter)object4);
            }
            compilationUnitScopeArray = compiler.compile(compilationUnitArray, null, bytecodeWriter, (FileSystem)object2, file, bl);
            if (verbose) {
                ((PrintWriter)object4).flush();
                Utils.printTime((String)"Compilation done.");
            }
        }
        if (!problems.isEmpty()) {
            System.err.println(problems.getDetailedMessage(false));
        }
        if (problems.containsErrors()) {
            ok = false;
        }
        if (ok) {
            for (int i = 0; i < compilationUnitScopeArray.length; ++i) {
                int n;
                if (!bl && !bl2) continue;
                Type[] typeArray = ((CompilationUnitScope)compilationUnitScopeArray[i]).getDeclaredTypes();
                for (n = 0; n < typeArray.length; ++n) {
                    Main.dumpType(typeArray[n], bl);
                }
                typeArray = ((CompilationUnitScope)compilationUnitScopeArray[i]).getLocalClasses();
                for (n = 0; n < typeArray.length; ++n) {
                    Main.dumpType(typeArray[n], bl);
                }
                System.out.println();
            }
            if (verbose) {
                Utils.printTime((String)"Writing of bytecode done.");
            }
            if (string != null) {
                URL uRL = object2.toURL(object2.getRoot());
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, ((ASMTypeLoader)object3).getClassLoader());
                return Class.forName(string, false, uRLClassLoader).getMethod("main", stringArray.getClass());
            }
        }
        return null;
    }

    public static void dumpType(Type type, boolean bl) {
        int n;
        System.out.print("\n" + type.getBinaryName() + " extends " + type.getSupertype().getBinaryName());
        int n2 = type.getDeclaredInterfaceCount();
        if (n2 > 0) {
            System.out.print(" implements ");
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(type.getDeclaredInterface(i).getBinaryName());
            }
        }
        System.out.println();
        Field[] fieldArray = Reflection.getDeclaredFields((Type)type);
        for (n = 0; n < fieldArray.length; ++n) {
            Field field = fieldArray[n];
            System.out.print(field.getDescriptor());
            if ((field.getModifiers() & 0x40000) != 0) {
                System.out.print(" = ");
                try {
                    System.out.print(Reflection.get(null, (Field)field));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println();
        }
        fieldArray = Reflection.getDeclaredMethods((Type)type);
        for (n = 0; n < fieldArray.length; ++n) {
            System.out.println(fieldArray[n].getDescriptor());
            if (!bl) continue;
            ((XMethod)fieldArray[n]).dumpTree();
        }
        for (n = 0; n < type.getDeclaredTypeCount(); ++n) {
            Main.dumpType(type.getDeclaredType(n), bl);
        }
    }

    static {
        ok = true;
    }
}

