/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import antlr.collections.AST;
import de.grogra.reflect.AnnotationImpl;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.I18NBundle;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.scope.Scope;
import java.lang.annotation.Annotation;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationInfo<T extends Annotation>
extends AnnotationImpl<T> {
    private static final I18NBundle I18N = Compiler.I18N;
    final Compiler compiler;
    final Scope scope;
    final AST node;
    int run;
    boolean ok = true;
    private boolean typeIsAnnot = false;
    private HashSet<String> elements;

    AnnotationInfo(Compiler compiler, Type<T> type, Scope scope, AST aST) {
        super(type);
        this.compiler = compiler;
        this.scope = scope;
        this.node = aST;
        this.run = compiler.getRun();
    }

    void init(AST aST) {
        if (this.elements == null) {
            this.elements = new HashSet();
            this.checkAnnotationClass(aST);
        }
    }

    void finish(boolean bl) {
        if (bl) {
            this.ok = false;
            return;
        }
        if (this.typeIsAnnot) {
            Type type = this.annotationType();
            for (int i = type.getDeclaredMethodCount() - 1; i >= 0; --i) {
                Method method = type.getDeclaredMethod(i);
                if (this.elements.contains(method.getSimpleName()) || type.getDefaultElementValue(method.getSimpleName()) != null) continue;
                this.compiler.problems.addSemanticError(I18N.msg("compiler.element-not-initialized", (Object)method.getSimpleName()), this.node);
            }
        }
    }

    Type addElement(AST aST) {
        if (!this.typeIsAnnot) {
            return null;
        }
        String string = aST.getText();
        Method method = Reflection.getElementMethod((Type)this.annotationType(), (String)string);
        if (method != null) {
            if (!this.elements.add(string)) {
                this.compiler.problems.addSemanticError(I18N.msg("compiler.duplicate-element-initialization", (Object)string), aST);
            }
            return method.getReturnType();
        }
        if (!Reflection.isInvalid((Type)this.annotationType())) {
            this.compiler.problems.addSemanticError(I18N.msg("compiler.no-element", (Object)string), aST);
        }
        return null;
    }

    void deferToCompilation() {
        this.run = 2;
        this.elements.clear();
    }

    void checkAnnotationClass(AST aST) {
        Type type = this.annotationType();
        if (!Reflection.isPublic((Member)type)) {
            this.compiler.problems.addSemanticError(I18N.msg("compiler.public-class-expected", (Object)type.getName()), aST);
        }
        if (Reflection.isInvalid((Type)type)) {
            this.typeIsAnnot = false;
        } else if (type.getDeclaredInterfaceCount() != 1 || !Reflection.equal(Annotation.class, (Type)type.getDeclaredInterface(0))) {
            this.compiler.problems.addSemanticError(I18N.msg("compiler.no-annotation-type", (Object)type), aST);
            this.typeIsAnnot = false;
        } else {
            this.typeIsAnnot = true;
        }
    }
}

